#!/usr/bin/env python
#
# Copyright 2004 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
# 

from gnuradio import gr
from gnuradio import usrp
from gnuradio.eng_option import eng_option
from gnuradio.wxgui import stdgui, fftsink, scopesink
from optparse import OptionParser
import wx

class app_flow_graph (stdgui.gui_flow_graph):
    def __init__(self, frame, panel, vbox, argv):
        stdgui.gui_flow_graph.__init__ (self, frame, panel, vbox, argv)

        
        parser = OptionParser (option_class=eng_option)
        parser.add_option ("-d", "--decim", type="int", default=16,
                           help="set fgpa decimation rate to DECIM")
        parser.add_option ("-c", "--cordic-freq", type="eng_float", default=0,
                           help="set Rx cordic frequency to FREQ", metavar="FREQ")
        parser.add_option ("-m", "--mux", type="intx", default=0x32103210,
                           help="set fpga FR_RX_MUX register to MUX")
        parser.add_option ("-n", "--nchan", type="intx", default=1,
                           help="set nchannels to NCHAN")
        parser.add_option ("-g", "--gain", type="eng_float", default=0,
                           help="set Rx PGA gain in dB (default 0 dB)")
        (options, args) = parser.parse_args ()

        u = usrp.source_c (0, options.decim, options.nchan, options.mux, 0)
        u.set_rx_freq (0, options.cordic_freq)
        u.set_pga (0, options.gain)
        u.set_pga (1, options.gain)
        
        input_rate = u.adc_freq () / u.decim_rate ()

        c2f_1 = gr.complex_to_float ()

        sink, win = scopesink.make_scope_sink_f (self, panel, "Rx Data", input_rate)
        vbox.Add (win, 1, wx.EXPAND)

        if(options.nchan == 2):
            u.set_rx_freq (1, options.cordic_freq)
            deint = gr.deinterleave (gr.sizeof_gr_complex)
            c2f_2 = gr.complex_to_float ()
            self.connect (u, deint)
            self.connect ((deint,0),c2f_1)
            self.connect ((deint,1),c2f_2)
            self.connect ((c2f_2, 0), (sink, 2))
            self.connect ((c2f_2, 1), (sink, 3))
        else:
            self.connect (u,c2f_1)
            
        self.connect ((c2f_1, 0), (sink, 0))
        self.connect ((c2f_1, 1), (sink, 1))

def main ():
    app = stdgui.stdapp (app_flow_graph, "USRP O'scope")
    app.MainLoop ()

if __name__ == '__main__':
    main ()
