/*  gnutrition - a nutrition and diet analysis program.
 *  Copyright (C) 2000 Edgar Denny (e.denny@ic.ac.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gnome.h>
#include <glade/glade.h>

#include "messages.h"

static GladeXML *xml = NULL;

static void load_xml( void);

/* load the glade interface if not already loaded. */
static void
load_xml()
{
	static gboolean loaded_xml = FALSE;

	/* load the glade interface. */
	if ( !loaded_xml)
	{
		xml = glade_xml_new( GNUTRITION_GLADEDIR "/messages.glade", NULL);
		loaded_xml = TRUE;

		if (  xml != NULL)
		{
			glade_xml_signal_autoconnect( xml);
		}
		else
		{
			g_log( "Gnutrition", G_LOG_LEVEL_ERROR,
					"messages.c:load_xml: cannot load glade file\n");
			return;
		}
	}
}

/* show the no row selected message box. */
void
gnutr_show_msg_no_row_selected()
{
	GtkWidget *dlg;

	if ( xml == NULL) load_xml();

	dlg = glade_xml_get_widget( xml, "no_row_selected_msgbox");
	gnome_dialog_close_hides( GNOME_DIALOG( dlg), TRUE);
	gtk_widget_show( dlg);
}

/* when the no row selected message box is clicked. */
void
on_no_row_selected_msgbox_clicked( GnomeDialog *gnomedialog,
                                   gint         button,
                                   gpointer     user_data)
{
	switch( button)
	{
		/* ok button pressed - hide the message box. */
		case 0:
		{
			GtkWidget *dlg = glade_xml_get_widget( xml, 
					"no_row_selected_msgbox");
			gtk_widget_hide( dlg);
		}
		break;
	}
}

/* show the nutrient already selected message box. */
void
gnutr_show_msg_nutrient_already_selected()
{
	GtkWidget *dlg;

	if ( xml == NULL) load_xml();

	dlg = glade_xml_get_widget( xml, "nutrient_already_selected_msgbox");
	gnome_dialog_close_hides( GNOME_DIALOG( dlg), TRUE);
	gtk_widget_show( dlg);
}

/* when the nutrient already selected message box is clicked. */
void
on_nutrient_already_selected_msgbox_clicked( GnomeDialog *gnomedialog,
                                             gint         button,
                                             gpointer     user_data)
{
	switch( button)
	{
		/* ok button pressed - hide the message box. */
		case 0:
		{
			GtkWidget *dlg = glade_xml_get_widget( xml, 
					"nutrient_already_selected_msgbox");
			gtk_widget_hide( dlg);
		}
		break;
	}
}

/* show the "cannot search for a food on the basis of
 * maximizing and minimizing the same nutrient" message box. */
void
gnutr_show_msg_cannot_max_min()
{
	GtkWidget *dlg;

	if ( xml == NULL) load_xml();

	dlg = glade_xml_get_widget( xml, "cannot_max_min_msgbox");
	gnome_dialog_close_hides( GNOME_DIALOG( dlg), TRUE);
	gtk_widget_show( dlg);
}

/* when the "cannot search for a food on the basis of maximizing and 
 * minimizing the same nutrient" message box is clicked. */
void
on_cannot_max_min_msgbox_clicked( GnomeDialog *gnomedialog,
                                   gint         button,
                                   gpointer     user_data)
{
	switch( button)
	{
		/* ok button pressed - hide the message box. */
		case 0:
		{
			GtkWidget *dlg = glade_xml_get_widget( xml, 
					"cannot_max_min_msgbox");
			gtk_widget_hide( dlg);
		}
		break;
	}
}

/* show the "no nutrients selected" message box when the 
 * "Search" button is released in the nutrient search dialog. */
void
gnutr_show_msg_no_nutrients_selected()
{
	GtkWidget *dlg;

	if ( xml == NULL) load_xml();

	dlg = glade_xml_get_widget( xml, "no_nutrients_selected_msgbox");
	gnome_dialog_close_hides( GNOME_DIALOG( dlg), TRUE);
	gtk_widget_show( dlg);
}

/* when the "no nutrients selected" message box is clicked. */
void
on_no_nutrients_selected_msgbox_clicked( GnomeDialog *gnomedialog,
                                         gint         button,
                                         gpointer     user_data)
{
	switch( button)
	{
		/* ok button pressed - hide the message box. */
		case 0:
		{
			GtkWidget *dlg = glade_xml_get_widget( xml, 
					"no_nutrients_selected_msgbox");
			gtk_widget_hide( dlg);
		}
		break;
	}
}

/* show the "no ingredient has been selected" message box when the 
 * "Edit" button is released in the nutrient search dialog. */
void
gnutr_show_msg_no_ingredient_selected()
{
	GtkWidget *dlg;

	if ( xml == NULL) load_xml();

	dlg = glade_xml_get_widget( xml, "no_ingredient_selected_msgbox");
	gnome_dialog_close_hides( GNOME_DIALOG( dlg), TRUE);
	gtk_widget_show( dlg);
}

/* when the "no ingredient has been selected" message box is clicked. */
void
on_no_ingredient_selected_msgbox_clicked( GnomeDialog *gnomedialog,
                                         gint         button,
                                         gpointer     user_data)
{
	switch( button)
	{
		/* ok button pressed - hide the message box. */
		case 0:
		{
			GtkWidget *dlg = glade_xml_get_widget( xml, 
					"no_ingredient_selected_msgbox");
			gtk_widget_hide( dlg);
		}
		break;
	}
}

/* show the "the number of sevings must be specified" message box. */
void
gnutr_show_msg_no_num_serv()
{
	GtkWidget *dlg;

	if ( xml == NULL) load_xml();

	dlg = glade_xml_get_widget( xml, "no_num_serv_msgbox");
	gnome_dialog_close_hides( GNOME_DIALOG( dlg), TRUE);
	gtk_widget_show( dlg);
}

/* when the "no ingredient has been selected" message box is clicked. */
void
on_no_num_serv_msgbox_clicked( GnomeDialog *gnomedialog,
                               gint         button,
                               gpointer     user_data)
{
	switch( button)
	{
		/* ok button pressed - hide the message box. */
		case 0:
		{
			GtkWidget *dlg = glade_xml_get_widget( xml, 
					"no_num_serv_msgbox");
			gtk_widget_hide( dlg);
		}
		break;
	}
}

/* show the "file not found" message box. */
void
gnutr_show_msg_file_not_found()
{
	GtkWidget *dlg;

	if ( xml == NULL) load_xml();

	dlg = glade_xml_get_widget( xml, "file_not_found_msgbox");
	gnome_dialog_close_hides( GNOME_DIALOG( dlg), TRUE);
	gtk_widget_show( dlg);
}

/* when the "file not found" message box is clicked. */
void
on_file_not_found_msgbox_clicked( GnomeDialog *gnomedialog,
                                  gint         button,
                                  gpointer     user_data)
{
	switch( button)
	{
		/* ok button pressed - hide the message box. */
		case 0:
		{
			GtkWidget *dlg = glade_xml_get_widget( xml, 
					"file_not_found_msgbox");
			gtk_widget_hide( dlg);
		}
		break;
	}
}

/* show the "no filename given" message box. */
void
gnutr_show_msg_no_filename_given()
{
	GtkWidget *dlg;

	if ( xml == NULL) load_xml();

	dlg = glade_xml_get_widget( xml, "no_filename_given_msgbox");
	gnome_dialog_close_hides( GNOME_DIALOG( dlg), TRUE);
	gtk_widget_show( dlg);
}

/* when the "no filename given" message box is clicked. */
void
on_no_filename_given_msgbox_clicked( GnomeDialog *gnomedialog,
                                     gint         button,
                                     gpointer     user_data)
{
	switch( button)
	{
		/* ok button pressed - hide the message box. */
		case 0:
		{
			GtkWidget *dlg = glade_xml_get_widget( xml, 
					"no_filename_given_msgbox");
			gtk_widget_hide( dlg);
		}
		break;
	}
}

/* show the "no recipe name given" message box. */
void
gnutr_show_msg_no_recipe_name()
{
	GtkWidget *dlg;

	if ( xml == NULL) load_xml();

	dlg = glade_xml_get_widget( xml, "no_recipe_name_msgbox");
	gnome_dialog_close_hides( GNOME_DIALOG( dlg), TRUE);
	gtk_widget_show( dlg);
}

/* when the "no recipe name given" message box is clicked. */
void
on_no_recipe_name_msgbox_clicked( GnomeDialog *gnomedialog,
                                     gint         button,
                                     gpointer     user_data)
{
	switch( button)
	{
		/* ok button pressed - hide the message box. */
		case 0:
		{
			GtkWidget *dlg = glade_xml_get_widget( xml, 
					"no_recipe_name_msgbox");
			gtk_widget_hide( dlg);
		}
		break;
	}
}
