;;;
;;; flushes checkpoints
;;;
(defun d-flush-checkpoints (files)
  (save-some-buffers t)
  (let ((ptr files))
    (while ptr
      (let ((auto-mode-alist (cons '("" . fundamental-mode) auto-mode-alist)))
        (find-file (car ptr)))
      (goto-char (point-min))
      (flush-lines "CHECKPOINT;")
      (save-buffer)
      (kill-buffer nil)
      (setq ptr (cdr ptr)))))

;;; (d-flush-checkpoints (directory-files "~/cbrow-test/" t "cc\\|hh$"))
;;; (d-flush-checkpoints (directory-files "~/zallegro/2004/Tritus-II/" t "cc\\|hh$"))

(provide 'd-flush-checkpoints)
;;; d-flush-checkpoints.el ends here
