/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ModuleContext;
import gnu.mapping.SimpleSymbol;
import gnu.mapping.Symbol;
import kawa.lang.SyntaxForm;
import kawa.lang.Translator;

public class IfFeature {
    public static final String PROVIDE_PREFIX = "%provide%";

    public static boolean testFeature(Object form) {
        if (form instanceof SyntaxForm) {
            SyntaxForm sf = (SyntaxForm)form;
            form = sf.getDatum();
        }
        if ((form = ((Translator)Compilation.getCurrent()).namespaceResolve(form)) instanceof String || form instanceof SimpleSymbol) {
            return IfFeature.hasFeature(form.toString());
        }
        return false;
    }

    public static boolean hasFeature(String name) {
        String classExistsPrefix;
        if (name == "kawa") {
            return true;
        }
        if (name == "srfi-0") {
            return true;
        }
        if (name == "srfi-4") {
            return true;
        }
        if (name == "srfi-6") {
            return true;
        }
        if (name == "srfi-8") {
            return true;
        }
        if (name == "srfi-9") {
            return true;
        }
        if (name == "srfi-11") {
            return true;
        }
        if (name == "srfi-16") {
            return true;
        }
        if (name == "srfi-17") {
            return true;
        }
        if (name == "srfi-23") {
            return true;
        }
        if (name == "srfi-25") {
            return true;
        }
        if (name == "srfi-26") {
            return true;
        }
        if (name == "srfi-28") {
            return true;
        }
        if (name == "srfi-30") {
            return true;
        }
        if (name == "srfi-39") {
            return true;
        }
        if (name == "string-normalize-unicode") {
            try {
                Class.forName("java.text.Normalizer");
                return true;
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
        }
        if (name == "in-http-server" || name == "in-servlet") {
            int mflags = ModuleContext.getContext().getFlags();
            if (name == "in-http-server") {
                return (mflags & ModuleContext.IN_HTTP_SERVER) != 0;
            }
            if (name == "in-servlet") {
                return (mflags & ModuleContext.IN_SERVLET) != 0;
            }
        }
        if (name.startsWith(classExistsPrefix = "class-exists:")) {
            name = name.substring(classExistsPrefix.length());
            try {
                Class.forName(name, false, IfFeature.class.getClassLoader());
                return true;
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
        }
        SimpleSymbol provide_symbol = Symbol.valueOf(PROVIDE_PREFIX + name);
        Declaration decl = Compilation.getCurrent().lookup(provide_symbol, -1);
        return decl != null && !decl.getFlag(65536L);
    }

    public static boolean isProvide(Declaration decl) {
        return decl.getName().startsWith(PROVIDE_PREFIX);
    }
}

