/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.lists.Array;
import gnu.lists.FVector;
import gnu.lists.GeneralArray;
import gnu.lists.SeqPosition;
import gnu.lists.SimpleVector;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import gnu.math.IntNum;

public class Arrays {
    static final int[] shapeStrides = new int[]{2, 1};
    static final int[] zeros2 = new int[2];

    public static Array shape(Object[] objectArray) {
        int n = objectArray.length;
        if ((n & 1) != 0) {
            throw new RuntimeException("shape: not an even number of arguments");
        }
        int n2 = n >> 1;
        int[] nArray = new int[]{n2, 2};
        return new FVector(objectArray).transpose(zeros2, nArray, 0, shapeStrides);
    }

    public static Array make(Array array, Object object2) {
        int n = array.getSize(0);
        int[] nArray = new int[n];
        int[] nArray2 = null;
        int n2 = 1;
        int n3 = n;
        while (--n3 >= 0) {
            int n4;
            int n5 = ((Number)array.getRowMajor(2 * n3)).intValue();
            int n6 = ((Number)array.getRowMajor(2 * n3 + 1)).intValue();
            nArray[n3] = n4 = n6 - n5;
            if (n5 != 0) {
                if (nArray2 == null) {
                    nArray2 = new int[n];
                }
                nArray2[n3] = n5;
            }
            n2 *= n4;
        }
        return GeneralArray.makeSimple(nArray2, nArray, new FVector(n2, object2));
    }

    public static Array makeSimple(Array array, SimpleVector simpleVector) {
        int n = array.getSize(0);
        int[] nArray = new int[n];
        int[] nArray2 = null;
        int n2 = n;
        while (--n2 >= 0) {
            int n3 = ((Number)array.getRowMajor(2 * n2)).intValue();
            int n4 = ((Number)array.getRowMajor(2 * n2 + 1)).intValue();
            nArray[n2] = n4 - n3;
            if (n3 == 0) continue;
            if (nArray2 == null) {
                nArray2 = new int[n];
            }
            nArray2[n2] = n3;
        }
        return GeneralArray.makeSimple(nArray2, nArray, simpleVector);
    }

    public static int effectiveIndex(Array array, Procedure procedure, Object[] objectArray, int[] nArray) throws Throwable {
        Object object2 = procedure.applyN(objectArray);
        if (object2 instanceof Values) {
            Values values = (Values)object2;
            int n = values.size();
            SeqPosition seqPosition = values.getIterator();
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = ((Number)seqPosition.next()).intValue();
                ++n2;
            }
        } else {
            nArray[0] = ((Number)procedure.applyN(objectArray)).intValue();
        }
        return array.getEffectiveIndex(nArray);
    }

    public static Array shareArray(Array array, Array array2, Procedure procedure) throws Throwable {
        int n = array2.getSize(0);
        Object[] objectArray = new Object[n];
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = n;
        while (--n2 >= 0) {
            Object object2;
            objectArray[n2] = object2 = array2.getRowMajor(2 * n2);
            nArray2[n2] = ((Number)object2).intValue();
        }
        int n3 = array.rank();
        int[] nArray3 = new int[n3];
        int n4 = Arrays.effectiveIndex(array, procedure, objectArray, nArray3);
        int[] nArray4 = new int[n];
        int n5 = n;
        while (--n5 >= 0) {
            int n6;
            int n7 = ((Number)array2.getRowMajor(2 * n5 + 1)).intValue();
            int n8 = nArray2[n5];
            nArray[n5] = n6 = n7 - n8;
            if (n6 == 0) {
                nArray4[n5] = 0;
                continue;
            }
            Object object3 = objectArray[n5];
            objectArray[n5] = IntNum.make(n8 + 1);
            nArray4[n5] = Arrays.effectiveIndex(array, procedure, objectArray, nArray3) - n4;
            objectArray[n5] = object3;
        }
        return array.transpose(nArray2, nArray, n4, nArray4);
    }
}

