#ifndef swevents_array_h_1203
#define swevents_array_h_1203

#include "swevents.h"

#define SWEVENT_LV	1
#define SWEVENT_LV6	6
#define SWI_EVENT	1  /* Is an event that takes place in swi.c */

				/* -SW_ERROR means event is always an error */
struct swEvents eventsArray[] = {
{"", 0, 0, "", 0, SW_NOTE},
{"SW_ACCESS_DENIED", 			4, 	SWEVENT_LV, "", 1, SW_ERROR},
{"SW_MEMORY_ERROR", 			5,	SWEVENT_LV, "", 1, -SW_ERROR},
{"SW_RESOURCE_ERROR", 			6,	SWEVENT_LV, "", 1, -SW_ERROR},
{"SW_INTERNAL_ERROR", 			7,	SWEVENT_LV, "", 1, -SW_ERROR},
{"SW_IO_ERROR", 			8,	SWEVENT_LV, "", 1, -SW_ERROR},
{"SW_AGENT_INITIALIZATION_FAILED", 	10,	SWEVENT_LV, "", 0, -SW_ERROR},
{"SW_SERVICE_NOT_AVALIABLE", 		11,	SWEVENT_LV, "", 0, -SW_ERROR},
{"SW_OTHER_SESSIONS_IN_PROGRESS", 	12,	SWEVENT_LV, "", 0, SW_WARNING},
{"SW_SESSION_BEGINS", 			28, 	SWEVENT_LV, "", 0, SW_NOTE},
{"SW_SESSION_ENDS", 			29, 	SWEVENT_LV, "", 0, SW_ERROR},
{"SW_CONNECTION_LIMIT_EXCEEDED", 	30,	SWEVENT_LV, "", 0, -SW_ERROR}, 
{"SW_SOC_DOES_NOT_EXIST", 		31, 	1, 	    "", 0, -SW_ERROR},
{"SW_SOC_IS_CORRUPT",	 		32,	SWEVENT_LV, "", 0, SW_ERROR},
{"SW_SOC_CREATED", 			34, 	1,          "", 0, SW_NOTE},
{"SW_SOC_IS_REMOTE", 			38, 	1,          "", 0, SW_NOTE},
{"SW_SOC_IS_SERIAL", 			40, 	1,          "", 0, SW_NOTE},
{"SW_SOC_AMBIGUOUS_TYPE",		49, 	SWEVENT_LV, "", 0, -SW_NOTE},
{"SW_ANALYSIS_BEGINS", 			52, 	SWEVENT_LV, "", 1, SW_NOTE},
{"SW_ANALYSIS_ENDS", 			53, 	SWEVENT_LV, "", 1, SW_NOTE},
{"SW_CHECK_SCRIPT_EXCLUDE",		57,	SWEVENT_LV, "", 1, SW_NOTE},
{"SW_CONFIGURE_EXCLUDE", 		58,	SWEVENT_LV, "", 1, SW_NOTE},
{"SW_SOURCE_ACCESS_ERROR", 		60, 	1, ": File not found.", 0, SW_NOTE},
{"SW_HIGHER_REVISION_INSTALLED", 	67,	SWEVENT_LV, "", 1, SW_NOTE},
{"SW_DEPENDENCY_NOT_MET",		70,	SWEVENT_LV, "", 1, SW_ERROR},
{"SW_NOT_COMPATIBLE",			71,	SWEVENT_LV, "", 1, SW_ERROR},
{"SW_CHECK_SCRIPT_WARNING",		72,	SWEVENT_LV, "", 1, SW_WARNING},
{"SW_CHECK_SCRIPT_ERROR",		73,	SWEVENT_LV, "", 1, -SW_ERROR},
{"SW_DSA_OVER_LIMIT",			75,	SWEVENT_LV, "", 1, SW_ERROR},
{"SW_DSA_FAILED_TO_RUN",		76,	SWEVENT_LV, "", 1, SW_NOTE},
{"SW_SKIPPED_GLOBAL_ERROR", 		80,	SWEVENT_LV, "", 1, SW_NOTE},
{"SW_FILE_WARNING",			84,	SWEVENT_LV, "", 1, SW_WARNING},
{"SW_FILE_ERROR",			85,	SWEVENT_LV, "", 1, -SW_ERROR},
{"SW_NOT_LOCATABLE",			86,	SWEVENT_LV, "", 1, SW_ERROR},
{"SW_SAME_REVISION_SKIPPED", 		87,	SWEVENT_LV, "", 1, SW_NOTE},
{"SW_EXECUTION_BEGINS", 		88, 	SWEVENT_LV, "", 1, SW_NOTE},
{"SW_EXECUTION_ENDS", 			89, 	SWEVENT_LV, "", 1, SW_ERROR},
{"SW_PRE_SCRIPT_WARNING",		95,	SWEVENT_LV, "", 1, SW_WARNING},
{"SW_PRE_SCRIPT_ERROR",			96,	SWEVENT_LV, "", 1, SW_ERROR},
{"SW_FILESET_WARNING",			97,	SWEVENT_LV, "", 1, SW_WARNING},
{"SW_FILESET_ERROR",			98,	SWEVENT_LV, "", 1, SW_ERROR},
{"SW_POST_SCRIPT_WARNING",		99,	SWEVENT_LV, "", 1, SW_WARNING},
{"SW_POST_SCRIPT_ERROR",		100,	SWEVENT_LV, "", 1, SW_ERROR},
{"SW_CONFIGURE_WARNING",		103,	SWEVENT_LV, "", 1, SW_WARNING},
{"SW_CONFIGURE_ERROR",			104,	SWEVENT_LV, "", 1, SW_ERROR},
{"SW_DATABASE_UPDATE_ERROR",		105,	SWEVENT_LV, "", 1, -SW_ERROR},
{"SW_FILESET_BEGINS",			117,	SWEVENT_LV, "", 1, SW_NOTE},
{"SW_CONTROL_SCRIPT_BEGINS",		118,	SWEVENT_LV, "", 1, SW_NOTE},

	/*	
	 * Events 0 - 255 are Posix or are reserved.
	 * Events >255 are specific to the swbis implementation.
	 */ 

{"SW_SOURCE_ACCESS_BEGINS", 		260, 	SWEVENT_LV, "", 0, SW_NOTE},
{"SW_SOURCE_ACCESS_ENDS", 		261, 	SWEVENT_LV, "", 0, SW_ERROR},
{"SW_CONTROL_SCRIPT_ENDS",		262,	SWEVENT_LV, "", 1, SW_NOTE},

{"SWI_PRODUCT_SCRIPT_ENDS", 		280, 	SWEVENT_LV, "", 1, SW_NOTE},
{"SWI_FILESET_SCRIPT_ENDS", 		281, 	SWEVENT_LV, "", 1, SW_NOTE},

{"SWI_CATALOG_UNPACK_BEGINS", 		302, 	SWEVENT_LV, "", 1, SW_NOTE},
{"SWI_CATALOG_UNPACK_ENDS", 		303, 	SWEVENT_LV, "", 1, SW_ERROR},
{"SWI_TASK_BEGINS", 			304, 	SWEVENT_LV6, "", 1, SW_NOTE},
{"SWI_TASK_ENDS", 			305, 	SWEVENT_LV6, "", 1, SW_ERROR},
{"SWI_SWICOL_ERROR", 			306, 	SWEVENT_LV, "", 1, SW_ERROR},
{"SWI_CATALOG_ANALYSIS_BEGINS",		307,	SWEVENT_LV, "", 1, SW_NOTE},
{"SWI_CATALOG_ANALYSIS_ENDS",		308,	SWEVENT_LV, "", 1, SW_ERROR},
{"SWBIS_TARGET_BEGINS",			309,	SWEVENT_LV, "", 1, SW_NOTE},
{"SWBIS_TARGET_ENDS",			310,	SWEVENT_LV, "", 1, SW_ERROR},
{"SWI_NORMAL_EXIT",			311,	SWEVENT_LV, "", 0, SW_ERROR},
{"SWI_SELECTION_BEGINS",		312,	SWEVENT_LV, "", 0, SW_NOTE},
{"SWI_SELECTION_ENDS",			313,	SWEVENT_LV, "", 0, SW_ERROR},
{"SWI_MSG",				314,	SWEVENT_LV, "", 1, SW_NOTE},
{"SWI_ATTRIBUTE",			315,	SWEVENT_LV, "", 1, SW_NOTE},
{"SWI_GROUP_BEGINS",			316,	SWEVENT_LV, "", 1, SW_NOTE},
{"SWI_GROUP_ENDS",			317,	SWEVENT_LV, "", 1, SW_NOTE},
{"", -1, 0, "", 0, SW_NOTE}
};

#endif
