/* $Id$
 * uxfio_i.h:  buffered u*ix I/O functions.
 *
 */

/*
 * Copyright (C) 1998  James H. Lowe, Jr.  <jhlowe@acm.org>
 *
 * COPYING TERMS AND CONDITIONS
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

#ifndef uxfio_i_20020419_h
#define uxfio_i_20020419_h

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#define UXFIO_I_NULL_FD -10001

typedef struct {
	int uxfdM;		/* unix file descriptor */
	int buffertypeM;	/* memmory segment, disk file, dynamic (growable) memory */
	int uxfd_can_seekM;	/* 1 if seekable file */
	int posM;		/* pointer in buf , always >=start AND <end */
	int startM;		/* beginning offset in buf of valid data, always 0 */
	int endM;		/* pointer offset of first byte of invalid data */
	int lenM;		/* length of buffer, memory length, or, maximum file length */
	int errorM;		/* error */
	int bytesreadM;		/* bytes read on virtual fd */
	int current_offsetM;	/* curent offset in physical/logical file.*/
	int buffer_activeM;	/* 1 if any buffertype is in use */
	char *bufM;		/* stream buffer for buffertype 0 */
	int buffdM;		/* file buffer for buffertype 1 */
	long offset_eof_savedM;	/* saved value of offset_eofM */
	long offset_eofM;	/* virtual end-of marker for the uxfio_read function */
	long offset_bofM;	/* virtual beginning of file. */
	int auto_disableM;	/* if a subsequent read() will read from uxfd entirely, set buffer_active to 0 */
	int auto_arm_delayM;	/* only disable buffer if auto_disable is set AND have previosly read from buffer */
	int write_insertM;	/* true if inserting into a file. see UXFIO_F_WRITE_INSERT */
	mode_t uxfio_modeM;
	int v_endM;		/* length of file */
	int use_countM;
	char * tmpfile_rootdirM;
	char buffilenameM[128];
	struct stat * statbufM;
	int did_dupe_fdM;
	int (*vir_fsyncM)(int  filedes);
	ssize_t (*vir_readM)(int  filedes, void * buf, size_t nbytes);
	ssize_t (*vir_tread_readM)(int  filedes, void * buf, size_t nbytes);
	ssize_t (*vir_writeM)(int  filedes, void * buf, size_t nbytes);
	int (*vir_ftruncateM)(int  filedes,  off_t nbytes);
	int (*vir_closeM)(int  filedes);
	off_t (*vir_lseekM)(int  filedes, off_t offset, int whence);
	int uxfio_fildesM;	/* Uxfio descriptor of this structure */
	int lock_buf_fatalM;     /* If realloc shifts the address of the file image, then exit */
	int output_block_sizeM;		/* 0 for no blocking */
	int output_buffer_cM;		/* output buffer data length */
	char * output_bufferM;		/* output buffering blocksize */
} UXFIO;

UXFIO * uxfio_debug_get_object_address(int fd);

#endif
