/* This file was generated by scm2java from source file "wbdefs.scm" */
/*  "wbdefs.scm" WB-tree File Based Associative String Data Base System. */
/*  Copyright (C) 1991, 1992, 1993, 2000 Free Software Foundation, Inc. */
/*  */
/*  This program is free software: you can redistribute it and/or modify */
/*  it under the terms of the GNU Lesser General Public License as */
/*  published by the Free Software Foundation, either version 3 of the */
/*  License, or (at your option) any later version. */
/*  */
/*  This program is distributed in the hope that it will be useful, but */
/*  WITHOUT ANY WARRANTY; without even the implied warranty of */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU */
/*  Lesser General Public License for more details. */
/*  */
/*  You should have received a copy of the GNU Lesser General Public */
/*  License along with this program.  If not, see */
/*  <http://www.gnu.org/licenses/>. */


package wb;

import static wb.SchlepRT.*;
import static wb.Ents.*;
import static wb.Wbsys.*;
import static wb.Blk.*;
import static wb.Lck.*;
public class Wbdefs {

/*  FLC-LEN must be larger than 2 times the maximum number of blocks */
/*  which would ever be needed for a freelist split. */

public static final int flcLen = 0xa;

/* amount to increase the ENT-TAB by when allocating buffers. */

public static final int entTabInc = 0x200;

/*  Byte-array directory names */
/*  These should be protected against EBCDIC. */

public static final byte []flcByts = stringToBytes("FLC");

public static final byte []fldByts = stringToBytes("FLD");

public static final byte []usedByts = stringToBytes("USED");

public static final byte []bsizByts = stringToBytes("BSIZ");

public static final byte []rootByts = stringToBytes("ROOT");

public static final byte []clnByts = stringToBytes("CLN");

public static final byte []authorsByts = stringToBytes("authors");

public static final byte []noByts = stringToBytes("");


public static boolean err_P(int x)
{
  return true
  && 0 > (x)
  && (x)>=(maxerr);
}


public static boolean realerr_P(int x)
{
  return true
  && (x)<=(retryerr)
  && (x)>=(maxerr);
}


public static boolean success_P(int x)
{
  return !(err_P(x));
}

/*  Return Codes */


public static final int success = 0;

/*  ERROR Return Codes */


public static final int notpres =  -1;


public static final int terminated =  -2;


public static final int retryerr =  -10;


public static final int keyerr =  -13;


public static final int argerr =  -15;


public static final int noroom =  -20;


public static final int typerr =  -30;


public static final int ioerr =  -40;


public static final int strangerr =  -45;


public static final int unkerr =  -90;


public static final int maxerr =  -100;



public static final int dirTyp = 0x44;

public static final int indTyp = 0x54;

public static final int seqTyp = 0x53;

public static final int frlTyp = 0x46;


public static final int wcbSap = 1;

public static final int wcbSar = 2;

public static final int wcbSac = 4;

public static final int wcbFac = 8;


public static final int endOfChain =  -1;

public static final int startOfChain =  -2;


public static final int leaf = 0x30;

/*  BLK PREDICATES */


public static boolean root_P(byte []blk)
{
  return (blk_Id(blk))==(blk_TopId(blk));
}


public static boolean endOfChain_P(byte []blk)
{
  return 0==(blk_NxtId(blk));
}


public static boolean leaf_P(byte []blk)
{
  return (blk_Level(blk))==(leaf);
}


public static int fieldLen(byte []blk,int pos)
{
  return (blk[pos] & 0xFF);
}


public static void setFieldLen(byte []blk,int pos,int len)
{
  blk[pos] = (byte) (0xff&(len));
  return;
}

/*  This is dangerous.  At the moment all occurences of next-field */
/*  have simple expressions for the second argument. */


public static int nextField(byte []blk,int pos)
{
  return (fieldLen(blk, pos))+(pos)+1;
}


public static int nextCnvpair(byte []blk,int pos)
{
  return nextField(blk, nextField(blk, 1+(pos)));
}


public static boolean blkEmpty_P(byte []blk)
{
  return (blk_End(blk))==(nextField(blk, 1+(blkDataStart)));
}

/*  LCK and ENT tables */

/*  If you change this, then change amnesia-ent! */
/*  This depends on segid never being less than -1 */

public static int hash2int(int segid,int num)
{
  return (((segid)*0x61)+(num)+((numBuks)*(1+(0x61/(numBuks)))))%(numBuks);
}


public static boolean sameBuk_P(int aSegid,int aNum,int bSegid,int bNum)
{
  return (hash2int(aSegid, aNum))==(hash2int(bSegid, bNum));
}


public static Ent getBuk(int segid,int blkNum)
{
  return bukTab[hash2int(segid, blkNum)];
}

/*  doesnt wait, ie, returns #F if busy */

public static boolean getBukLck_P(int segid,int blkNum)
{
  return tryLck_P(lckTab[hash2int(segid, blkNum)]);
}


public static Ent getBukWait(int segid,int blkNum)
{
  lck(lckTab[hash2int(segid, blkNum)]);
  return bukTab[hash2int(segid, blkNum)];
}


public static void relBuk(int segid,int blkNum)
{
  unlck(lckTab[hash2int(segid, blkNum)]);
  return;
}

/*  SET-BUK! assumes BUK is already lcked by caller */

public static void setBuk(int segid,int blkNum,Ent ent)
{
  bukTab[hash2int(segid, blkNum)] = ent;
  return;
}

/* (defconst ACCFOO 'ACCFOO) */

public static final int accnone = 1;

public static final int accread = 2;

public static final int accwrite = 3;

public static final int accpend = 4;

/*  Tokens for use in the PKT:MATCH-POS field */

public static final int pastp = 5;
			/* match(new-key, after-key) > repeatcount(after-key) */

public static final int qpastp = 6;
			/* match(new-key, after-key) <= repeatcount(after-key) */

public static final int match = 7;

public static final int matchend = 8;

public static final int pastend = 9;

/*  Operation codes for SCAN */

public static final int remScan =  -1;

public static final int countScan = 0;

public static final int modifyScan = 1;

}
