/*
 * tclDecls.h --
 *
 *	Declarations of functions in the platform independent public Tcl API.
 *
 * Copyright (c) 1998-1999 by Scriptics Corporation.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#ifndef _TCLDECLS
#define _TCLDECLS

#undef TCL_STORAGE_CLASS
#ifdef BUILD_tcl
#   define TCL_STORAGE_CLASS DLLEXPORT
#else
#   ifdef USE_TCL_STUBS
#      define TCL_STORAGE_CLASS
#   else
#      define TCL_STORAGE_CLASS DLLIMPORT
#   endif
#endif

/*
 * WARNING: This file is automatically generated by the tools/genStubs.tcl
 * script.  Any modifications to the function declarations below should be made
 * in the generic/tcl.decls script.
 */

/* !BEGIN!: Do not edit below this line. */

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Exported function declarations:
 */

#ifndef Tcl_PkgProvideEx_TCL_DECLARED
#define Tcl_PkgProvideEx_TCL_DECLARED
/* 0 */
EXTERN int		Tcl_PkgProvideEx(Tcl_Interp *interp,
				CONST char *name, CONST char *version,
				ClientData clientData);
#endif
#ifndef Tcl_PkgRequireEx_TCL_DECLARED
#define Tcl_PkgRequireEx_TCL_DECLARED
/* 1 */
EXTERN CONST84_RETURN char * Tcl_PkgRequireEx(Tcl_Interp *interp,
				CONST char *name, CONST char *version,
				int exact, ClientData *clientDataPtr);
#endif
#ifndef Tcl_Panic_TCL_DECLARED
#define Tcl_Panic_TCL_DECLARED
/* 2 */
EXTERN void		Tcl_Panic(CONST char *format, ...);
#endif
#ifndef Tcl_Alloc_TCL_DECLARED
#define Tcl_Alloc_TCL_DECLARED
/* 3 */
EXTERN char *		Tcl_Alloc(unsigned int size);
#endif
#ifndef Tcl_Free_TCL_DECLARED
#define Tcl_Free_TCL_DECLARED
/* 4 */
EXTERN void		Tcl_Free(char *ptr);
#endif
#ifndef Tcl_Realloc_TCL_DECLARED
#define Tcl_Realloc_TCL_DECLARED
/* 5 */
EXTERN char *		Tcl_Realloc(char *ptr, unsigned int size);
#endif
#ifndef Tcl_DbCkalloc_TCL_DECLARED
#define Tcl_DbCkalloc_TCL_DECLARED
/* 6 */
EXTERN char *		Tcl_DbCkalloc(unsigned int size, CONST char *file,
				int line);
#endif
#ifndef Tcl_DbCkfree_TCL_DECLARED
#define Tcl_DbCkfree_TCL_DECLARED
/* 7 */
EXTERN void		Tcl_DbCkfree(char *ptr, CONST char *file, int line);
#endif
#ifndef Tcl_DbCkrealloc_TCL_DECLARED
#define Tcl_DbCkrealloc_TCL_DECLARED
/* 8 */
EXTERN char *		Tcl_DbCkrealloc(char *ptr, unsigned int size,
				CONST char *file, int line);
#endif
#if !defined(__WIN32__) && !defined(MAC_OSX_TCL) /* UNIX */
#ifndef Tcl_CreateFileHandler_TCL_DECLARED
#define Tcl_CreateFileHandler_TCL_DECLARED
/* 9 */
EXTERN void		Tcl_CreateFileHandler(int fd, int mask,
				Tcl_FileProc *proc, ClientData clientData);
#endif
#endif /* UNIX */
#ifdef MAC_OSX_TCL /* MACOSX */
#ifndef Tcl_CreateFileHandler_TCL_DECLARED
#define Tcl_CreateFileHandler_TCL_DECLARED
/* 9 */
EXTERN void		Tcl_CreateFileHandler(int fd, int mask,
				Tcl_FileProc *proc, ClientData clientData);
#endif
#endif /* MACOSX */
#if !defined(__WIN32__) && !defined(MAC_OSX_TCL) /* UNIX */
#ifndef Tcl_DeleteFileHandler_TCL_DECLARED
#define Tcl_DeleteFileHandler_TCL_DECLARED
/* 10 */
EXTERN void		Tcl_DeleteFileHandler(int fd);
#endif
#endif /* UNIX */
#ifdef MAC_OSX_TCL /* MACOSX */
#ifndef Tcl_DeleteFileHandler_TCL_DECLARED
#define Tcl_DeleteFileHandler_TCL_DECLARED
/* 10 */
EXTERN void		Tcl_DeleteFileHandler(int fd);
#endif
#endif /* MACOSX */
#ifndef Tcl_SetTimer_TCL_DECLARED
#define Tcl_SetTimer_TCL_DECLARED
/* 11 */
EXTERN void		Tcl_SetTimer(Tcl_Time *timePtr);
#endif
#ifndef Tcl_Sleep_TCL_DECLARED
#define Tcl_Sleep_TCL_DECLARED
/* 12 */
EXTERN void		Tcl_Sleep(int ms);
#endif
#ifndef Tcl_WaitForEvent_TCL_DECLARED
#define Tcl_WaitForEvent_TCL_DECLARED
/* 13 */
EXTERN int		Tcl_WaitForEvent(Tcl_Time *timePtr);
#endif
#ifndef Tcl_AppendAllObjTypes_TCL_DECLARED
#define Tcl_AppendAllObjTypes_TCL_DECLARED
/* 14 */
EXTERN int		Tcl_AppendAllObjTypes(Tcl_Interp *interp,
				Tcl_Obj *objPtr);
#endif
#ifndef Tcl_AppendStringsToObj_TCL_DECLARED
#define Tcl_AppendStringsToObj_TCL_DECLARED
/* 15 */
EXTERN void		Tcl_AppendStringsToObj(Tcl_Obj *objPtr, ...);
#endif
#ifndef Tcl_AppendToObj_TCL_DECLARED
#define Tcl_AppendToObj_TCL_DECLARED
/* 16 */
EXTERN void		Tcl_AppendToObj(Tcl_Obj *objPtr, CONST char *bytes,
				int length);
#endif
#ifndef Tcl_ConcatObj_TCL_DECLARED
#define Tcl_ConcatObj_TCL_DECLARED
/* 17 */
EXTERN Tcl_Obj *	Tcl_ConcatObj(int objc, Tcl_Obj *CONST objv[]);
#endif
#ifndef Tcl_ConvertToType_TCL_DECLARED
#define Tcl_ConvertToType_TCL_DECLARED
/* 18 */
EXTERN int		Tcl_ConvertToType(Tcl_Interp *interp,
				Tcl_Obj *objPtr, Tcl_ObjType *typePtr);
#endif
#ifndef Tcl_DbDecrRefCount_TCL_DECLARED
#define Tcl_DbDecrRefCount_TCL_DECLARED
/* 19 */
EXTERN void		Tcl_DbDecrRefCount(Tcl_Obj *objPtr, CONST char *file,
				int line);
#endif
#ifndef Tcl_DbIncrRefCount_TCL_DECLARED
#define Tcl_DbIncrRefCount_TCL_DECLARED
/* 20 */
EXTERN void		Tcl_DbIncrRefCount(Tcl_Obj *objPtr, CONST char *file,
				int line);
#endif
#ifndef Tcl_DbIsShared_TCL_DECLARED
#define Tcl_DbIsShared_TCL_DECLARED
/* 21 */
EXTERN int		Tcl_DbIsShared(Tcl_Obj *objPtr, CONST char *file,
				int line);
#endif
#ifndef Tcl_DbNewBooleanObj_TCL_DECLARED
#define Tcl_DbNewBooleanObj_TCL_DECLARED
/* 22 */
EXTERN Tcl_Obj *	Tcl_DbNewBooleanObj(int boolValue, CONST char *file,
				int line);
#endif
#ifndef Tcl_DbNewByteArrayObj_TCL_DECLARED
#define Tcl_DbNewByteArrayObj_TCL_DECLARED
/* 23 */
EXTERN Tcl_Obj *	Tcl_DbNewByteArrayObj(CONST unsigned char *bytes,
				int length, CONST char *file, int line);
#endif
#ifndef Tcl_DbNewDoubleObj_TCL_DECLARED
#define Tcl_DbNewDoubleObj_TCL_DECLARED
/* 24 */
EXTERN Tcl_Obj *	Tcl_DbNewDoubleObj(double doubleValue,
				CONST char *file, int line);
#endif
#ifndef Tcl_DbNewListObj_TCL_DECLARED
#define Tcl_DbNewListObj_TCL_DECLARED
/* 25 */
EXTERN Tcl_Obj *	Tcl_DbNewListObj(int objc, Tcl_Obj *CONST *objv,
				CONST char *file, int line);
#endif
#ifndef Tcl_DbNewLongObj_TCL_DECLARED
#define Tcl_DbNewLongObj_TCL_DECLARED
/* 26 */
EXTERN Tcl_Obj *	Tcl_DbNewLongObj(long longValue, CONST char *file,
				int line);
#endif
#ifndef Tcl_DbNewObj_TCL_DECLARED
#define Tcl_DbNewObj_TCL_DECLARED
/* 27 */
EXTERN Tcl_Obj *	Tcl_DbNewObj(CONST char *file, int line);
#endif
#ifndef Tcl_DbNewStringObj_TCL_DECLARED
#define Tcl_DbNewStringObj_TCL_DECLARED
/* 28 */
EXTERN Tcl_Obj *	Tcl_DbNewStringObj(CONST char *bytes, int length,
				CONST char *file, int line);
#endif
#ifndef Tcl_DuplicateObj_TCL_DECLARED
#define Tcl_DuplicateObj_TCL_DECLARED
/* 29 */
EXTERN Tcl_Obj *	Tcl_DuplicateObj(Tcl_Obj *objPtr);
#endif
#ifndef TclFreeObj_TCL_DECLARED
#define TclFreeObj_TCL_DECLARED
/* 30 */
EXTERN void		TclFreeObj(Tcl_Obj *objPtr);
#endif
#ifndef Tcl_GetBoolean_TCL_DECLARED
#define Tcl_GetBoolean_TCL_DECLARED
/* 31 */
EXTERN int		Tcl_GetBoolean(Tcl_Interp *interp, CONST char *src,
				int *boolPtr);
#endif
#ifndef Tcl_GetBooleanFromObj_TCL_DECLARED
#define Tcl_GetBooleanFromObj_TCL_DECLARED
/* 32 */
EXTERN int		Tcl_GetBooleanFromObj(Tcl_Interp *interp,
				Tcl_Obj *objPtr, int *boolPtr);
#endif
#ifndef Tcl_GetByteArrayFromObj_TCL_DECLARED
#define Tcl_GetByteArrayFromObj_TCL_DECLARED
/* 33 */
EXTERN unsigned char *	Tcl_GetByteArrayFromObj(Tcl_Obj *objPtr,
				int *lengthPtr);
#endif
#ifndef Tcl_GetDouble_TCL_DECLARED
#define Tcl_GetDouble_TCL_DECLARED
/* 34 */
EXTERN int		Tcl_GetDouble(Tcl_Interp *interp, CONST char *src,
				double *doublePtr);
#endif
#ifndef Tcl_GetDoubleFromObj_TCL_DECLARED
#define Tcl_GetDoubleFromObj_TCL_DECLARED
/* 35 */
EXTERN int		Tcl_GetDoubleFromObj(Tcl_Interp *interp,
				Tcl_Obj *objPtr, double *doublePtr);
#endif
#ifndef Tcl_GetIndexFromObj_TCL_DECLARED
#define Tcl_GetIndexFromObj_TCL_DECLARED
/* 36 */
EXTERN int		Tcl_GetIndexFromObj(Tcl_Interp *interp,
				Tcl_Obj *objPtr, CONST84 char **tablePtr,
				CONST char *msg, int flags, int *indexPtr);
#endif
#ifndef Tcl_GetInt_TCL_DECLARED
#define Tcl_GetInt_TCL_DECLARED
/* 37 */
EXTERN int		Tcl_GetInt(Tcl_Interp *interp, CONST char *src,
				int *intPtr);
#endif
#ifndef Tcl_GetIntFromObj_TCL_DECLARED
#define Tcl_GetIntFromObj_TCL_DECLARED
/* 38 */
EXTERN int		Tcl_GetIntFromObj(Tcl_Interp *interp,
				Tcl_Obj *objPtr, int *intPtr);
#endif
#ifndef Tcl_GetLongFromObj_TCL_DECLARED
#define Tcl_GetLongFromObj_TCL_DECLARED
/* 39 */
EXTERN int		Tcl_GetLongFromObj(Tcl_Interp *interp,
				Tcl_Obj *objPtr, long *longPtr);
#endif
#ifndef Tcl_GetObjType_TCL_DECLARED
#define Tcl_GetObjType_TCL_DECLARED
/* 40 */
EXTERN Tcl_ObjType *	Tcl_GetObjType(CONST char *typeName);
#endif
#ifndef Tcl_GetStringFromObj_TCL_DECLARED
#define Tcl_GetStringFromObj_TCL_DECLARED
/* 41 */
EXTERN char *		Tcl_GetStringFromObj(Tcl_Obj *objPtr, int *lengthPtr);
#endif
#ifndef Tcl_InvalidateStringRep_TCL_DECLARED
#define Tcl_InvalidateStringRep_TCL_DECLARED
/* 42 */
EXTERN void		Tcl_InvalidateStringRep(Tcl_Obj *objPtr);
#endif
#ifndef Tcl_ListObjAppendList_TCL_DECLARED
#define Tcl_ListObjAppendList_TCL_DECLARED
/* 43 */
EXTERN int		Tcl_ListObjAppendList(Tcl_Interp *interp,
				Tcl_Obj *listPtr, Tcl_Obj *elemListPtr);
#endif
#ifndef Tcl_ListObjAppendElement_TCL_DECLARED
#define Tcl_ListObjAppendElement_TCL_DECLARED
/* 44 */
EXTERN int		Tcl_ListObjAppendElement(Tcl_Interp *interp,
				Tcl_Obj *listPtr, Tcl_Obj *objPtr);
#endif
#ifndef Tcl_ListObjGetElements_TCL_DECLARED
#define Tcl_ListObjGetElements_TCL_DECLARED
/* 45 */
EXTERN int		Tcl_ListObjGetElements(Tcl_Interp *interp,
				Tcl_Obj *listPtr, int *objcPtr,
				Tcl_Obj ***objvPtr);
#endif
#ifndef Tcl_ListObjIndex_TCL_DECLARED
#define Tcl_ListObjIndex_TCL_DECLARED
/* 46 */
EXTERN int		Tcl_ListObjIndex(Tcl_Interp *interp,
				Tcl_Obj *listPtr, int index,
				Tcl_Obj **objPtrPtr);
#endif
#ifndef Tcl_ListObjLength_TCL_DECLARED
#define Tcl_ListObjLength_TCL_DECLARED
/* 47 */
EXTERN int		Tcl_ListObjLength(Tcl_Interp *interp,
				Tcl_Obj *listPtr, int *lengthPtr);
#endif
#ifndef Tcl_ListObjReplace_TCL_DECLARED
#define Tcl_ListObjReplace_TCL_DECLARED
/* 48 */
EXTERN int		Tcl_ListObjReplace(Tcl_Interp *interp,
				Tcl_Obj *listPtr, int first, int count,
				int objc, Tcl_Obj *CONST objv[]);
#endif
#ifndef Tcl_NewBooleanObj_TCL_DECLARED
#define Tcl_NewBooleanObj_TCL_DECLARED
/* 49 */
EXTERN Tcl_Obj *	Tcl_NewBooleanObj(int boolValue);
#endif
#ifndef Tcl_NewByteArrayObj_TCL_DECLARED
#define Tcl_NewByteArrayObj_TCL_DECLARED
/* 50 */
EXTERN Tcl_Obj *	Tcl_NewByteArrayObj(CONST unsigned char *bytes,
				int length);
#endif
#ifndef Tcl_NewDoubleObj_TCL_DECLARED
#define Tcl_NewDoubleObj_TCL_DECLARED
/* 51 */
EXTERN Tcl_Obj *	Tcl_NewDoubleObj(double doubleValue);
#endif
#ifndef Tcl_NewIntObj_TCL_DECLARED
#define Tcl_NewIntObj_TCL_DECLARED
/* 52 */
EXTERN Tcl_Obj *	Tcl_NewIntObj(int intValue);
#endif
#ifndef Tcl_NewListObj_TCL_DECLARED
#define Tcl_NewListObj_TCL_DECLARED
/* 53 */
EXTERN Tcl_Obj *	Tcl_NewListObj(int objc, Tcl_Obj *CONST objv[]);
#endif
#ifndef Tcl_NewLongObj_TCL_DECLARED
#define Tcl_NewLongObj_TCL_DECLARED
/* 54 */
EXTERN Tcl_Obj *	Tcl_NewLongObj(long longValue);
#endif
#ifndef Tcl_NewObj_TCL_DECLARED
#define Tcl_NewObj_TCL_DECLARED
/* 55 */
EXTERN Tcl_Obj *	Tcl_NewObj(void);
#endif
#ifndef Tcl_NewStringObj_TCL_DECLARED
#define Tcl_NewStringObj_TCL_DECLARED
/* 56 */
EXTERN Tcl_Obj *	Tcl_NewStringObj(CONST char *bytes, int length);
#endif
#ifndef Tcl_SetBooleanObj_TCL_DECLARED
#define Tcl_SetBooleanObj_TCL_DECLARED
/* 57 */
EXTERN void		Tcl_SetBooleanObj(Tcl_Obj *objPtr, int boolValue);
#endif
#ifndef Tcl_SetByteArrayLength_TCL_DECLARED
#define Tcl_SetByteArrayLength_TCL_DECLARED
/* 58 */
EXTERN unsigned char *	Tcl_SetByteArrayLength(Tcl_Obj *objPtr, int length);
#endif
#ifndef Tcl_SetByteArrayObj_TCL_DECLARED
#define Tcl_SetByteArrayObj_TCL_DECLARED
/* 59 */
EXTERN void		Tcl_SetByteArrayObj(Tcl_Obj *objPtr,
				CONST unsigned char *bytes, int length);
#endif
#ifndef Tcl_SetDoubleObj_TCL_DECLARED
#define Tcl_SetDoubleObj_TCL_DECLARED
/* 60 */
EXTERN void		Tcl_SetDoubleObj(Tcl_Obj *objPtr, double doubleValue);
#endif
#ifndef Tcl_SetIntObj_TCL_DECLARED
#define Tcl_SetIntObj_TCL_DECLARED
/* 61 */
EXTERN void		Tcl_SetIntObj(Tcl_Obj *objPtr, int intValue);
#endif
#ifndef Tcl_SetListObj_TCL_DECLARED
#define Tcl_SetListObj_TCL_DECLARED
/* 62 */
EXTERN void		Tcl_SetListObj(Tcl_Obj *objPtr, int objc,
				Tcl_Obj *CONST objv[]);
#endif
#ifndef Tcl_SetLongObj_TCL_DECLARED
#define Tcl_SetLongObj_TCL_DECLARED
/* 63 */
EXTERN void		Tcl_SetLongObj(Tcl_Obj *objPtr, long longValue);
#endif
#ifndef Tcl_SetObjLength_TCL_DECLARED
#define Tcl_SetObjLength_TCL_DECLARED
/* 64 */
EXTERN void		Tcl_SetObjLength(Tcl_Obj *objPtr, int length);
#endif
#ifndef Tcl_SetStringObj_TCL_DECLARED
#define Tcl_SetStringObj_TCL_DECLARED
/* 65 */
EXTERN void		Tcl_SetStringObj(Tcl_Obj *objPtr, CONST char *bytes,
				int length);
#endif
#ifndef Tcl_AddErrorInfo_TCL_DECLARED
#define Tcl_AddErrorInfo_TCL_DECLARED
/* 66 */
EXTERN void		Tcl_AddErrorInfo(Tcl_Interp *interp,
				CONST char *message);
#endif
#ifndef Tcl_AddObjErrorInfo_TCL_DECLARED
#define Tcl_AddObjErrorInfo_TCL_DECLARED
/* 67 */
EXTERN void		Tcl_AddObjErrorInfo(Tcl_Interp *interp,
				CONST char *message, int length);
#endif
#ifndef Tcl_AllowExceptions_TCL_DECLARED
#define Tcl_AllowExceptions_TCL_DECLARED
/* 68 */
EXTERN void		Tcl_AllowExceptions(Tcl_Interp *interp);
#endif
#ifndef Tcl_AppendElement_TCL_DECLARED
#define Tcl_AppendElement_TCL_DECLARED
/* 69 */
EXTERN void		Tcl_AppendElement(Tcl_Interp *interp,
				CONST char *element);
#endif
#ifndef Tcl_AppendResult_TCL_DECLARED
#define Tcl_AppendResult_TCL_DECLARED
/* 70 */
EXTERN void		Tcl_AppendResult(Tcl_Interp *interp, ...);
#endif
#ifndef Tcl_AsyncCreate_TCL_DECLARED
#define Tcl_AsyncCreate_TCL_DECLARED
/* 71 */
EXTERN Tcl_AsyncHandler	 Tcl_AsyncCreate(Tcl_AsyncProc *proc,
				ClientData clientData);
#endif
#ifndef Tcl_AsyncDelete_TCL_DECLARED
#define Tcl_AsyncDelete_TCL_DECLARED
/* 72 */
EXTERN void		Tcl_AsyncDelete(Tcl_AsyncHandler async);
#endif
#ifndef Tcl_AsyncInvoke_TCL_DECLARED
#define Tcl_AsyncInvoke_TCL_DECLARED
/* 73 */
EXTERN int		Tcl_AsyncInvoke(Tcl_Interp *interp, int code);
#endif
#ifndef Tcl_AsyncMark_TCL_DECLARED
#define Tcl_AsyncMark_TCL_DECLARED
/* 74 */
EXTERN void		Tcl_AsyncMark(Tcl_AsyncHandler async);
#endif
#ifndef Tcl_AsyncReady_TCL_DECLARED
#define Tcl_AsyncReady_TCL_DECLARED
/* 75 */
EXTERN int		Tcl_AsyncReady(void);
#endif
#ifndef Tcl_BackgroundError_TCL_DECLARED
#define Tcl_BackgroundError_TCL_DECLARED
/* 76 */
EXTERN void		Tcl_BackgroundError(Tcl_Interp *interp);
#endif
#ifndef Tcl_Backslash_TCL_DECLARED
#define Tcl_Backslash_TCL_DECLARED
/* 77 */
EXTERN char		Tcl_Backslash(CONST char *src, int *readPtr);
#endif
#ifndef Tcl_BadChannelOption_TCL_DECLARED
#define Tcl_BadChannelOption_TCL_DECLARED
/* 78 */
EXTERN int		Tcl_BadChannelOption(Tcl_Interp *interp,
				CONST char *optionName,
				CONST char *optionList);
#endif
#ifndef Tcl_CallWhenDeleted_TCL_DECLARED
#define Tcl_CallWhenDeleted_TCL_DECLARED
/* 79 */
EXTERN void		Tcl_CallWhenDeleted(Tcl_Interp *interp,
				Tcl_InterpDeleteProc *proc,
				ClientData clientData);
#endif
#ifndef Tcl_CancelIdleCall_TCL_DECLARED
#define Tcl_CancelIdleCall_TCL_DECLARED
/* 80 */
EXTERN void		Tcl_CancelIdleCall(Tcl_IdleProc *idleProc,
				ClientData clientData);
#endif
#ifndef Tcl_Close_TCL_DECLARED
#define Tcl_Close_TCL_DECLARED
/* 81 */
EXTERN int		Tcl_Close(Tcl_Interp *interp, Tcl_Channel chan);
#endif
#ifndef Tcl_CommandComplete_TCL_DECLARED
#define Tcl_CommandComplete_TCL_DECLARED
/* 82 */
EXTERN int		Tcl_CommandComplete(CONST char *cmd);
#endif
#ifndef Tcl_Concat_TCL_DECLARED
#define Tcl_Concat_TCL_DECLARED
/* 83 */
EXTERN char *		Tcl_Concat(int argc, CONST84 char *CONST *argv);
#endif
#ifndef Tcl_ConvertElement_TCL_DECLARED
#define Tcl_ConvertElement_TCL_DECLARED
/* 84 */
EXTERN int		Tcl_ConvertElement(CONST char *src, char *dst,
				int flags);
#endif
#ifndef Tcl_ConvertCountedElement_TCL_DECLARED
#define Tcl_ConvertCountedElement_TCL_DECLARED
/* 85 */
EXTERN int		Tcl_ConvertCountedElement(CONST char *src,
				int length, char *dst, int flags);
#endif
#ifndef Tcl_CreateAlias_TCL_DECLARED
#define Tcl_CreateAlias_TCL_DECLARED
/* 86 */
EXTERN int		Tcl_CreateAlias(Tcl_Interp *slave,
				CONST char *slaveCmd, Tcl_Interp *target,
				CONST char *targetCmd, int argc,
				CONST84 char *CONST *argv);
#endif
#ifndef Tcl_CreateAliasObj_TCL_DECLARED
#define Tcl_CreateAliasObj_TCL_DECLARED
/* 87 */
EXTERN int		Tcl_CreateAliasObj(Tcl_Interp *slave,
				CONST char *slaveCmd, Tcl_Interp *target,
				CONST char *targetCmd, int objc,
				Tcl_Obj *CONST objv[]);
#endif
#ifndef Tcl_CreateChannel_TCL_DECLARED
#define Tcl_CreateChannel_TCL_DECLARED
/* 88 */
EXTERN Tcl_Channel	Tcl_CreateChannel(Tcl_ChannelType *typePtr,
				CONST char *chanName,
				ClientData instanceData, int mask);
#endif
#ifndef Tcl_CreateChannelHandler_TCL_DECLARED
#define Tcl_CreateChannelHandler_TCL_DECLARED
/* 89 */
EXTERN void		Tcl_CreateChannelHandler(Tcl_Channel chan, int mask,
				Tcl_ChannelProc *proc, ClientData clientData);
#endif
#ifndef Tcl_CreateCloseHandler_TCL_DECLARED
#define Tcl_CreateCloseHandler_TCL_DECLARED
/* 90 */
EXTERN void		Tcl_CreateCloseHandler(Tcl_Channel chan,
				Tcl_CloseProc *proc, ClientData clientData);
#endif
#ifndef Tcl_CreateCommand_TCL_DECLARED
#define Tcl_CreateCommand_TCL_DECLARED
/* 91 */
EXTERN Tcl_Command	Tcl_CreateCommand(Tcl_Interp *interp,
				CONST char *cmdName, Tcl_CmdProc *proc,
				ClientData clientData,
				Tcl_CmdDeleteProc *deleteProc);
#endif
#ifndef Tcl_CreateEventSource_TCL_DECLARED
#define Tcl_CreateEventSource_TCL_DECLARED
/* 92 */
EXTERN void		Tcl_CreateEventSource(Tcl_EventSetupProc *setupProc,
				Tcl_EventCheckProc *checkProc,
				ClientData clientData);
#endif
#ifndef Tcl_CreateExitHandler_TCL_DECLARED
#define Tcl_CreateExitHandler_TCL_DECLARED
/* 93 */
EXTERN void		Tcl_CreateExitHandler(Tcl_ExitProc *proc,
				ClientData clientData);
#endif
#ifndef Tcl_CreateInterp_TCL_DECLARED
#define Tcl_CreateInterp_TCL_DECLARED
/* 94 */
EXTERN Tcl_Interp *	Tcl_CreateInterp(void);
#endif
#ifndef Tcl_CreateMathFunc_TCL_DECLARED
#define Tcl_CreateMathFunc_TCL_DECLARED
/* 95 */
EXTERN void		Tcl_CreateMathFunc(Tcl_Interp *interp,
				CONST char *name, int numArgs,
				Tcl_ValueType *argTypes, Tcl_MathProc *proc,
				ClientData clientData);
#endif
#ifndef Tcl_CreateObjCommand_TCL_DECLARED
#define Tcl_CreateObjCommand_TCL_DECLARED
/* 96 */
EXTERN Tcl_Command	Tcl_CreateObjCommand(Tcl_Interp *interp,
				CONST char *cmdName, Tcl_ObjCmdProc *proc,
				ClientData clientData,
				Tcl_CmdDeleteProc *deleteProc);
#endif
#ifndef Tcl_CreateSlave_TCL_DECLARED
#define Tcl_CreateSlave_TCL_DECLARED
/* 97 */
EXTERN Tcl_Interp *	Tcl_CreateSlave(Tcl_Interp *interp,
				CONST char *slaveName, int isSafe);
#endif
#ifndef Tcl_CreateTimerHandler_TCL_DECLARED
#define Tcl_CreateTimerHandler_TCL_DECLARED
/* 98 */
EXTERN Tcl_TimerToken	Tcl_CreateTimerHandler(int milliseconds,
				Tcl_TimerProc *proc, ClientData clientData);
#endif
#ifndef Tcl_CreateTrace_TCL_DECLARED
#define Tcl_CreateTrace_TCL_DECLARED
/* 99 */
EXTERN Tcl_Trace	Tcl_CreateTrace(Tcl_Interp *interp, int level,
				Tcl_CmdTraceProc *proc,
				ClientData clientData);
#endif
#ifndef Tcl_DeleteAssocData_TCL_DECLARED
#define Tcl_DeleteAssocData_TCL_DECLARED
/* 100 */
EXTERN void		Tcl_DeleteAssocData(Tcl_Interp *interp,
				CONST char *name);
#endif
#ifndef Tcl_DeleteChannelHandler_TCL_DECLARED
#define Tcl_DeleteChannelHandler_TCL_DECLARED
/* 101 */
EXTERN void		Tcl_DeleteChannelHandler(Tcl_Channel chan,
				Tcl_ChannelProc *proc, ClientData clientData);
#endif
#ifndef Tcl_DeleteCloseHandler_TCL_DECLARED
#define Tcl_DeleteCloseHandler_TCL_DECLARED
/* 102 */
EXTERN void		Tcl_DeleteCloseHandler(Tcl_Channel chan,
				Tcl_CloseProc *proc, ClientData clientData);
#endif
#ifndef Tcl_DeleteCommand_TCL_DECLARED
#define Tcl_DeleteCommand_TCL_DECLARED
/* 103 */
EXTERN int		Tcl_DeleteCommand(Tcl_Interp *interp,
				CONST char *cmdName);
#endif
#ifndef Tcl_DeleteCommandFromToken_TCL_DECLARED
#define Tcl_DeleteCommandFromToken_TCL_DECLARED
/* 104 */
EXTERN int		Tcl_DeleteCommandFromToken(Tcl_Interp *interp,
				Tcl_Command command);
#endif
#ifndef Tcl_DeleteEvents_TCL_DECLARED
#define Tcl_DeleteEvents_TCL_DECLARED
/* 105 */
EXTERN void		Tcl_DeleteEvents(Tcl_EventDeleteProc *proc,
				ClientData clientData);
#endif
#ifndef Tcl_DeleteEventSource_TCL_DECLARED
#define Tcl_DeleteEventSource_TCL_DECLARED
/* 106 */
EXTERN void		Tcl_DeleteEventSource(Tcl_EventSetupProc *setupProc,
				Tcl_EventCheckProc *checkProc,
				ClientData clientData);
#endif
#ifndef Tcl_DeleteExitHandler_TCL_DECLARED
#define Tcl_DeleteExitHandler_TCL_DECLARED
/* 107 */
EXTERN void		Tcl_DeleteExitHandler(Tcl_ExitProc *proc,
				ClientData clientData);
#endif
#ifndef Tcl_DeleteHashEntry_TCL_DECLARED
#define Tcl_DeleteHashEntry_TCL_DECLARED
/* 108 */
EXTERN void		Tcl_DeleteHashEntry(Tcl_HashEntry *entryPtr);
#endif
#ifndef Tcl_DeleteHashTable_TCL_DECLARED
#define Tcl_DeleteHashTable_TCL_DECLARED
/* 109 */
EXTERN void		Tcl_DeleteHashTable(Tcl_HashTable *tablePtr);
#endif
#ifndef Tcl_DeleteInterp_TCL_DECLARED
#define Tcl_DeleteInterp_TCL_DECLARED
/* 110 */
EXTERN void		Tcl_DeleteInterp(Tcl_Interp *interp);
#endif
#ifndef Tcl_DetachPids_TCL_DECLARED
#define Tcl_DetachPids_TCL_DECLARED
/* 111 */
EXTERN void		Tcl_DetachPids(int numPids, Tcl_Pid *pidPtr);
#endif
#ifndef Tcl_DeleteTimerHandler_TCL_DECLARED
#define Tcl_DeleteTimerHandler_TCL_DECLARED
/* 112 */
EXTERN void		Tcl_DeleteTimerHandler(Tcl_TimerToken token);
#endif
#ifndef Tcl_DeleteTrace_TCL_DECLARED
#define Tcl_DeleteTrace_TCL_DECLARED
/* 113 */
EXTERN void		Tcl_DeleteTrace(Tcl_Interp *interp, Tcl_Trace trace);
#endif
#ifndef Tcl_DontCallWhenDeleted_TCL_DECLARED
#define Tcl_DontCallWhenDeleted_TCL_DECLARED
/* 114 */
EXTERN void		Tcl_DontCallWhenDeleted(Tcl_Interp *interp,
				Tcl_InterpDeleteProc *proc,
				ClientData clientData);
#endif
#ifndef Tcl_DoOneEvent_TCL_DECLARED
#define Tcl_DoOneEvent_TCL_DECLARED
/* 115 */
EXTERN int		Tcl_DoOneEvent(int flags);
#endif
#ifndef Tcl_DoWhenIdle_TCL_DECLARED
#define Tcl_DoWhenIdle_TCL_DECLARED
/* 116 */
EXTERN void		Tcl_DoWhenIdle(Tcl_IdleProc *proc,
				ClientData clientData);
#endif
#ifndef Tcl_DStringAppend_TCL_DECLARED
#define Tcl_DStringAppend_TCL_DECLARED
/* 117 */
EXTERN char *		Tcl_DStringAppend(Tcl_DString *dsPtr,
				CONST char *bytes, int length);
#endif
#ifndef Tcl_DStringAppendElement_TCL_DECLARED
#define Tcl_DStringAppendElement_TCL_DECLARED
/* 118 */
EXTERN char *		Tcl_DStringAppendElement(Tcl_DString *dsPtr,
				CONST char *element);
#endif
#ifndef Tcl_DStringEndSublist_TCL_DECLARED
#define Tcl_DStringEndSublist_TCL_DECLARED
/* 119 */
EXTERN void		Tcl_DStringEndSublist(Tcl_DString *dsPtr);
#endif
#ifndef Tcl_DStringFree_TCL_DECLARED
#define Tcl_DStringFree_TCL_DECLARED
/* 120 */
EXTERN void		Tcl_DStringFree(Tcl_DString *dsPtr);
#endif
#ifndef Tcl_DStringGetResult_TCL_DECLARED
#define Tcl_DStringGetResult_TCL_DECLARED
/* 121 */
EXTERN void		Tcl_DStringGetResult(Tcl_Interp *interp,
				Tcl_DString *dsPtr);
#endif
#ifndef Tcl_DStringInit_TCL_DECLARED
#define Tcl_DStringInit_TCL_DECLARED
/* 122 */
EXTERN void		Tcl_DStringInit(Tcl_DString *dsPtr);
#endif
#ifndef Tcl_DStringResult_TCL_DECLARED
#define Tcl_DStringResult_TCL_DECLARED
/* 123 */
EXTERN void		Tcl_DStringResult(Tcl_Interp *interp,
				Tcl_DString *dsPtr);
#endif
#ifndef Tcl_DStringSetLength_TCL_DECLARED
#define Tcl_DStringSetLength_TCL_DECLARED
/* 124 */
EXTERN void		Tcl_DStringSetLength(Tcl_DString *dsPtr, int length);
#endif
#ifndef Tcl_DStringStartSublist_TCL_DECLARED
#define Tcl_DStringStartSublist_TCL_DECLARED
/* 125 */
EXTERN void		Tcl_DStringStartSublist(Tcl_DString *dsPtr);
#endif
#ifndef Tcl_Eof_TCL_DECLARED
#define Tcl_Eof_TCL_DECLARED
/* 126 */
EXTERN int		Tcl_Eof(Tcl_Channel chan);
#endif
#ifndef Tcl_ErrnoId_TCL_DECLARED
#define Tcl_ErrnoId_TCL_DECLARED
/* 127 */
EXTERN CONST84_RETURN char * Tcl_ErrnoId(void);
#endif
#ifndef Tcl_ErrnoMsg_TCL_DECLARED
#define Tcl_ErrnoMsg_TCL_DECLARED
/* 128 */
EXTERN CONST84_RETURN char * Tcl_ErrnoMsg(int err);
#endif
#ifndef Tcl_Eval_TCL_DECLARED
#define Tcl_Eval_TCL_DECLARED
/* 129 */
EXTERN int		Tcl_Eval(Tcl_Interp *interp, CONST char *script);
#endif
#ifndef Tcl_EvalFile_TCL_DECLARED
#define Tcl_EvalFile_TCL_DECLARED
/* 130 */
EXTERN int		Tcl_EvalFile(Tcl_Interp *interp,
				CONST char *fileName);
#endif
#ifndef Tcl_EvalObj_TCL_DECLARED
#define Tcl_EvalObj_TCL_DECLARED
/* 131 */
EXTERN int		Tcl_EvalObj(Tcl_Interp *interp, Tcl_Obj *objPtr);
#endif
#ifndef Tcl_EventuallyFree_TCL_DECLARED
#define Tcl_EventuallyFree_TCL_DECLARED
/* 132 */
EXTERN void		Tcl_EventuallyFree(ClientData clientData,
				Tcl_FreeProc *freeProc);
#endif
#ifndef Tcl_Exit_TCL_DECLARED
#define Tcl_Exit_TCL_DECLARED
/* 133 */
EXTERN void		Tcl_Exit(int status);
#endif
#ifndef Tcl_ExposeCommand_TCL_DECLARED
#define Tcl_ExposeCommand_TCL_DECLARED
/* 134 */
EXTERN int		Tcl_ExposeCommand(Tcl_Interp *interp,
				CONST char *hiddenCmdToken,
				CONST char *cmdName);
#endif
#ifndef Tcl_ExprBoolean_TCL_DECLARED
#define Tcl_ExprBoolean_TCL_DECLARED
/* 135 */
EXTERN int		Tcl_ExprBoolean(Tcl_Interp *interp, CONST char *expr,
				int *ptr);
#endif
#ifndef Tcl_ExprBooleanObj_TCL_DECLARED
#define Tcl_ExprBooleanObj_TCL_DECLARED
/* 136 */
EXTERN int		Tcl_ExprBooleanObj(Tcl_Interp *interp,
				Tcl_Obj *objPtr, int *ptr);
#endif
#ifndef Tcl_ExprDouble_TCL_DECLARED
#define Tcl_ExprDouble_TCL_DECLARED
/* 137 */
EXTERN int		Tcl_ExprDouble(Tcl_Interp *interp, CONST char *expr,
				double *ptr);
#endif
#ifndef Tcl_ExprDoubleObj_TCL_DECLARED
#define Tcl_ExprDoubleObj_TCL_DECLARED
/* 138 */
EXTERN int		Tcl_ExprDoubleObj(Tcl_Interp *interp,
				Tcl_Obj *objPtr, double *ptr);
#endif
#ifndef Tcl_ExprLong_TCL_DECLARED
#define Tcl_ExprLong_TCL_DECLARED
/* 139 */
EXTERN int		Tcl_ExprLong(Tcl_Interp *interp, CONST char *expr,
				long *ptr);
#endif
#ifndef Tcl_ExprLongObj_TCL_DECLARED
#define Tcl_ExprLongObj_TCL_DECLARED
/* 140 */
EXTERN int		Tcl_ExprLongObj(Tcl_Interp *interp, Tcl_Obj *objPtr,
				long *ptr);
#endif
#ifndef Tcl_ExprObj_TCL_DECLARED
#define Tcl_ExprObj_TCL_DECLARED
/* 141 */
EXTERN int		Tcl_ExprObj(Tcl_Interp *interp, Tcl_Obj *objPtr,
				Tcl_Obj **resultPtrPtr);
#endif
#ifndef Tcl_ExprString_TCL_DECLARED
#define Tcl_ExprString_TCL_DECLARED
/* 142 */
EXTERN int		Tcl_ExprString(Tcl_Interp *interp, CONST char *expr);
#endif
#ifndef Tcl_Finalize_TCL_DECLARED
#define Tcl_Finalize_TCL_DECLARED
/* 143 */
EXTERN void		Tcl_Finalize(void);
#endif
#ifndef Tcl_FindExecutable_TCL_DECLARED
#define Tcl_FindExecutable_TCL_DECLARED
/* 144 */
EXTERN void		Tcl_FindExecutable(CONST char *argv0);
#endif
#ifndef Tcl_FirstHashEntry_TCL_DECLARED
#define Tcl_FirstHashEntry_TCL_DECLARED
/* 145 */
EXTERN Tcl_HashEntry *	Tcl_FirstHashEntry(Tcl_HashTable *tablePtr,
				Tcl_HashSearch *searchPtr);
#endif
#ifndef Tcl_Flush_TCL_DECLARED
#define Tcl_Flush_TCL_DECLARED
/* 146 */
EXTERN int		Tcl_Flush(Tcl_Channel chan);
#endif
#ifndef Tcl_FreeResult_TCL_DECLARED
#define Tcl_FreeResult_TCL_DECLARED
/* 147 */
EXTERN void		Tcl_FreeResult(Tcl_Interp *interp);
#endif
#ifndef Tcl_GetAlias_TCL_DECLARED
#define Tcl_GetAlias_TCL_DECLARED
/* 148 */
EXTERN int		Tcl_GetAlias(Tcl_Interp *interp,
				CONST char *slaveCmd,
				Tcl_Interp **targetInterpPtr,
				CONST84 char **targetCmdPtr, int *argcPtr,
				CONST84 char ***argvPtr);
#endif
#ifndef Tcl_GetAliasObj_TCL_DECLARED
#define Tcl_GetAliasObj_TCL_DECLARED
/* 149 */
EXTERN int		Tcl_GetAliasObj(Tcl_Interp *interp,
				CONST char *slaveCmd,
				Tcl_Interp **targetInterpPtr,
				CONST84 char **targetCmdPtr, int *objcPtr,
				Tcl_Obj ***objv);
#endif
#ifndef Tcl_GetAssocData_TCL_DECLARED
#define Tcl_GetAssocData_TCL_DECLARED
/* 150 */
EXTERN ClientData	Tcl_GetAssocData(Tcl_Interp *interp,
				CONST char *name,
				Tcl_InterpDeleteProc **procPtr);
#endif
#ifndef Tcl_GetChannel_TCL_DECLARED
#define Tcl_GetChannel_TCL_DECLARED
/* 151 */
EXTERN Tcl_Channel	Tcl_GetChannel(Tcl_Interp *interp,
				CONST char *chanName, int *modePtr);
#endif
#ifndef Tcl_GetChannelBufferSize_TCL_DECLARED
#define Tcl_GetChannelBufferSize_TCL_DECLARED
/* 152 */
EXTERN int		Tcl_GetChannelBufferSize(Tcl_Channel chan);
#endif
#ifndef Tcl_GetChannelHandle_TCL_DECLARED
#define Tcl_GetChannelHandle_TCL_DECLARED
/* 153 */
EXTERN int		Tcl_GetChannelHandle(Tcl_Channel chan, int direction,
				ClientData *handlePtr);
#endif
#ifndef Tcl_GetChannelInstanceData_TCL_DECLARED
#define Tcl_GetChannelInstanceData_TCL_DECLARED
/* 154 */
EXTERN ClientData	Tcl_GetChannelInstanceData(Tcl_Channel chan);
#endif
#ifndef Tcl_GetChannelMode_TCL_DECLARED
#define Tcl_GetChannelMode_TCL_DECLARED
/* 155 */
EXTERN int		Tcl_GetChannelMode(Tcl_Channel chan);
#endif
#ifndef Tcl_GetChannelName_TCL_DECLARED
#define Tcl_GetChannelName_TCL_DECLARED
/* 156 */
EXTERN CONST84_RETURN char * Tcl_GetChannelName(Tcl_Channel chan);
#endif
#ifndef Tcl_GetChannelOption_TCL_DECLARED
#define Tcl_GetChannelOption_TCL_DECLARED
/* 157 */
EXTERN int		Tcl_GetChannelOption(Tcl_Interp *interp,
				Tcl_Channel chan, CONST char *optionName,
				Tcl_DString *dsPtr);
#endif
#ifndef Tcl_GetChannelType_TCL_DECLARED
#define Tcl_GetChannelType_TCL_DECLARED
/* 158 */
EXTERN Tcl_ChannelType * Tcl_GetChannelType(Tcl_Channel chan);
#endif
#ifndef Tcl_GetCommandInfo_TCL_DECLARED
#define Tcl_GetCommandInfo_TCL_DECLARED
/* 159 */
EXTERN int		Tcl_GetCommandInfo(Tcl_Interp *interp,
				CONST char *cmdName, Tcl_CmdInfo *infoPtr);
#endif
#ifndef Tcl_GetCommandName_TCL_DECLARED
#define Tcl_GetCommandName_TCL_DECLARED
/* 160 */
EXTERN CONST84_RETURN char * Tcl_GetCommandName(Tcl_Interp *interp,
				Tcl_Command command);
#endif
#ifndef Tcl_GetErrno_TCL_DECLARED
#define Tcl_GetErrno_TCL_DECLARED
/* 161 */
EXTERN int		Tcl_GetErrno(void);
#endif
#ifndef Tcl_GetHostName_TCL_DECLARED
#define Tcl_GetHostName_TCL_DECLARED
/* 162 */
EXTERN CONST84_RETURN char * Tcl_GetHostName(void);
#endif
#ifndef Tcl_GetInterpPath_TCL_DECLARED
#define Tcl_GetInterpPath_TCL_DECLARED
/* 163 */
EXTERN int		Tcl_GetInterpPath(Tcl_Interp *askInterp,
				Tcl_Interp *slaveInterp);
#endif
#ifndef Tcl_GetMaster_TCL_DECLARED
#define Tcl_GetMaster_TCL_DECLARED
/* 164 */
EXTERN Tcl_Interp *	Tcl_GetMaster(Tcl_Interp *interp);
#endif
#ifndef Tcl_GetNameOfExecutable_TCL_DECLARED
#define Tcl_GetNameOfExecutable_TCL_DECLARED
/* 165 */
EXTERN CONST char *	Tcl_GetNameOfExecutable(void);
#endif
#ifndef Tcl_GetObjResult_TCL_DECLARED
#define Tcl_GetObjResult_TCL_DECLARED
/* 166 */
EXTERN Tcl_Obj *	Tcl_GetObjResult(Tcl_Interp *interp);
#endif
#if !defined(__WIN32__) && !defined(MAC_OSX_TCL) /* UNIX */
#ifndef Tcl_GetOpenFile_TCL_DECLARED
#define Tcl_GetOpenFile_TCL_DECLARED
/* 167 */
EXTERN int		Tcl_GetOpenFile(Tcl_Interp *interp,
				CONST char *chanID, int forWriting,
				int checkUsage, ClientData *filePtr);
#endif
#endif /* UNIX */
#ifdef MAC_OSX_TCL /* MACOSX */
#ifndef Tcl_GetOpenFile_TCL_DECLARED
#define Tcl_GetOpenFile_TCL_DECLARED
/* 167 */
EXTERN int		Tcl_GetOpenFile(Tcl_Interp *interp,
				CONST char *chanID, int forWriting,
				int checkUsage, ClientData *filePtr);
#endif
#endif /* MACOSX */
#ifndef Tcl_GetPathType_TCL_DECLARED
#define Tcl_GetPathType_TCL_DECLARED
/* 168 */
EXTERN Tcl_PathType	Tcl_GetPathType(CONST char *path);
#endif
#ifndef Tcl_Gets_TCL_DECLARED
#define Tcl_Gets_TCL_DECLARED
/* 169 */
EXTERN int		Tcl_Gets(Tcl_Channel chan, Tcl_DString *dsPtr);
#endif
#ifndef Tcl_GetsObj_TCL_DECLARED
#define Tcl_GetsObj_TCL_DECLARED
/* 170 */
EXTERN int		Tcl_GetsObj(Tcl_Channel chan, Tcl_Obj *objPtr);
#endif
#ifndef Tcl_GetServiceMode_TCL_DECLARED
#define Tcl_GetServiceMode_TCL_DECLARED
/* 171 */
EXTERN int		Tcl_GetServiceMode(void);
#endif
#ifndef Tcl_GetSlave_TCL_DECLARED
#define Tcl_GetSlave_TCL_DECLARED
/* 172 */
EXTERN Tcl_Interp *	Tcl_GetSlave(Tcl_Interp *interp,
				CONST char *slaveName);
#endif
#ifndef Tcl_GetStdChannel_TCL_DECLARED
#define Tcl_GetStdChannel_TCL_DECLARED
/* 173 */
EXTERN Tcl_Channel	Tcl_GetStdChannel(int type);
#endif
#ifndef Tcl_GetStringResult_TCL_DECLARED
#define Tcl_GetStringResult_TCL_DECLARED
/* 174 */
EXTERN CONST84_RETURN char * Tcl_GetStringResult(Tcl_Interp *interp);
#endif
#ifndef Tcl_GetVar_TCL_DECLARED
#define Tcl_GetVar_TCL_DECLARED
/* 175 */
EXTERN CONST84_RETURN char * Tcl_GetVar(Tcl_Interp *interp,
				CONST char *varName, int flags);
#endif
#ifndef Tcl_GetVar2_TCL_DECLARED
#define Tcl_GetVar2_TCL_DECLARED
/* 176 */
EXTERN CONST84_RETURN char * Tcl_GetVar2(Tcl_Interp *interp,
				CONST char *part1, CONST char *part2,
				int flags);
#endif
#ifndef Tcl_GlobalEval_TCL_DECLARED
#define Tcl_GlobalEval_TCL_DECLARED
/* 177 */
EXTERN int		Tcl_GlobalEval(Tcl_Interp *interp,
				CONST char *command);
#endif
#ifndef Tcl_GlobalEvalObj_TCL_DECLARED
#define Tcl_GlobalEvalObj_TCL_DECLARED
/* 178 */
EXTERN int		Tcl_GlobalEvalObj(Tcl_Interp *interp,
				Tcl_Obj *objPtr);
#endif
#ifndef Tcl_HideCommand_TCL_DECLARED
#define Tcl_HideCommand_TCL_DECLARED
/* 179 */
EXTERN int		Tcl_HideCommand(Tcl_Interp *interp,
				CONST char *cmdName,
				CONST char *hiddenCmdToken);
#endif
#ifndef Tcl_Init_TCL_DECLARED
#define Tcl_Init_TCL_DECLARED
/* 180 */
EXTERN int		Tcl_Init(Tcl_Interp *interp);
#endif
#ifndef Tcl_InitHashTable_TCL_DECLARED
#define Tcl_InitHashTable_TCL_DECLARED
/* 181 */
EXTERN void		Tcl_InitHashTable(Tcl_HashTable *tablePtr,
				int keyType);
#endif
#ifndef Tcl_InputBlocked_TCL_DECLARED
#define Tcl_InputBlocked_TCL_DECLARED
/* 182 */
EXTERN int		Tcl_InputBlocked(Tcl_Channel chan);
#endif
#ifndef Tcl_InputBuffered_TCL_DECLARED
#define Tcl_InputBuffered_TCL_DECLARED
/* 183 */
EXTERN int		Tcl_InputBuffered(Tcl_Channel chan);
#endif
#ifndef Tcl_InterpDeleted_TCL_DECLARED
#define Tcl_InterpDeleted_TCL_DECLARED
/* 184 */
EXTERN int		Tcl_InterpDeleted(Tcl_Interp *interp);
#endif
#ifndef Tcl_IsSafe_TCL_DECLARED
#define Tcl_IsSafe_TCL_DECLARED
/* 185 */
EXTERN int		Tcl_IsSafe(Tcl_Interp *interp);
#endif
#ifndef Tcl_JoinPath_TCL_DECLARED
#define Tcl_JoinPath_TCL_DECLARED
/* 186 */
EXTERN char *		Tcl_JoinPath(int argc, CONST84 char *CONST *argv,
				Tcl_DString *resultPtr);
#endif
#ifndef Tcl_LinkVar_TCL_DECLARED
#define Tcl_LinkVar_TCL_DECLARED
/* 187 */
EXTERN int		Tcl_LinkVar(Tcl_Interp *interp, CONST char *varName,
				char *addr, int type);
#endif
/* Slot 188 is reserved */
#ifndef Tcl_MakeFileChannel_TCL_DECLARED
#define Tcl_MakeFileChannel_TCL_DECLARED
/* 189 */
EXTERN Tcl_Channel	Tcl_MakeFileChannel(ClientData handle, int mode);
#endif
#ifndef Tcl_MakeSafe_TCL_DECLARED
#define Tcl_MakeSafe_TCL_DECLARED
/* 190 */
EXTERN int		Tcl_MakeSafe(Tcl_Interp *interp);
#endif
#ifndef Tcl_MakeTcpClientChannel_TCL_DECLARED
#define Tcl_MakeTcpClientChannel_TCL_DECLARED
/* 191 */
EXTERN Tcl_Channel	Tcl_MakeTcpClientChannel(ClientData tcpSocket);
#endif
#ifndef Tcl_Merge_TCL_DECLARED
#define Tcl_Merge_TCL_DECLARED
/* 192 */
EXTERN char *		Tcl_Merge(int argc, CONST84 char *CONST *argv);
#endif
#ifndef Tcl_NextHashEntry_TCL_DECLARED
#define Tcl_NextHashEntry_TCL_DECLARED
/* 193 */
EXTERN Tcl_HashEntry *	Tcl_NextHashEntry(Tcl_HashSearch *searchPtr);
#endif
#ifndef Tcl_NotifyChannel_TCL_DECLARED
#define Tcl_NotifyChannel_TCL_DECLARED
/* 194 */
EXTERN void		Tcl_NotifyChannel(Tcl_Channel channel, int mask);
#endif
#ifndef Tcl_ObjGetVar2_TCL_DECLARED
#define Tcl_ObjGetVar2_TCL_DECLARED
/* 195 */
EXTERN Tcl_Obj *	Tcl_ObjGetVar2(Tcl_Interp *interp, Tcl_Obj *part1Ptr,
				Tcl_Obj *part2Ptr, int flags);
#endif
#ifndef Tcl_ObjSetVar2_TCL_DECLARED
#define Tcl_ObjSetVar2_TCL_DECLARED
/* 196 */
EXTERN Tcl_Obj *	Tcl_ObjSetVar2(Tcl_Interp *interp, Tcl_Obj *part1Ptr,
				Tcl_Obj *part2Ptr, Tcl_Obj *newValuePtr,
				int flags);
#endif
#ifndef Tcl_OpenCommandChannel_TCL_DECLARED
#define Tcl_OpenCommandChannel_TCL_DECLARED
/* 197 */
EXTERN Tcl_Channel	Tcl_OpenCommandChannel(Tcl_Interp *interp, int argc,
				CONST84 char **argv, int flags);
#endif
#ifndef Tcl_OpenFileChannel_TCL_DECLARED
#define Tcl_OpenFileChannel_TCL_DECLARED
/* 198 */
EXTERN Tcl_Channel	Tcl_OpenFileChannel(Tcl_Interp *interp,
				CONST char *fileName, CONST char *modeString,
				int permissions);
#endif
#ifndef Tcl_OpenTcpClient_TCL_DECLARED
#define Tcl_OpenTcpClient_TCL_DECLARED
/* 199 */
EXTERN Tcl_Channel	Tcl_OpenTcpClient(Tcl_Interp *interp, int port,
				CONST char *address, CONST char *myaddr,
				int myport, int async);
#endif
#ifndef Tcl_OpenTcpServer_TCL_DECLARED
#define Tcl_OpenTcpServer_TCL_DECLARED
/* 200 */
EXTERN Tcl_Channel	Tcl_OpenTcpServer(Tcl_Interp *interp, int port,
				CONST char *host,
				Tcl_TcpAcceptProc *acceptProc,
				ClientData callbackData);
#endif
#ifndef Tcl_Preserve_TCL_DECLARED
#define Tcl_Preserve_TCL_DECLARED
/* 201 */
EXTERN void		Tcl_Preserve(ClientData data);
#endif
#ifndef Tcl_PrintDouble_TCL_DECLARED
#define Tcl_PrintDouble_TCL_DECLARED
/* 202 */
EXTERN void		Tcl_PrintDouble(Tcl_Interp *interp, double value,
				char *dst);
#endif
#ifndef Tcl_PutEnv_TCL_DECLARED
#define Tcl_PutEnv_TCL_DECLARED
/* 203 */
EXTERN int		Tcl_PutEnv(CONST char *assignment);
#endif
#ifndef Tcl_PosixError_TCL_DECLARED
#define Tcl_PosixError_TCL_DECLARED
/* 204 */
EXTERN CONST84_RETURN char * Tcl_PosixError(Tcl_Interp *interp);
#endif
#ifndef Tcl_QueueEvent_TCL_DECLARED
#define Tcl_QueueEvent_TCL_DECLARED
/* 205 */
EXTERN void		Tcl_QueueEvent(Tcl_Event *evPtr,
				Tcl_QueuePosition position);
#endif
#ifndef Tcl_Read_TCL_DECLARED
#define Tcl_Read_TCL_DECLARED
/* 206 */
EXTERN int		Tcl_Read(Tcl_Channel chan, char *bufPtr, int toRead);
#endif
#ifndef Tcl_ReapDetachedProcs_TCL_DECLARED
#define Tcl_ReapDetachedProcs_TCL_DECLARED
/* 207 */
EXTERN void		Tcl_ReapDetachedProcs(void);
#endif
#ifndef Tcl_RecordAndEval_TCL_DECLARED
#define Tcl_RecordAndEval_TCL_DECLARED
/* 208 */
EXTERN int		Tcl_RecordAndEval(Tcl_Interp *interp,
				CONST char *cmd, int flags);
#endif
#ifndef Tcl_RecordAndEvalObj_TCL_DECLARED
#define Tcl_RecordAndEvalObj_TCL_DECLARED
/* 209 */
EXTERN int		Tcl_RecordAndEvalObj(Tcl_Interp *interp,
				Tcl_Obj *cmdPtr, int flags);
#endif
#ifndef Tcl_RegisterChannel_TCL_DECLARED
#define Tcl_RegisterChannel_TCL_DECLARED
/* 210 */
EXTERN void		Tcl_RegisterChannel(Tcl_Interp *interp,
				Tcl_Channel chan);
#endif
#ifndef Tcl_RegisterObjType_TCL_DECLARED
#define Tcl_RegisterObjType_TCL_DECLARED
/* 211 */
EXTERN void		Tcl_RegisterObjType(Tcl_ObjType *typePtr);
#endif
#ifndef Tcl_RegExpCompile_TCL_DECLARED
#define Tcl_RegExpCompile_TCL_DECLARED
/* 212 */
EXTERN Tcl_RegExp	Tcl_RegExpCompile(Tcl_Interp *interp,
				CONST char *pattern);
#endif
#ifndef Tcl_RegExpExec_TCL_DECLARED
#define Tcl_RegExpExec_TCL_DECLARED
/* 213 */
EXTERN int		Tcl_RegExpExec(Tcl_Interp *interp, Tcl_RegExp regexp,
				CONST char *text, CONST char *start);
#endif
#ifndef Tcl_RegExpMatch_TCL_DECLARED
#define Tcl_RegExpMatch_TCL_DECLARED
/* 214 */
EXTERN int		Tcl_RegExpMatch(Tcl_Interp *interp, CONST char *text,
				CONST char *pattern);
#endif
#ifndef Tcl_RegExpRange_TCL_DECLARED
#define Tcl_RegExpRange_TCL_DECLARED
/* 215 */
EXTERN void		Tcl_RegExpRange(Tcl_RegExp regexp, int index,
				CONST84 char **startPtr,
				CONST84 char **endPtr);
#endif
#ifndef Tcl_Release_TCL_DECLARED
#define Tcl_Release_TCL_DECLARED
/* 216 */
EXTERN void		Tcl_Release(ClientData clientData);
#endif
#ifndef Tcl_ResetResult_TCL_DECLARED
#define Tcl_ResetResult_TCL_DECLARED
/* 217 */
EXTERN void		Tcl_ResetResult(Tcl_Interp *interp);
#endif
#ifndef Tcl_ScanElement_TCL_DECLARED
#define Tcl_ScanElement_TCL_DECLARED
/* 218 */
EXTERN int		Tcl_ScanElement(CONST char *src, int *flagPtr);
#endif
#ifndef Tcl_ScanCountedElement_TCL_DECLARED
#define Tcl_ScanCountedElement_TCL_DECLARED
/* 219 */
EXTERN int		Tcl_ScanCountedElement(CONST char *src, int length,
				int *flagPtr);
#endif
#ifndef Tcl_SeekOld_TCL_DECLARED
#define Tcl_SeekOld_TCL_DECLARED
/* 220 */
EXTERN int		Tcl_SeekOld(Tcl_Channel chan, int offset, int mode);
#endif
#ifndef Tcl_ServiceAll_TCL_DECLARED
#define Tcl_ServiceAll_TCL_DECLARED
/* 221 */
EXTERN int		Tcl_ServiceAll(void);
#endif
#ifndef Tcl_ServiceEvent_TCL_DECLARED
#define Tcl_ServiceEvent_TCL_DECLARED
/* 222 */
EXTERN int		Tcl_ServiceEvent(int flags);
#endif
#ifndef Tcl_SetAssocData_TCL_DECLARED
#define Tcl_SetAssocData_TCL_DECLARED
/* 223 */
EXTERN void		Tcl_SetAssocData(Tcl_Interp *interp,
				CONST char *name, Tcl_InterpDeleteProc *proc,
				ClientData clientData);
#endif
#ifndef Tcl_SetChannelBufferSize_TCL_DECLARED
#define Tcl_SetChannelBufferSize_TCL_DECLARED
/* 224 */
EXTERN void		Tcl_SetChannelBufferSize(Tcl_Channel chan, int sz);
#endif
#ifndef Tcl_SetChannelOption_TCL_DECLARED
#define Tcl_SetChannelOption_TCL_DECLARED
/* 225 */
EXTERN int		Tcl_SetChannelOption(Tcl_Interp *interp,
				Tcl_Channel chan, CONST char *optionName,
				CONST char *newValue);
#endif
#ifndef Tcl_SetCommandInfo_TCL_DECLARED
#define Tcl_SetCommandInfo_TCL_DECLARED
/* 226 */
EXTERN int		Tcl_SetCommandInfo(Tcl_Interp *interp,
				CONST char *cmdName,
				CONST Tcl_CmdInfo *infoPtr);
#endif
#ifndef Tcl_SetErrno_TCL_DECLARED
#define Tcl_SetErrno_TCL_DECLARED
/* 227 */
EXTERN void		Tcl_SetErrno(int err);
#endif
#ifndef Tcl_SetErrorCode_TCL_DECLARED
#define Tcl_SetErrorCode_TCL_DECLARED
/* 228 */
EXTERN void		Tcl_SetErrorCode(Tcl_Interp *interp, ...);
#endif
#ifndef Tcl_SetMaxBlockTime_TCL_DECLARED
#define Tcl_SetMaxBlockTime_TCL_DECLARED
/* 229 */
EXTERN void		Tcl_SetMaxBlockTime(Tcl_Time *timePtr);
#endif
#ifndef Tcl_SetPanicProc_TCL_DECLARED
#define Tcl_SetPanicProc_TCL_DECLARED
/* 230 */
EXTERN void		Tcl_SetPanicProc(Tcl_PanicProc *panicProc);
#endif
#ifndef Tcl_SetRecursionLimit_TCL_DECLARED
#define Tcl_SetRecursionLimit_TCL_DECLARED
/* 231 */
EXTERN int		Tcl_SetRecursionLimit(Tcl_Interp *interp, int depth);
#endif
#ifndef Tcl_SetResult_TCL_DECLARED
#define Tcl_SetResult_TCL_DECLARED
/* 232 */
EXTERN void		Tcl_SetResult(Tcl_Interp *interp, char *result,
				Tcl_FreeProc *freeProc);
#endif
#ifndef Tcl_SetServiceMode_TCL_DECLARED
#define Tcl_SetServiceMode_TCL_DECLARED
/* 233 */
EXTERN int		Tcl_SetServiceMode(int mode);
#endif
#ifndef Tcl_SetObjErrorCode_TCL_DECLARED
#define Tcl_SetObjErrorCode_TCL_DECLARED
/* 234 */
EXTERN void		Tcl_SetObjErrorCode(Tcl_Interp *interp,
				Tcl_Obj *errorObjPtr);
#endif
#ifndef Tcl_SetObjResult_TCL_DECLARED
#define Tcl_SetObjResult_TCL_DECLARED
/* 235 */
EXTERN void		Tcl_SetObjResult(Tcl_Interp *interp,
				Tcl_Obj *resultObjPtr);
#endif
#ifndef Tcl_SetStdChannel_TCL_DECLARED
#define Tcl_SetStdChannel_TCL_DECLARED
/* 236 */
EXTERN void		Tcl_SetStdChannel(Tcl_Channel channel, int type);
#endif
#ifndef Tcl_SetVar_TCL_DECLARED
#define Tcl_SetVar_TCL_DECLARED
/* 237 */
EXTERN CONST84_RETURN char * Tcl_SetVar(Tcl_Interp *interp,
				CONST char *varName, CONST char *newValue,
				int flags);
#endif
#ifndef Tcl_SetVar2_TCL_DECLARED
#define Tcl_SetVar2_TCL_DECLARED
/* 238 */
EXTERN CONST84_RETURN char * Tcl_SetVar2(Tcl_Interp *interp,
				CONST char *part1, CONST char *part2,
				CONST char *newValue, int flags);
#endif
#ifndef Tcl_SignalId_TCL_DECLARED
#define Tcl_SignalId_TCL_DECLARED
/* 239 */
EXTERN CONST84_RETURN char * Tcl_SignalId(int sig);
#endif
#ifndef Tcl_SignalMsg_TCL_DECLARED
#define Tcl_SignalMsg_TCL_DECLARED
/* 240 */
EXTERN CONST84_RETURN char * Tcl_SignalMsg(int sig);
#endif
#ifndef Tcl_SourceRCFile_TCL_DECLARED
#define Tcl_SourceRCFile_TCL_DECLARED
/* 241 */
EXTERN void		Tcl_SourceRCFile(Tcl_Interp *interp);
#endif
#ifndef Tcl_SplitList_TCL_DECLARED
#define Tcl_SplitList_TCL_DECLARED
/* 242 */
EXTERN int		Tcl_SplitList(Tcl_Interp *interp,
				CONST char *listStr, int *argcPtr,
				CONST84 char ***argvPtr);
#endif
#ifndef Tcl_SplitPath_TCL_DECLARED
#define Tcl_SplitPath_TCL_DECLARED
/* 243 */
EXTERN void		Tcl_SplitPath(CONST char *path, int *argcPtr,
				CONST84 char ***argvPtr);
#endif
#ifndef Tcl_StaticPackage_TCL_DECLARED
#define Tcl_StaticPackage_TCL_DECLARED
/* 244 */
EXTERN void		Tcl_StaticPackage(Tcl_Interp *interp,
				CONST char *pkgName,
				Tcl_PackageInitProc *initProc,
				Tcl_PackageInitProc *safeInitProc);
#endif
#ifndef Tcl_StringMatch_TCL_DECLARED
#define Tcl_StringMatch_TCL_DECLARED
/* 245 */
EXTERN int		Tcl_StringMatch(CONST char *str, CONST char *pattern);
#endif
#ifndef Tcl_TellOld_TCL_DECLARED
#define Tcl_TellOld_TCL_DECLARED
/* 246 */
EXTERN int		Tcl_TellOld(Tcl_Channel chan);
#endif
#ifndef Tcl_TraceVar_TCL_DECLARED
#define Tcl_TraceVar_TCL_DECLARED
/* 247 */
EXTERN int		Tcl_TraceVar(Tcl_Interp *interp, CONST char *varName,
				int flags, Tcl_VarTraceProc *proc,
				ClientData clientData);
#endif
#ifndef Tcl_TraceVar2_TCL_DECLARED
#define Tcl_TraceVar2_TCL_DECLARED
/* 248 */
EXTERN int		Tcl_TraceVar2(Tcl_Interp *interp, CONST char *part1,
				CONST char *part2, int flags,
				Tcl_VarTraceProc *proc,
				ClientData clientData);
#endif
#ifndef Tcl_TranslateFileName_TCL_DECLARED
#define Tcl_TranslateFileName_TCL_DECLARED
/* 249 */
EXTERN char *		Tcl_TranslateFileName(Tcl_Interp *interp,
				CONST char *name, Tcl_DString *bufferPtr);
#endif
#ifndef Tcl_Ungets_TCL_DECLARED
#define Tcl_Ungets_TCL_DECLARED
/* 250 */
EXTERN int		Tcl_Ungets(Tcl_Channel chan, CONST char *str,
				int len, int atHead);
#endif
#ifndef Tcl_UnlinkVar_TCL_DECLARED
#define Tcl_UnlinkVar_TCL_DECLARED
/* 251 */
EXTERN void		Tcl_UnlinkVar(Tcl_Interp *interp,
				CONST char *varName);
#endif
#ifndef Tcl_UnregisterChannel_TCL_DECLARED
#define Tcl_UnregisterChannel_TCL_DECLARED
/* 252 */
EXTERN int		Tcl_UnregisterChannel(Tcl_Interp *interp,
				Tcl_Channel chan);
#endif
#ifndef Tcl_UnsetVar_TCL_DECLARED
#define Tcl_UnsetVar_TCL_DECLARED
/* 253 */
EXTERN int		Tcl_UnsetVar(Tcl_Interp *interp, CONST char *varName,
				int flags);
#endif
#ifndef Tcl_UnsetVar2_TCL_DECLARED
#define Tcl_UnsetVar2_TCL_DECLARED
/* 254 */
EXTERN int		Tcl_UnsetVar2(Tcl_Interp *interp, CONST char *part1,
				CONST char *part2, int flags);
#endif
#ifndef Tcl_UntraceVar_TCL_DECLARED
#define Tcl_UntraceVar_TCL_DECLARED
/* 255 */
EXTERN void		Tcl_UntraceVar(Tcl_Interp *interp,
				CONST char *varName, int flags,
				Tcl_VarTraceProc *proc,
				ClientData clientData);
#endif
#ifndef Tcl_UntraceVar2_TCL_DECLARED
#define Tcl_UntraceVar2_TCL_DECLARED
/* 256 */
EXTERN void		Tcl_UntraceVar2(Tcl_Interp *interp,
				CONST char *part1, CONST char *part2,
				int flags, Tcl_VarTraceProc *proc,
				ClientData clientData);
#endif
#ifndef Tcl_UpdateLinkedVar_TCL_DECLARED
#define Tcl_UpdateLinkedVar_TCL_DECLARED
/* 257 */
EXTERN void		Tcl_UpdateLinkedVar(Tcl_Interp *interp,
				CONST char *varName);
#endif
#ifndef Tcl_UpVar_TCL_DECLARED
#define Tcl_UpVar_TCL_DECLARED
/* 258 */
EXTERN int		Tcl_UpVar(Tcl_Interp *interp, CONST char *frameName,
				CONST char *varName, CONST char *localName,
				int flags);
#endif
#ifndef Tcl_UpVar2_TCL_DECLARED
#define Tcl_UpVar2_TCL_DECLARED
/* 259 */
EXTERN int		Tcl_UpVar2(Tcl_Interp *interp, CONST char *frameName,
				CONST char *part1, CONST char *part2,
				CONST char *localName, int flags);
#endif
#ifndef Tcl_VarEval_TCL_DECLARED
#define Tcl_VarEval_TCL_DECLARED
/* 260 */
EXTERN int		Tcl_VarEval(Tcl_Interp *interp, ...);
#endif
#ifndef Tcl_VarTraceInfo_TCL_DECLARED
#define Tcl_VarTraceInfo_TCL_DECLARED
/* 261 */
EXTERN ClientData	Tcl_VarTraceInfo(Tcl_Interp *interp,
				CONST char *varName, int flags,
				Tcl_VarTraceProc *procPtr,
				ClientData prevClientData);
#endif
#ifndef Tcl_VarTraceInfo2_TCL_DECLARED
#define Tcl_VarTraceInfo2_TCL_DECLARED
/* 262 */
EXTERN ClientData	Tcl_VarTraceInfo2(Tcl_Interp *interp,
				CONST char *part1, CONST char *part2,
				int flags, Tcl_VarTraceProc *procPtr,
				ClientData prevClientData);
#endif
#ifndef Tcl_Write_TCL_DECLARED
#define Tcl_Write_TCL_DECLARED
/* 263 */
EXTERN int		Tcl_Write(Tcl_Channel chan, CONST char *s, int slen);
#endif
#ifndef Tcl_WrongNumArgs_TCL_DECLARED
#define Tcl_WrongNumArgs_TCL_DECLARED
/* 264 */
EXTERN void		Tcl_WrongNumArgs(Tcl_Interp *interp, int objc,
				Tcl_Obj *CONST objv[], CONST char *message);
#endif
#ifndef Tcl_DumpActiveMemory_TCL_DECLARED
#define Tcl_DumpActiveMemory_TCL_DECLARED
/* 265 */
EXTERN int		Tcl_DumpActiveMemory(CONST char *fileName);
#endif
#ifndef Tcl_ValidateAllMemory_TCL_DECLARED
#define Tcl_ValidateAllMemory_TCL_DECLARED
/* 266 */
EXTERN void		Tcl_ValidateAllMemory(CONST char *file, int line);
#endif
#ifndef Tcl_AppendResultVA_TCL_DECLARED
#define Tcl_AppendResultVA_TCL_DECLARED
/* 267 */
EXTERN void		Tcl_AppendResultVA(Tcl_Interp *interp,
				va_list argList);
#endif
#ifndef Tcl_AppendStringsToObjVA_TCL_DECLARED
#define Tcl_AppendStringsToObjVA_TCL_DECLARED
/* 268 */
EXTERN void		Tcl_AppendStringsToObjVA(Tcl_Obj *objPtr,
				va_list argList);
#endif
#ifndef Tcl_HashStats_TCL_DECLARED
#define Tcl_HashStats_TCL_DECLARED
/* 269 */
EXTERN char *		Tcl_HashStats(Tcl_HashTable *tablePtr);
#endif
#ifndef Tcl_ParseVar_TCL_DECLARED
#define Tcl_ParseVar_TCL_DECLARED
/* 270 */
EXTERN CONST84_RETURN char * Tcl_ParseVar(Tcl_Interp *interp,
				CONST char *start, CONST84 char **termPtr);
#endif
#ifndef Tcl_PkgPresent_TCL_DECLARED
#define Tcl_PkgPresent_TCL_DECLARED
/* 271 */
EXTERN CONST84_RETURN char * Tcl_PkgPresent(Tcl_Interp *interp,
				CONST char *name, CONST char *version,
				int exact);
#endif
#ifndef Tcl_PkgPresentEx_TCL_DECLARED
#define Tcl_PkgPresentEx_TCL_DECLARED
/* 272 */
EXTERN CONST84_RETURN char * Tcl_PkgPresentEx(Tcl_Interp *interp,
				CONST char *name, CONST char *version,
				int exact, ClientData *clientDataPtr);
#endif
#ifndef Tcl_PkgProvide_TCL_DECLARED
#define Tcl_PkgProvide_TCL_DECLARED
/* 273 */
EXTERN int		Tcl_PkgProvide(Tcl_Interp *interp, CONST char *name,
				CONST char *version);
#endif
#ifndef Tcl_PkgRequire_TCL_DECLARED
#define Tcl_PkgRequire_TCL_DECLARED
/* 274 */
EXTERN CONST84_RETURN char * Tcl_PkgRequire(Tcl_Interp *interp,
				CONST char *name, CONST char *version,
				int exact);
#endif
#ifndef Tcl_SetErrorCodeVA_TCL_DECLARED
#define Tcl_SetErrorCodeVA_TCL_DECLARED
/* 275 */
EXTERN void		Tcl_SetErrorCodeVA(Tcl_Interp *interp,
				va_list argList);
#endif
#ifndef Tcl_VarEvalVA_TCL_DECLARED
#define Tcl_VarEvalVA_TCL_DECLARED
/* 276 */
EXTERN int		Tcl_VarEvalVA(Tcl_Interp *interp, va_list argList);
#endif
#ifndef Tcl_WaitPid_TCL_DECLARED
#define Tcl_WaitPid_TCL_DECLARED
/* 277 */
EXTERN Tcl_Pid		Tcl_WaitPid(Tcl_Pid pid, int *statPtr, int options);
#endif
#ifndef Tcl_PanicVA_TCL_DECLARED
#define Tcl_PanicVA_TCL_DECLARED
/* 278 */
EXTERN void		Tcl_PanicVA(CONST char *format, va_list argList);
#endif
#ifndef Tcl_GetVersion_TCL_DECLARED
#define Tcl_GetVersion_TCL_DECLARED
/* 279 */
EXTERN void		Tcl_GetVersion(int *major, int *minor,
				int *patchLevel, int *type);
#endif
#ifndef Tcl_InitMemory_TCL_DECLARED
#define Tcl_InitMemory_TCL_DECLARED
/* 280 */
EXTERN void		Tcl_InitMemory(Tcl_Interp *interp);
#endif
#ifndef Tcl_StackChannel_TCL_DECLARED
#define Tcl_StackChannel_TCL_DECLARED
/* 281 */
EXTERN Tcl_Channel	Tcl_StackChannel(Tcl_Interp *interp,
				Tcl_ChannelType *typePtr,
				ClientData instanceData, int mask,
				Tcl_Channel prevChan);
#endif
#ifndef Tcl_UnstackChannel_TCL_DECLARED
#define Tcl_UnstackChannel_TCL_DECLARED
/* 282 */
EXTERN int		Tcl_UnstackChannel(Tcl_Interp *interp,
				Tcl_Channel chan);
#endif
#ifndef Tcl_GetStackedChannel_TCL_DECLARED
#define Tcl_GetStackedChannel_TCL_DECLARED
/* 283 */
EXTERN Tcl_Channel	Tcl_GetStackedChannel(Tcl_Channel chan);
#endif
#ifndef Tcl_SetMainLoop_TCL_DECLARED
#define Tcl_SetMainLoop_TCL_DECLARED
/* 284 */
EXTERN void		Tcl_SetMainLoop(Tcl_MainLoopProc *proc);
#endif
/* Slot 285 is reserved */
#ifndef Tcl_AppendObjToObj_TCL_DECLARED
#define Tcl_AppendObjToObj_TCL_DECLARED
/* 286 */
EXTERN void		Tcl_AppendObjToObj(Tcl_Obj *objPtr,
				Tcl_Obj *appendObjPtr);
#endif
#ifndef Tcl_CreateEncoding_TCL_DECLARED
#define Tcl_CreateEncoding_TCL_DECLARED
/* 287 */
EXTERN Tcl_Encoding	Tcl_CreateEncoding(CONST Tcl_EncodingType *typePtr);
#endif
#ifndef Tcl_CreateThreadExitHandler_TCL_DECLARED
#define Tcl_CreateThreadExitHandler_TCL_DECLARED
/* 288 */
EXTERN void		Tcl_CreateThreadExitHandler(Tcl_ExitProc *proc,
				ClientData clientData);
#endif
#ifndef Tcl_DeleteThreadExitHandler_TCL_DECLARED
#define Tcl_DeleteThreadExitHandler_TCL_DECLARED
/* 289 */
EXTERN void		Tcl_DeleteThreadExitHandler(Tcl_ExitProc *proc,
				ClientData clientData);
#endif
#ifndef Tcl_DiscardResult_TCL_DECLARED
#define Tcl_DiscardResult_TCL_DECLARED
/* 290 */
EXTERN void		Tcl_DiscardResult(Tcl_SavedResult *statePtr);
#endif
#ifndef Tcl_EvalEx_TCL_DECLARED
#define Tcl_EvalEx_TCL_DECLARED
/* 291 */
EXTERN int		Tcl_EvalEx(Tcl_Interp *interp, CONST char *script,
				int numBytes, int flags);
#endif
#ifndef Tcl_EvalObjv_TCL_DECLARED
#define Tcl_EvalObjv_TCL_DECLARED
/* 292 */
EXTERN int		Tcl_EvalObjv(Tcl_Interp *interp, int objc,
				Tcl_Obj *CONST objv[], int flags);
#endif
#ifndef Tcl_EvalObjEx_TCL_DECLARED
#define Tcl_EvalObjEx_TCL_DECLARED
/* 293 */
EXTERN int		Tcl_EvalObjEx(Tcl_Interp *interp, Tcl_Obj *objPtr,
				int flags);
#endif
#ifndef Tcl_ExitThread_TCL_DECLARED
#define Tcl_ExitThread_TCL_DECLARED
/* 294 */
EXTERN void		Tcl_ExitThread(int status);
#endif
#ifndef Tcl_ExternalToUtf_TCL_DECLARED
#define Tcl_ExternalToUtf_TCL_DECLARED
/* 295 */
EXTERN int		Tcl_ExternalToUtf(Tcl_Interp *interp,
				Tcl_Encoding encoding, CONST char *src,
				int srcLen, int flags,
				Tcl_EncodingState *statePtr, char *dst,
				int dstLen, int *srcReadPtr,
				int *dstWrotePtr, int *dstCharsPtr);
#endif
#ifndef Tcl_ExternalToUtfDString_TCL_DECLARED
#define Tcl_ExternalToUtfDString_TCL_DECLARED
/* 296 */
EXTERN char *		Tcl_ExternalToUtfDString(Tcl_Encoding encoding,
				CONST char *src, int srcLen,
				Tcl_DString *dsPtr);
#endif
#ifndef Tcl_FinalizeThread_TCL_DECLARED
#define Tcl_FinalizeThread_TCL_DECLARED
/* 297 */
EXTERN void		Tcl_FinalizeThread(void);
#endif
#ifndef Tcl_FinalizeNotifier_TCL_DECLARED
#define Tcl_FinalizeNotifier_TCL_DECLARED
/* 298 */
EXTERN void		Tcl_FinalizeNotifier(ClientData clientData);
#endif
#ifndef Tcl_FreeEncoding_TCL_DECLARED
#define Tcl_FreeEncoding_TCL_DECLARED
/* 299 */
EXTERN void		Tcl_FreeEncoding(Tcl_Encoding encoding);
#endif
#ifndef Tcl_GetCurrentThread_TCL_DECLARED
#define Tcl_GetCurrentThread_TCL_DECLARED
/* 300 */
EXTERN Tcl_ThreadId	Tcl_GetCurrentThread(void);
#endif
#ifndef Tcl_GetEncoding_TCL_DECLARED
#define Tcl_GetEncoding_TCL_DECLARED
/* 301 */
EXTERN Tcl_Encoding	Tcl_GetEncoding(Tcl_Interp *interp, CONST char *name);
#endif
#ifndef Tcl_GetEncodingName_TCL_DECLARED
#define Tcl_GetEncodingName_TCL_DECLARED
/* 302 */
EXTERN CONST84_RETURN char * Tcl_GetEncodingName(Tcl_Encoding encoding);
#endif
#ifndef Tcl_GetEncodingNames_TCL_DECLARED
#define Tcl_GetEncodingNames_TCL_DECLARED
/* 303 */
EXTERN void		Tcl_GetEncodingNames(Tcl_Interp *interp);
#endif
#ifndef Tcl_GetIndexFromObjStruct_TCL_DECLARED
#define Tcl_GetIndexFromObjStruct_TCL_DECLARED
/* 304 */
EXTERN int		Tcl_GetIndexFromObjStruct(Tcl_Interp *interp,
				Tcl_Obj *objPtr, CONST VOID *tablePtr,
				int offset, CONST char *msg, int flags,
				int *indexPtr);
#endif
#ifndef Tcl_GetThreadData_TCL_DECLARED
#define Tcl_GetThreadData_TCL_DECLARED
/* 305 */
EXTERN VOID *		Tcl_GetThreadData(Tcl_ThreadDataKey *keyPtr,
				int size);
#endif
#ifndef Tcl_GetVar2Ex_TCL_DECLARED
#define Tcl_GetVar2Ex_TCL_DECLARED
/* 306 */
EXTERN Tcl_Obj *	Tcl_GetVar2Ex(Tcl_Interp *interp, CONST char *part1,
				CONST char *part2, int flags);
#endif
#ifndef Tcl_InitNotifier_TCL_DECLARED
#define Tcl_InitNotifier_TCL_DECLARED
/* 307 */
EXTERN ClientData	Tcl_InitNotifier(void);
#endif
#ifndef Tcl_MutexLock_TCL_DECLARED
#define Tcl_MutexLock_TCL_DECLARED
/* 308 */
EXTERN void		Tcl_MutexLock(Tcl_Mutex *mutexPtr);
#endif
#ifndef Tcl_MutexUnlock_TCL_DECLARED
#define Tcl_MutexUnlock_TCL_DECLARED
/* 309 */
EXTERN void		Tcl_MutexUnlock(Tcl_Mutex *mutexPtr);
#endif
#ifndef Tcl_ConditionNotify_TCL_DECLARED
#define Tcl_ConditionNotify_TCL_DECLARED
/* 310 */
EXTERN void		Tcl_ConditionNotify(Tcl_Condition *condPtr);
#endif
#ifndef Tcl_ConditionWait_TCL_DECLARED
#define Tcl_ConditionWait_TCL_DECLARED
/* 311 */
EXTERN void		Tcl_ConditionWait(Tcl_Condition *condPtr,
				Tcl_Mutex *mutexPtr, Tcl_Time *timePtr);
#endif
#ifndef Tcl_NumUtfChars_TCL_DECLARED
#define Tcl_NumUtfChars_TCL_DECLARED
/* 312 */
EXTERN int		Tcl_NumUtfChars(CONST char *src, int length);
#endif
#ifndef Tcl_ReadChars_TCL_DECLARED
#define Tcl_ReadChars_TCL_DECLARED
/* 313 */
EXTERN int		Tcl_ReadChars(Tcl_Channel channel, Tcl_Obj *objPtr,
				int charsToRead, int appendFlag);
#endif
#ifndef Tcl_RestoreResult_TCL_DECLARED
#define Tcl_RestoreResult_TCL_DECLARED
/* 314 */
EXTERN void		Tcl_RestoreResult(Tcl_Interp *interp,
				Tcl_SavedResult *statePtr);
#endif
#ifndef Tcl_SaveResult_TCL_DECLARED
#define Tcl_SaveResult_TCL_DECLARED
/* 315 */
EXTERN void		Tcl_SaveResult(Tcl_Interp *interp,
				Tcl_SavedResult *statePtr);
#endif
#ifndef Tcl_SetSystemEncoding_TCL_DECLARED
#define Tcl_SetSystemEncoding_TCL_DECLARED
/* 316 */
EXTERN int		Tcl_SetSystemEncoding(Tcl_Interp *interp,
				CONST char *name);
#endif
#ifndef Tcl_SetVar2Ex_TCL_DECLARED
#define Tcl_SetVar2Ex_TCL_DECLARED
/* 317 */
EXTERN Tcl_Obj *	Tcl_SetVar2Ex(Tcl_Interp *interp, CONST char *part1,
				CONST char *part2, Tcl_Obj *newValuePtr,
				int flags);
#endif
#ifndef Tcl_ThreadAlert_TCL_DECLARED
#define Tcl_ThreadAlert_TCL_DECLARED
/* 318 */
EXTERN void		Tcl_ThreadAlert(Tcl_ThreadId threadId);
#endif
#ifndef Tcl_ThreadQueueEvent_TCL_DECLARED
#define Tcl_ThreadQueueEvent_TCL_DECLARED
/* 319 */
EXTERN void		Tcl_ThreadQueueEvent(Tcl_ThreadId threadId,
				Tcl_Event *evPtr, Tcl_QueuePosition position);
#endif
#ifndef Tcl_UniCharAtIndex_TCL_DECLARED
#define Tcl_UniCharAtIndex_TCL_DECLARED
/* 320 */
EXTERN Tcl_UniChar	Tcl_UniCharAtIndex(CONST char *src, int index);
#endif
#ifndef Tcl_UniCharToLower_TCL_DECLARED
#define Tcl_UniCharToLower_TCL_DECLARED
/* 321 */
EXTERN Tcl_UniChar	Tcl_UniCharToLower(int ch);
#endif
#ifndef Tcl_UniCharToTitle_TCL_DECLARED
#define Tcl_UniCharToTitle_TCL_DECLARED
/* 322 */
EXTERN Tcl_UniChar	Tcl_UniCharToTitle(int ch);
#endif
#ifndef Tcl_UniCharToUpper_TCL_DECLARED
#define Tcl_UniCharToUpper_TCL_DECLARED
/* 323 */
EXTERN Tcl_UniChar	Tcl_UniCharToUpper(int ch);
#endif
#ifndef Tcl_UniCharToUtf_TCL_DECLARED
#define Tcl_UniCharToUtf_TCL_DECLARED
/* 324 */
EXTERN int		Tcl_UniCharToUtf(int ch, char *buf);
#endif
#ifndef Tcl_UtfAtIndex_TCL_DECLARED
#define Tcl_UtfAtIndex_TCL_DECLARED
/* 325 */
EXTERN CONST84_RETURN char * Tcl_UtfAtIndex(CONST char *src, int index);
#endif
#ifndef Tcl_UtfCharComplete_TCL_DECLARED
#define Tcl_UtfCharComplete_TCL_DECLARED
/* 326 */
EXTERN int		Tcl_UtfCharComplete(CONST char *src, int length);
#endif
#ifndef Tcl_UtfBackslash_TCL_DECLARED
#define Tcl_UtfBackslash_TCL_DECLARED
/* 327 */
EXTERN int		Tcl_UtfBackslash(CONST char *src, int *readPtr,
				char *dst);
#endif
#ifndef Tcl_UtfFindFirst_TCL_DECLARED
#define Tcl_UtfFindFirst_TCL_DECLARED
/* 328 */
EXTERN CONST84_RETURN char * Tcl_UtfFindFirst(CONST char *src, int ch);
#endif
#ifndef Tcl_UtfFindLast_TCL_DECLARED
#define Tcl_UtfFindLast_TCL_DECLARED
/* 329 */
EXTERN CONST84_RETURN char * Tcl_UtfFindLast(CONST char *src, int ch);
#endif
#ifndef Tcl_UtfNext_TCL_DECLARED
#define Tcl_UtfNext_TCL_DECLARED
/* 330 */
EXTERN CONST84_RETURN char * Tcl_UtfNext(CONST char *src);
#endif
#ifndef Tcl_UtfPrev_TCL_DECLARED
#define Tcl_UtfPrev_TCL_DECLARED
/* 331 */
EXTERN CONST84_RETURN char * Tcl_UtfPrev(CONST char *src, CONST char *start);
#endif
#ifndef Tcl_UtfToExternal_TCL_DECLARED
#define Tcl_UtfToExternal_TCL_DECLARED
/* 332 */
EXTERN int		Tcl_UtfToExternal(Tcl_Interp *interp,
				Tcl_Encoding encoding, CONST char *src,
				int srcLen, int flags,
				Tcl_EncodingState *statePtr, char *dst,
				int dstLen, int *srcReadPtr,
				int *dstWrotePtr, int *dstCharsPtr);
#endif
#ifndef Tcl_UtfToExternalDString_TCL_DECLARED
#define Tcl_UtfToExternalDString_TCL_DECLARED
/* 333 */
EXTERN char *		Tcl_UtfToExternalDString(Tcl_Encoding encoding,
				CONST char *src, int srcLen,
				Tcl_DString *dsPtr);
#endif
#ifndef Tcl_UtfToLower_TCL_DECLARED
#define Tcl_UtfToLower_TCL_DECLARED
/* 334 */
EXTERN int		Tcl_UtfToLower(char *src);
#endif
#ifndef Tcl_UtfToTitle_TCL_DECLARED
#define Tcl_UtfToTitle_TCL_DECLARED
/* 335 */
EXTERN int		Tcl_UtfToTitle(char *src);
#endif
#ifndef Tcl_UtfToUniChar_TCL_DECLARED
#define Tcl_UtfToUniChar_TCL_DECLARED
/* 336 */
EXTERN int		Tcl_UtfToUniChar(CONST char *src, Tcl_UniChar *chPtr);
#endif
#ifndef Tcl_UtfToUpper_TCL_DECLARED
#define Tcl_UtfToUpper_TCL_DECLARED
/* 337 */
EXTERN int		Tcl_UtfToUpper(char *src);
#endif
#ifndef Tcl_WriteChars_TCL_DECLARED
#define Tcl_WriteChars_TCL_DECLARED
/* 338 */
EXTERN int		Tcl_WriteChars(Tcl_Channel chan, CONST char *src,
				int srcLen);
#endif
#ifndef Tcl_WriteObj_TCL_DECLARED
#define Tcl_WriteObj_TCL_DECLARED
/* 339 */
EXTERN int		Tcl_WriteObj(Tcl_Channel chan, Tcl_Obj *objPtr);
#endif
#ifndef Tcl_GetString_TCL_DECLARED
#define Tcl_GetString_TCL_DECLARED
/* 340 */
EXTERN char *		Tcl_GetString(Tcl_Obj *objPtr);
#endif
#ifndef Tcl_GetDefaultEncodingDir_TCL_DECLARED
#define Tcl_GetDefaultEncodingDir_TCL_DECLARED
/* 341 */
EXTERN CONST84_RETURN char * Tcl_GetDefaultEncodingDir(void);
#endif
#ifndef Tcl_SetDefaultEncodingDir_TCL_DECLARED
#define Tcl_SetDefaultEncodingDir_TCL_DECLARED
/* 342 */
EXTERN void		Tcl_SetDefaultEncodingDir(CONST char *path);
#endif
#ifndef Tcl_AlertNotifier_TCL_DECLARED
#define Tcl_AlertNotifier_TCL_DECLARED
/* 343 */
EXTERN void		Tcl_AlertNotifier(ClientData clientData);
#endif
#ifndef Tcl_ServiceModeHook_TCL_DECLARED
#define Tcl_ServiceModeHook_TCL_DECLARED
/* 344 */
EXTERN void		Tcl_ServiceModeHook(int mode);
#endif
#ifndef Tcl_UniCharIsAlnum_TCL_DECLARED
#define Tcl_UniCharIsAlnum_TCL_DECLARED
/* 345 */
EXTERN int		Tcl_UniCharIsAlnum(int ch);
#endif
#ifndef Tcl_UniCharIsAlpha_TCL_DECLARED
#define Tcl_UniCharIsAlpha_TCL_DECLARED
/* 346 */
EXTERN int		Tcl_UniCharIsAlpha(int ch);
#endif
#ifndef Tcl_UniCharIsDigit_TCL_DECLARED
#define Tcl_UniCharIsDigit_TCL_DECLARED
/* 347 */
EXTERN int		Tcl_UniCharIsDigit(int ch);
#endif
#ifndef Tcl_UniCharIsLower_TCL_DECLARED
#define Tcl_UniCharIsLower_TCL_DECLARED
/* 348 */
EXTERN int		Tcl_UniCharIsLower(int ch);
#endif
#ifndef Tcl_UniCharIsSpace_TCL_DECLARED
#define Tcl_UniCharIsSpace_TCL_DECLARED
/* 349 */
EXTERN int		Tcl_UniCharIsSpace(int ch);
#endif
#ifndef Tcl_UniCharIsUpper_TCL_DECLARED
#define Tcl_UniCharIsUpper_TCL_DECLARED
/* 350 */
EXTERN int		Tcl_UniCharIsUpper(int ch);
#endif
#ifndef Tcl_UniCharIsWordChar_TCL_DECLARED
#define Tcl_UniCharIsWordChar_TCL_DECLARED
/* 351 */
EXTERN int		Tcl_UniCharIsWordChar(int ch);
#endif
#ifndef Tcl_UniCharLen_TCL_DECLARED
#define Tcl_UniCharLen_TCL_DECLARED
/* 352 */
EXTERN int		Tcl_UniCharLen(CONST Tcl_UniChar *uniStr);
#endif
#ifndef Tcl_UniCharNcmp_TCL_DECLARED
#define Tcl_UniCharNcmp_TCL_DECLARED
/* 353 */
EXTERN int		Tcl_UniCharNcmp(CONST Tcl_UniChar *ucs,
				CONST Tcl_UniChar *uct,
				unsigned long numChars);
#endif
#ifndef Tcl_UniCharToUtfDString_TCL_DECLARED
#define Tcl_UniCharToUtfDString_TCL_DECLARED
/* 354 */
EXTERN char *		Tcl_UniCharToUtfDString(CONST Tcl_UniChar *uniStr,
				int uniLength, Tcl_DString *dsPtr);
#endif
#ifndef Tcl_UtfToUniCharDString_TCL_DECLARED
#define Tcl_UtfToUniCharDString_TCL_DECLARED
/* 355 */
EXTERN Tcl_UniChar *	Tcl_UtfToUniCharDString(CONST char *src, int length,
				Tcl_DString *dsPtr);
#endif
#ifndef Tcl_GetRegExpFromObj_TCL_DECLARED
#define Tcl_GetRegExpFromObj_TCL_DECLARED
/* 356 */
EXTERN Tcl_RegExp	Tcl_GetRegExpFromObj(Tcl_Interp *interp,
				Tcl_Obj *patObj, int flags);
#endif
#ifndef Tcl_EvalTokens_TCL_DECLARED
#define Tcl_EvalTokens_TCL_DECLARED
/* 357 */
EXTERN Tcl_Obj *	Tcl_EvalTokens(Tcl_Interp *interp,
				Tcl_Token *tokenPtr, int count);
#endif
#ifndef Tcl_FreeParse_TCL_DECLARED
#define Tcl_FreeParse_TCL_DECLARED
/* 358 */
EXTERN void		Tcl_FreeParse(Tcl_Parse *parsePtr);
#endif
#ifndef Tcl_LogCommandInfo_TCL_DECLARED
#define Tcl_LogCommandInfo_TCL_DECLARED
/* 359 */
EXTERN void		Tcl_LogCommandInfo(Tcl_Interp *interp,
				CONST char *script, CONST char *command,
				int length);
#endif
#ifndef Tcl_ParseBraces_TCL_DECLARED
#define Tcl_ParseBraces_TCL_DECLARED
/* 360 */
EXTERN int		Tcl_ParseBraces(Tcl_Interp *interp,
				CONST char *start, int numBytes,
				Tcl_Parse *parsePtr, int append,
				CONST84 char **termPtr);
#endif
#ifndef Tcl_ParseCommand_TCL_DECLARED
#define Tcl_ParseCommand_TCL_DECLARED
/* 361 */
EXTERN int		Tcl_ParseCommand(Tcl_Interp *interp,
				CONST char *start, int numBytes, int nested,
				Tcl_Parse *parsePtr);
#endif
#ifndef Tcl_ParseExpr_TCL_DECLARED
#define Tcl_ParseExpr_TCL_DECLARED
/* 362 */
EXTERN int		Tcl_ParseExpr(Tcl_Interp *interp, CONST char *start,
				int numBytes, Tcl_Parse *parsePtr);
#endif
#ifndef Tcl_ParseQuotedString_TCL_DECLARED
#define Tcl_ParseQuotedString_TCL_DECLARED
/* 363 */
EXTERN int		Tcl_ParseQuotedString(Tcl_Interp *interp,
				CONST char *start, int numBytes,
				Tcl_Parse *parsePtr, int append,
				CONST84 char **termPtr);
#endif
#ifndef Tcl_ParseVarName_TCL_DECLARED
#define Tcl_ParseVarName_TCL_DECLARED
/* 364 */
EXTERN int		Tcl_ParseVarName(Tcl_Interp *interp,
				CONST char *start, int numBytes,
				Tcl_Parse *parsePtr, int append);
#endif
#ifndef Tcl_GetCwd_TCL_DECLARED
#define Tcl_GetCwd_TCL_DECLARED
/* 365 */
EXTERN char *		Tcl_GetCwd(Tcl_Interp *interp, Tcl_DString *cwdPtr);
#endif
#ifndef Tcl_Chdir_TCL_DECLARED
#define Tcl_Chdir_TCL_DECLARED
/* 366 */
EXTERN int		Tcl_Chdir(CONST char *dirName);
#endif
#ifndef Tcl_Access_TCL_DECLARED
#define Tcl_Access_TCL_DECLARED
/* 367 */
EXTERN int		Tcl_Access(CONST char *path, int mode);
#endif
#ifndef Tcl_Stat_TCL_DECLARED
#define Tcl_Stat_TCL_DECLARED
/* 368 */
EXTERN int		Tcl_Stat(CONST char *path, struct stat *bufPtr);
#endif
#ifndef Tcl_UtfNcmp_TCL_DECLARED
#define Tcl_UtfNcmp_TCL_DECLARED
/* 369 */
EXTERN int		Tcl_UtfNcmp(CONST char *s1, CONST char *s2,
				unsigned long n);
#endif
#ifndef Tcl_UtfNcasecmp_TCL_DECLARED
#define Tcl_UtfNcasecmp_TCL_DECLARED
/* 370 */
EXTERN int		Tcl_UtfNcasecmp(CONST char *s1, CONST char *s2,
				unsigned long n);
#endif
#ifndef Tcl_StringCaseMatch_TCL_DECLARED
#define Tcl_StringCaseMatch_TCL_DECLARED
/* 371 */
EXTERN int		Tcl_StringCaseMatch(CONST char *str,
				CONST char *pattern, int nocase);
#endif
#ifndef Tcl_UniCharIsControl_TCL_DECLARED
#define Tcl_UniCharIsControl_TCL_DECLARED
/* 372 */
EXTERN int		Tcl_UniCharIsControl(int ch);
#endif
#ifndef Tcl_UniCharIsGraph_TCL_DECLARED
#define Tcl_UniCharIsGraph_TCL_DECLARED
/* 373 */
EXTERN int		Tcl_UniCharIsGraph(int ch);
#endif
#ifndef Tcl_UniCharIsPrint_TCL_DECLARED
#define Tcl_UniCharIsPrint_TCL_DECLARED
/* 374 */
EXTERN int		Tcl_UniCharIsPrint(int ch);
#endif
#ifndef Tcl_UniCharIsPunct_TCL_DECLARED
#define Tcl_UniCharIsPunct_TCL_DECLARED
/* 375 */
EXTERN int		Tcl_UniCharIsPunct(int ch);
#endif
#ifndef Tcl_RegExpExecObj_TCL_DECLARED
#define Tcl_RegExpExecObj_TCL_DECLARED
/* 376 */
EXTERN int		Tcl_RegExpExecObj(Tcl_Interp *interp,
				Tcl_RegExp regexp, Tcl_Obj *textObj,
				int offset, int nmatches, int flags);
#endif
#ifndef Tcl_RegExpGetInfo_TCL_DECLARED
#define Tcl_RegExpGetInfo_TCL_DECLARED
/* 377 */
EXTERN void		Tcl_RegExpGetInfo(Tcl_RegExp regexp,
				Tcl_RegExpInfo *infoPtr);
#endif
#ifndef Tcl_NewUnicodeObj_TCL_DECLARED
#define Tcl_NewUnicodeObj_TCL_DECLARED
/* 378 */
EXTERN Tcl_Obj *	Tcl_NewUnicodeObj(CONST Tcl_UniChar *unicode,
				int numChars);
#endif
#ifndef Tcl_SetUnicodeObj_TCL_DECLARED
#define Tcl_SetUnicodeObj_TCL_DECLARED
/* 379 */
EXTERN void		Tcl_SetUnicodeObj(Tcl_Obj *objPtr,
				CONST Tcl_UniChar *unicode, int numChars);
#endif
#ifndef Tcl_GetCharLength_TCL_DECLARED
#define Tcl_GetCharLength_TCL_DECLARED
/* 380 */
EXTERN int		Tcl_GetCharLength(Tcl_Obj *objPtr);
#endif
#ifndef Tcl_GetUniChar_TCL_DECLARED
#define Tcl_GetUniChar_TCL_DECLARED
/* 381 */
EXTERN Tcl_UniChar	Tcl_GetUniChar(Tcl_Obj *objPtr, int index);
#endif
#ifndef Tcl_GetUnicode_TCL_DECLARED
#define Tcl_GetUnicode_TCL_DECLARED
/* 382 */
EXTERN Tcl_UniChar *	Tcl_GetUnicode(Tcl_Obj *objPtr);
#endif
#ifndef Tcl_GetRange_TCL_DECLARED
#define Tcl_GetRange_TCL_DECLARED
/* 383 */
EXTERN Tcl_Obj *	Tcl_GetRange(Tcl_Obj *objPtr, int first, int last);
#endif
#ifndef Tcl_AppendUnicodeToObj_TCL_DECLARED
#define Tcl_AppendUnicodeToObj_TCL_DECLARED
/* 384 */
EXTERN void		Tcl_AppendUnicodeToObj(Tcl_Obj *objPtr,
				CONST Tcl_UniChar *unicode, int length);
#endif
#ifndef Tcl_RegExpMatchObj_TCL_DECLARED
#define Tcl_RegExpMatchObj_TCL_DECLARED
/* 385 */
EXTERN int		Tcl_RegExpMatchObj(Tcl_Interp *interp,
				Tcl_Obj *textObj, Tcl_Obj *patternObj);
#endif
#ifndef Tcl_SetNotifier_TCL_DECLARED
#define Tcl_SetNotifier_TCL_DECLARED
/* 386 */
EXTERN void		Tcl_SetNotifier(Tcl_NotifierProcs *notifierProcPtr);
#endif
#ifndef Tcl_GetAllocMutex_TCL_DECLARED
#define Tcl_GetAllocMutex_TCL_DECLARED
/* 387 */
EXTERN Tcl_Mutex *	Tcl_GetAllocMutex(void);
#endif
#ifndef Tcl_GetChannelNames_TCL_DECLARED
#define Tcl_GetChannelNames_TCL_DECLARED
/* 388 */
EXTERN int		Tcl_GetChannelNames(Tcl_Interp *interp);
#endif
#ifndef Tcl_GetChannelNamesEx_TCL_DECLARED
#define Tcl_GetChannelNamesEx_TCL_DECLARED
/* 389 */
EXTERN int		Tcl_GetChannelNamesEx(Tcl_Interp *interp,
				CONST char *pattern);
#endif
#ifndef Tcl_ProcObjCmd_TCL_DECLARED
#define Tcl_ProcObjCmd_TCL_DECLARED
/* 390 */
EXTERN int		Tcl_ProcObjCmd(ClientData clientData,
				Tcl_Interp *interp, int objc,
				Tcl_Obj *CONST objv[]);
#endif
#ifndef Tcl_ConditionFinalize_TCL_DECLARED
#define Tcl_ConditionFinalize_TCL_DECLARED
/* 391 */
EXTERN void		Tcl_ConditionFinalize(Tcl_Condition *condPtr);
#endif
#ifndef Tcl_MutexFinalize_TCL_DECLARED
#define Tcl_MutexFinalize_TCL_DECLARED
/* 392 */
EXTERN void		Tcl_MutexFinalize(Tcl_Mutex *mutex);
#endif
#ifndef Tcl_CreateThread_TCL_DECLARED
#define Tcl_CreateThread_TCL_DECLARED
/* 393 */
EXTERN int		Tcl_CreateThread(Tcl_ThreadId *idPtr,
				Tcl_ThreadCreateProc proc,
				ClientData clientData, int stackSize,
				int flags);
#endif
#ifndef Tcl_ReadRaw_TCL_DECLARED
#define Tcl_ReadRaw_TCL_DECLARED
/* 394 */
EXTERN int		Tcl_ReadRaw(Tcl_Channel chan, char *dst,
				int bytesToRead);
#endif
#ifndef Tcl_WriteRaw_TCL_DECLARED
#define Tcl_WriteRaw_TCL_DECLARED
/* 395 */
EXTERN int		Tcl_WriteRaw(Tcl_Channel chan, CONST char *src,
				int srcLen);
#endif
#ifndef Tcl_GetTopChannel_TCL_DECLARED
#define Tcl_GetTopChannel_TCL_DECLARED
/* 396 */
EXTERN Tcl_Channel	Tcl_GetTopChannel(Tcl_Channel chan);
#endif
#ifndef Tcl_ChannelBuffered_TCL_DECLARED
#define Tcl_ChannelBuffered_TCL_DECLARED
/* 397 */
EXTERN int		Tcl_ChannelBuffered(Tcl_Channel chan);
#endif
#ifndef Tcl_ChannelName_TCL_DECLARED
#define Tcl_ChannelName_TCL_DECLARED
/* 398 */
EXTERN CONST84_RETURN char * Tcl_ChannelName(
				CONST Tcl_ChannelType *chanTypePtr);
#endif
#ifndef Tcl_ChannelVersion_TCL_DECLARED
#define Tcl_ChannelVersion_TCL_DECLARED
/* 399 */
EXTERN Tcl_ChannelTypeVersion Tcl_ChannelVersion(
				CONST Tcl_ChannelType *chanTypePtr);
#endif
#ifndef Tcl_ChannelBlockModeProc_TCL_DECLARED
#define Tcl_ChannelBlockModeProc_TCL_DECLARED
/* 400 */
EXTERN Tcl_DriverBlockModeProc * Tcl_ChannelBlockModeProc(
				CONST Tcl_ChannelType *chanTypePtr);
#endif
#ifndef Tcl_ChannelCloseProc_TCL_DECLARED
#define Tcl_ChannelCloseProc_TCL_DECLARED
/* 401 */
EXTERN Tcl_DriverCloseProc * Tcl_ChannelCloseProc(
				CONST Tcl_ChannelType *chanTypePtr);
#endif
#ifndef Tcl_ChannelClose2Proc_TCL_DECLARED
#define Tcl_ChannelClose2Proc_TCL_DECLARED
/* 402 */
EXTERN Tcl_DriverClose2Proc * Tcl_ChannelClose2Proc(
				CONST Tcl_ChannelType *chanTypePtr);
#endif
#ifndef Tcl_ChannelInputProc_TCL_DECLARED
#define Tcl_ChannelInputProc_TCL_DECLARED
/* 403 */
EXTERN Tcl_DriverInputProc * Tcl_ChannelInputProc(
				CONST Tcl_ChannelType *chanTypePtr);
#endif
#ifndef Tcl_ChannelOutputProc_TCL_DECLARED
#define Tcl_ChannelOutputProc_TCL_DECLARED
/* 404 */
EXTERN Tcl_DriverOutputProc * Tcl_ChannelOutputProc(
				CONST Tcl_ChannelType *chanTypePtr);
#endif
#ifndef Tcl_ChannelSeekProc_TCL_DECLARED
#define Tcl_ChannelSeekProc_TCL_DECLARED
/* 405 */
EXTERN Tcl_DriverSeekProc * Tcl_ChannelSeekProc(
				CONST Tcl_ChannelType *chanTypePtr);
#endif
#ifndef Tcl_ChannelSetOptionProc_TCL_DECLARED
#define Tcl_ChannelSetOptionProc_TCL_DECLARED
/* 406 */
EXTERN Tcl_DriverSetOptionProc * Tcl_ChannelSetOptionProc(
				CONST Tcl_ChannelType *chanTypePtr);
#endif
#ifndef Tcl_ChannelGetOptionProc_TCL_DECLARED
#define Tcl_ChannelGetOptionProc_TCL_DECLARED
/* 407 */
EXTERN Tcl_DriverGetOptionProc * Tcl_ChannelGetOptionProc(
				CONST Tcl_ChannelType *chanTypePtr);
#endif
#ifndef Tcl_ChannelWatchProc_TCL_DECLARED
#define Tcl_ChannelWatchProc_TCL_DECLARED
/* 408 */
EXTERN Tcl_DriverWatchProc * Tcl_ChannelWatchProc(
				CONST Tcl_ChannelType *chanTypePtr);
#endif
#ifndef Tcl_ChannelGetHandleProc_TCL_DECLARED
#define Tcl_ChannelGetHandleProc_TCL_DECLARED
/* 409 */
EXTERN Tcl_DriverGetHandleProc * Tcl_ChannelGetHandleProc(
				CONST Tcl_ChannelType *chanTypePtr);
#endif
#ifndef Tcl_ChannelFlushProc_TCL_DECLARED
#define Tcl_ChannelFlushProc_TCL_DECLARED
/* 410 */
EXTERN Tcl_DriverFlushProc * Tcl_ChannelFlushProc(
				CONST Tcl_ChannelType *chanTypePtr);
#endif
#ifndef Tcl_ChannelHandlerProc_TCL_DECLARED
#define Tcl_ChannelHandlerProc_TCL_DECLARED
/* 411 */
EXTERN Tcl_DriverHandlerProc * Tcl_ChannelHandlerProc(
				CONST Tcl_ChannelType *chanTypePtr);
#endif
#ifndef Tcl_JoinThread_TCL_DECLARED
#define Tcl_JoinThread_TCL_DECLARED
/* 412 */
EXTERN int		Tcl_JoinThread(Tcl_ThreadId threadId, int *result);
#endif
#ifndef Tcl_IsChannelShared_TCL_DECLARED
#define Tcl_IsChannelShared_TCL_DECLARED
/* 413 */
EXTERN int		Tcl_IsChannelShared(Tcl_Channel channel);
#endif
#ifndef Tcl_IsChannelRegistered_TCL_DECLARED
#define Tcl_IsChannelRegistered_TCL_DECLARED
/* 414 */
EXTERN int		Tcl_IsChannelRegistered(Tcl_Interp *interp,
				Tcl_Channel channel);
#endif
#ifndef Tcl_CutChannel_TCL_DECLARED
#define Tcl_CutChannel_TCL_DECLARED
/* 415 */
EXTERN void		Tcl_CutChannel(Tcl_Channel channel);
#endif
#ifndef Tcl_SpliceChannel_TCL_DECLARED
#define Tcl_SpliceChannel_TCL_DECLARED
/* 416 */
EXTERN void		Tcl_SpliceChannel(Tcl_Channel channel);
#endif
#ifndef Tcl_ClearChannelHandlers_TCL_DECLARED
#define Tcl_ClearChannelHandlers_TCL_DECLARED
/* 417 */
EXTERN void		Tcl_ClearChannelHandlers(Tcl_Channel channel);
#endif
#ifndef Tcl_IsChannelExisting_TCL_DECLARED
#define Tcl_IsChannelExisting_TCL_DECLARED
/* 418 */
EXTERN int		Tcl_IsChannelExisting(CONST char *channelName);
#endif
#ifndef Tcl_UniCharNcasecmp_TCL_DECLARED
#define Tcl_UniCharNcasecmp_TCL_DECLARED
/* 419 */
EXTERN int		Tcl_UniCharNcasecmp(CONST Tcl_UniChar *ucs,
				CONST Tcl_UniChar *uct,
				unsigned long numChars);
#endif
#ifndef Tcl_UniCharCaseMatch_TCL_DECLARED
#define Tcl_UniCharCaseMatch_TCL_DECLARED
/* 420 */
EXTERN int		Tcl_UniCharCaseMatch(CONST Tcl_UniChar *uniStr,
				CONST Tcl_UniChar *uniPattern, int nocase);
#endif
#ifndef Tcl_FindHashEntry_TCL_DECLARED
#define Tcl_FindHashEntry_TCL_DECLARED
/* 421 */
EXTERN Tcl_HashEntry *	Tcl_FindHashEntry(Tcl_HashTable *tablePtr,
				CONST char *key);
#endif
#ifndef Tcl_CreateHashEntry_TCL_DECLARED
#define Tcl_CreateHashEntry_TCL_DECLARED
/* 422 */
EXTERN Tcl_HashEntry *	Tcl_CreateHashEntry(Tcl_HashTable *tablePtr,
				CONST char *key, int *newPtr);
#endif
#ifndef Tcl_InitCustomHashTable_TCL_DECLARED
#define Tcl_InitCustomHashTable_TCL_DECLARED
/* 423 */
EXTERN void		Tcl_InitCustomHashTable(Tcl_HashTable *tablePtr,
				int keyType, Tcl_HashKeyType *typePtr);
#endif
#ifndef Tcl_InitObjHashTable_TCL_DECLARED
#define Tcl_InitObjHashTable_TCL_DECLARED
/* 424 */
EXTERN void		Tcl_InitObjHashTable(Tcl_HashTable *tablePtr);
#endif
#ifndef Tcl_CommandTraceInfo_TCL_DECLARED
#define Tcl_CommandTraceInfo_TCL_DECLARED
/* 425 */
EXTERN ClientData	Tcl_CommandTraceInfo(Tcl_Interp *interp,
				CONST char *varName, int flags,
				Tcl_CommandTraceProc *procPtr,
				ClientData prevClientData);
#endif
#ifndef Tcl_TraceCommand_TCL_DECLARED
#define Tcl_TraceCommand_TCL_DECLARED
/* 426 */
EXTERN int		Tcl_TraceCommand(Tcl_Interp *interp,
				CONST char *varName, int flags,
				Tcl_CommandTraceProc *proc,
				ClientData clientData);
#endif
#ifndef Tcl_UntraceCommand_TCL_DECLARED
#define Tcl_UntraceCommand_TCL_DECLARED
/* 427 */
EXTERN void		Tcl_UntraceCommand(Tcl_Interp *interp,
				CONST char *varName, int flags,
				Tcl_CommandTraceProc *proc,
				ClientData clientData);
#endif
#ifndef Tcl_AttemptAlloc_TCL_DECLARED
#define Tcl_AttemptAlloc_TCL_DECLARED
/* 428 */
EXTERN char *		Tcl_AttemptAlloc(unsigned int size);
#endif
#ifndef Tcl_AttemptDbCkalloc_TCL_DECLARED
#define Tcl_AttemptDbCkalloc_TCL_DECLARED
/* 429 */
EXTERN char *		Tcl_AttemptDbCkalloc(unsigned int size,
				CONST char *file, int line);
#endif
#ifndef Tcl_AttemptRealloc_TCL_DECLARED
#define Tcl_AttemptRealloc_TCL_DECLARED
/* 430 */
EXTERN char *		Tcl_AttemptRealloc(char *ptr, unsigned int size);
#endif
#ifndef Tcl_AttemptDbCkrealloc_TCL_DECLARED
#define Tcl_AttemptDbCkrealloc_TCL_DECLARED
/* 431 */
EXTERN char *		Tcl_AttemptDbCkrealloc(char *ptr, unsigned int size,
				CONST char *file, int line);
#endif
#ifndef Tcl_AttemptSetObjLength_TCL_DECLARED
#define Tcl_AttemptSetObjLength_TCL_DECLARED
/* 432 */
EXTERN int		Tcl_AttemptSetObjLength(Tcl_Obj *objPtr, int length);
#endif
#ifndef Tcl_GetChannelThread_TCL_DECLARED
#define Tcl_GetChannelThread_TCL_DECLARED
/* 433 */
EXTERN Tcl_ThreadId	Tcl_GetChannelThread(Tcl_Channel channel);
#endif
#ifndef Tcl_GetUnicodeFromObj_TCL_DECLARED
#define Tcl_GetUnicodeFromObj_TCL_DECLARED
/* 434 */
EXTERN Tcl_UniChar *	Tcl_GetUnicodeFromObj(Tcl_Obj *objPtr,
				int *lengthPtr);
#endif
#ifndef Tcl_GetMathFuncInfo_TCL_DECLARED
#define Tcl_GetMathFuncInfo_TCL_DECLARED
/* 435 */
EXTERN int		Tcl_GetMathFuncInfo(Tcl_Interp *interp,
				CONST char *name, int *numArgsPtr,
				Tcl_ValueType **argTypesPtr,
				Tcl_MathProc **procPtr,
				ClientData *clientDataPtr);
#endif
#ifndef Tcl_ListMathFuncs_TCL_DECLARED
#define Tcl_ListMathFuncs_TCL_DECLARED
/* 436 */
EXTERN Tcl_Obj *	Tcl_ListMathFuncs(Tcl_Interp *interp,
				CONST char *pattern);
#endif
#ifndef Tcl_SubstObj_TCL_DECLARED
#define Tcl_SubstObj_TCL_DECLARED
/* 437 */
EXTERN Tcl_Obj *	Tcl_SubstObj(Tcl_Interp *interp, Tcl_Obj *objPtr,
				int flags);
#endif
#ifndef Tcl_DetachChannel_TCL_DECLARED
#define Tcl_DetachChannel_TCL_DECLARED
/* 438 */
EXTERN int		Tcl_DetachChannel(Tcl_Interp *interp,
				Tcl_Channel channel);
#endif
#ifndef Tcl_IsStandardChannel_TCL_DECLARED
#define Tcl_IsStandardChannel_TCL_DECLARED
/* 439 */
EXTERN int		Tcl_IsStandardChannel(Tcl_Channel channel);
#endif
#ifndef Tcl_FSCopyFile_TCL_DECLARED
#define Tcl_FSCopyFile_TCL_DECLARED
/* 440 */
EXTERN int		Tcl_FSCopyFile(Tcl_Obj *srcPathPtr,
				Tcl_Obj *destPathPtr);
#endif
#ifndef Tcl_FSCopyDirectory_TCL_DECLARED
#define Tcl_FSCopyDirectory_TCL_DECLARED
/* 441 */
EXTERN int		Tcl_FSCopyDirectory(Tcl_Obj *srcPathPtr,
				Tcl_Obj *destPathPtr, Tcl_Obj **errorPtr);
#endif
#ifndef Tcl_FSCreateDirectory_TCL_DECLARED
#define Tcl_FSCreateDirectory_TCL_DECLARED
/* 442 */
EXTERN int		Tcl_FSCreateDirectory(Tcl_Obj *pathPtr);
#endif
#ifndef Tcl_FSDeleteFile_TCL_DECLARED
#define Tcl_FSDeleteFile_TCL_DECLARED
/* 443 */
EXTERN int		Tcl_FSDeleteFile(Tcl_Obj *pathPtr);
#endif
#ifndef Tcl_FSLoadFile_TCL_DECLARED
#define Tcl_FSLoadFile_TCL_DECLARED
/* 444 */
EXTERN int		Tcl_FSLoadFile(Tcl_Interp *interp, Tcl_Obj *pathPtr,
				CONST char *sym1, CONST char *sym2,
				Tcl_PackageInitProc **proc1Ptr,
				Tcl_PackageInitProc **proc2Ptr,
				Tcl_LoadHandle *handlePtr,
				Tcl_FSUnloadFileProc **unloadProcPtr);
#endif
#ifndef Tcl_FSMatchInDirectory_TCL_DECLARED
#define Tcl_FSMatchInDirectory_TCL_DECLARED
/* 445 */
EXTERN int		Tcl_FSMatchInDirectory(Tcl_Interp *interp,
				Tcl_Obj *result, Tcl_Obj *pathPtr,
				CONST char *pattern, Tcl_GlobTypeData *types);
#endif
#ifndef Tcl_FSLink_TCL_DECLARED
#define Tcl_FSLink_TCL_DECLARED
/* 446 */
EXTERN Tcl_Obj *	Tcl_FSLink(Tcl_Obj *pathPtr, Tcl_Obj *toPtr,
				int linkAction);
#endif
#ifndef Tcl_FSRemoveDirectory_TCL_DECLARED
#define Tcl_FSRemoveDirectory_TCL_DECLARED
/* 447 */
EXTERN int		Tcl_FSRemoveDirectory(Tcl_Obj *pathPtr,
				int recursive, Tcl_Obj **errorPtr);
#endif
#ifndef Tcl_FSRenameFile_TCL_DECLARED
#define Tcl_FSRenameFile_TCL_DECLARED
/* 448 */
EXTERN int		Tcl_FSRenameFile(Tcl_Obj *srcPathPtr,
				Tcl_Obj *destPathPtr);
#endif
#ifndef Tcl_FSLstat_TCL_DECLARED
#define Tcl_FSLstat_TCL_DECLARED
/* 449 */
EXTERN int		Tcl_FSLstat(Tcl_Obj *pathPtr, Tcl_StatBuf *buf);
#endif
#ifndef Tcl_FSUtime_TCL_DECLARED
#define Tcl_FSUtime_TCL_DECLARED
/* 450 */
EXTERN int		Tcl_FSUtime(Tcl_Obj *pathPtr, struct utimbuf *tval);
#endif
#ifndef Tcl_FSFileAttrsGet_TCL_DECLARED
#define Tcl_FSFileAttrsGet_TCL_DECLARED
/* 451 */
EXTERN int		Tcl_FSFileAttrsGet(Tcl_Interp *interp, int index,
				Tcl_Obj *pathPtr, Tcl_Obj **objPtrRef);
#endif
#ifndef Tcl_FSFileAttrsSet_TCL_DECLARED
#define Tcl_FSFileAttrsSet_TCL_DECLARED
/* 452 */
EXTERN int		Tcl_FSFileAttrsSet(Tcl_Interp *interp, int index,
				Tcl_Obj *pathPtr, Tcl_Obj *objPtr);
#endif
#ifndef Tcl_FSFileAttrStrings_TCL_DECLARED
#define Tcl_FSFileAttrStrings_TCL_DECLARED
/* 453 */
EXTERN CONST char **	Tcl_FSFileAttrStrings(Tcl_Obj *pathPtr,
				Tcl_Obj **objPtrRef);
#endif
#ifndef Tcl_FSStat_TCL_DECLARED
#define Tcl_FSStat_TCL_DECLARED
/* 454 */
EXTERN int		Tcl_FSStat(Tcl_Obj *pathPtr, Tcl_StatBuf *buf);
#endif
#ifndef Tcl_FSAccess_TCL_DECLARED
#define Tcl_FSAccess_TCL_DECLARED
/* 455 */
EXTERN int		Tcl_FSAccess(Tcl_Obj *pathPtr, int mode);
#endif
#ifndef Tcl_FSOpenFileChannel_TCL_DECLARED
#define Tcl_FSOpenFileChannel_TCL_DECLARED
/* 456 */
EXTERN Tcl_Channel	Tcl_FSOpenFileChannel(Tcl_Interp *interp,
				Tcl_Obj *pathPtr, CONST char *modeString,
				int permissions);
#endif
#ifndef Tcl_FSGetCwd_TCL_DECLARED
#define Tcl_FSGetCwd_TCL_DECLARED
/* 457 */
EXTERN Tcl_Obj *	Tcl_FSGetCwd(Tcl_Interp *interp);
#endif
#ifndef Tcl_FSChdir_TCL_DECLARED
#define Tcl_FSChdir_TCL_DECLARED
/* 458 */
EXTERN int		Tcl_FSChdir(Tcl_Obj *pathPtr);
#endif
#ifndef Tcl_FSConvertToPathType_TCL_DECLARED
#define Tcl_FSConvertToPathType_TCL_DECLARED
/* 459 */
EXTERN int		Tcl_FSConvertToPathType(Tcl_Interp *interp,
				Tcl_Obj *pathPtr);
#endif
#ifndef Tcl_FSJoinPath_TCL_DECLARED
#define Tcl_FSJoinPath_TCL_DECLARED
/* 460 */
EXTERN Tcl_Obj *	Tcl_FSJoinPath(Tcl_Obj *listObj, int elements);
#endif
#ifndef Tcl_FSSplitPath_TCL_DECLARED
#define Tcl_FSSplitPath_TCL_DECLARED
/* 461 */
EXTERN Tcl_Obj *	Tcl_FSSplitPath(Tcl_Obj *pathPtr, int *lenPtr);
#endif
#ifndef Tcl_FSEqualPaths_TCL_DECLARED
#define Tcl_FSEqualPaths_TCL_DECLARED
/* 462 */
EXTERN int		Tcl_FSEqualPaths(Tcl_Obj *firstPtr,
				Tcl_Obj *secondPtr);
#endif
#ifndef Tcl_FSGetNormalizedPath_TCL_DECLARED
#define Tcl_FSGetNormalizedPath_TCL_DECLARED
/* 463 */
EXTERN Tcl_Obj *	Tcl_FSGetNormalizedPath(Tcl_Interp *interp,
				Tcl_Obj *pathPtr);
#endif
#ifndef Tcl_FSJoinToPath_TCL_DECLARED
#define Tcl_FSJoinToPath_TCL_DECLARED
/* 464 */
EXTERN Tcl_Obj *	Tcl_FSJoinToPath(Tcl_Obj *pathPtr, int objc,
				Tcl_Obj *CONST objv[]);
#endif
#ifndef Tcl_FSGetInternalRep_TCL_DECLARED
#define Tcl_FSGetInternalRep_TCL_DECLARED
/* 465 */
EXTERN ClientData	Tcl_FSGetInternalRep(Tcl_Obj *pathPtr,
				Tcl_Filesystem *fsPtr);
#endif
#ifndef Tcl_FSGetTranslatedPath_TCL_DECLARED
#define Tcl_FSGetTranslatedPath_TCL_DECLARED
/* 466 */
EXTERN Tcl_Obj *	Tcl_FSGetTranslatedPath(Tcl_Interp *interp,
				Tcl_Obj *pathPtr);
#endif
#ifndef Tcl_FSEvalFile_TCL_DECLARED
#define Tcl_FSEvalFile_TCL_DECLARED
/* 467 */
EXTERN int		Tcl_FSEvalFile(Tcl_Interp *interp, Tcl_Obj *fileName);
#endif
#ifndef Tcl_FSNewNativePath_TCL_DECLARED
#define Tcl_FSNewNativePath_TCL_DECLARED
/* 468 */
EXTERN Tcl_Obj *	Tcl_FSNewNativePath(Tcl_Filesystem *fromFilesystem,
				ClientData clientData);
#endif
#ifndef Tcl_FSGetNativePath_TCL_DECLARED
#define Tcl_FSGetNativePath_TCL_DECLARED
/* 469 */
EXTERN CONST char *	Tcl_FSGetNativePath(Tcl_Obj *pathPtr);
#endif
#ifndef Tcl_FSFileSystemInfo_TCL_DECLARED
#define Tcl_FSFileSystemInfo_TCL_DECLARED
/* 470 */
EXTERN Tcl_Obj *	Tcl_FSFileSystemInfo(Tcl_Obj *pathPtr);
#endif
#ifndef Tcl_FSPathSeparator_TCL_DECLARED
#define Tcl_FSPathSeparator_TCL_DECLARED
/* 471 */
EXTERN Tcl_Obj *	Tcl_FSPathSeparator(Tcl_Obj *pathPtr);
#endif
#ifndef Tcl_FSListVolumes_TCL_DECLARED
#define Tcl_FSListVolumes_TCL_DECLARED
/* 472 */
EXTERN Tcl_Obj *	Tcl_FSListVolumes(void);
#endif
#ifndef Tcl_FSRegister_TCL_DECLARED
#define Tcl_FSRegister_TCL_DECLARED
/* 473 */
EXTERN int		Tcl_FSRegister(ClientData clientData,
				Tcl_Filesystem *fsPtr);
#endif
#ifndef Tcl_FSUnregister_TCL_DECLARED
#define Tcl_FSUnregister_TCL_DECLARED
/* 474 */
EXTERN int		Tcl_FSUnregister(Tcl_Filesystem *fsPtr);
#endif
#ifndef Tcl_FSData_TCL_DECLARED
#define Tcl_FSData_TCL_DECLARED
/* 475 */
EXTERN ClientData	Tcl_FSData(Tcl_Filesystem *fsPtr);
#endif
#ifndef Tcl_FSGetTranslatedStringPath_TCL_DECLARED
#define Tcl_FSGetTranslatedStringPath_TCL_DECLARED
/* 476 */
EXTERN CONST char *	Tcl_FSGetTranslatedStringPath(Tcl_Interp *interp,
				Tcl_Obj *pathPtr);
#endif
#ifndef Tcl_FSGetFileSystemForPath_TCL_DECLARED
#define Tcl_FSGetFileSystemForPath_TCL_DECLARED
/* 477 */
EXTERN Tcl_Filesystem *	 Tcl_FSGetFileSystemForPath(Tcl_Obj *pathPtr);
#endif
#ifndef Tcl_FSGetPathType_TCL_DECLARED
#define Tcl_FSGetPathType_TCL_DECLARED
/* 478 */
EXTERN Tcl_PathType	Tcl_FSGetPathType(Tcl_Obj *pathPtr);
#endif
#ifndef Tcl_OutputBuffered_TCL_DECLARED
#define Tcl_OutputBuffered_TCL_DECLARED
/* 479 */
EXTERN int		Tcl_OutputBuffered(Tcl_Channel chan);
#endif
#ifndef Tcl_FSMountsChanged_TCL_DECLARED
#define Tcl_FSMountsChanged_TCL_DECLARED
/* 480 */
EXTERN void		Tcl_FSMountsChanged(Tcl_Filesystem *fsPtr);
#endif
#ifndef Tcl_EvalTokensStandard_TCL_DECLARED
#define Tcl_EvalTokensStandard_TCL_DECLARED
/* 481 */
EXTERN int		Tcl_EvalTokensStandard(Tcl_Interp *interp,
				Tcl_Token *tokenPtr, int count);
#endif
#ifndef Tcl_GetTime_TCL_DECLARED
#define Tcl_GetTime_TCL_DECLARED
/* 482 */
EXTERN void		Tcl_GetTime(Tcl_Time *timeBuf);
#endif
#ifndef Tcl_CreateObjTrace_TCL_DECLARED
#define Tcl_CreateObjTrace_TCL_DECLARED
/* 483 */
EXTERN Tcl_Trace	Tcl_CreateObjTrace(Tcl_Interp *interp, int level,
				int flags, Tcl_CmdObjTraceProc *objProc,
				ClientData clientData,
				Tcl_CmdObjTraceDeleteProc *delProc);
#endif
#ifndef Tcl_GetCommandInfoFromToken_TCL_DECLARED
#define Tcl_GetCommandInfoFromToken_TCL_DECLARED
/* 484 */
EXTERN int		Tcl_GetCommandInfoFromToken(Tcl_Command token,
				Tcl_CmdInfo *infoPtr);
#endif
#ifndef Tcl_SetCommandInfoFromToken_TCL_DECLARED
#define Tcl_SetCommandInfoFromToken_TCL_DECLARED
/* 485 */
EXTERN int		Tcl_SetCommandInfoFromToken(Tcl_Command token,
				CONST Tcl_CmdInfo *infoPtr);
#endif
#ifndef Tcl_DbNewWideIntObj_TCL_DECLARED
#define Tcl_DbNewWideIntObj_TCL_DECLARED
/* 486 */
EXTERN Tcl_Obj *	Tcl_DbNewWideIntObj(Tcl_WideInt wideValue,
				CONST char *file, int line);
#endif
#ifndef Tcl_GetWideIntFromObj_TCL_DECLARED
#define Tcl_GetWideIntFromObj_TCL_DECLARED
/* 487 */
EXTERN int		Tcl_GetWideIntFromObj(Tcl_Interp *interp,
				Tcl_Obj *objPtr, Tcl_WideInt *widePtr);
#endif
#ifndef Tcl_NewWideIntObj_TCL_DECLARED
#define Tcl_NewWideIntObj_TCL_DECLARED
/* 488 */
EXTERN Tcl_Obj *	Tcl_NewWideIntObj(Tcl_WideInt wideValue);
#endif
#ifndef Tcl_SetWideIntObj_TCL_DECLARED
#define Tcl_SetWideIntObj_TCL_DECLARED
/* 489 */
EXTERN void		Tcl_SetWideIntObj(Tcl_Obj *objPtr,
				Tcl_WideInt wideValue);
#endif
#ifndef Tcl_AllocStatBuf_TCL_DECLARED
#define Tcl_AllocStatBuf_TCL_DECLARED
/* 490 */
EXTERN Tcl_StatBuf *	Tcl_AllocStatBuf(void);
#endif
#ifndef Tcl_Seek_TCL_DECLARED
#define Tcl_Seek_TCL_DECLARED
/* 491 */
EXTERN Tcl_WideInt	Tcl_Seek(Tcl_Channel chan, Tcl_WideInt offset,
				int mode);
#endif
#ifndef Tcl_Tell_TCL_DECLARED
#define Tcl_Tell_TCL_DECLARED
/* 492 */
EXTERN Tcl_WideInt	Tcl_Tell(Tcl_Channel chan);
#endif
#ifndef Tcl_ChannelWideSeekProc_TCL_DECLARED
#define Tcl_ChannelWideSeekProc_TCL_DECLARED
/* 493 */
EXTERN Tcl_DriverWideSeekProc * Tcl_ChannelWideSeekProc(
				CONST Tcl_ChannelType *chanTypePtr);
#endif
#ifndef Tcl_DictObjPut_TCL_DECLARED
#define Tcl_DictObjPut_TCL_DECLARED
/* 494 */
EXTERN int		Tcl_DictObjPut(Tcl_Interp *interp, Tcl_Obj *dictPtr,
				Tcl_Obj *keyPtr, Tcl_Obj *valuePtr);
#endif
#ifndef Tcl_DictObjGet_TCL_DECLARED
#define Tcl_DictObjGet_TCL_DECLARED
/* 495 */
EXTERN int		Tcl_DictObjGet(Tcl_Interp *interp, Tcl_Obj *dictPtr,
				Tcl_Obj *keyPtr, Tcl_Obj **valuePtrPtr);
#endif
#ifndef Tcl_DictObjRemove_TCL_DECLARED
#define Tcl_DictObjRemove_TCL_DECLARED
/* 496 */
EXTERN int		Tcl_DictObjRemove(Tcl_Interp *interp,
				Tcl_Obj *dictPtr, Tcl_Obj *keyPtr);
#endif
#ifndef Tcl_DictObjSize_TCL_DECLARED
#define Tcl_DictObjSize_TCL_DECLARED
/* 497 */
EXTERN int		Tcl_DictObjSize(Tcl_Interp *interp, Tcl_Obj *dictPtr,
				int *sizePtr);
#endif
#ifndef Tcl_DictObjFirst_TCL_DECLARED
#define Tcl_DictObjFirst_TCL_DECLARED
/* 498 */
EXTERN int		Tcl_DictObjFirst(Tcl_Interp *interp,
				Tcl_Obj *dictPtr, Tcl_DictSearch *searchPtr,
				Tcl_Obj **keyPtrPtr, Tcl_Obj **valuePtrPtr,
				int *donePtr);
#endif
#ifndef Tcl_DictObjNext_TCL_DECLARED
#define Tcl_DictObjNext_TCL_DECLARED
/* 499 */
EXTERN void		Tcl_DictObjNext(Tcl_DictSearch *searchPtr,
				Tcl_Obj **keyPtrPtr, Tcl_Obj **valuePtrPtr,
				int *donePtr);
#endif
#ifndef Tcl_DictObjDone_TCL_DECLARED
#define Tcl_DictObjDone_TCL_DECLARED
/* 500 */
EXTERN void		Tcl_DictObjDone(Tcl_DictSearch *searchPtr);
#endif
#ifndef Tcl_DictObjPutKeyList_TCL_DECLARED
#define Tcl_DictObjPutKeyList_TCL_DECLARED
/* 501 */
EXTERN int		Tcl_DictObjPutKeyList(Tcl_Interp *interp,
				Tcl_Obj *dictPtr, int keyc,
				Tcl_Obj *CONST *keyv, Tcl_Obj *valuePtr);
#endif
#ifndef Tcl_DictObjRemoveKeyList_TCL_DECLARED
#define Tcl_DictObjRemoveKeyList_TCL_DECLARED
/* 502 */
EXTERN int		Tcl_DictObjRemoveKeyList(Tcl_Interp *interp,
				Tcl_Obj *dictPtr, int keyc,
				Tcl_Obj *CONST *keyv);
#endif
#ifndef Tcl_NewDictObj_TCL_DECLARED
#define Tcl_NewDictObj_TCL_DECLARED
/* 503 */
EXTERN Tcl_Obj *	Tcl_NewDictObj(void);
#endif
#ifndef Tcl_DbNewDictObj_TCL_DECLARED
#define Tcl_DbNewDictObj_TCL_DECLARED
/* 504 */
EXTERN Tcl_Obj *	Tcl_DbNewDictObj(CONST char *file, int line);
#endif
#ifndef Tcl_RegisterConfig_TCL_DECLARED
#define Tcl_RegisterConfig_TCL_DECLARED
/* 505 */
EXTERN void		Tcl_RegisterConfig(Tcl_Interp *interp,
				CONST char *pkgName,
				Tcl_Config *configuration,
				CONST char *valEncoding);
#endif
#ifndef Tcl_CreateNamespace_TCL_DECLARED
#define Tcl_CreateNamespace_TCL_DECLARED
/* 506 */
EXTERN Tcl_Namespace *	Tcl_CreateNamespace(Tcl_Interp *interp,
				CONST char *name, ClientData clientData,
				Tcl_NamespaceDeleteProc *deleteProc);
#endif
#ifndef Tcl_DeleteNamespace_TCL_DECLARED
#define Tcl_DeleteNamespace_TCL_DECLARED
/* 507 */
EXTERN void		Tcl_DeleteNamespace(Tcl_Namespace *nsPtr);
#endif
#ifndef Tcl_AppendExportList_TCL_DECLARED
#define Tcl_AppendExportList_TCL_DECLARED
/* 508 */
EXTERN int		Tcl_AppendExportList(Tcl_Interp *interp,
				Tcl_Namespace *nsPtr, Tcl_Obj *objPtr);
#endif
#ifndef Tcl_Export_TCL_DECLARED
#define Tcl_Export_TCL_DECLARED
/* 509 */
EXTERN int		Tcl_Export(Tcl_Interp *interp, Tcl_Namespace *nsPtr,
				CONST char *pattern, int resetListFirst);
#endif
#ifndef Tcl_Import_TCL_DECLARED
#define Tcl_Import_TCL_DECLARED
/* 510 */
EXTERN int		Tcl_Import(Tcl_Interp *interp, Tcl_Namespace *nsPtr,
				CONST char *pattern, int allowOverwrite);
#endif
#ifndef Tcl_ForgetImport_TCL_DECLARED
#define Tcl_ForgetImport_TCL_DECLARED
/* 511 */
EXTERN int		Tcl_ForgetImport(Tcl_Interp *interp,
				Tcl_Namespace *nsPtr, CONST char *pattern);
#endif
#ifndef Tcl_GetCurrentNamespace_TCL_DECLARED
#define Tcl_GetCurrentNamespace_TCL_DECLARED
/* 512 */
EXTERN Tcl_Namespace *	Tcl_GetCurrentNamespace(Tcl_Interp *interp);
#endif
#ifndef Tcl_GetGlobalNamespace_TCL_DECLARED
#define Tcl_GetGlobalNamespace_TCL_DECLARED
/* 513 */
EXTERN Tcl_Namespace *	Tcl_GetGlobalNamespace(Tcl_Interp *interp);
#endif
#ifndef Tcl_FindNamespace_TCL_DECLARED
#define Tcl_FindNamespace_TCL_DECLARED
/* 514 */
EXTERN Tcl_Namespace *	Tcl_FindNamespace(Tcl_Interp *interp,
				CONST char *name,
				Tcl_Namespace *contextNsPtr, int flags);
#endif
#ifndef Tcl_FindCommand_TCL_DECLARED
#define Tcl_FindCommand_TCL_DECLARED
/* 515 */
EXTERN Tcl_Command	Tcl_FindCommand(Tcl_Interp *interp, CONST char *name,
				Tcl_Namespace *contextNsPtr, int flags);
#endif
#ifndef Tcl_GetCommandFromObj_TCL_DECLARED
#define Tcl_GetCommandFromObj_TCL_DECLARED
/* 516 */
EXTERN Tcl_Command	Tcl_GetCommandFromObj(Tcl_Interp *interp,
				Tcl_Obj *objPtr);
#endif
#ifndef Tcl_GetCommandFullName_TCL_DECLARED
#define Tcl_GetCommandFullName_TCL_DECLARED
/* 517 */
EXTERN void		Tcl_GetCommandFullName(Tcl_Interp *interp,
				Tcl_Command command, Tcl_Obj *objPtr);
#endif
#ifndef Tcl_FSEvalFileEx_TCL_DECLARED
#define Tcl_FSEvalFileEx_TCL_DECLARED
/* 518 */
EXTERN int		Tcl_FSEvalFileEx(Tcl_Interp *interp,
				Tcl_Obj *fileName, CONST char *encodingName);
#endif
#ifndef Tcl_SetExitProc_TCL_DECLARED
#define Tcl_SetExitProc_TCL_DECLARED
/* 519 */
EXTERN Tcl_ExitProc *	Tcl_SetExitProc(Tcl_ExitProc *proc);
#endif
#ifndef Tcl_LimitAddHandler_TCL_DECLARED
#define Tcl_LimitAddHandler_TCL_DECLARED
/* 520 */
EXTERN void		Tcl_LimitAddHandler(Tcl_Interp *interp, int type,
				Tcl_LimitHandlerProc *handlerProc,
				ClientData clientData,
				Tcl_LimitHandlerDeleteProc *deleteProc);
#endif
#ifndef Tcl_LimitRemoveHandler_TCL_DECLARED
#define Tcl_LimitRemoveHandler_TCL_DECLARED
/* 521 */
EXTERN void		Tcl_LimitRemoveHandler(Tcl_Interp *interp, int type,
				Tcl_LimitHandlerProc *handlerProc,
				ClientData clientData);
#endif
#ifndef Tcl_LimitReady_TCL_DECLARED
#define Tcl_LimitReady_TCL_DECLARED
/* 522 */
EXTERN int		Tcl_LimitReady(Tcl_Interp *interp);
#endif
#ifndef Tcl_LimitCheck_TCL_DECLARED
#define Tcl_LimitCheck_TCL_DECLARED
/* 523 */
EXTERN int		Tcl_LimitCheck(Tcl_Interp *interp);
#endif
#ifndef Tcl_LimitExceeded_TCL_DECLARED
#define Tcl_LimitExceeded_TCL_DECLARED
/* 524 */
EXTERN int		Tcl_LimitExceeded(Tcl_Interp *interp);
#endif
#ifndef Tcl_LimitSetCommands_TCL_DECLARED
#define Tcl_LimitSetCommands_TCL_DECLARED
/* 525 */
EXTERN void		Tcl_LimitSetCommands(Tcl_Interp *interp,
				int commandLimit);
#endif
#ifndef Tcl_LimitSetTime_TCL_DECLARED
#define Tcl_LimitSetTime_TCL_DECLARED
/* 526 */
EXTERN void		Tcl_LimitSetTime(Tcl_Interp *interp,
				Tcl_Time *timeLimitPtr);
#endif
#ifndef Tcl_LimitSetGranularity_TCL_DECLARED
#define Tcl_LimitSetGranularity_TCL_DECLARED
/* 527 */
EXTERN void		Tcl_LimitSetGranularity(Tcl_Interp *interp, int type,
				int granularity);
#endif
#ifndef Tcl_LimitTypeEnabled_TCL_DECLARED
#define Tcl_LimitTypeEnabled_TCL_DECLARED
/* 528 */
EXTERN int		Tcl_LimitTypeEnabled(Tcl_Interp *interp, int type);
#endif
#ifndef Tcl_LimitTypeExceeded_TCL_DECLARED
#define Tcl_LimitTypeExceeded_TCL_DECLARED
/* 529 */
EXTERN int		Tcl_LimitTypeExceeded(Tcl_Interp *interp, int type);
#endif
#ifndef Tcl_LimitTypeSet_TCL_DECLARED
#define Tcl_LimitTypeSet_TCL_DECLARED
/* 530 */
EXTERN void		Tcl_LimitTypeSet(Tcl_Interp *interp, int type);
#endif
#ifndef Tcl_LimitTypeReset_TCL_DECLARED
#define Tcl_LimitTypeReset_TCL_DECLARED
/* 531 */
EXTERN void		Tcl_LimitTypeReset(Tcl_Interp *interp, int type);
#endif
#ifndef Tcl_LimitGetCommands_TCL_DECLARED
#define Tcl_LimitGetCommands_TCL_DECLARED
/* 532 */
EXTERN int		Tcl_LimitGetCommands(Tcl_Interp *interp);
#endif
#ifndef Tcl_LimitGetTime_TCL_DECLARED
#define Tcl_LimitGetTime_TCL_DECLARED
/* 533 */
EXTERN void		Tcl_LimitGetTime(Tcl_Interp *interp,
				Tcl_Time *timeLimitPtr);
#endif
#ifndef Tcl_LimitGetGranularity_TCL_DECLARED
#define Tcl_LimitGetGranularity_TCL_DECLARED
/* 534 */
EXTERN int		Tcl_LimitGetGranularity(Tcl_Interp *interp, int type);
#endif
#ifndef Tcl_SaveInterpState_TCL_DECLARED
#define Tcl_SaveInterpState_TCL_DECLARED
/* 535 */
EXTERN Tcl_InterpState	Tcl_SaveInterpState(Tcl_Interp *interp, int status);
#endif
#ifndef Tcl_RestoreInterpState_TCL_DECLARED
#define Tcl_RestoreInterpState_TCL_DECLARED
/* 536 */
EXTERN int		Tcl_RestoreInterpState(Tcl_Interp *interp,
				Tcl_InterpState state);
#endif
#ifndef Tcl_DiscardInterpState_TCL_DECLARED
#define Tcl_DiscardInterpState_TCL_DECLARED
/* 537 */
EXTERN void		Tcl_DiscardInterpState(Tcl_InterpState state);
#endif
#ifndef Tcl_SetReturnOptions_TCL_DECLARED
#define Tcl_SetReturnOptions_TCL_DECLARED
/* 538 */
EXTERN int		Tcl_SetReturnOptions(Tcl_Interp *interp,
				Tcl_Obj *options);
#endif
#ifndef Tcl_GetReturnOptions_TCL_DECLARED
#define Tcl_GetReturnOptions_TCL_DECLARED
/* 539 */
EXTERN Tcl_Obj *	Tcl_GetReturnOptions(Tcl_Interp *interp, int result);
#endif
#ifndef Tcl_IsEnsemble_TCL_DECLARED
#define Tcl_IsEnsemble_TCL_DECLARED
/* 540 */
EXTERN int		Tcl_IsEnsemble(Tcl_Command token);
#endif
#ifndef Tcl_CreateEnsemble_TCL_DECLARED
#define Tcl_CreateEnsemble_TCL_DECLARED
/* 541 */
EXTERN Tcl_Command	Tcl_CreateEnsemble(Tcl_Interp *interp,
				CONST char *name,
				Tcl_Namespace *namespacePtr, int flags);
#endif
#ifndef Tcl_FindEnsemble_TCL_DECLARED
#define Tcl_FindEnsemble_TCL_DECLARED
/* 542 */
EXTERN Tcl_Command	Tcl_FindEnsemble(Tcl_Interp *interp,
				Tcl_Obj *cmdNameObj, int flags);
#endif
#ifndef Tcl_SetEnsembleSubcommandList_TCL_DECLARED
#define Tcl_SetEnsembleSubcommandList_TCL_DECLARED
/* 543 */
EXTERN int		Tcl_SetEnsembleSubcommandList(Tcl_Interp *interp,
				Tcl_Command token, Tcl_Obj *subcmdList);
#endif
#ifndef Tcl_SetEnsembleMappingDict_TCL_DECLARED
#define Tcl_SetEnsembleMappingDict_TCL_DECLARED
/* 544 */
EXTERN int		Tcl_SetEnsembleMappingDict(Tcl_Interp *interp,
				Tcl_Command token, Tcl_Obj *mapDict);
#endif
#ifndef Tcl_SetEnsembleUnknownHandler_TCL_DECLARED
#define Tcl_SetEnsembleUnknownHandler_TCL_DECLARED
/* 545 */
EXTERN int		Tcl_SetEnsembleUnknownHandler(Tcl_Interp *interp,
				Tcl_Command token, Tcl_Obj *unknownList);
#endif
#ifndef Tcl_SetEnsembleFlags_TCL_DECLARED
#define Tcl_SetEnsembleFlags_TCL_DECLARED
/* 546 */
EXTERN int		Tcl_SetEnsembleFlags(Tcl_Interp *interp,
				Tcl_Command token, int flags);
#endif
#ifndef Tcl_GetEnsembleSubcommandList_TCL_DECLARED
#define Tcl_GetEnsembleSubcommandList_TCL_DECLARED
/* 547 */
EXTERN int		Tcl_GetEnsembleSubcommandList(Tcl_Interp *interp,
				Tcl_Command token, Tcl_Obj **subcmdListPtr);
#endif
#ifndef Tcl_GetEnsembleMappingDict_TCL_DECLARED
#define Tcl_GetEnsembleMappingDict_TCL_DECLARED
/* 548 */
EXTERN int		Tcl_GetEnsembleMappingDict(Tcl_Interp *interp,
				Tcl_Command token, Tcl_Obj **mapDictPtr);
#endif
#ifndef Tcl_GetEnsembleUnknownHandler_TCL_DECLARED
#define Tcl_GetEnsembleUnknownHandler_TCL_DECLARED
/* 549 */
EXTERN int		Tcl_GetEnsembleUnknownHandler(Tcl_Interp *interp,
				Tcl_Command token, Tcl_Obj **unknownListPtr);
#endif
#ifndef Tcl_GetEnsembleFlags_TCL_DECLARED
#define Tcl_GetEnsembleFlags_TCL_DECLARED
/* 550 */
EXTERN int		Tcl_GetEnsembleFlags(Tcl_Interp *interp,
				Tcl_Command token, int *flagsPtr);
#endif
#ifndef Tcl_GetEnsembleNamespace_TCL_DECLARED
#define Tcl_GetEnsembleNamespace_TCL_DECLARED
/* 551 */
EXTERN int		Tcl_GetEnsembleNamespace(Tcl_Interp *interp,
				Tcl_Command token,
				Tcl_Namespace **namespacePtrPtr);
#endif
#ifndef Tcl_SetTimeProc_TCL_DECLARED
#define Tcl_SetTimeProc_TCL_DECLARED
/* 552 */
EXTERN void		Tcl_SetTimeProc(Tcl_GetTimeProc *getProc,
				Tcl_ScaleTimeProc *scaleProc,
				ClientData clientData);
#endif
#ifndef Tcl_QueryTimeProc_TCL_DECLARED
#define Tcl_QueryTimeProc_TCL_DECLARED
/* 553 */
EXTERN void		Tcl_QueryTimeProc(Tcl_GetTimeProc **getProc,
				Tcl_ScaleTimeProc **scaleProc,
				ClientData *clientData);
#endif
#ifndef Tcl_ChannelThreadActionProc_TCL_DECLARED
#define Tcl_ChannelThreadActionProc_TCL_DECLARED
/* 554 */
EXTERN Tcl_DriverThreadActionProc * Tcl_ChannelThreadActionProc(
				CONST Tcl_ChannelType *chanTypePtr);
#endif
#ifndef Tcl_NewBignumObj_TCL_DECLARED
#define Tcl_NewBignumObj_TCL_DECLARED
/* 555 */
EXTERN Tcl_Obj *	Tcl_NewBignumObj(mp_int *value);
#endif
#ifndef Tcl_DbNewBignumObj_TCL_DECLARED
#define Tcl_DbNewBignumObj_TCL_DECLARED
/* 556 */
EXTERN Tcl_Obj *	Tcl_DbNewBignumObj(mp_int *value, CONST char *file,
				int line);
#endif
#ifndef Tcl_SetBignumObj_TCL_DECLARED
#define Tcl_SetBignumObj_TCL_DECLARED
/* 557 */
EXTERN void		Tcl_SetBignumObj(Tcl_Obj *obj, mp_int *value);
#endif
#ifndef Tcl_GetBignumFromObj_TCL_DECLARED
#define Tcl_GetBignumFromObj_TCL_DECLARED
/* 558 */
EXTERN int		Tcl_GetBignumFromObj(Tcl_Interp *interp,
				Tcl_Obj *obj, mp_int *value);
#endif
#ifndef Tcl_TakeBignumFromObj_TCL_DECLARED
#define Tcl_TakeBignumFromObj_TCL_DECLARED
/* 559 */
EXTERN int		Tcl_TakeBignumFromObj(Tcl_Interp *interp,
				Tcl_Obj *obj, mp_int *value);
#endif
#ifndef Tcl_TruncateChannel_TCL_DECLARED
#define Tcl_TruncateChannel_TCL_DECLARED
/* 560 */
EXTERN int		Tcl_TruncateChannel(Tcl_Channel chan,
				Tcl_WideInt length);
#endif
#ifndef Tcl_ChannelTruncateProc_TCL_DECLARED
#define Tcl_ChannelTruncateProc_TCL_DECLARED
/* 561 */
EXTERN Tcl_DriverTruncateProc * Tcl_ChannelTruncateProc(
				CONST Tcl_ChannelType *chanTypePtr);
#endif
#ifndef Tcl_SetChannelErrorInterp_TCL_DECLARED
#define Tcl_SetChannelErrorInterp_TCL_DECLARED
/* 562 */
EXTERN void		Tcl_SetChannelErrorInterp(Tcl_Interp *interp,
				Tcl_Obj *msg);
#endif
#ifndef Tcl_GetChannelErrorInterp_TCL_DECLARED
#define Tcl_GetChannelErrorInterp_TCL_DECLARED
/* 563 */
EXTERN void		Tcl_GetChannelErrorInterp(Tcl_Interp *interp,
				Tcl_Obj **msg);
#endif
#ifndef Tcl_SetChannelError_TCL_DECLARED
#define Tcl_SetChannelError_TCL_DECLARED
/* 564 */
EXTERN void		Tcl_SetChannelError(Tcl_Channel chan, Tcl_Obj *msg);
#endif
#ifndef Tcl_GetChannelError_TCL_DECLARED
#define Tcl_GetChannelError_TCL_DECLARED
/* 565 */
EXTERN void		Tcl_GetChannelError(Tcl_Channel chan, Tcl_Obj **msg);
#endif
#ifndef Tcl_InitBignumFromDouble_TCL_DECLARED
#define Tcl_InitBignumFromDouble_TCL_DECLARED
/* 566 */
EXTERN int		Tcl_InitBignumFromDouble(Tcl_Interp *interp,
				double initval, mp_int *toInit);
#endif
#ifndef Tcl_GetNamespaceUnknownHandler_TCL_DECLARED
#define Tcl_GetNamespaceUnknownHandler_TCL_DECLARED
/* 567 */
EXTERN Tcl_Obj *	Tcl_GetNamespaceUnknownHandler(Tcl_Interp *interp,
				Tcl_Namespace *nsPtr);
#endif
#ifndef Tcl_SetNamespaceUnknownHandler_TCL_DECLARED
#define Tcl_SetNamespaceUnknownHandler_TCL_DECLARED
/* 568 */
EXTERN int		Tcl_SetNamespaceUnknownHandler(Tcl_Interp *interp,
				Tcl_Namespace *nsPtr, Tcl_Obj *handlerPtr);
#endif
#ifndef Tcl_GetEncodingFromObj_TCL_DECLARED
#define Tcl_GetEncodingFromObj_TCL_DECLARED
/* 569 */
EXTERN int		Tcl_GetEncodingFromObj(Tcl_Interp *interp,
				Tcl_Obj *objPtr, Tcl_Encoding *encodingPtr);
#endif
#ifndef Tcl_GetEncodingSearchPath_TCL_DECLARED
#define Tcl_GetEncodingSearchPath_TCL_DECLARED
/* 570 */
EXTERN Tcl_Obj *	Tcl_GetEncodingSearchPath(void);
#endif
#ifndef Tcl_SetEncodingSearchPath_TCL_DECLARED
#define Tcl_SetEncodingSearchPath_TCL_DECLARED
/* 571 */
EXTERN int		Tcl_SetEncodingSearchPath(Tcl_Obj *searchPath);
#endif
#ifndef Tcl_GetEncodingNameFromEnvironment_TCL_DECLARED
#define Tcl_GetEncodingNameFromEnvironment_TCL_DECLARED
/* 572 */
EXTERN CONST char *	Tcl_GetEncodingNameFromEnvironment(
				Tcl_DString *bufPtr);
#endif
#ifndef Tcl_PkgRequireProc_TCL_DECLARED
#define Tcl_PkgRequireProc_TCL_DECLARED
/* 573 */
EXTERN int		Tcl_PkgRequireProc(Tcl_Interp *interp,
				CONST char *name, int objc,
				Tcl_Obj *CONST objv[],
				ClientData *clientDataPtr);
#endif
#ifndef Tcl_AppendObjToErrorInfo_TCL_DECLARED
#define Tcl_AppendObjToErrorInfo_TCL_DECLARED
/* 574 */
EXTERN void		Tcl_AppendObjToErrorInfo(Tcl_Interp *interp,
				Tcl_Obj *objPtr);
#endif
#ifndef Tcl_AppendLimitedToObj_TCL_DECLARED
#define Tcl_AppendLimitedToObj_TCL_DECLARED
/* 575 */
EXTERN void		Tcl_AppendLimitedToObj(Tcl_Obj *objPtr,
				CONST char *bytes, int length, int limit,
				CONST char *ellipsis);
#endif
#ifndef Tcl_Format_TCL_DECLARED
#define Tcl_Format_TCL_DECLARED
/* 576 */
EXTERN Tcl_Obj *	Tcl_Format(Tcl_Interp *interp, CONST char *format,
				int objc, Tcl_Obj *CONST objv[]);
#endif
#ifndef Tcl_AppendFormatToObj_TCL_DECLARED
#define Tcl_AppendFormatToObj_TCL_DECLARED
/* 577 */
EXTERN int		Tcl_AppendFormatToObj(Tcl_Interp *interp,
				Tcl_Obj *objPtr, CONST char *format,
				int objc, Tcl_Obj *CONST objv[]);
#endif
#ifndef Tcl_ObjPrintf_TCL_DECLARED
#define Tcl_ObjPrintf_TCL_DECLARED
/* 578 */
EXTERN Tcl_Obj *	Tcl_ObjPrintf(CONST char *format, ...);
#endif
#ifndef Tcl_AppendPrintfToObj_TCL_DECLARED
#define Tcl_AppendPrintfToObj_TCL_DECLARED
/* 579 */
EXTERN void		Tcl_AppendPrintfToObj(Tcl_Obj *objPtr,
				CONST char *format, ...);
#endif
/* Slot 580 is reserved */
/* Slot 581 is reserved */
/* Slot 582 is reserved */
/* Slot 583 is reserved */
/* Slot 584 is reserved */
/* Slot 585 is reserved */
/* Slot 586 is reserved */
/* Slot 587 is reserved */
/* Slot 588 is reserved */
/* Slot 589 is reserved */
/* Slot 590 is reserved */
/* Slot 591 is reserved */
/* Slot 592 is reserved */
/* Slot 593 is reserved */
/* Slot 594 is reserved */
/* Slot 595 is reserved */
/* Slot 596 is reserved */
/* Slot 597 is reserved */
/* Slot 598 is reserved */
/* Slot 599 is reserved */
/* Slot 600 is reserved */
/* Slot 601 is reserved */
/* Slot 602 is reserved */
/* Slot 603 is reserved */
/* Slot 604 is reserved */
/* Slot 605 is reserved */
/* Slot 606 is reserved */
/* Slot 607 is reserved */
/* Slot 608 is reserved */
/* Slot 609 is reserved */
/* Slot 610 is reserved */
/* Slot 611 is reserved */
/* Slot 612 is reserved */
/* Slot 613 is reserved */
/* Slot 614 is reserved */
/* Slot 615 is reserved */
/* Slot 616 is reserved */
/* Slot 617 is reserved */
/* Slot 618 is reserved */
/* Slot 619 is reserved */
/* Slot 620 is reserved */
/* Slot 621 is reserved */
/* Slot 622 is reserved */
/* Slot 623 is reserved */
/* Slot 624 is reserved */
/* Slot 625 is reserved */
/* Slot 626 is reserved */
/* Slot 627 is reserved */
/* Slot 628 is reserved */
/* Slot 629 is reserved */
#ifndef TclUnusedStubEntry_TCL_DECLARED
#define TclUnusedStubEntry_TCL_DECLARED
/* 630 */
EXTERN void		TclUnusedStubEntry(void);
#endif

typedef struct TclStubHooks {
    struct TclPlatStubs *tclPlatStubs;
    struct TclIntStubs *tclIntStubs;
    struct TclIntPlatStubs *tclIntPlatStubs;
} TclStubHooks;

typedef struct TclStubs {
    int magic;
    struct TclStubHooks *hooks;

    int (*tcl_PkgProvideEx) (Tcl_Interp *interp, CONST char *name, CONST char *version, ClientData clientData); /* 0 */
    CONST84_RETURN char * (*tcl_PkgRequireEx) (Tcl_Interp *interp, CONST char *name, CONST char *version, int exact, ClientData *clientDataPtr); /* 1 */
    void (*tcl_Panic) (CONST char *format, ...); /* 2 */
    char * (*tcl_Alloc) (unsigned int size); /* 3 */
    void (*tcl_Free) (char *ptr); /* 4 */
    char * (*tcl_Realloc) (char *ptr, unsigned int size); /* 5 */
    char * (*tcl_DbCkalloc) (unsigned int size, CONST char *file, int line); /* 6 */
    void (*tcl_DbCkfree) (char *ptr, CONST char *file, int line); /* 7 */
    char * (*tcl_DbCkrealloc) (char *ptr, unsigned int size, CONST char *file, int line); /* 8 */
#if !defined(__WIN32__) && !defined(MAC_OSX_TCL) /* UNIX */
    void (*tcl_CreateFileHandler) (int fd, int mask, Tcl_FileProc *proc, ClientData clientData); /* 9 */
#endif /* UNIX */
#if defined(__WIN32__) /* WIN */
    VOID *reserved9;
#endif /* WIN */
#ifdef MAC_OSX_TCL /* MACOSX */
    void (*tcl_CreateFileHandler) (int fd, int mask, Tcl_FileProc *proc, ClientData clientData); /* 9 */
#endif /* MACOSX */
#if !defined(__WIN32__) && !defined(MAC_OSX_TCL) /* UNIX */
    void (*tcl_DeleteFileHandler) (int fd); /* 10 */
#endif /* UNIX */
#if defined(__WIN32__) /* WIN */
    VOID *reserved10;
#endif /* WIN */
#ifdef MAC_OSX_TCL /* MACOSX */
    void (*tcl_DeleteFileHandler) (int fd); /* 10 */
#endif /* MACOSX */
    void (*tcl_SetTimer) (Tcl_Time *timePtr); /* 11 */
    void (*tcl_Sleep) (int ms); /* 12 */
    int (*tcl_WaitForEvent) (Tcl_Time *timePtr); /* 13 */
    int (*tcl_AppendAllObjTypes) (Tcl_Interp *interp, Tcl_Obj *objPtr); /* 14 */
    void (*tcl_AppendStringsToObj) (Tcl_Obj *objPtr, ...); /* 15 */
    void (*tcl_AppendToObj) (Tcl_Obj *objPtr, CONST char *bytes, int length); /* 16 */
    Tcl_Obj * (*tcl_ConcatObj) (int objc, Tcl_Obj *CONST objv[]); /* 17 */
    int (*tcl_ConvertToType) (Tcl_Interp *interp, Tcl_Obj *objPtr, Tcl_ObjType *typePtr); /* 18 */
    void (*tcl_DbDecrRefCount) (Tcl_Obj *objPtr, CONST char *file, int line); /* 19 */
    void (*tcl_DbIncrRefCount) (Tcl_Obj *objPtr, CONST char *file, int line); /* 20 */
    int (*tcl_DbIsShared) (Tcl_Obj *objPtr, CONST char *file, int line); /* 21 */
    Tcl_Obj * (*tcl_DbNewBooleanObj) (int boolValue, CONST char *file, int line); /* 22 */
    Tcl_Obj * (*tcl_DbNewByteArrayObj) (CONST unsigned char *bytes, int length, CONST char *file, int line); /* 23 */
    Tcl_Obj * (*tcl_DbNewDoubleObj) (double doubleValue, CONST char *file, int line); /* 24 */
    Tcl_Obj * (*tcl_DbNewListObj) (int objc, Tcl_Obj *CONST *objv, CONST char *file, int line); /* 25 */
    Tcl_Obj * (*tcl_DbNewLongObj) (long longValue, CONST char *file, int line); /* 26 */
    Tcl_Obj * (*tcl_DbNewObj) (CONST char *file, int line); /* 27 */
    Tcl_Obj * (*tcl_DbNewStringObj) (CONST char *bytes, int length, CONST char *file, int line); /* 28 */
    Tcl_Obj * (*tcl_DuplicateObj) (Tcl_Obj *objPtr); /* 29 */
    void (*tclFreeObj) (Tcl_Obj *objPtr); /* 30 */
    int (*tcl_GetBoolean) (Tcl_Interp *interp, CONST char *src, int *boolPtr); /* 31 */
    int (*tcl_GetBooleanFromObj) (Tcl_Interp *interp, Tcl_Obj *objPtr, int *boolPtr); /* 32 */
    unsigned char * (*tcl_GetByteArrayFromObj) (Tcl_Obj *objPtr, int *lengthPtr); /* 33 */
    int (*tcl_GetDouble) (Tcl_Interp *interp, CONST char *src, double *doublePtr); /* 34 */
    int (*tcl_GetDoubleFromObj) (Tcl_Interp *interp, Tcl_Obj *objPtr, double *doublePtr); /* 35 */
    int (*tcl_GetIndexFromObj) (Tcl_Interp *interp, Tcl_Obj *objPtr, CONST84 char **tablePtr, CONST char *msg, int flags, int *indexPtr); /* 36 */
    int (*tcl_GetInt) (Tcl_Interp *interp, CONST char *src, int *intPtr); /* 37 */
    int (*tcl_GetIntFromObj) (Tcl_Interp *interp, Tcl_Obj *objPtr, int *intPtr); /* 38 */
    int (*tcl_GetLongFromObj) (Tcl_Interp *interp, Tcl_Obj *objPtr, long *longPtr); /* 39 */
    Tcl_ObjType * (*tcl_GetObjType) (CONST char *typeName); /* 40 */
    char * (*tcl_GetStringFromObj) (Tcl_Obj *objPtr, int *lengthPtr); /* 41 */
    void (*tcl_InvalidateStringRep) (Tcl_Obj *objPtr); /* 42 */
    int (*tcl_ListObjAppendList) (Tcl_Interp *interp, Tcl_Obj *listPtr, Tcl_Obj *elemListPtr); /* 43 */
    int (*tcl_ListObjAppendElement) (Tcl_Interp *interp, Tcl_Obj *listPtr, Tcl_Obj *objPtr); /* 44 */
    int (*tcl_ListObjGetElements) (Tcl_Interp *interp, Tcl_Obj *listPtr, int *objcPtr, Tcl_Obj ***objvPtr); /* 45 */
    int (*tcl_ListObjIndex) (Tcl_Interp *interp, Tcl_Obj *listPtr, int index, Tcl_Obj **objPtrPtr); /* 46 */
    int (*tcl_ListObjLength) (Tcl_Interp *interp, Tcl_Obj *listPtr, int *lengthPtr); /* 47 */
    int (*tcl_ListObjReplace) (Tcl_Interp *interp, Tcl_Obj *listPtr, int first, int count, int objc, Tcl_Obj *CONST objv[]); /* 48 */
    Tcl_Obj * (*tcl_NewBooleanObj) (int boolValue); /* 49 */
    Tcl_Obj * (*tcl_NewByteArrayObj) (CONST unsigned char *bytes, int length); /* 50 */
    Tcl_Obj * (*tcl_NewDoubleObj) (double doubleValue); /* 51 */
    Tcl_Obj * (*tcl_NewIntObj) (int intValue); /* 52 */
    Tcl_Obj * (*tcl_NewListObj) (int objc, Tcl_Obj *CONST objv[]); /* 53 */
    Tcl_Obj * (*tcl_NewLongObj) (long longValue); /* 54 */
    Tcl_Obj * (*tcl_NewObj) (void); /* 55 */
    Tcl_Obj * (*tcl_NewStringObj) (CONST char *bytes, int length); /* 56 */
    void (*tcl_SetBooleanObj) (Tcl_Obj *objPtr, int boolValue); /* 57 */
    unsigned char * (*tcl_SetByteArrayLength) (Tcl_Obj *objPtr, int length); /* 58 */
    void (*tcl_SetByteArrayObj) (Tcl_Obj *objPtr, CONST unsigned char *bytes, int length); /* 59 */
    void (*tcl_SetDoubleObj) (Tcl_Obj *objPtr, double doubleValue); /* 60 */
    void (*tcl_SetIntObj) (Tcl_Obj *objPtr, int intValue); /* 61 */
    void (*tcl_SetListObj) (Tcl_Obj *objPtr, int objc, Tcl_Obj *CONST objv[]); /* 62 */
    void (*tcl_SetLongObj) (Tcl_Obj *objPtr, long longValue); /* 63 */
    void (*tcl_SetObjLength) (Tcl_Obj *objPtr, int length); /* 64 */
    void (*tcl_SetStringObj) (Tcl_Obj *objPtr, CONST char *bytes, int length); /* 65 */
    void (*tcl_AddErrorInfo) (Tcl_Interp *interp, CONST char *message); /* 66 */
    void (*tcl_AddObjErrorInfo) (Tcl_Interp *interp, CONST char *message, int length); /* 67 */
    void (*tcl_AllowExceptions) (Tcl_Interp *interp); /* 68 */
    void (*tcl_AppendElement) (Tcl_Interp *interp, CONST char *element); /* 69 */
    void (*tcl_AppendResult) (Tcl_Interp *interp, ...); /* 70 */
    Tcl_AsyncHandler (*tcl_AsyncCreate) (Tcl_AsyncProc *proc, ClientData clientData); /* 71 */
    void (*tcl_AsyncDelete) (Tcl_AsyncHandler async); /* 72 */
    int (*tcl_AsyncInvoke) (Tcl_Interp *interp, int code); /* 73 */
    void (*tcl_AsyncMark) (Tcl_AsyncHandler async); /* 74 */
    int (*tcl_AsyncReady) (void); /* 75 */
    void (*tcl_BackgroundError) (Tcl_Interp *interp); /* 76 */
    char (*tcl_Backslash) (CONST char *src, int *readPtr); /* 77 */
    int (*tcl_BadChannelOption) (Tcl_Interp *interp, CONST char *optionName, CONST char *optionList); /* 78 */
    void (*tcl_CallWhenDeleted) (Tcl_Interp *interp, Tcl_InterpDeleteProc *proc, ClientData clientData); /* 79 */
    void (*tcl_CancelIdleCall) (Tcl_IdleProc *idleProc, ClientData clientData); /* 80 */
    int (*tcl_Close) (Tcl_Interp *interp, Tcl_Channel chan); /* 81 */
    int (*tcl_CommandComplete) (CONST char *cmd); /* 82 */
    char * (*tcl_Concat) (int argc, CONST84 char *CONST *argv); /* 83 */
    int (*tcl_ConvertElement) (CONST char *src, char *dst, int flags); /* 84 */
    int (*tcl_ConvertCountedElement) (CONST char *src, int length, char *dst, int flags); /* 85 */
    int (*tcl_CreateAlias) (Tcl_Interp *slave, CONST char *slaveCmd, Tcl_Interp *target, CONST char *targetCmd, int argc, CONST84 char *CONST *argv); /* 86 */
    int (*tcl_CreateAliasObj) (Tcl_Interp *slave, CONST char *slaveCmd, Tcl_Interp *target, CONST char *targetCmd, int objc, Tcl_Obj *CONST objv[]); /* 87 */
    Tcl_Channel (*tcl_CreateChannel) (Tcl_ChannelType *typePtr, CONST char *chanName, ClientData instanceData, int mask); /* 88 */
    void (*tcl_CreateChannelHandler) (Tcl_Channel chan, int mask, Tcl_ChannelProc *proc, ClientData clientData); /* 89 */
    void (*tcl_CreateCloseHandler) (Tcl_Channel chan, Tcl_CloseProc *proc, ClientData clientData); /* 90 */
    Tcl_Command (*tcl_CreateCommand) (Tcl_Interp *interp, CONST char *cmdName, Tcl_CmdProc *proc, ClientData clientData, Tcl_CmdDeleteProc *deleteProc); /* 91 */
    void (*tcl_CreateEventSource) (Tcl_EventSetupProc *setupProc, Tcl_EventCheckProc *checkProc, ClientData clientData); /* 92 */
    void (*tcl_CreateExitHandler) (Tcl_ExitProc *proc, ClientData clientData); /* 93 */
    Tcl_Interp * (*tcl_CreateInterp) (void); /* 94 */
    void (*tcl_CreateMathFunc) (Tcl_Interp *interp, CONST char *name, int numArgs, Tcl_ValueType *argTypes, Tcl_MathProc *proc, ClientData clientData); /* 95 */
    Tcl_Command (*tcl_CreateObjCommand) (Tcl_Interp *interp, CONST char *cmdName, Tcl_ObjCmdProc *proc, ClientData clientData, Tcl_CmdDeleteProc *deleteProc); /* 96 */
    Tcl_Interp * (*tcl_CreateSlave) (Tcl_Interp *interp, CONST char *slaveName, int isSafe); /* 97 */
    Tcl_TimerToken (*tcl_CreateTimerHandler) (int milliseconds, Tcl_TimerProc *proc, ClientData clientData); /* 98 */
    Tcl_Trace (*tcl_CreateTrace) (Tcl_Interp *interp, int level, Tcl_CmdTraceProc *proc, ClientData clientData); /* 99 */
    void (*tcl_DeleteAssocData) (Tcl_Interp *interp, CONST char *name); /* 100 */
    void (*tcl_DeleteChannelHandler) (Tcl_Channel chan, Tcl_ChannelProc *proc, ClientData clientData); /* 101 */
    void (*tcl_DeleteCloseHandler) (Tcl_Channel chan, Tcl_CloseProc *proc, ClientData clientData); /* 102 */
    int (*tcl_DeleteCommand) (Tcl_Interp *interp, CONST char *cmdName); /* 103 */
    int (*tcl_DeleteCommandFromToken) (Tcl_Interp *interp, Tcl_Command command); /* 104 */
    void (*tcl_DeleteEvents) (Tcl_EventDeleteProc *proc, ClientData clientData); /* 105 */
    void (*tcl_DeleteEventSource) (Tcl_EventSetupProc *setupProc, Tcl_EventCheckProc *checkProc, ClientData clientData); /* 106 */
    void (*tcl_DeleteExitHandler) (Tcl_ExitProc *proc, ClientData clientData); /* 107 */
    void (*tcl_DeleteHashEntry) (Tcl_HashEntry *entryPtr); /* 108 */
    void (*tcl_DeleteHashTable) (Tcl_HashTable *tablePtr); /* 109 */
    void (*tcl_DeleteInterp) (Tcl_Interp *interp); /* 110 */
    void (*tcl_DetachPids) (int numPids, Tcl_Pid *pidPtr); /* 111 */
    void (*tcl_DeleteTimerHandler) (Tcl_TimerToken token); /* 112 */
    void (*tcl_DeleteTrace) (Tcl_Interp *interp, Tcl_Trace trace); /* 113 */
    void (*tcl_DontCallWhenDeleted) (Tcl_Interp *interp, Tcl_InterpDeleteProc *proc, ClientData clientData); /* 114 */
    int (*tcl_DoOneEvent) (int flags); /* 115 */
    void (*tcl_DoWhenIdle) (Tcl_IdleProc *proc, ClientData clientData); /* 116 */
    char * (*tcl_DStringAppend) (Tcl_DString *dsPtr, CONST char *bytes, int length); /* 117 */
    char * (*tcl_DStringAppendElement) (Tcl_DString *dsPtr, CONST char *element); /* 118 */
    void (*tcl_DStringEndSublist) (Tcl_DString *dsPtr); /* 119 */
    void (*tcl_DStringFree) (Tcl_DString *dsPtr); /* 120 */
    void (*tcl_DStringGetResult) (Tcl_Interp *interp, Tcl_DString *dsPtr); /* 121 */
    void (*tcl_DStringInit) (Tcl_DString *dsPtr); /* 122 */
    void (*tcl_DStringResult) (Tcl_Interp *interp, Tcl_DString *dsPtr); /* 123 */
    void (*tcl_DStringSetLength) (Tcl_DString *dsPtr, int length); /* 124 */
    void (*tcl_DStringStartSublist) (Tcl_DString *dsPtr); /* 125 */
    int (*tcl_Eof) (Tcl_Channel chan); /* 126 */
    CONST84_RETURN char * (*tcl_ErrnoId) (void); /* 127 */
    CONST84_RETURN char * (*tcl_ErrnoMsg) (int err); /* 128 */
    int (*tcl_Eval) (Tcl_Interp *interp, CONST char *script); /* 129 */
    int (*tcl_EvalFile) (Tcl_Interp *interp, CONST char *fileName); /* 130 */
    int (*tcl_EvalObj) (Tcl_Interp *interp, Tcl_Obj *objPtr); /* 131 */
    void (*tcl_EventuallyFree) (ClientData clientData, Tcl_FreeProc *freeProc); /* 132 */
    void (*tcl_Exit) (int status); /* 133 */
    int (*tcl_ExposeCommand) (Tcl_Interp *interp, CONST char *hiddenCmdToken, CONST char *cmdName); /* 134 */
    int (*tcl_ExprBoolean) (Tcl_Interp *interp, CONST char *expr, int *ptr); /* 135 */
    int (*tcl_ExprBooleanObj) (Tcl_Interp *interp, Tcl_Obj *objPtr, int *ptr); /* 136 */
    int (*tcl_ExprDouble) (Tcl_Interp *interp, CONST char *expr, double *ptr); /* 137 */
    int (*tcl_ExprDoubleObj) (Tcl_Interp *interp, Tcl_Obj *objPtr, double *ptr); /* 138 */
    int (*tcl_ExprLong) (Tcl_Interp *interp, CONST char *expr, long *ptr); /* 139 */
    int (*tcl_ExprLongObj) (Tcl_Interp *interp, Tcl_Obj *objPtr, long *ptr); /* 140 */
    int (*tcl_ExprObj) (Tcl_Interp *interp, Tcl_Obj *objPtr, Tcl_Obj **resultPtrPtr); /* 141 */
    int (*tcl_ExprString) (Tcl_Interp *interp, CONST char *expr); /* 142 */
    void (*tcl_Finalize) (void); /* 143 */
    void (*tcl_FindExecutable) (CONST char *argv0); /* 144 */
    Tcl_HashEntry * (*tcl_FirstHashEntry) (Tcl_HashTable *tablePtr, Tcl_HashSearch *searchPtr); /* 145 */
    int (*tcl_Flush) (Tcl_Channel chan); /* 146 */
    void (*tcl_FreeResult) (Tcl_Interp *interp); /* 147 */
    int (*tcl_GetAlias) (Tcl_Interp *interp, CONST char *slaveCmd, Tcl_Interp **targetInterpPtr, CONST84 char **targetCmdPtr, int *argcPtr, CONST84 char ***argvPtr); /* 148 */
    int (*tcl_GetAliasObj) (Tcl_Interp *interp, CONST char *slaveCmd, Tcl_Interp **targetInterpPtr, CONST84 char **targetCmdPtr, int *objcPtr, Tcl_Obj ***objv); /* 149 */
    ClientData (*tcl_GetAssocData) (Tcl_Interp *interp, CONST char *name, Tcl_InterpDeleteProc **procPtr); /* 150 */
    Tcl_Channel (*tcl_GetChannel) (Tcl_Interp *interp, CONST char *chanName, int *modePtr); /* 151 */
    int (*tcl_GetChannelBufferSize) (Tcl_Channel chan); /* 152 */
    int (*tcl_GetChannelHandle) (Tcl_Channel chan, int direction, ClientData *handlePtr); /* 153 */
    ClientData (*tcl_GetChannelInstanceData) (Tcl_Channel chan); /* 154 */
    int (*tcl_GetChannelMode) (Tcl_Channel chan); /* 155 */
    CONST84_RETURN char * (*tcl_GetChannelName) (Tcl_Channel chan); /* 156 */
    int (*tcl_GetChannelOption) (Tcl_Interp *interp, Tcl_Channel chan, CONST char *optionName, Tcl_DString *dsPtr); /* 157 */
    Tcl_ChannelType * (*tcl_GetChannelType) (Tcl_Channel chan); /* 158 */
    int (*tcl_GetCommandInfo) (Tcl_Interp *interp, CONST char *cmdName, Tcl_CmdInfo *infoPtr); /* 159 */
    CONST84_RETURN char * (*tcl_GetCommandName) (Tcl_Interp *interp, Tcl_Command command); /* 160 */
    int (*tcl_GetErrno) (void); /* 161 */
    CONST84_RETURN char * (*tcl_GetHostName) (void); /* 162 */
    int (*tcl_GetInterpPath) (Tcl_Interp *askInterp, Tcl_Interp *slaveInterp); /* 163 */
    Tcl_Interp * (*tcl_GetMaster) (Tcl_Interp *interp); /* 164 */
    CONST char * (*tcl_GetNameOfExecutable) (void); /* 165 */
    Tcl_Obj * (*tcl_GetObjResult) (Tcl_Interp *interp); /* 166 */
#if !defined(__WIN32__) && !defined(MAC_OSX_TCL) /* UNIX */
    int (*tcl_GetOpenFile) (Tcl_Interp *interp, CONST char *chanID, int forWriting, int checkUsage, ClientData *filePtr); /* 167 */
#endif /* UNIX */
#if defined(__WIN32__) /* WIN */
    VOID *reserved167;
#endif /* WIN */
#ifdef MAC_OSX_TCL /* MACOSX */
    int (*tcl_GetOpenFile) (Tcl_Interp *interp, CONST char *chanID, int forWriting, int checkUsage, ClientData *filePtr); /* 167 */
#endif /* MACOSX */
    Tcl_PathType (*tcl_GetPathType) (CONST char *path); /* 168 */
    int (*tcl_Gets) (Tcl_Channel chan, Tcl_DString *dsPtr); /* 169 */
    int (*tcl_GetsObj) (Tcl_Channel chan, Tcl_Obj *objPtr); /* 170 */
    int (*tcl_GetServiceMode) (void); /* 171 */
    Tcl_Interp * (*tcl_GetSlave) (Tcl_Interp *interp, CONST char *slaveName); /* 172 */
    Tcl_Channel (*tcl_GetStdChannel) (int type); /* 173 */
    CONST84_RETURN char * (*tcl_GetStringResult) (Tcl_Interp *interp); /* 174 */
    CONST84_RETURN char * (*tcl_GetVar) (Tcl_Interp *interp, CONST char *varName, int flags); /* 175 */
    CONST84_RETURN char * (*tcl_GetVar2) (Tcl_Interp *interp, CONST char *part1, CONST char *part2, int flags); /* 176 */
    int (*tcl_GlobalEval) (Tcl_Interp *interp, CONST char *command); /* 177 */
    int (*tcl_GlobalEvalObj) (Tcl_Interp *interp, Tcl_Obj *objPtr); /* 178 */
    int (*tcl_HideCommand) (Tcl_Interp *interp, CONST char *cmdName, CONST char *hiddenCmdToken); /* 179 */
    int (*tcl_Init) (Tcl_Interp *interp); /* 180 */
    void (*tcl_InitHashTable) (Tcl_HashTable *tablePtr, int keyType); /* 181 */
    int (*tcl_InputBlocked) (Tcl_Channel chan); /* 182 */
    int (*tcl_InputBuffered) (Tcl_Channel chan); /* 183 */
    int (*tcl_InterpDeleted) (Tcl_Interp *interp); /* 184 */
    int (*tcl_IsSafe) (Tcl_Interp *interp); /* 185 */
    char * (*tcl_JoinPath) (int argc, CONST84 char *CONST *argv, Tcl_DString *resultPtr); /* 186 */
    int (*tcl_LinkVar) (Tcl_Interp *interp, CONST char *varName, char *addr, int type); /* 187 */
    VOID *reserved188;
    Tcl_Channel (*tcl_MakeFileChannel) (ClientData handle, int mode); /* 189 */
    int (*tcl_MakeSafe) (Tcl_Interp *interp); /* 190 */
    Tcl_Channel (*tcl_MakeTcpClientChannel) (ClientData tcpSocket); /* 191 */
    char * (*tcl_Merge) (int argc, CONST84 char *CONST *argv); /* 192 */
    Tcl_HashEntry * (*tcl_NextHashEntry) (Tcl_HashSearch *searchPtr); /* 193 */
    void (*tcl_NotifyChannel) (Tcl_Channel channel, int mask); /* 194 */
    Tcl_Obj * (*tcl_ObjGetVar2) (Tcl_Interp *interp, Tcl_Obj *part1Ptr, Tcl_Obj *part2Ptr, int flags); /* 195 */
    Tcl_Obj * (*tcl_ObjSetVar2) (Tcl_Interp *interp, Tcl_Obj *part1Ptr, Tcl_Obj *part2Ptr, Tcl_Obj *newValuePtr, int flags); /* 196 */
    Tcl_Channel (*tcl_OpenCommandChannel) (Tcl_Interp *interp, int argc, CONST84 char **argv, int flags); /* 197 */
    Tcl_Channel (*tcl_OpenFileChannel) (Tcl_Interp *interp, CONST char *fileName, CONST char *modeString, int permissions); /* 198 */
    Tcl_Channel (*tcl_OpenTcpClient) (Tcl_Interp *interp, int port, CONST char *address, CONST char *myaddr, int myport, int async); /* 199 */
    Tcl_Channel (*tcl_OpenTcpServer) (Tcl_Interp *interp, int port, CONST char *host, Tcl_TcpAcceptProc *acceptProc, ClientData callbackData); /* 200 */
    void (*tcl_Preserve) (ClientData data); /* 201 */
    void (*tcl_PrintDouble) (Tcl_Interp *interp, double value, char *dst); /* 202 */
    int (*tcl_PutEnv) (CONST char *assignment); /* 203 */
    CONST84_RETURN char * (*tcl_PosixError) (Tcl_Interp *interp); /* 204 */
    void (*tcl_QueueEvent) (Tcl_Event *evPtr, Tcl_QueuePosition position); /* 205 */
    int (*tcl_Read) (Tcl_Channel chan, char *bufPtr, int toRead); /* 206 */
    void (*tcl_ReapDetachedProcs) (void); /* 207 */
    int (*tcl_RecordAndEval) (Tcl_Interp *interp, CONST char *cmd, int flags); /* 208 */
    int (*tcl_RecordAndEvalObj) (Tcl_Interp *interp, Tcl_Obj *cmdPtr, int flags); /* 209 */
    void (*tcl_RegisterChannel) (Tcl_Interp *interp, Tcl_Channel chan); /* 210 */
    void (*tcl_RegisterObjType) (Tcl_ObjType *typePtr); /* 211 */
    Tcl_RegExp (*tcl_RegExpCompile) (Tcl_Interp *interp, CONST char *pattern); /* 212 */
    int (*tcl_RegExpExec) (Tcl_Interp *interp, Tcl_RegExp regexp, CONST char *text, CONST char *start); /* 213 */
    int (*tcl_RegExpMatch) (Tcl_Interp *interp, CONST char *text, CONST char *pattern); /* 214 */
    void (*tcl_RegExpRange) (Tcl_RegExp regexp, int index, CONST84 char **startPtr, CONST84 char **endPtr); /* 215 */
    void (*tcl_Release) (ClientData clientData); /* 216 */
    void (*tcl_ResetResult) (Tcl_Interp *interp); /* 217 */
    int (*tcl_ScanElement) (CONST char *src, int *flagPtr); /* 218 */
    int (*tcl_ScanCountedElement) (CONST char *src, int length, int *flagPtr); /* 219 */
    int (*tcl_SeekOld) (Tcl_Channel chan, int offset, int mode); /* 220 */
    int (*tcl_ServiceAll) (void); /* 221 */
    int (*tcl_ServiceEvent) (int flags); /* 222 */
    void (*tcl_SetAssocData) (Tcl_Interp *interp, CONST char *name, Tcl_InterpDeleteProc *proc, ClientData clientData); /* 223 */
    void (*tcl_SetChannelBufferSize) (Tcl_Channel chan, int sz); /* 224 */
    int (*tcl_SetChannelOption) (Tcl_Interp *interp, Tcl_Channel chan, CONST char *optionName, CONST char *newValue); /* 225 */
    int (*tcl_SetCommandInfo) (Tcl_Interp *interp, CONST char *cmdName, CONST Tcl_CmdInfo *infoPtr); /* 226 */
    void (*tcl_SetErrno) (int err); /* 227 */
    void (*tcl_SetErrorCode) (Tcl_Interp *interp, ...); /* 228 */
    void (*tcl_SetMaxBlockTime) (Tcl_Time *timePtr); /* 229 */
    void (*tcl_SetPanicProc) (Tcl_PanicProc *panicProc); /* 230 */
    int (*tcl_SetRecursionLimit) (Tcl_Interp *interp, int depth); /* 231 */
    void (*tcl_SetResult) (Tcl_Interp *interp, char *result, Tcl_FreeProc *freeProc); /* 232 */
    int (*tcl_SetServiceMode) (int mode); /* 233 */
    void (*tcl_SetObjErrorCode) (Tcl_Interp *interp, Tcl_Obj *errorObjPtr); /* 234 */
    void (*tcl_SetObjResult) (Tcl_Interp *interp, Tcl_Obj *resultObjPtr); /* 235 */
    void (*tcl_SetStdChannel) (Tcl_Channel channel, int type); /* 236 */
    CONST84_RETURN char * (*tcl_SetVar) (Tcl_Interp *interp, CONST char *varName, CONST char *newValue, int flags); /* 237 */
    CONST84_RETURN char * (*tcl_SetVar2) (Tcl_Interp *interp, CONST char *part1, CONST char *part2, CONST char *newValue, int flags); /* 238 */
    CONST84_RETURN char * (*tcl_SignalId) (int sig); /* 239 */
    CONST84_RETURN char * (*tcl_SignalMsg) (int sig); /* 240 */
    void (*tcl_SourceRCFile) (Tcl_Interp *interp); /* 241 */
    int (*tcl_SplitList) (Tcl_Interp *interp, CONST char *listStr, int *argcPtr, CONST84 char ***argvPtr); /* 242 */
    void (*tcl_SplitPath) (CONST char *path, int *argcPtr, CONST84 char ***argvPtr); /* 243 */
    void (*tcl_StaticPackage) (Tcl_Interp *interp, CONST char *pkgName, Tcl_PackageInitProc *initProc, Tcl_PackageInitProc *safeInitProc); /* 244 */
    int (*tcl_StringMatch) (CONST char *str, CONST char *pattern); /* 245 */
    int (*tcl_TellOld) (Tcl_Channel chan); /* 246 */
    int (*tcl_TraceVar) (Tcl_Interp *interp, CONST char *varName, int flags, Tcl_VarTraceProc *proc, ClientData clientData); /* 247 */
    int (*tcl_TraceVar2) (Tcl_Interp *interp, CONST char *part1, CONST char *part2, int flags, Tcl_VarTraceProc *proc, ClientData clientData); /* 248 */
    char * (*tcl_TranslateFileName) (Tcl_Interp *interp, CONST char *name, Tcl_DString *bufferPtr); /* 249 */
    int (*tcl_Ungets) (Tcl_Channel chan, CONST char *str, int len, int atHead); /* 250 */
    void (*tcl_UnlinkVar) (Tcl_Interp *interp, CONST char *varName); /* 251 */
    int (*tcl_UnregisterChannel) (Tcl_Interp *interp, Tcl_Channel chan); /* 252 */
    int (*tcl_UnsetVar) (Tcl_Interp *interp, CONST char *varName, int flags); /* 253 */
    int (*tcl_UnsetVar2) (Tcl_Interp *interp, CONST char *part1, CONST char *part2, int flags); /* 254 */
    void (*tcl_UntraceVar) (Tcl_Interp *interp, CONST char *varName, int flags, Tcl_VarTraceProc *proc, ClientData clientData); /* 255 */
    void (*tcl_UntraceVar2) (Tcl_Interp *interp, CONST char *part1, CONST char *part2, int flags, Tcl_VarTraceProc *proc, ClientData clientData); /* 256 */
    void (*tcl_UpdateLinkedVar) (Tcl_Interp *interp, CONST char *varName); /* 257 */
    int (*tcl_UpVar) (Tcl_Interp *interp, CONST char *frameName, CONST char *varName, CONST char *localName, int flags); /* 258 */
    int (*tcl_UpVar2) (Tcl_Interp *interp, CONST char *frameName, CONST char *part1, CONST char *part2, CONST char *localName, int flags); /* 259 */
    int (*tcl_VarEval) (Tcl_Interp *interp, ...); /* 260 */
    ClientData (*tcl_VarTraceInfo) (Tcl_Interp *interp, CONST char *varName, int flags, Tcl_VarTraceProc *procPtr, ClientData prevClientData); /* 261 */
    ClientData (*tcl_VarTraceInfo2) (Tcl_Interp *interp, CONST char *part1, CONST char *part2, int flags, Tcl_VarTraceProc *procPtr, ClientData prevClientData); /* 262 */
    int (*tcl_Write) (Tcl_Channel chan, CONST char *s, int slen); /* 263 */
    void (*tcl_WrongNumArgs) (Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[], CONST char *message); /* 264 */
    int (*tcl_DumpActiveMemory) (CONST char *fileName); /* 265 */
    void (*tcl_ValidateAllMemory) (CONST char *file, int line); /* 266 */
    void (*tcl_AppendResultVA) (Tcl_Interp *interp, va_list argList); /* 267 */
    void (*tcl_AppendStringsToObjVA) (Tcl_Obj *objPtr, va_list argList); /* 268 */
    char * (*tcl_HashStats) (Tcl_HashTable *tablePtr); /* 269 */
    CONST84_RETURN char * (*tcl_ParseVar) (Tcl_Interp *interp, CONST char *start, CONST84 char **termPtr); /* 270 */
    CONST84_RETURN char * (*tcl_PkgPresent) (Tcl_Interp *interp, CONST char *name, CONST char *version, int exact); /* 271 */
    CONST84_RETURN char * (*tcl_PkgPresentEx) (Tcl_Interp *interp, CONST char *name, CONST char *version, int exact, ClientData *clientDataPtr); /* 272 */
    int (*tcl_PkgProvide) (Tcl_Interp *interp, CONST char *name, CONST char *version); /* 273 */
    CONST84_RETURN char * (*tcl_PkgRequire) (Tcl_Interp *interp, CONST char *name, CONST char *version, int exact); /* 274 */
    void (*tcl_SetErrorCodeVA) (Tcl_Interp *interp, va_list argList); /* 275 */
    int (*tcl_VarEvalVA) (Tcl_Interp *interp, va_list argList); /* 276 */
    Tcl_Pid (*tcl_WaitPid) (Tcl_Pid pid, int *statPtr, int options); /* 277 */
    void (*tcl_PanicVA) (CONST char *format, va_list argList); /* 278 */
    void (*tcl_GetVersion) (int *major, int *minor, int *patchLevel, int *type); /* 279 */
    void (*tcl_InitMemory) (Tcl_Interp *interp); /* 280 */
    Tcl_Channel (*tcl_StackChannel) (Tcl_Interp *interp, Tcl_ChannelType *typePtr, ClientData instanceData, int mask, Tcl_Channel prevChan); /* 281 */
    int (*tcl_UnstackChannel) (Tcl_Interp *interp, Tcl_Channel chan); /* 282 */
    Tcl_Channel (*tcl_GetStackedChannel) (Tcl_Channel chan); /* 283 */
    void (*tcl_SetMainLoop) (Tcl_MainLoopProc *proc); /* 284 */
    VOID *reserved285;
    void (*tcl_AppendObjToObj) (Tcl_Obj *objPtr, Tcl_Obj *appendObjPtr); /* 286 */
    Tcl_Encoding (*tcl_CreateEncoding) (CONST Tcl_EncodingType *typePtr); /* 287 */
    void (*tcl_CreateThreadExitHandler) (Tcl_ExitProc *proc, ClientData clientData); /* 288 */
    void (*tcl_DeleteThreadExitHandler) (Tcl_ExitProc *proc, ClientData clientData); /* 289 */
    void (*tcl_DiscardResult) (Tcl_SavedResult *statePtr); /* 290 */
    int (*tcl_EvalEx) (Tcl_Interp *interp, CONST char *script, int numBytes, int flags); /* 291 */
    int (*tcl_EvalObjv) (Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[], int flags); /* 292 */
    int (*tcl_EvalObjEx) (Tcl_Interp *interp, Tcl_Obj *objPtr, int flags); /* 293 */
    void (*tcl_ExitThread) (int status); /* 294 */
    int (*tcl_ExternalToUtf) (Tcl_Interp *interp, Tcl_Encoding encoding, CONST char *src, int srcLen, int flags, Tcl_EncodingState *statePtr, char *dst, int dstLen, int *srcReadPtr, int *dstWrotePtr, int *dstCharsPtr); /* 295 */
    char * (*tcl_ExternalToUtfDString) (Tcl_Encoding encoding, CONST char *src, int srcLen, Tcl_DString *dsPtr); /* 296 */
    void (*tcl_FinalizeThread) (void); /* 297 */
    void (*tcl_FinalizeNotifier) (ClientData clientData); /* 298 */
    void (*tcl_FreeEncoding) (Tcl_Encoding encoding); /* 299 */
    Tcl_ThreadId (*tcl_GetCurrentThread) (void); /* 300 */
    Tcl_Encoding (*tcl_GetEncoding) (Tcl_Interp *interp, CONST char *name); /* 301 */
    CONST84_RETURN char * (*tcl_GetEncodingName) (Tcl_Encoding encoding); /* 302 */
    void (*tcl_GetEncodingNames) (Tcl_Interp *interp); /* 303 */
    int (*tcl_GetIndexFromObjStruct) (Tcl_Interp *interp, Tcl_Obj *objPtr, CONST VOID *tablePtr, int offset, CONST char *msg, int flags, int *indexPtr); /* 304 */
    VOID * (*tcl_GetThreadData) (Tcl_ThreadDataKey *keyPtr, int size); /* 305 */
    Tcl_Obj * (*tcl_GetVar2Ex) (Tcl_Interp *interp, CONST char *part1, CONST char *part2, int flags); /* 306 */
    ClientData (*tcl_InitNotifier) (void); /* 307 */
    void (*tcl_MutexLock) (Tcl_Mutex *mutexPtr); /* 308 */
    void (*tcl_MutexUnlock) (Tcl_Mutex *mutexPtr); /* 309 */
    void (*tcl_ConditionNotify) (Tcl_Condition *condPtr); /* 310 */
    void (*tcl_ConditionWait) (Tcl_Condition *condPtr, Tcl_Mutex *mutexPtr, Tcl_Time *timePtr); /* 311 */
    int (*tcl_NumUtfChars) (CONST char *src, int length); /* 312 */
    int (*tcl_ReadChars) (Tcl_Channel channel, Tcl_Obj *objPtr, int charsToRead, int appendFlag); /* 313 */
    void (*tcl_RestoreResult) (Tcl_Interp *interp, Tcl_SavedResult *statePtr); /* 314 */
    void (*tcl_SaveResult) (Tcl_Interp *interp, Tcl_SavedResult *statePtr); /* 315 */
    int (*tcl_SetSystemEncoding) (Tcl_Interp *interp, CONST char *name); /* 316 */
    Tcl_Obj * (*tcl_SetVar2Ex) (Tcl_Interp *interp, CONST char *part1, CONST char *part2, Tcl_Obj *newValuePtr, int flags); /* 317 */
    void (*tcl_ThreadAlert) (Tcl_ThreadId threadId); /* 318 */
    void (*tcl_ThreadQueueEvent) (Tcl_ThreadId threadId, Tcl_Event *evPtr, Tcl_QueuePosition position); /* 319 */
    Tcl_UniChar (*tcl_UniCharAtIndex) (CONST char *src, int index); /* 320 */
    Tcl_UniChar (*tcl_UniCharToLower) (int ch); /* 321 */
    Tcl_UniChar (*tcl_UniCharToTitle) (int ch); /* 322 */
    Tcl_UniChar (*tcl_UniCharToUpper) (int ch); /* 323 */
    int (*tcl_UniCharToUtf) (int ch, char *buf); /* 324 */
    CONST84_RETURN char * (*tcl_UtfAtIndex) (CONST char *src, int index); /* 325 */
    int (*tcl_UtfCharComplete) (CONST char *src, int length); /* 326 */
    int (*tcl_UtfBackslash) (CONST char *src, int *readPtr, char *dst); /* 327 */
    CONST84_RETURN char * (*tcl_UtfFindFirst) (CONST char *src, int ch); /* 328 */
    CONST84_RETURN char * (*tcl_UtfFindLast) (CONST char *src, int ch); /* 329 */
    CONST84_RETURN char * (*tcl_UtfNext) (CONST char *src); /* 330 */
    CONST84_RETURN char * (*tcl_UtfPrev) (CONST char *src, CONST char *start); /* 331 */
    int (*tcl_UtfToExternal) (Tcl_Interp *interp, Tcl_Encoding encoding, CONST char *src, int srcLen, int flags, Tcl_EncodingState *statePtr, char *dst, int dstLen, int *srcReadPtr, int *dstWrotePtr, int *dstCharsPtr); /* 332 */
    char * (*tcl_UtfToExternalDString) (Tcl_Encoding encoding, CONST char *src, int srcLen, Tcl_DString *dsPtr); /* 333 */
    int (*tcl_UtfToLower) (char *src); /* 334 */
    int (*tcl_UtfToTitle) (char *src); /* 335 */
    int (*tcl_UtfToUniChar) (CONST char *src, Tcl_UniChar *chPtr); /* 336 */
    int (*tcl_UtfToUpper) (char *src); /* 337 */
    int (*tcl_WriteChars) (Tcl_Channel chan, CONST char *src, int srcLen); /* 338 */
    int (*tcl_WriteObj) (Tcl_Channel chan, Tcl_Obj *objPtr); /* 339 */
    char * (*tcl_GetString) (Tcl_Obj *objPtr); /* 340 */
    CONST84_RETURN char * (*tcl_GetDefaultEncodingDir) (void); /* 341 */
    void (*tcl_SetDefaultEncodingDir) (CONST char *path); /* 342 */
    void (*tcl_AlertNotifier) (ClientData clientData); /* 343 */
    void (*tcl_ServiceModeHook) (int mode); /* 344 */
    int (*tcl_UniCharIsAlnum) (int ch); /* 345 */
    int (*tcl_UniCharIsAlpha) (int ch); /* 346 */
    int (*tcl_UniCharIsDigit) (int ch); /* 347 */
    int (*tcl_UniCharIsLower) (int ch); /* 348 */
    int (*tcl_UniCharIsSpace) (int ch); /* 349 */
    int (*tcl_UniCharIsUpper) (int ch); /* 350 */
    int (*tcl_UniCharIsWordChar) (int ch); /* 351 */
    int (*tcl_UniCharLen) (CONST Tcl_UniChar *uniStr); /* 352 */
    int (*tcl_UniCharNcmp) (CONST Tcl_UniChar *ucs, CONST Tcl_UniChar *uct, unsigned long numChars); /* 353 */
    char * (*tcl_UniCharToUtfDString) (CONST Tcl_UniChar *uniStr, int uniLength, Tcl_DString *dsPtr); /* 354 */
    Tcl_UniChar * (*tcl_UtfToUniCharDString) (CONST char *src, int length, Tcl_DString *dsPtr); /* 355 */
    Tcl_RegExp (*tcl_GetRegExpFromObj) (Tcl_Interp *interp, Tcl_Obj *patObj, int flags); /* 356 */
    Tcl_Obj * (*tcl_EvalTokens) (Tcl_Interp *interp, Tcl_Token *tokenPtr, int count); /* 357 */
    void (*tcl_FreeParse) (Tcl_Parse *parsePtr); /* 358 */
    void (*tcl_LogCommandInfo) (Tcl_Interp *interp, CONST char *script, CONST char *command, int length); /* 359 */
    int (*tcl_ParseBraces) (Tcl_Interp *interp, CONST char *start, int numBytes, Tcl_Parse *parsePtr, int append, CONST84 char **termPtr); /* 360 */
    int (*tcl_ParseCommand) (Tcl_Interp *interp, CONST char *start, int numBytes, int nested, Tcl_Parse *parsePtr); /* 361 */
    int (*tcl_ParseExpr) (Tcl_Interp *interp, CONST char *start, int numBytes, Tcl_Parse *parsePtr); /* 362 */
    int (*tcl_ParseQuotedString) (Tcl_Interp *interp, CONST char *start, int numBytes, Tcl_Parse *parsePtr, int append, CONST84 char **termPtr); /* 363 */
    int (*tcl_ParseVarName) (Tcl_Interp *interp, CONST char *start, int numBytes, Tcl_Parse *parsePtr, int append); /* 364 */
    char * (*tcl_GetCwd) (Tcl_Interp *interp, Tcl_DString *cwdPtr); /* 365 */
    int (*tcl_Chdir) (CONST char *dirName); /* 366 */
    int (*tcl_Access) (CONST char *path, int mode); /* 367 */
    int (*tcl_Stat) (CONST char *path, struct stat *bufPtr); /* 368 */
    int (*tcl_UtfNcmp) (CONST char *s1, CONST char *s2, unsigned long n); /* 369 */
    int (*tcl_UtfNcasecmp) (CONST char *s1, CONST char *s2, unsigned long n); /* 370 */
    int (*tcl_StringCaseMatch) (CONST char *str, CONST char *pattern, int nocase); /* 371 */
    int (*tcl_UniCharIsControl) (int ch); /* 372 */
    int (*tcl_UniCharIsGraph) (int ch); /* 373 */
    int (*tcl_UniCharIsPrint) (int ch); /* 374 */
    int (*tcl_UniCharIsPunct) (int ch); /* 375 */
    int (*tcl_RegExpExecObj) (Tcl_Interp *interp, Tcl_RegExp regexp, Tcl_Obj *textObj, int offset, int nmatches, int flags); /* 376 */
    void (*tcl_RegExpGetInfo) (Tcl_RegExp regexp, Tcl_RegExpInfo *infoPtr); /* 377 */
    Tcl_Obj * (*tcl_NewUnicodeObj) (CONST Tcl_UniChar *unicode, int numChars); /* 378 */
    void (*tcl_SetUnicodeObj) (Tcl_Obj *objPtr, CONST Tcl_UniChar *unicode, int numChars); /* 379 */
    int (*tcl_GetCharLength) (Tcl_Obj *objPtr); /* 380 */
    Tcl_UniChar (*tcl_GetUniChar) (Tcl_Obj *objPtr, int index); /* 381 */
    Tcl_UniChar * (*tcl_GetUnicode) (Tcl_Obj *objPtr); /* 382 */
    Tcl_Obj * (*tcl_GetRange) (Tcl_Obj *objPtr, int first, int last); /* 383 */
    void (*tcl_AppendUnicodeToObj) (Tcl_Obj *objPtr, CONST Tcl_UniChar *unicode, int length); /* 384 */
    int (*tcl_RegExpMatchObj) (Tcl_Interp *interp, Tcl_Obj *textObj, Tcl_Obj *patternObj); /* 385 */
    void (*tcl_SetNotifier) (Tcl_NotifierProcs *notifierProcPtr); /* 386 */
    Tcl_Mutex * (*tcl_GetAllocMutex) (void); /* 387 */
    int (*tcl_GetChannelNames) (Tcl_Interp *interp); /* 388 */
    int (*tcl_GetChannelNamesEx) (Tcl_Interp *interp, CONST char *pattern); /* 389 */
    int (*tcl_ProcObjCmd) (ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]); /* 390 */
    void (*tcl_ConditionFinalize) (Tcl_Condition *condPtr); /* 391 */
    void (*tcl_MutexFinalize) (Tcl_Mutex *mutex); /* 392 */
    int (*tcl_CreateThread) (Tcl_ThreadId *idPtr, Tcl_ThreadCreateProc proc, ClientData clientData, int stackSize, int flags); /* 393 */
    int (*tcl_ReadRaw) (Tcl_Channel chan, char *dst, int bytesToRead); /* 394 */
    int (*tcl_WriteRaw) (Tcl_Channel chan, CONST char *src, int srcLen); /* 395 */
    Tcl_Channel (*tcl_GetTopChannel) (Tcl_Channel chan); /* 396 */
    int (*tcl_ChannelBuffered) (Tcl_Channel chan); /* 397 */
    CONST84_RETURN char * (*tcl_ChannelName) (CONST Tcl_ChannelType *chanTypePtr); /* 398 */
    Tcl_ChannelTypeVersion (*tcl_ChannelVersion) (CONST Tcl_ChannelType *chanTypePtr); /* 399 */
    Tcl_DriverBlockModeProc * (*tcl_ChannelBlockModeProc) (CONST Tcl_ChannelType *chanTypePtr); /* 400 */
    Tcl_DriverCloseProc * (*tcl_ChannelCloseProc) (CONST Tcl_ChannelType *chanTypePtr); /* 401 */
    Tcl_DriverClose2Proc * (*tcl_ChannelClose2Proc) (CONST Tcl_ChannelType *chanTypePtr); /* 402 */
    Tcl_DriverInputProc * (*tcl_ChannelInputProc) (CONST Tcl_ChannelType *chanTypePtr); /* 403 */
    Tcl_DriverOutputProc * (*tcl_ChannelOutputProc) (CONST Tcl_ChannelType *chanTypePtr); /* 404 */
    Tcl_DriverSeekProc * (*tcl_ChannelSeekProc) (CONST Tcl_ChannelType *chanTypePtr); /* 405 */
    Tcl_DriverSetOptionProc * (*tcl_ChannelSetOptionProc) (CONST Tcl_ChannelType *chanTypePtr); /* 406 */
    Tcl_DriverGetOptionProc * (*tcl_ChannelGetOptionProc) (CONST Tcl_ChannelType *chanTypePtr); /* 407 */
    Tcl_DriverWatchProc * (*tcl_ChannelWatchProc) (CONST Tcl_ChannelType *chanTypePtr); /* 408 */
    Tcl_DriverGetHandleProc * (*tcl_ChannelGetHandleProc) (CONST Tcl_ChannelType *chanTypePtr); /* 409 */
    Tcl_DriverFlushProc * (*tcl_ChannelFlushProc) (CONST Tcl_ChannelType *chanTypePtr); /* 410 */
    Tcl_DriverHandlerProc * (*tcl_ChannelHandlerProc) (CONST Tcl_ChannelType *chanTypePtr); /* 411 */
    int (*tcl_JoinThread) (Tcl_ThreadId threadId, int *result); /* 412 */
    int (*tcl_IsChannelShared) (Tcl_Channel channel); /* 413 */
    int (*tcl_IsChannelRegistered) (Tcl_Interp *interp, Tcl_Channel channel); /* 414 */
    void (*tcl_CutChannel) (Tcl_Channel channel); /* 415 */
    void (*tcl_SpliceChannel) (Tcl_Channel channel); /* 416 */
    void (*tcl_ClearChannelHandlers) (Tcl_Channel channel); /* 417 */
    int (*tcl_IsChannelExisting) (CONST char *channelName); /* 418 */
    int (*tcl_UniCharNcasecmp) (CONST Tcl_UniChar *ucs, CONST Tcl_UniChar *uct, unsigned long numChars); /* 419 */
    int (*tcl_UniCharCaseMatch) (CONST Tcl_UniChar *uniStr, CONST Tcl_UniChar *uniPattern, int nocase); /* 420 */
    Tcl_HashEntry * (*tcl_FindHashEntry) (Tcl_HashTable *tablePtr, CONST char *key); /* 421 */
    Tcl_HashEntry * (*tcl_CreateHashEntry) (Tcl_HashTable *tablePtr, CONST char *key, int *newPtr); /* 422 */
    void (*tcl_InitCustomHashTable) (Tcl_HashTable *tablePtr, int keyType, Tcl_HashKeyType *typePtr); /* 423 */
    void (*tcl_InitObjHashTable) (Tcl_HashTable *tablePtr); /* 424 */
    ClientData (*tcl_CommandTraceInfo) (Tcl_Interp *interp, CONST char *varName, int flags, Tcl_CommandTraceProc *procPtr, ClientData prevClientData); /* 425 */
    int (*tcl_TraceCommand) (Tcl_Interp *interp, CONST char *varName, int flags, Tcl_CommandTraceProc *proc, ClientData clientData); /* 426 */
    void (*tcl_UntraceCommand) (Tcl_Interp *interp, CONST char *varName, int flags, Tcl_CommandTraceProc *proc, ClientData clientData); /* 427 */
    char * (*tcl_AttemptAlloc) (unsigned int size); /* 428 */
    char * (*tcl_AttemptDbCkalloc) (unsigned int size, CONST char *file, int line); /* 429 */
    char * (*tcl_AttemptRealloc) (char *ptr, unsigned int size); /* 430 */
    char * (*tcl_AttemptDbCkrealloc) (char *ptr, unsigned int size, CONST char *file, int line); /* 431 */
    int (*tcl_AttemptSetObjLength) (Tcl_Obj *objPtr, int length); /* 432 */
    Tcl_ThreadId (*tcl_GetChannelThread) (Tcl_Channel channel); /* 433 */
    Tcl_UniChar * (*tcl_GetUnicodeFromObj) (Tcl_Obj *objPtr, int *lengthPtr); /* 434 */
    int (*tcl_GetMathFuncInfo) (Tcl_Interp *interp, CONST char *name, int *numArgsPtr, Tcl_ValueType **argTypesPtr, Tcl_MathProc **procPtr, ClientData *clientDataPtr); /* 435 */
    Tcl_Obj * (*tcl_ListMathFuncs) (Tcl_Interp *interp, CONST char *pattern); /* 436 */
    Tcl_Obj * (*tcl_SubstObj) (Tcl_Interp *interp, Tcl_Obj *objPtr, int flags); /* 437 */
    int (*tcl_DetachChannel) (Tcl_Interp *interp, Tcl_Channel channel); /* 438 */
    int (*tcl_IsStandardChannel) (Tcl_Channel channel); /* 439 */
    int (*tcl_FSCopyFile) (Tcl_Obj *srcPathPtr, Tcl_Obj *destPathPtr); /* 440 */
    int (*tcl_FSCopyDirectory) (Tcl_Obj *srcPathPtr, Tcl_Obj *destPathPtr, Tcl_Obj **errorPtr); /* 441 */
    int (*tcl_FSCreateDirectory) (Tcl_Obj *pathPtr); /* 442 */
    int (*tcl_FSDeleteFile) (Tcl_Obj *pathPtr); /* 443 */
    int (*tcl_FSLoadFile) (Tcl_Interp *interp, Tcl_Obj *pathPtr, CONST char *sym1, CONST char *sym2, Tcl_PackageInitProc **proc1Ptr, Tcl_PackageInitProc **proc2Ptr, Tcl_LoadHandle *handlePtr, Tcl_FSUnloadFileProc **unloadProcPtr); /* 444 */
    int (*tcl_FSMatchInDirectory) (Tcl_Interp *interp, Tcl_Obj *result, Tcl_Obj *pathPtr, CONST char *pattern, Tcl_GlobTypeData *types); /* 445 */
    Tcl_Obj * (*tcl_FSLink) (Tcl_Obj *pathPtr, Tcl_Obj *toPtr, int linkAction); /* 446 */
    int (*tcl_FSRemoveDirectory) (Tcl_Obj *pathPtr, int recursive, Tcl_Obj **errorPtr); /* 447 */
    int (*tcl_FSRenameFile) (Tcl_Obj *srcPathPtr, Tcl_Obj *destPathPtr); /* 448 */
    int (*tcl_FSLstat) (Tcl_Obj *pathPtr, Tcl_StatBuf *buf); /* 449 */
    int (*tcl_FSUtime) (Tcl_Obj *pathPtr, struct utimbuf *tval); /* 450 */
    int (*tcl_FSFileAttrsGet) (Tcl_Interp *interp, int index, Tcl_Obj *pathPtr, Tcl_Obj **objPtrRef); /* 451 */
    int (*tcl_FSFileAttrsSet) (Tcl_Interp *interp, int index, Tcl_Obj *pathPtr, Tcl_Obj *objPtr); /* 452 */
    CONST char ** (*tcl_FSFileAttrStrings) (Tcl_Obj *pathPtr, Tcl_Obj **objPtrRef); /* 453 */
    int (*tcl_FSStat) (Tcl_Obj *pathPtr, Tcl_StatBuf *buf); /* 454 */
    int (*tcl_FSAccess) (Tcl_Obj *pathPtr, int mode); /* 455 */
    Tcl_Channel (*tcl_FSOpenFileChannel) (Tcl_Interp *interp, Tcl_Obj *pathPtr, CONST char *modeString, int permissions); /* 456 */
    Tcl_Obj * (*tcl_FSGetCwd) (Tcl_Interp *interp); /* 457 */
    int (*tcl_FSChdir) (Tcl_Obj *pathPtr); /* 458 */
    int (*tcl_FSConvertToPathType) (Tcl_Interp *interp, Tcl_Obj *pathPtr); /* 459 */
    Tcl_Obj * (*tcl_FSJoinPath) (Tcl_Obj *listObj, int elements); /* 460 */
    Tcl_Obj * (*tcl_FSSplitPath) (Tcl_Obj *pathPtr, int *lenPtr); /* 461 */
    int (*tcl_FSEqualPaths) (Tcl_Obj *firstPtr, Tcl_Obj *secondPtr); /* 462 */
    Tcl_Obj * (*tcl_FSGetNormalizedPath) (Tcl_Interp *interp, Tcl_Obj *pathPtr); /* 463 */
    Tcl_Obj * (*tcl_FSJoinToPath) (Tcl_Obj *pathPtr, int objc, Tcl_Obj *CONST objv[]); /* 464 */
    ClientData (*tcl_FSGetInternalRep) (Tcl_Obj *pathPtr, Tcl_Filesystem *fsPtr); /* 465 */
    Tcl_Obj * (*tcl_FSGetTranslatedPath) (Tcl_Interp *interp, Tcl_Obj *pathPtr); /* 466 */
    int (*tcl_FSEvalFile) (Tcl_Interp *interp, Tcl_Obj *fileName); /* 467 */
    Tcl_Obj * (*tcl_FSNewNativePath) (Tcl_Filesystem *fromFilesystem, ClientData clientData); /* 468 */
    CONST char * (*tcl_FSGetNativePath) (Tcl_Obj *pathPtr); /* 469 */
    Tcl_Obj * (*tcl_FSFileSystemInfo) (Tcl_Obj *pathPtr); /* 470 */
    Tcl_Obj * (*tcl_FSPathSeparator) (Tcl_Obj *pathPtr); /* 471 */
    Tcl_Obj * (*tcl_FSListVolumes) (void); /* 472 */
    int (*tcl_FSRegister) (ClientData clientData, Tcl_Filesystem *fsPtr); /* 473 */
    int (*tcl_FSUnregister) (Tcl_Filesystem *fsPtr); /* 474 */
    ClientData (*tcl_FSData) (Tcl_Filesystem *fsPtr); /* 475 */
    CONST char * (*tcl_FSGetTranslatedStringPath) (Tcl_Interp *interp, Tcl_Obj *pathPtr); /* 476 */
    Tcl_Filesystem * (*tcl_FSGetFileSystemForPath) (Tcl_Obj *pathPtr); /* 477 */
    Tcl_PathType (*tcl_FSGetPathType) (Tcl_Obj *pathPtr); /* 478 */
    int (*tcl_OutputBuffered) (Tcl_Channel chan); /* 479 */
    void (*tcl_FSMountsChanged) (Tcl_Filesystem *fsPtr); /* 480 */
    int (*tcl_EvalTokensStandard) (Tcl_Interp *interp, Tcl_Token *tokenPtr, int count); /* 481 */
    void (*tcl_GetTime) (Tcl_Time *timeBuf); /* 482 */
    Tcl_Trace (*tcl_CreateObjTrace) (Tcl_Interp *interp, int level, int flags, Tcl_CmdObjTraceProc *objProc, ClientData clientData, Tcl_CmdObjTraceDeleteProc *delProc); /* 483 */
    int (*tcl_GetCommandInfoFromToken) (Tcl_Command token, Tcl_CmdInfo *infoPtr); /* 484 */
    int (*tcl_SetCommandInfoFromToken) (Tcl_Command token, CONST Tcl_CmdInfo *infoPtr); /* 485 */
    Tcl_Obj * (*tcl_DbNewWideIntObj) (Tcl_WideInt wideValue, CONST char *file, int line); /* 486 */
    int (*tcl_GetWideIntFromObj) (Tcl_Interp *interp, Tcl_Obj *objPtr, Tcl_WideInt *widePtr); /* 487 */
    Tcl_Obj * (*tcl_NewWideIntObj) (Tcl_WideInt wideValue); /* 488 */
    void (*tcl_SetWideIntObj) (Tcl_Obj *objPtr, Tcl_WideInt wideValue); /* 489 */
    Tcl_StatBuf * (*tcl_AllocStatBuf) (void); /* 490 */
    Tcl_WideInt (*tcl_Seek) (Tcl_Channel chan, Tcl_WideInt offset, int mode); /* 491 */
    Tcl_WideInt (*tcl_Tell) (Tcl_Channel chan); /* 492 */
    Tcl_DriverWideSeekProc * (*tcl_ChannelWideSeekProc) (CONST Tcl_ChannelType *chanTypePtr); /* 493 */
    int (*tcl_DictObjPut) (Tcl_Interp *interp, Tcl_Obj *dictPtr, Tcl_Obj *keyPtr, Tcl_Obj *valuePtr); /* 494 */
    int (*tcl_DictObjGet) (Tcl_Interp *interp, Tcl_Obj *dictPtr, Tcl_Obj *keyPtr, Tcl_Obj **valuePtrPtr); /* 495 */
    int (*tcl_DictObjRemove) (Tcl_Interp *interp, Tcl_Obj *dictPtr, Tcl_Obj *keyPtr); /* 496 */
    int (*tcl_DictObjSize) (Tcl_Interp *interp, Tcl_Obj *dictPtr, int *sizePtr); /* 497 */
    int (*tcl_DictObjFirst) (Tcl_Interp *interp, Tcl_Obj *dictPtr, Tcl_DictSearch *searchPtr, Tcl_Obj **keyPtrPtr, Tcl_Obj **valuePtrPtr, int *donePtr); /* 498 */
    void (*tcl_DictObjNext) (Tcl_DictSearch *searchPtr, Tcl_Obj **keyPtrPtr, Tcl_Obj **valuePtrPtr, int *donePtr); /* 499 */
    void (*tcl_DictObjDone) (Tcl_DictSearch *searchPtr); /* 500 */
    int (*tcl_DictObjPutKeyList) (Tcl_Interp *interp, Tcl_Obj *dictPtr, int keyc, Tcl_Obj *CONST *keyv, Tcl_Obj *valuePtr); /* 501 */
    int (*tcl_DictObjRemoveKeyList) (Tcl_Interp *interp, Tcl_Obj *dictPtr, int keyc, Tcl_Obj *CONST *keyv); /* 502 */
    Tcl_Obj * (*tcl_NewDictObj) (void); /* 503 */
    Tcl_Obj * (*tcl_DbNewDictObj) (CONST char *file, int line); /* 504 */
    void (*tcl_RegisterConfig) (Tcl_Interp *interp, CONST char *pkgName, Tcl_Config *configuration, CONST char *valEncoding); /* 505 */
    Tcl_Namespace * (*tcl_CreateNamespace) (Tcl_Interp *interp, CONST char *name, ClientData clientData, Tcl_NamespaceDeleteProc *deleteProc); /* 506 */
    void (*tcl_DeleteNamespace) (Tcl_Namespace *nsPtr); /* 507 */
    int (*tcl_AppendExportList) (Tcl_Interp *interp, Tcl_Namespace *nsPtr, Tcl_Obj *objPtr); /* 508 */
    int (*tcl_Export) (Tcl_Interp *interp, Tcl_Namespace *nsPtr, CONST char *pattern, int resetListFirst); /* 509 */
    int (*tcl_Import) (Tcl_Interp *interp, Tcl_Namespace *nsPtr, CONST char *pattern, int allowOverwrite); /* 510 */
    int (*tcl_ForgetImport) (Tcl_Interp *interp, Tcl_Namespace *nsPtr, CONST char *pattern); /* 511 */
    Tcl_Namespace * (*tcl_GetCurrentNamespace) (Tcl_Interp *interp); /* 512 */
    Tcl_Namespace * (*tcl_GetGlobalNamespace) (Tcl_Interp *interp); /* 513 */
    Tcl_Namespace * (*tcl_FindNamespace) (Tcl_Interp *interp, CONST char *name, Tcl_Namespace *contextNsPtr, int flags); /* 514 */
    Tcl_Command (*tcl_FindCommand) (Tcl_Interp *interp, CONST char *name, Tcl_Namespace *contextNsPtr, int flags); /* 515 */
    Tcl_Command (*tcl_GetCommandFromObj) (Tcl_Interp *interp, Tcl_Obj *objPtr); /* 516 */
    void (*tcl_GetCommandFullName) (Tcl_Interp *interp, Tcl_Command command, Tcl_Obj *objPtr); /* 517 */
    int (*tcl_FSEvalFileEx) (Tcl_Interp *interp, Tcl_Obj *fileName, CONST char *encodingName); /* 518 */
    Tcl_ExitProc * (*tcl_SetExitProc) (Tcl_ExitProc *proc); /* 519 */
    void (*tcl_LimitAddHandler) (Tcl_Interp *interp, int type, Tcl_LimitHandlerProc *handlerProc, ClientData clientData, Tcl_LimitHandlerDeleteProc *deleteProc); /* 520 */
    void (*tcl_LimitRemoveHandler) (Tcl_Interp *interp, int type, Tcl_LimitHandlerProc *handlerProc, ClientData clientData); /* 521 */
    int (*tcl_LimitReady) (Tcl_Interp *interp); /* 522 */
    int (*tcl_LimitCheck) (Tcl_Interp *interp); /* 523 */
    int (*tcl_LimitExceeded) (Tcl_Interp *interp); /* 524 */
    void (*tcl_LimitSetCommands) (Tcl_Interp *interp, int commandLimit); /* 525 */
    void (*tcl_LimitSetTime) (Tcl_Interp *interp, Tcl_Time *timeLimitPtr); /* 526 */
    void (*tcl_LimitSetGranularity) (Tcl_Interp *interp, int type, int granularity); /* 527 */
    int (*tcl_LimitTypeEnabled) (Tcl_Interp *interp, int type); /* 528 */
    int (*tcl_LimitTypeExceeded) (Tcl_Interp *interp, int type); /* 529 */
    void (*tcl_LimitTypeSet) (Tcl_Interp *interp, int type); /* 530 */
    void (*tcl_LimitTypeReset) (Tcl_Interp *interp, int type); /* 531 */
    int (*tcl_LimitGetCommands) (Tcl_Interp *interp); /* 532 */
    void (*tcl_LimitGetTime) (Tcl_Interp *interp, Tcl_Time *timeLimitPtr); /* 533 */
    int (*tcl_LimitGetGranularity) (Tcl_Interp *interp, int type); /* 534 */
    Tcl_InterpState (*tcl_SaveInterpState) (Tcl_Interp *interp, int status); /* 535 */
    int (*tcl_RestoreInterpState) (Tcl_Interp *interp, Tcl_InterpState state); /* 536 */
    void (*tcl_DiscardInterpState) (Tcl_InterpState state); /* 537 */
    int (*tcl_SetReturnOptions) (Tcl_Interp *interp, Tcl_Obj *options); /* 538 */
    Tcl_Obj * (*tcl_GetReturnOptions) (Tcl_Interp *interp, int result); /* 539 */
    int (*tcl_IsEnsemble) (Tcl_Command token); /* 540 */
    Tcl_Command (*tcl_CreateEnsemble) (Tcl_Interp *interp, CONST char *name, Tcl_Namespace *namespacePtr, int flags); /* 541 */
    Tcl_Command (*tcl_FindEnsemble) (Tcl_Interp *interp, Tcl_Obj *cmdNameObj, int flags); /* 542 */
    int (*tcl_SetEnsembleSubcommandList) (Tcl_Interp *interp, Tcl_Command token, Tcl_Obj *subcmdList); /* 543 */
    int (*tcl_SetEnsembleMappingDict) (Tcl_Interp *interp, Tcl_Command token, Tcl_Obj *mapDict); /* 544 */
    int (*tcl_SetEnsembleUnknownHandler) (Tcl_Interp *interp, Tcl_Command token, Tcl_Obj *unknownList); /* 545 */
    int (*tcl_SetEnsembleFlags) (Tcl_Interp *interp, Tcl_Command token, int flags); /* 546 */
    int (*tcl_GetEnsembleSubcommandList) (Tcl_Interp *interp, Tcl_Command token, Tcl_Obj **subcmdListPtr); /* 547 */
    int (*tcl_GetEnsembleMappingDict) (Tcl_Interp *interp, Tcl_Command token, Tcl_Obj **mapDictPtr); /* 548 */
    int (*tcl_GetEnsembleUnknownHandler) (Tcl_Interp *interp, Tcl_Command token, Tcl_Obj **unknownListPtr); /* 549 */
    int (*tcl_GetEnsembleFlags) (Tcl_Interp *interp, Tcl_Command token, int *flagsPtr); /* 550 */
    int (*tcl_GetEnsembleNamespace) (Tcl_Interp *interp, Tcl_Command token, Tcl_Namespace **namespacePtrPtr); /* 551 */
    void (*tcl_SetTimeProc) (Tcl_GetTimeProc *getProc, Tcl_ScaleTimeProc *scaleProc, ClientData clientData); /* 552 */
    void (*tcl_QueryTimeProc) (Tcl_GetTimeProc **getProc, Tcl_ScaleTimeProc **scaleProc, ClientData *clientData); /* 553 */
    Tcl_DriverThreadActionProc * (*tcl_ChannelThreadActionProc) (CONST Tcl_ChannelType *chanTypePtr); /* 554 */
    Tcl_Obj * (*tcl_NewBignumObj) (mp_int *value); /* 555 */
    Tcl_Obj * (*tcl_DbNewBignumObj) (mp_int *value, CONST char *file, int line); /* 556 */
    void (*tcl_SetBignumObj) (Tcl_Obj *obj, mp_int *value); /* 557 */
    int (*tcl_GetBignumFromObj) (Tcl_Interp *interp, Tcl_Obj *obj, mp_int *value); /* 558 */
    int (*tcl_TakeBignumFromObj) (Tcl_Interp *interp, Tcl_Obj *obj, mp_int *value); /* 559 */
    int (*tcl_TruncateChannel) (Tcl_Channel chan, Tcl_WideInt length); /* 560 */
    Tcl_DriverTruncateProc * (*tcl_ChannelTruncateProc) (CONST Tcl_ChannelType *chanTypePtr); /* 561 */
    void (*tcl_SetChannelErrorInterp) (Tcl_Interp *interp, Tcl_Obj *msg); /* 562 */
    void (*tcl_GetChannelErrorInterp) (Tcl_Interp *interp, Tcl_Obj **msg); /* 563 */
    void (*tcl_SetChannelError) (Tcl_Channel chan, Tcl_Obj *msg); /* 564 */
    void (*tcl_GetChannelError) (Tcl_Channel chan, Tcl_Obj **msg); /* 565 */
    int (*tcl_InitBignumFromDouble) (Tcl_Interp *interp, double initval, mp_int *toInit); /* 566 */
    Tcl_Obj * (*tcl_GetNamespaceUnknownHandler) (Tcl_Interp *interp, Tcl_Namespace *nsPtr); /* 567 */
    int (*tcl_SetNamespaceUnknownHandler) (Tcl_Interp *interp, Tcl_Namespace *nsPtr, Tcl_Obj *handlerPtr); /* 568 */
    int (*tcl_GetEncodingFromObj) (Tcl_Interp *interp, Tcl_Obj *objPtr, Tcl_Encoding *encodingPtr); /* 569 */
    Tcl_Obj * (*tcl_GetEncodingSearchPath) (void); /* 570 */
    int (*tcl_SetEncodingSearchPath) (Tcl_Obj *searchPath); /* 571 */
    CONST char * (*tcl_GetEncodingNameFromEnvironment) (Tcl_DString *bufPtr); /* 572 */
    int (*tcl_PkgRequireProc) (Tcl_Interp *interp, CONST char *name, int objc, Tcl_Obj *CONST objv[], ClientData *clientDataPtr); /* 573 */
    void (*tcl_AppendObjToErrorInfo) (Tcl_Interp *interp, Tcl_Obj *objPtr); /* 574 */
    void (*tcl_AppendLimitedToObj) (Tcl_Obj *objPtr, CONST char *bytes, int length, int limit, CONST char *ellipsis); /* 575 */
    Tcl_Obj * (*tcl_Format) (Tcl_Interp *interp, CONST char *format, int objc, Tcl_Obj *CONST objv[]); /* 576 */
    int (*tcl_AppendFormatToObj) (Tcl_Interp *interp, Tcl_Obj *objPtr, CONST char *format, int objc, Tcl_Obj *CONST objv[]); /* 577 */
    Tcl_Obj * (*tcl_ObjPrintf) (CONST char *format, ...); /* 578 */
    void (*tcl_AppendPrintfToObj) (Tcl_Obj *objPtr, CONST char *format, ...); /* 579 */
    VOID *reserved580;
    VOID *reserved581;
    VOID *reserved582;
    VOID *reserved583;
    VOID *reserved584;
    VOID *reserved585;
    VOID *reserved586;
    VOID *reserved587;
    VOID *reserved588;
    VOID *reserved589;
    VOID *reserved590;
    VOID *reserved591;
    VOID *reserved592;
    VOID *reserved593;
    VOID *reserved594;
    VOID *reserved595;
    VOID *reserved596;
    VOID *reserved597;
    VOID *reserved598;
    VOID *reserved599;
    VOID *reserved600;
    VOID *reserved601;
    VOID *reserved602;
    VOID *reserved603;
    VOID *reserved604;
    VOID *reserved605;
    VOID *reserved606;
    VOID *reserved607;
    VOID *reserved608;
    VOID *reserved609;
    VOID *reserved610;
    VOID *reserved611;
    VOID *reserved612;
    VOID *reserved613;
    VOID *reserved614;
    VOID *reserved615;
    VOID *reserved616;
    VOID *reserved617;
    VOID *reserved618;
    VOID *reserved619;
    VOID *reserved620;
    VOID *reserved621;
    VOID *reserved622;
    VOID *reserved623;
    VOID *reserved624;
    VOID *reserved625;
    VOID *reserved626;
    VOID *reserved627;
    VOID *reserved628;
    VOID *reserved629;
    void (*tclUnusedStubEntry) (void); /* 630 */
} TclStubs;

extern TclStubs *tclStubsPtr;

#ifdef __cplusplus
}
#endif

#if defined(USE_TCL_STUBS) && !defined(USE_TCL_STUB_PROCS)

/*
 * Inline function declarations:
 */

#ifndef Tcl_PkgProvideEx
#define Tcl_PkgProvideEx \
	(tclStubsPtr->tcl_PkgProvideEx) /* 0 */
#endif
#ifndef Tcl_PkgRequireEx
#define Tcl_PkgRequireEx \
	(tclStubsPtr->tcl_PkgRequireEx) /* 1 */
#endif
#ifndef Tcl_Panic
#define Tcl_Panic \
	(tclStubsPtr->tcl_Panic) /* 2 */
#endif
#ifndef Tcl_Alloc
#define Tcl_Alloc \
	(tclStubsPtr->tcl_Alloc) /* 3 */
#endif
#ifndef Tcl_Free
#define Tcl_Free \
	(tclStubsPtr->tcl_Free) /* 4 */
#endif
#ifndef Tcl_Realloc
#define Tcl_Realloc \
	(tclStubsPtr->tcl_Realloc) /* 5 */
#endif
#ifndef Tcl_DbCkalloc
#define Tcl_DbCkalloc \
	(tclStubsPtr->tcl_DbCkalloc) /* 6 */
#endif
#ifndef Tcl_DbCkfree
#define Tcl_DbCkfree \
	(tclStubsPtr->tcl_DbCkfree) /* 7 */
#endif
#ifndef Tcl_DbCkrealloc
#define Tcl_DbCkrealloc \
	(tclStubsPtr->tcl_DbCkrealloc) /* 8 */
#endif
#if !defined(__WIN32__) && !defined(MAC_OSX_TCL) /* UNIX */
#ifndef Tcl_CreateFileHandler
#define Tcl_CreateFileHandler \
	(tclStubsPtr->tcl_CreateFileHandler) /* 9 */
#endif
#endif /* UNIX */
#ifdef MAC_OSX_TCL /* MACOSX */
#ifndef Tcl_CreateFileHandler
#define Tcl_CreateFileHandler \
	(tclStubsPtr->tcl_CreateFileHandler) /* 9 */
#endif
#endif /* MACOSX */
#if !defined(__WIN32__) && !defined(MAC_OSX_TCL) /* UNIX */
#ifndef Tcl_DeleteFileHandler
#define Tcl_DeleteFileHandler \
	(tclStubsPtr->tcl_DeleteFileHandler) /* 10 */
#endif
#endif /* UNIX */
#ifdef MAC_OSX_TCL /* MACOSX */
#ifndef Tcl_DeleteFileHandler
#define Tcl_DeleteFileHandler \
	(tclStubsPtr->tcl_DeleteFileHandler) /* 10 */
#endif
#endif /* MACOSX */
#ifndef Tcl_SetTimer
#define Tcl_SetTimer \
	(tclStubsPtr->tcl_SetTimer) /* 11 */
#endif
#ifndef Tcl_Sleep
#define Tcl_Sleep \
	(tclStubsPtr->tcl_Sleep) /* 12 */
#endif
#ifndef Tcl_WaitForEvent
#define Tcl_WaitForEvent \
	(tclStubsPtr->tcl_WaitForEvent) /* 13 */
#endif
#ifndef Tcl_AppendAllObjTypes
#define Tcl_AppendAllObjTypes \
	(tclStubsPtr->tcl_AppendAllObjTypes) /* 14 */
#endif
#ifndef Tcl_AppendStringsToObj
#define Tcl_AppendStringsToObj \
	(tclStubsPtr->tcl_AppendStringsToObj) /* 15 */
#endif
#ifndef Tcl_AppendToObj
#define Tcl_AppendToObj \
	(tclStubsPtr->tcl_AppendToObj) /* 16 */
#endif
#ifndef Tcl_ConcatObj
#define Tcl_ConcatObj \
	(tclStubsPtr->tcl_ConcatObj) /* 17 */
#endif
#ifndef Tcl_ConvertToType
#define Tcl_ConvertToType \
	(tclStubsPtr->tcl_ConvertToType) /* 18 */
#endif
#ifndef Tcl_DbDecrRefCount
#define Tcl_DbDecrRefCount \
	(tclStubsPtr->tcl_DbDecrRefCount) /* 19 */
#endif
#ifndef Tcl_DbIncrRefCount
#define Tcl_DbIncrRefCount \
	(tclStubsPtr->tcl_DbIncrRefCount) /* 20 */
#endif
#ifndef Tcl_DbIsShared
#define Tcl_DbIsShared \
	(tclStubsPtr->tcl_DbIsShared) /* 21 */
#endif
#ifndef Tcl_DbNewBooleanObj
#define Tcl_DbNewBooleanObj \
	(tclStubsPtr->tcl_DbNewBooleanObj) /* 22 */
#endif
#ifndef Tcl_DbNewByteArrayObj
#define Tcl_DbNewByteArrayObj \
	(tclStubsPtr->tcl_DbNewByteArrayObj) /* 23 */
#endif
#ifndef Tcl_DbNewDoubleObj
#define Tcl_DbNewDoubleObj \
	(tclStubsPtr->tcl_DbNewDoubleObj) /* 24 */
#endif
#ifndef Tcl_DbNewListObj
#define Tcl_DbNewListObj \
	(tclStubsPtr->tcl_DbNewListObj) /* 25 */
#endif
#ifndef Tcl_DbNewLongObj
#define Tcl_DbNewLongObj \
	(tclStubsPtr->tcl_DbNewLongObj) /* 26 */
#endif
#ifndef Tcl_DbNewObj
#define Tcl_DbNewObj \
	(tclStubsPtr->tcl_DbNewObj) /* 27 */
#endif
#ifndef Tcl_DbNewStringObj
#define Tcl_DbNewStringObj \
	(tclStubsPtr->tcl_DbNewStringObj) /* 28 */
#endif
#ifndef Tcl_DuplicateObj
#define Tcl_DuplicateObj \
	(tclStubsPtr->tcl_DuplicateObj) /* 29 */
#endif
#ifndef TclFreeObj
#define TclFreeObj \
	(tclStubsPtr->tclFreeObj) /* 30 */
#endif
#ifndef Tcl_GetBoolean
#define Tcl_GetBoolean \
	(tclStubsPtr->tcl_GetBoolean) /* 31 */
#endif
#ifndef Tcl_GetBooleanFromObj
#define Tcl_GetBooleanFromObj \
	(tclStubsPtr->tcl_GetBooleanFromObj) /* 32 */
#endif
#ifndef Tcl_GetByteArrayFromObj
#define Tcl_GetByteArrayFromObj \
	(tclStubsPtr->tcl_GetByteArrayFromObj) /* 33 */
#endif
#ifndef Tcl_GetDouble
#define Tcl_GetDouble \
	(tclStubsPtr->tcl_GetDouble) /* 34 */
#endif
#ifndef Tcl_GetDoubleFromObj
#define Tcl_GetDoubleFromObj \
	(tclStubsPtr->tcl_GetDoubleFromObj) /* 35 */
#endif
#ifndef Tcl_GetIndexFromObj
#define Tcl_GetIndexFromObj \
	(tclStubsPtr->tcl_GetIndexFromObj) /* 36 */
#endif
#ifndef Tcl_GetInt
#define Tcl_GetInt \
	(tclStubsPtr->tcl_GetInt) /* 37 */
#endif
#ifndef Tcl_GetIntFromObj
#define Tcl_GetIntFromObj \
	(tclStubsPtr->tcl_GetIntFromObj) /* 38 */
#endif
#ifndef Tcl_GetLongFromObj
#define Tcl_GetLongFromObj \
	(tclStubsPtr->tcl_GetLongFromObj) /* 39 */
#endif
#ifndef Tcl_GetObjType
#define Tcl_GetObjType \
	(tclStubsPtr->tcl_GetObjType) /* 40 */
#endif
#ifndef Tcl_GetStringFromObj
#define Tcl_GetStringFromObj \
	(tclStubsPtr->tcl_GetStringFromObj) /* 41 */
#endif
#ifndef Tcl_InvalidateStringRep
#define Tcl_InvalidateStringRep \
	(tclStubsPtr->tcl_InvalidateStringRep) /* 42 */
#endif
#ifndef Tcl_ListObjAppendList
#define Tcl_ListObjAppendList \
	(tclStubsPtr->tcl_ListObjAppendList) /* 43 */
#endif
#ifndef Tcl_ListObjAppendElement
#define Tcl_ListObjAppendElement \
	(tclStubsPtr->tcl_ListObjAppendElement) /* 44 */
#endif
#ifndef Tcl_ListObjGetElements
#define Tcl_ListObjGetElements \
	(tclStubsPtr->tcl_ListObjGetElements) /* 45 */
#endif
#ifndef Tcl_ListObjIndex
#define Tcl_ListObjIndex \
	(tclStubsPtr->tcl_ListObjIndex) /* 46 */
#endif
#ifndef Tcl_ListObjLength
#define Tcl_ListObjLength \
	(tclStubsPtr->tcl_ListObjLength) /* 47 */
#endif
#ifndef Tcl_ListObjReplace
#define Tcl_ListObjReplace \
	(tclStubsPtr->tcl_ListObjReplace) /* 48 */
#endif
#ifndef Tcl_NewBooleanObj
#define Tcl_NewBooleanObj \
	(tclStubsPtr->tcl_NewBooleanObj) /* 49 */
#endif
#ifndef Tcl_NewByteArrayObj
#define Tcl_NewByteArrayObj \
	(tclStubsPtr->tcl_NewByteArrayObj) /* 50 */
#endif
#ifndef Tcl_NewDoubleObj
#define Tcl_NewDoubleObj \
	(tclStubsPtr->tcl_NewDoubleObj) /* 51 */
#endif
#ifndef Tcl_NewIntObj
#define Tcl_NewIntObj \
	(tclStubsPtr->tcl_NewIntObj) /* 52 */
#endif
#ifndef Tcl_NewListObj
#define Tcl_NewListObj \
	(tclStubsPtr->tcl_NewListObj) /* 53 */
#endif
#ifndef Tcl_NewLongObj
#define Tcl_NewLongObj \
	(tclStubsPtr->tcl_NewLongObj) /* 54 */
#endif
#ifndef Tcl_NewObj
#define Tcl_NewObj \
	(tclStubsPtr->tcl_NewObj) /* 55 */
#endif
#ifndef Tcl_NewStringObj
#define Tcl_NewStringObj \
	(tclStubsPtr->tcl_NewStringObj) /* 56 */
#endif
#ifndef Tcl_SetBooleanObj
#define Tcl_SetBooleanObj \
	(tclStubsPtr->tcl_SetBooleanObj) /* 57 */
#endif
#ifndef Tcl_SetByteArrayLength
#define Tcl_SetByteArrayLength \
	(tclStubsPtr->tcl_SetByteArrayLength) /* 58 */
#endif
#ifndef Tcl_SetByteArrayObj
#define Tcl_SetByteArrayObj \
	(tclStubsPtr->tcl_SetByteArrayObj) /* 59 */
#endif
#ifndef Tcl_SetDoubleObj
#define Tcl_SetDoubleObj \
	(tclStubsPtr->tcl_SetDoubleObj) /* 60 */
#endif
#ifndef Tcl_SetIntObj
#define Tcl_SetIntObj \
	(tclStubsPtr->tcl_SetIntObj) /* 61 */
#endif
#ifndef Tcl_SetListObj
#define Tcl_SetListObj \
	(tclStubsPtr->tcl_SetListObj) /* 62 */
#endif
#ifndef Tcl_SetLongObj
#define Tcl_SetLongObj \
	(tclStubsPtr->tcl_SetLongObj) /* 63 */
#endif
#ifndef Tcl_SetObjLength
#define Tcl_SetObjLength \
	(tclStubsPtr->tcl_SetObjLength) /* 64 */
#endif
#ifndef Tcl_SetStringObj
#define Tcl_SetStringObj \
	(tclStubsPtr->tcl_SetStringObj) /* 65 */
#endif
#ifndef Tcl_AddErrorInfo
#define Tcl_AddErrorInfo \
	(tclStubsPtr->tcl_AddErrorInfo) /* 66 */
#endif
#ifndef Tcl_AddObjErrorInfo
#define Tcl_AddObjErrorInfo \
	(tclStubsPtr->tcl_AddObjErrorInfo) /* 67 */
#endif
#ifndef Tcl_AllowExceptions
#define Tcl_AllowExceptions \
	(tclStubsPtr->tcl_AllowExceptions) /* 68 */
#endif
#ifndef Tcl_AppendElement
#define Tcl_AppendElement \
	(tclStubsPtr->tcl_AppendElement) /* 69 */
#endif
#ifndef Tcl_AppendResult
#define Tcl_AppendResult \
	(tclStubsPtr->tcl_AppendResult) /* 70 */
#endif
#ifndef Tcl_AsyncCreate
#define Tcl_AsyncCreate \
	(tclStubsPtr->tcl_AsyncCreate) /* 71 */
#endif
#ifndef Tcl_AsyncDelete
#define Tcl_AsyncDelete \
	(tclStubsPtr->tcl_AsyncDelete) /* 72 */
#endif
#ifndef Tcl_AsyncInvoke
#define Tcl_AsyncInvoke \
	(tclStubsPtr->tcl_AsyncInvoke) /* 73 */
#endif
#ifndef Tcl_AsyncMark
#define Tcl_AsyncMark \
	(tclStubsPtr->tcl_AsyncMark) /* 74 */
#endif
#ifndef Tcl_AsyncReady
#define Tcl_AsyncReady \
	(tclStubsPtr->tcl_AsyncReady) /* 75 */
#endif
#ifndef Tcl_BackgroundError
#define Tcl_BackgroundError \
	(tclStubsPtr->tcl_BackgroundError) /* 76 */
#endif
#ifndef Tcl_Backslash
#define Tcl_Backslash \
	(tclStubsPtr->tcl_Backslash) /* 77 */
#endif
#ifndef Tcl_BadChannelOption
#define Tcl_BadChannelOption \
	(tclStubsPtr->tcl_BadChannelOption) /* 78 */
#endif
#ifndef Tcl_CallWhenDeleted
#define Tcl_CallWhenDeleted \
	(tclStubsPtr->tcl_CallWhenDeleted) /* 79 */
#endif
#ifndef Tcl_CancelIdleCall
#define Tcl_CancelIdleCall \
	(tclStubsPtr->tcl_CancelIdleCall) /* 80 */
#endif
#ifndef Tcl_Close
#define Tcl_Close \
	(tclStubsPtr->tcl_Close) /* 81 */
#endif
#ifndef Tcl_CommandComplete
#define Tcl_CommandComplete \
	(tclStubsPtr->tcl_CommandComplete) /* 82 */
#endif
#ifndef Tcl_Concat
#define Tcl_Concat \
	(tclStubsPtr->tcl_Concat) /* 83 */
#endif
#ifndef Tcl_ConvertElement
#define Tcl_ConvertElement \
	(tclStubsPtr->tcl_ConvertElement) /* 84 */
#endif
#ifndef Tcl_ConvertCountedElement
#define Tcl_ConvertCountedElement \
	(tclStubsPtr->tcl_ConvertCountedElement) /* 85 */
#endif
#ifndef Tcl_CreateAlias
#define Tcl_CreateAlias \
	(tclStubsPtr->tcl_CreateAlias) /* 86 */
#endif
#ifndef Tcl_CreateAliasObj
#define Tcl_CreateAliasObj \
	(tclStubsPtr->tcl_CreateAliasObj) /* 87 */
#endif
#ifndef Tcl_CreateChannel
#define Tcl_CreateChannel \
	(tclStubsPtr->tcl_CreateChannel) /* 88 */
#endif
#ifndef Tcl_CreateChannelHandler
#define Tcl_CreateChannelHandler \
	(tclStubsPtr->tcl_CreateChannelHandler) /* 89 */
#endif
#ifndef Tcl_CreateCloseHandler
#define Tcl_CreateCloseHandler \
	(tclStubsPtr->tcl_CreateCloseHandler) /* 90 */
#endif
#ifndef Tcl_CreateCommand
#define Tcl_CreateCommand \
	(tclStubsPtr->tcl_CreateCommand) /* 91 */
#endif
#ifndef Tcl_CreateEventSource
#define Tcl_CreateEventSource \
	(tclStubsPtr->tcl_CreateEventSource) /* 92 */
#endif
#ifndef Tcl_CreateExitHandler
#define Tcl_CreateExitHandler \
	(tclStubsPtr->tcl_CreateExitHandler) /* 93 */
#endif
#ifndef Tcl_CreateInterp
#define Tcl_CreateInterp \
	(tclStubsPtr->tcl_CreateInterp) /* 94 */
#endif
#ifndef Tcl_CreateMathFunc
#define Tcl_CreateMathFunc \
	(tclStubsPtr->tcl_CreateMathFunc) /* 95 */
#endif
#ifndef Tcl_CreateObjCommand
#define Tcl_CreateObjCommand \
	(tclStubsPtr->tcl_CreateObjCommand) /* 96 */
#endif
#ifndef Tcl_CreateSlave
#define Tcl_CreateSlave \
	(tclStubsPtr->tcl_CreateSlave) /* 97 */
#endif
#ifndef Tcl_CreateTimerHandler
#define Tcl_CreateTimerHandler \
	(tclStubsPtr->tcl_CreateTimerHandler) /* 98 */
#endif
#ifndef Tcl_CreateTrace
#define Tcl_CreateTrace \
	(tclStubsPtr->tcl_CreateTrace) /* 99 */
#endif
#ifndef Tcl_DeleteAssocData
#define Tcl_DeleteAssocData \
	(tclStubsPtr->tcl_DeleteAssocData) /* 100 */
#endif
#ifndef Tcl_DeleteChannelHandler
#define Tcl_DeleteChannelHandler \
	(tclStubsPtr->tcl_DeleteChannelHandler) /* 101 */
#endif
#ifndef Tcl_DeleteCloseHandler
#define Tcl_DeleteCloseHandler \
	(tclStubsPtr->tcl_DeleteCloseHandler) /* 102 */
#endif
#ifndef Tcl_DeleteCommand
#define Tcl_DeleteCommand \
	(tclStubsPtr->tcl_DeleteCommand) /* 103 */
#endif
#ifndef Tcl_DeleteCommandFromToken
#define Tcl_DeleteCommandFromToken \
	(tclStubsPtr->tcl_DeleteCommandFromToken) /* 104 */
#endif
#ifndef Tcl_DeleteEvents
#define Tcl_DeleteEvents \
	(tclStubsPtr->tcl_DeleteEvents) /* 105 */
#endif
#ifndef Tcl_DeleteEventSource
#define Tcl_DeleteEventSource \
	(tclStubsPtr->tcl_DeleteEventSource) /* 106 */
#endif
#ifndef Tcl_DeleteExitHandler
#define Tcl_DeleteExitHandler \
	(tclStubsPtr->tcl_DeleteExitHandler) /* 107 */
#endif
#ifndef Tcl_DeleteHashEntry
#define Tcl_DeleteHashEntry \
	(tclStubsPtr->tcl_DeleteHashEntry) /* 108 */
#endif
#ifndef Tcl_DeleteHashTable
#define Tcl_DeleteHashTable \
	(tclStubsPtr->tcl_DeleteHashTable) /* 109 */
#endif
#ifndef Tcl_DeleteInterp
#define Tcl_DeleteInterp \
	(tclStubsPtr->tcl_DeleteInterp) /* 110 */
#endif
#ifndef Tcl_DetachPids
#define Tcl_DetachPids \
	(tclStubsPtr->tcl_DetachPids) /* 111 */
#endif
#ifndef Tcl_DeleteTimerHandler
#define Tcl_DeleteTimerHandler \
	(tclStubsPtr->tcl_DeleteTimerHandler) /* 112 */
#endif
#ifndef Tcl_DeleteTrace
#define Tcl_DeleteTrace \
	(tclStubsPtr->tcl_DeleteTrace) /* 113 */
#endif
#ifndef Tcl_DontCallWhenDeleted
#define Tcl_DontCallWhenDeleted \
	(tclStubsPtr->tcl_DontCallWhenDeleted) /* 114 */
#endif
#ifndef Tcl_DoOneEvent
#define Tcl_DoOneEvent \
	(tclStubsPtr->tcl_DoOneEvent) /* 115 */
#endif
#ifndef Tcl_DoWhenIdle
#define Tcl_DoWhenIdle \
	(tclStubsPtr->tcl_DoWhenIdle) /* 116 */
#endif
#ifndef Tcl_DStringAppend
#define Tcl_DStringAppend \
	(tclStubsPtr->tcl_DStringAppend) /* 117 */
#endif
#ifndef Tcl_DStringAppendElement
#define Tcl_DStringAppendElement \
	(tclStubsPtr->tcl_DStringAppendElement) /* 118 */
#endif
#ifndef Tcl_DStringEndSublist
#define Tcl_DStringEndSublist \
	(tclStubsPtr->tcl_DStringEndSublist) /* 119 */
#endif
#ifndef Tcl_DStringFree
#define Tcl_DStringFree \
	(tclStubsPtr->tcl_DStringFree) /* 120 */
#endif
#ifndef Tcl_DStringGetResult
#define Tcl_DStringGetResult \
	(tclStubsPtr->tcl_DStringGetResult) /* 121 */
#endif
#ifndef Tcl_DStringInit
#define Tcl_DStringInit \
	(tclStubsPtr->tcl_DStringInit) /* 122 */
#endif
#ifndef Tcl_DStringResult
#define Tcl_DStringResult \
	(tclStubsPtr->tcl_DStringResult) /* 123 */
#endif
#ifndef Tcl_DStringSetLength
#define Tcl_DStringSetLength \
	(tclStubsPtr->tcl_DStringSetLength) /* 124 */
#endif
#ifndef Tcl_DStringStartSublist
#define Tcl_DStringStartSublist \
	(tclStubsPtr->tcl_DStringStartSublist) /* 125 */
#endif
#ifndef Tcl_Eof
#define Tcl_Eof \
	(tclStubsPtr->tcl_Eof) /* 126 */
#endif
#ifndef Tcl_ErrnoId
#define Tcl_ErrnoId \
	(tclStubsPtr->tcl_ErrnoId) /* 127 */
#endif
#ifndef Tcl_ErrnoMsg
#define Tcl_ErrnoMsg \
	(tclStubsPtr->tcl_ErrnoMsg) /* 128 */
#endif
#ifndef Tcl_Eval
#define Tcl_Eval \
	(tclStubsPtr->tcl_Eval) /* 129 */
#endif
#ifndef Tcl_EvalFile
#define Tcl_EvalFile \
	(tclStubsPtr->tcl_EvalFile) /* 130 */
#endif
#ifndef Tcl_EvalObj
#define Tcl_EvalObj \
	(tclStubsPtr->tcl_EvalObj) /* 131 */
#endif
#ifndef Tcl_EventuallyFree
#define Tcl_EventuallyFree \
	(tclStubsPtr->tcl_EventuallyFree) /* 132 */
#endif
#ifndef Tcl_Exit
#define Tcl_Exit \
	(tclStubsPtr->tcl_Exit) /* 133 */
#endif
#ifndef Tcl_ExposeCommand
#define Tcl_ExposeCommand \
	(tclStubsPtr->tcl_ExposeCommand) /* 134 */
#endif
#ifndef Tcl_ExprBoolean
#define Tcl_ExprBoolean \
	(tclStubsPtr->tcl_ExprBoolean) /* 135 */
#endif
#ifndef Tcl_ExprBooleanObj
#define Tcl_ExprBooleanObj \
	(tclStubsPtr->tcl_ExprBooleanObj) /* 136 */
#endif
#ifndef Tcl_ExprDouble
#define Tcl_ExprDouble \
	(tclStubsPtr->tcl_ExprDouble) /* 137 */
#endif
#ifndef Tcl_ExprDoubleObj
#define Tcl_ExprDoubleObj \
	(tclStubsPtr->tcl_ExprDoubleObj) /* 138 */
#endif
#ifndef Tcl_ExprLong
#define Tcl_ExprLong \
	(tclStubsPtr->tcl_ExprLong) /* 139 */
#endif
#ifndef Tcl_ExprLongObj
#define Tcl_ExprLongObj \
	(tclStubsPtr->tcl_ExprLongObj) /* 140 */
#endif
#ifndef Tcl_ExprObj
#define Tcl_ExprObj \
	(tclStubsPtr->tcl_ExprObj) /* 141 */
#endif
#ifndef Tcl_ExprString
#define Tcl_ExprString \
	(tclStubsPtr->tcl_ExprString) /* 142 */
#endif
#ifndef Tcl_Finalize
#define Tcl_Finalize \
	(tclStubsPtr->tcl_Finalize) /* 143 */
#endif
#ifndef Tcl_FindExecutable
#define Tcl_FindExecutable \
	(tclStubsPtr->tcl_FindExecutable) /* 144 */
#endif
#ifndef Tcl_FirstHashEntry
#define Tcl_FirstHashEntry \
	(tclStubsPtr->tcl_FirstHashEntry) /* 145 */
#endif
#ifndef Tcl_Flush
#define Tcl_Flush \
	(tclStubsPtr->tcl_Flush) /* 146 */
#endif
#ifndef Tcl_FreeResult
#define Tcl_FreeResult \
	(tclStubsPtr->tcl_FreeResult) /* 147 */
#endif
#ifndef Tcl_GetAlias
#define Tcl_GetAlias \
	(tclStubsPtr->tcl_GetAlias) /* 148 */
#endif
#ifndef Tcl_GetAliasObj
#define Tcl_GetAliasObj \
	(tclStubsPtr->tcl_GetAliasObj) /* 149 */
#endif
#ifndef Tcl_GetAssocData
#define Tcl_GetAssocData \
	(tclStubsPtr->tcl_GetAssocData) /* 150 */
#endif
#ifndef Tcl_GetChannel
#define Tcl_GetChannel \
	(tclStubsPtr->tcl_GetChannel) /* 151 */
#endif
#ifndef Tcl_GetChannelBufferSize
#define Tcl_GetChannelBufferSize \
	(tclStubsPtr->tcl_GetChannelBufferSize) /* 152 */
#endif
#ifndef Tcl_GetChannelHandle
#define Tcl_GetChannelHandle \
	(tclStubsPtr->tcl_GetChannelHandle) /* 153 */
#endif
#ifndef Tcl_GetChannelInstanceData
#define Tcl_GetChannelInstanceData \
	(tclStubsPtr->tcl_GetChannelInstanceData) /* 154 */
#endif
#ifndef Tcl_GetChannelMode
#define Tcl_GetChannelMode \
	(tclStubsPtr->tcl_GetChannelMode) /* 155 */
#endif
#ifndef Tcl_GetChannelName
#define Tcl_GetChannelName \
	(tclStubsPtr->tcl_GetChannelName) /* 156 */
#endif
#ifndef Tcl_GetChannelOption
#define Tcl_GetChannelOption \
	(tclStubsPtr->tcl_GetChannelOption) /* 157 */
#endif
#ifndef Tcl_GetChannelType
#define Tcl_GetChannelType \
	(tclStubsPtr->tcl_GetChannelType) /* 158 */
#endif
#ifndef Tcl_GetCommandInfo
#define Tcl_GetCommandInfo \
	(tclStubsPtr->tcl_GetCommandInfo) /* 159 */
#endif
#ifndef Tcl_GetCommandName
#define Tcl_GetCommandName \
	(tclStubsPtr->tcl_GetCommandName) /* 160 */
#endif
#ifndef Tcl_GetErrno
#define Tcl_GetErrno \
	(tclStubsPtr->tcl_GetErrno) /* 161 */
#endif
#ifndef Tcl_GetHostName
#define Tcl_GetHostName \
	(tclStubsPtr->tcl_GetHostName) /* 162 */
#endif
#ifndef Tcl_GetInterpPath
#define Tcl_GetInterpPath \
	(tclStubsPtr->tcl_GetInterpPath) /* 163 */
#endif
#ifndef Tcl_GetMaster
#define Tcl_GetMaster \
	(tclStubsPtr->tcl_GetMaster) /* 164 */
#endif
#ifndef Tcl_GetNameOfExecutable
#define Tcl_GetNameOfExecutable \
	(tclStubsPtr->tcl_GetNameOfExecutable) /* 165 */
#endif
#ifndef Tcl_GetObjResult
#define Tcl_GetObjResult \
	(tclStubsPtr->tcl_GetObjResult) /* 166 */
#endif
#if !defined(__WIN32__) && !defined(MAC_OSX_TCL) /* UNIX */
#ifndef Tcl_GetOpenFile
#define Tcl_GetOpenFile \
	(tclStubsPtr->tcl_GetOpenFile) /* 167 */
#endif
#endif /* UNIX */
#ifdef MAC_OSX_TCL /* MACOSX */
#ifndef Tcl_GetOpenFile
#define Tcl_GetOpenFile \
	(tclStubsPtr->tcl_GetOpenFile) /* 167 */
#endif
#endif /* MACOSX */
#ifndef Tcl_GetPathType
#define Tcl_GetPathType \
	(tclStubsPtr->tcl_GetPathType) /* 168 */
#endif
#ifndef Tcl_Gets
#define Tcl_Gets \
	(tclStubsPtr->tcl_Gets) /* 169 */
#endif
#ifndef Tcl_GetsObj
#define Tcl_GetsObj \
	(tclStubsPtr->tcl_GetsObj) /* 170 */
#endif
#ifndef Tcl_GetServiceMode
#define Tcl_GetServiceMode \
	(tclStubsPtr->tcl_GetServiceMode) /* 171 */
#endif
#ifndef Tcl_GetSlave
#define Tcl_GetSlave \
	(tclStubsPtr->tcl_GetSlave) /* 172 */
#endif
#ifndef Tcl_GetStdChannel
#define Tcl_GetStdChannel \
	(tclStubsPtr->tcl_GetStdChannel) /* 173 */
#endif
#ifndef Tcl_GetStringResult
#define Tcl_GetStringResult \
	(tclStubsPtr->tcl_GetStringResult) /* 174 */
#endif
#ifndef Tcl_GetVar
#define Tcl_GetVar \
	(tclStubsPtr->tcl_GetVar) /* 175 */
#endif
#ifndef Tcl_GetVar2
#define Tcl_GetVar2 \
	(tclStubsPtr->tcl_GetVar2) /* 176 */
#endif
#ifndef Tcl_GlobalEval
#define Tcl_GlobalEval \
	(tclStubsPtr->tcl_GlobalEval) /* 177 */
#endif
#ifndef Tcl_GlobalEvalObj
#define Tcl_GlobalEvalObj \
	(tclStubsPtr->tcl_GlobalEvalObj) /* 178 */
#endif
#ifndef Tcl_HideCommand
#define Tcl_HideCommand \
	(tclStubsPtr->tcl_HideCommand) /* 179 */
#endif
#ifndef Tcl_Init
#define Tcl_Init \
	(tclStubsPtr->tcl_Init) /* 180 */
#endif
#ifndef Tcl_InitHashTable
#define Tcl_InitHashTable \
	(tclStubsPtr->tcl_InitHashTable) /* 181 */
#endif
#ifndef Tcl_InputBlocked
#define Tcl_InputBlocked \
	(tclStubsPtr->tcl_InputBlocked) /* 182 */
#endif
#ifndef Tcl_InputBuffered
#define Tcl_InputBuffered \
	(tclStubsPtr->tcl_InputBuffered) /* 183 */
#endif
#ifndef Tcl_InterpDeleted
#define Tcl_InterpDeleted \
	(tclStubsPtr->tcl_InterpDeleted) /* 184 */
#endif
#ifndef Tcl_IsSafe
#define Tcl_IsSafe \
	(tclStubsPtr->tcl_IsSafe) /* 185 */
#endif
#ifndef Tcl_JoinPath
#define Tcl_JoinPath \
	(tclStubsPtr->tcl_JoinPath) /* 186 */
#endif
#ifndef Tcl_LinkVar
#define Tcl_LinkVar \
	(tclStubsPtr->tcl_LinkVar) /* 187 */
#endif
/* Slot 188 is reserved */
#ifndef Tcl_MakeFileChannel
#define Tcl_MakeFileChannel \
	(tclStubsPtr->tcl_MakeFileChannel) /* 189 */
#endif
#ifndef Tcl_MakeSafe
#define Tcl_MakeSafe \
	(tclStubsPtr->tcl_MakeSafe) /* 190 */
#endif
#ifndef Tcl_MakeTcpClientChannel
#define Tcl_MakeTcpClientChannel \
	(tclStubsPtr->tcl_MakeTcpClientChannel) /* 191 */
#endif
#ifndef Tcl_Merge
#define Tcl_Merge \
	(tclStubsPtr->tcl_Merge) /* 192 */
#endif
#ifndef Tcl_NextHashEntry
#define Tcl_NextHashEntry \
	(tclStubsPtr->tcl_NextHashEntry) /* 193 */
#endif
#ifndef Tcl_NotifyChannel
#define Tcl_NotifyChannel \
	(tclStubsPtr->tcl_NotifyChannel) /* 194 */
#endif
#ifndef Tcl_ObjGetVar2
#define Tcl_ObjGetVar2 \
	(tclStubsPtr->tcl_ObjGetVar2) /* 195 */
#endif
#ifndef Tcl_ObjSetVar2
#define Tcl_ObjSetVar2 \
	(tclStubsPtr->tcl_ObjSetVar2) /* 196 */
#endif
#ifndef Tcl_OpenCommandChannel
#define Tcl_OpenCommandChannel \
	(tclStubsPtr->tcl_OpenCommandChannel) /* 197 */
#endif
#ifndef Tcl_OpenFileChannel
#define Tcl_OpenFileChannel \
	(tclStubsPtr->tcl_OpenFileChannel) /* 198 */
#endif
#ifndef Tcl_OpenTcpClient
#define Tcl_OpenTcpClient \
	(tclStubsPtr->tcl_OpenTcpClient) /* 199 */
#endif
#ifndef Tcl_OpenTcpServer
#define Tcl_OpenTcpServer \
	(tclStubsPtr->tcl_OpenTcpServer) /* 200 */
#endif
#ifndef Tcl_Preserve
#define Tcl_Preserve \
	(tclStubsPtr->tcl_Preserve) /* 201 */
#endif
#ifndef Tcl_PrintDouble
#define Tcl_PrintDouble \
	(tclStubsPtr->tcl_PrintDouble) /* 202 */
#endif
#ifndef Tcl_PutEnv
#define Tcl_PutEnv \
	(tclStubsPtr->tcl_PutEnv) /* 203 */
#endif
#ifndef Tcl_PosixError
#define Tcl_PosixError \
	(tclStubsPtr->tcl_PosixError) /* 204 */
#endif
#ifndef Tcl_QueueEvent
#define Tcl_QueueEvent \
	(tclStubsPtr->tcl_QueueEvent) /* 205 */
#endif
#ifndef Tcl_Read
#define Tcl_Read \
	(tclStubsPtr->tcl_Read) /* 206 */
#endif
#ifndef Tcl_ReapDetachedProcs
#define Tcl_ReapDetachedProcs \
	(tclStubsPtr->tcl_ReapDetachedProcs) /* 207 */
#endif
#ifndef Tcl_RecordAndEval
#define Tcl_RecordAndEval \
	(tclStubsPtr->tcl_RecordAndEval) /* 208 */
#endif
#ifndef Tcl_RecordAndEvalObj
#define Tcl_RecordAndEvalObj \
	(tclStubsPtr->tcl_RecordAndEvalObj) /* 209 */
#endif
#ifndef Tcl_RegisterChannel
#define Tcl_RegisterChannel \
	(tclStubsPtr->tcl_RegisterChannel) /* 210 */
#endif
#ifndef Tcl_RegisterObjType
#define Tcl_RegisterObjType \
	(tclStubsPtr->tcl_RegisterObjType) /* 211 */
#endif
#ifndef Tcl_RegExpCompile
#define Tcl_RegExpCompile \
	(tclStubsPtr->tcl_RegExpCompile) /* 212 */
#endif
#ifndef Tcl_RegExpExec
#define Tcl_RegExpExec \
	(tclStubsPtr->tcl_RegExpExec) /* 213 */
#endif
#ifndef Tcl_RegExpMatch
#define Tcl_RegExpMatch \
	(tclStubsPtr->tcl_RegExpMatch) /* 214 */
#endif
#ifndef Tcl_RegExpRange
#define Tcl_RegExpRange \
	(tclStubsPtr->tcl_RegExpRange) /* 215 */
#endif
#ifndef Tcl_Release
#define Tcl_Release \
	(tclStubsPtr->tcl_Release) /* 216 */
#endif
#ifndef Tcl_ResetResult
#define Tcl_ResetResult \
	(tclStubsPtr->tcl_ResetResult) /* 217 */
#endif
#ifndef Tcl_ScanElement
#define Tcl_ScanElement \
	(tclStubsPtr->tcl_ScanElement) /* 218 */
#endif
#ifndef Tcl_ScanCountedElement
#define Tcl_ScanCountedElement \
	(tclStubsPtr->tcl_ScanCountedElement) /* 219 */
#endif
#ifndef Tcl_SeekOld
#define Tcl_SeekOld \
	(tclStubsPtr->tcl_SeekOld) /* 220 */
#endif
#ifndef Tcl_ServiceAll
#define Tcl_ServiceAll \
	(tclStubsPtr->tcl_ServiceAll) /* 221 */
#endif
#ifndef Tcl_ServiceEvent
#define Tcl_ServiceEvent \
	(tclStubsPtr->tcl_ServiceEvent) /* 222 */
#endif
#ifndef Tcl_SetAssocData
#define Tcl_SetAssocData \
	(tclStubsPtr->tcl_SetAssocData) /* 223 */
#endif
#ifndef Tcl_SetChannelBufferSize
#define Tcl_SetChannelBufferSize \
	(tclStubsPtr->tcl_SetChannelBufferSize) /* 224 */
#endif
#ifndef Tcl_SetChannelOption
#define Tcl_SetChannelOption \
	(tclStubsPtr->tcl_SetChannelOption) /* 225 */
#endif
#ifndef Tcl_SetCommandInfo
#define Tcl_SetCommandInfo \
	(tclStubsPtr->tcl_SetCommandInfo) /* 226 */
#endif
#ifndef Tcl_SetErrno
#define Tcl_SetErrno \
	(tclStubsPtr->tcl_SetErrno) /* 227 */
#endif
#ifndef Tcl_SetErrorCode
#define Tcl_SetErrorCode \
	(tclStubsPtr->tcl_SetErrorCode) /* 228 */
#endif
#ifndef Tcl_SetMaxBlockTime
#define Tcl_SetMaxBlockTime \
	(tclStubsPtr->tcl_SetMaxBlockTime) /* 229 */
#endif
#ifndef Tcl_SetPanicProc
#define Tcl_SetPanicProc \
	(tclStubsPtr->tcl_SetPanicProc) /* 230 */
#endif
#ifndef Tcl_SetRecursionLimit
#define Tcl_SetRecursionLimit \
	(tclStubsPtr->tcl_SetRecursionLimit) /* 231 */
#endif
#ifndef Tcl_SetResult
#define Tcl_SetResult \
	(tclStubsPtr->tcl_SetResult) /* 232 */
#endif
#ifndef Tcl_SetServiceMode
#define Tcl_SetServiceMode \
	(tclStubsPtr->tcl_SetServiceMode) /* 233 */
#endif
#ifndef Tcl_SetObjErrorCode
#define Tcl_SetObjErrorCode \
	(tclStubsPtr->tcl_SetObjErrorCode) /* 234 */
#endif
#ifndef Tcl_SetObjResult
#define Tcl_SetObjResult \
	(tclStubsPtr->tcl_SetObjResult) /* 235 */
#endif
#ifndef Tcl_SetStdChannel
#define Tcl_SetStdChannel \
	(tclStubsPtr->tcl_SetStdChannel) /* 236 */
#endif
#ifndef Tcl_SetVar
#define Tcl_SetVar \
	(tclStubsPtr->tcl_SetVar) /* 237 */
#endif
#ifndef Tcl_SetVar2
#define Tcl_SetVar2 \
	(tclStubsPtr->tcl_SetVar2) /* 238 */
#endif
#ifndef Tcl_SignalId
#define Tcl_SignalId \
	(tclStubsPtr->tcl_SignalId) /* 239 */
#endif
#ifndef Tcl_SignalMsg
#define Tcl_SignalMsg \
	(tclStubsPtr->tcl_SignalMsg) /* 240 */
#endif
#ifndef Tcl_SourceRCFile
#define Tcl_SourceRCFile \
	(tclStubsPtr->tcl_SourceRCFile) /* 241 */
#endif
#ifndef Tcl_SplitList
#define Tcl_SplitList \
	(tclStubsPtr->tcl_SplitList) /* 242 */
#endif
#ifndef Tcl_SplitPath
#define Tcl_SplitPath \
	(tclStubsPtr->tcl_SplitPath) /* 243 */
#endif
#ifndef Tcl_StaticPackage
#define Tcl_StaticPackage \
	(tclStubsPtr->tcl_StaticPackage) /* 244 */
#endif
#ifndef Tcl_StringMatch
#define Tcl_StringMatch \
	(tclStubsPtr->tcl_StringMatch) /* 245 */
#endif
#ifndef Tcl_TellOld
#define Tcl_TellOld \
	(tclStubsPtr->tcl_TellOld) /* 246 */
#endif
#ifndef Tcl_TraceVar
#define Tcl_TraceVar \
	(tclStubsPtr->tcl_TraceVar) /* 247 */
#endif
#ifndef Tcl_TraceVar2
#define Tcl_TraceVar2 \
	(tclStubsPtr->tcl_TraceVar2) /* 248 */
#endif
#ifndef Tcl_TranslateFileName
#define Tcl_TranslateFileName \
	(tclStubsPtr->tcl_TranslateFileName) /* 249 */
#endif
#ifndef Tcl_Ungets
#define Tcl_Ungets \
	(tclStubsPtr->tcl_Ungets) /* 250 */
#endif
#ifndef Tcl_UnlinkVar
#define Tcl_UnlinkVar \
	(tclStubsPtr->tcl_UnlinkVar) /* 251 */
#endif
#ifndef Tcl_UnregisterChannel
#define Tcl_UnregisterChannel \
	(tclStubsPtr->tcl_UnregisterChannel) /* 252 */
#endif
#ifndef Tcl_UnsetVar
#define Tcl_UnsetVar \
	(tclStubsPtr->tcl_UnsetVar) /* 253 */
#endif
#ifndef Tcl_UnsetVar2
#define Tcl_UnsetVar2 \
	(tclStubsPtr->tcl_UnsetVar2) /* 254 */
#endif
#ifndef Tcl_UntraceVar
#define Tcl_UntraceVar \
	(tclStubsPtr->tcl_UntraceVar) /* 255 */
#endif
#ifndef Tcl_UntraceVar2
#define Tcl_UntraceVar2 \
	(tclStubsPtr->tcl_UntraceVar2) /* 256 */
#endif
#ifndef Tcl_UpdateLinkedVar
#define Tcl_UpdateLinkedVar \
	(tclStubsPtr->tcl_UpdateLinkedVar) /* 257 */
#endif
#ifndef Tcl_UpVar
#define Tcl_UpVar \
	(tclStubsPtr->tcl_UpVar) /* 258 */
#endif
#ifndef Tcl_UpVar2
#define Tcl_UpVar2 \
	(tclStubsPtr->tcl_UpVar2) /* 259 */
#endif
#ifndef Tcl_VarEval
#define Tcl_VarEval \
	(tclStubsPtr->tcl_VarEval) /* 260 */
#endif
#ifndef Tcl_VarTraceInfo
#define Tcl_VarTraceInfo \
	(tclStubsPtr->tcl_VarTraceInfo) /* 261 */
#endif
#ifndef Tcl_VarTraceInfo2
#define Tcl_VarTraceInfo2 \
	(tclStubsPtr->tcl_VarTraceInfo2) /* 262 */
#endif
#ifndef Tcl_Write
#define Tcl_Write \
	(tclStubsPtr->tcl_Write) /* 263 */
#endif
#ifndef Tcl_WrongNumArgs
#define Tcl_WrongNumArgs \
	(tclStubsPtr->tcl_WrongNumArgs) /* 264 */
#endif
#ifndef Tcl_DumpActiveMemory
#define Tcl_DumpActiveMemory \
	(tclStubsPtr->tcl_DumpActiveMemory) /* 265 */
#endif
#ifndef Tcl_ValidateAllMemory
#define Tcl_ValidateAllMemory \
	(tclStubsPtr->tcl_ValidateAllMemory) /* 266 */
#endif
#ifndef Tcl_AppendResultVA
#define Tcl_AppendResultVA \
	(tclStubsPtr->tcl_AppendResultVA) /* 267 */
#endif
#ifndef Tcl_AppendStringsToObjVA
#define Tcl_AppendStringsToObjVA \
	(tclStubsPtr->tcl_AppendStringsToObjVA) /* 268 */
#endif
#ifndef Tcl_HashStats
#define Tcl_HashStats \
	(tclStubsPtr->tcl_HashStats) /* 269 */
#endif
#ifndef Tcl_ParseVar
#define Tcl_ParseVar \
	(tclStubsPtr->tcl_ParseVar) /* 270 */
#endif
#ifndef Tcl_PkgPresent
#define Tcl_PkgPresent \
	(tclStubsPtr->tcl_PkgPresent) /* 271 */
#endif
#ifndef Tcl_PkgPresentEx
#define Tcl_PkgPresentEx \
	(tclStubsPtr->tcl_PkgPresentEx) /* 272 */
#endif
#ifndef Tcl_PkgProvide
#define Tcl_PkgProvide \
	(tclStubsPtr->tcl_PkgProvide) /* 273 */
#endif
#ifndef Tcl_PkgRequire
#define Tcl_PkgRequire \
	(tclStubsPtr->tcl_PkgRequire) /* 274 */
#endif
#ifndef Tcl_SetErrorCodeVA
#define Tcl_SetErrorCodeVA \
	(tclStubsPtr->tcl_SetErrorCodeVA) /* 275 */
#endif
#ifndef Tcl_VarEvalVA
#define Tcl_VarEvalVA \
	(tclStubsPtr->tcl_VarEvalVA) /* 276 */
#endif
#ifndef Tcl_WaitPid
#define Tcl_WaitPid \
	(tclStubsPtr->tcl_WaitPid) /* 277 */
#endif
#ifndef Tcl_PanicVA
#define Tcl_PanicVA \
	(tclStubsPtr->tcl_PanicVA) /* 278 */
#endif
#ifndef Tcl_GetVersion
#define Tcl_GetVersion \
	(tclStubsPtr->tcl_GetVersion) /* 279 */
#endif
#ifndef Tcl_InitMemory
#define Tcl_InitMemory \
	(tclStubsPtr->tcl_InitMemory) /* 280 */
#endif
#ifndef Tcl_StackChannel
#define Tcl_StackChannel \
	(tclStubsPtr->tcl_StackChannel) /* 281 */
#endif
#ifndef Tcl_UnstackChannel
#define Tcl_UnstackChannel \
	(tclStubsPtr->tcl_UnstackChannel) /* 282 */
#endif
#ifndef Tcl_GetStackedChannel
#define Tcl_GetStackedChannel \
	(tclStubsPtr->tcl_GetStackedChannel) /* 283 */
#endif
#ifndef Tcl_SetMainLoop
#define Tcl_SetMainLoop \
	(tclStubsPtr->tcl_SetMainLoop) /* 284 */
#endif
/* Slot 285 is reserved */
#ifndef Tcl_AppendObjToObj
#define Tcl_AppendObjToObj \
	(tclStubsPtr->tcl_AppendObjToObj) /* 286 */
#endif
#ifndef Tcl_CreateEncoding
#define Tcl_CreateEncoding \
	(tclStubsPtr->tcl_CreateEncoding) /* 287 */
#endif
#ifndef Tcl_CreateThreadExitHandler
#define Tcl_CreateThreadExitHandler \
	(tclStubsPtr->tcl_CreateThreadExitHandler) /* 288 */
#endif
#ifndef Tcl_DeleteThreadExitHandler
#define Tcl_DeleteThreadExitHandler \
	(tclStubsPtr->tcl_DeleteThreadExitHandler) /* 289 */
#endif
#ifndef Tcl_DiscardResult
#define Tcl_DiscardResult \
	(tclStubsPtr->tcl_DiscardResult) /* 290 */
#endif
#ifndef Tcl_EvalEx
#define Tcl_EvalEx \
	(tclStubsPtr->tcl_EvalEx) /* 291 */
#endif
#ifndef Tcl_EvalObjv
#define Tcl_EvalObjv \
	(tclStubsPtr->tcl_EvalObjv) /* 292 */
#endif
#ifndef Tcl_EvalObjEx
#define Tcl_EvalObjEx \
	(tclStubsPtr->tcl_EvalObjEx) /* 293 */
#endif
#ifndef Tcl_ExitThread
#define Tcl_ExitThread \
	(tclStubsPtr->tcl_ExitThread) /* 294 */
#endif
#ifndef Tcl_ExternalToUtf
#define Tcl_ExternalToUtf \
	(tclStubsPtr->tcl_ExternalToUtf) /* 295 */
#endif
#ifndef Tcl_ExternalToUtfDString
#define Tcl_ExternalToUtfDString \
	(tclStubsPtr->tcl_ExternalToUtfDString) /* 296 */
#endif
#ifndef Tcl_FinalizeThread
#define Tcl_FinalizeThread \
	(tclStubsPtr->tcl_FinalizeThread) /* 297 */
#endif
#ifndef Tcl_FinalizeNotifier
#define Tcl_FinalizeNotifier \
	(tclStubsPtr->tcl_FinalizeNotifier) /* 298 */
#endif
#ifndef Tcl_FreeEncoding
#define Tcl_FreeEncoding \
	(tclStubsPtr->tcl_FreeEncoding) /* 299 */
#endif
#ifndef Tcl_GetCurrentThread
#define Tcl_GetCurrentThread \
	(tclStubsPtr->tcl_GetCurrentThread) /* 300 */
#endif
#ifndef Tcl_GetEncoding
#define Tcl_GetEncoding \
	(tclStubsPtr->tcl_GetEncoding) /* 301 */
#endif
#ifndef Tcl_GetEncodingName
#define Tcl_GetEncodingName \
	(tclStubsPtr->tcl_GetEncodingName) /* 302 */
#endif
#ifndef Tcl_GetEncodingNames
#define Tcl_GetEncodingNames \
	(tclStubsPtr->tcl_GetEncodingNames) /* 303 */
#endif
#ifndef Tcl_GetIndexFromObjStruct
#define Tcl_GetIndexFromObjStruct \
	(tclStubsPtr->tcl_GetIndexFromObjStruct) /* 304 */
#endif
#ifndef Tcl_GetThreadData
#define Tcl_GetThreadData \
	(tclStubsPtr->tcl_GetThreadData) /* 305 */
#endif
#ifndef Tcl_GetVar2Ex
#define Tcl_GetVar2Ex \
	(tclStubsPtr->tcl_GetVar2Ex) /* 306 */
#endif
#ifndef Tcl_InitNotifier
#define Tcl_InitNotifier \
	(tclStubsPtr->tcl_InitNotifier) /* 307 */
#endif
#ifndef Tcl_MutexLock
#define Tcl_MutexLock \
	(tclStubsPtr->tcl_MutexLock) /* 308 */
#endif
#ifndef Tcl_MutexUnlock
#define Tcl_MutexUnlock \
	(tclStubsPtr->tcl_MutexUnlock) /* 309 */
#endif
#ifndef Tcl_ConditionNotify
#define Tcl_ConditionNotify \
	(tclStubsPtr->tcl_ConditionNotify) /* 310 */
#endif
#ifndef Tcl_ConditionWait
#define Tcl_ConditionWait \
	(tclStubsPtr->tcl_ConditionWait) /* 311 */
#endif
#ifndef Tcl_NumUtfChars
#define Tcl_NumUtfChars \
	(tclStubsPtr->tcl_NumUtfChars) /* 312 */
#endif
#ifndef Tcl_ReadChars
#define Tcl_ReadChars \
	(tclStubsPtr->tcl_ReadChars) /* 313 */
#endif
#ifndef Tcl_RestoreResult
#define Tcl_RestoreResult \
	(tclStubsPtr->tcl_RestoreResult) /* 314 */
#endif
#ifndef Tcl_SaveResult
#define Tcl_SaveResult \
	(tclStubsPtr->tcl_SaveResult) /* 315 */
#endif
#ifndef Tcl_SetSystemEncoding
#define Tcl_SetSystemEncoding \
	(tclStubsPtr->tcl_SetSystemEncoding) /* 316 */
#endif
#ifndef Tcl_SetVar2Ex
#define Tcl_SetVar2Ex \
	(tclStubsPtr->tcl_SetVar2Ex) /* 317 */
#endif
#ifndef Tcl_ThreadAlert
#define Tcl_ThreadAlert \
	(tclStubsPtr->tcl_ThreadAlert) /* 318 */
#endif
#ifndef Tcl_ThreadQueueEvent
#define Tcl_ThreadQueueEvent \
	(tclStubsPtr->tcl_ThreadQueueEvent) /* 319 */
#endif
#ifndef Tcl_UniCharAtIndex
#define Tcl_UniCharAtIndex \
	(tclStubsPtr->tcl_UniCharAtIndex) /* 320 */
#endif
#ifndef Tcl_UniCharToLower
#define Tcl_UniCharToLower \
	(tclStubsPtr->tcl_UniCharToLower) /* 321 */
#endif
#ifndef Tcl_UniCharToTitle
#define Tcl_UniCharToTitle \
	(tclStubsPtr->tcl_UniCharToTitle) /* 322 */
#endif
#ifndef Tcl_UniCharToUpper
#define Tcl_UniCharToUpper \
	(tclStubsPtr->tcl_UniCharToUpper) /* 323 */
#endif
#ifndef Tcl_UniCharToUtf
#define Tcl_UniCharToUtf \
	(tclStubsPtr->tcl_UniCharToUtf) /* 324 */
#endif
#ifndef Tcl_UtfAtIndex
#define Tcl_UtfAtIndex \
	(tclStubsPtr->tcl_UtfAtIndex) /* 325 */
#endif
#ifndef Tcl_UtfCharComplete
#define Tcl_UtfCharComplete \
	(tclStubsPtr->tcl_UtfCharComplete) /* 326 */
#endif
#ifndef Tcl_UtfBackslash
#define Tcl_UtfBackslash \
	(tclStubsPtr->tcl_UtfBackslash) /* 327 */
#endif
#ifndef Tcl_UtfFindFirst
#define Tcl_UtfFindFirst \
	(tclStubsPtr->tcl_UtfFindFirst) /* 328 */
#endif
#ifndef Tcl_UtfFindLast
#define Tcl_UtfFindLast \
	(tclStubsPtr->tcl_UtfFindLast) /* 329 */
#endif
#ifndef Tcl_UtfNext
#define Tcl_UtfNext \
	(tclStubsPtr->tcl_UtfNext) /* 330 */
#endif
#ifndef Tcl_UtfPrev
#define Tcl_UtfPrev \
	(tclStubsPtr->tcl_UtfPrev) /* 331 */
#endif
#ifndef Tcl_UtfToExternal
#define Tcl_UtfToExternal \
	(tclStubsPtr->tcl_UtfToExternal) /* 332 */
#endif
#ifndef Tcl_UtfToExternalDString
#define Tcl_UtfToExternalDString \
	(tclStubsPtr->tcl_UtfToExternalDString) /* 333 */
#endif
#ifndef Tcl_UtfToLower
#define Tcl_UtfToLower \
	(tclStubsPtr->tcl_UtfToLower) /* 334 */
#endif
#ifndef Tcl_UtfToTitle
#define Tcl_UtfToTitle \
	(tclStubsPtr->tcl_UtfToTitle) /* 335 */
#endif
#ifndef Tcl_UtfToUniChar
#define Tcl_UtfToUniChar \
	(tclStubsPtr->tcl_UtfToUniChar) /* 336 */
#endif
#ifndef Tcl_UtfToUpper
#define Tcl_UtfToUpper \
	(tclStubsPtr->tcl_UtfToUpper) /* 337 */
#endif
#ifndef Tcl_WriteChars
#define Tcl_WriteChars \
	(tclStubsPtr->tcl_WriteChars) /* 338 */
#endif
#ifndef Tcl_WriteObj
#define Tcl_WriteObj \
	(tclStubsPtr->tcl_WriteObj) /* 339 */
#endif
#ifndef Tcl_GetString
#define Tcl_GetString \
	(tclStubsPtr->tcl_GetString) /* 340 */
#endif
#ifndef Tcl_GetDefaultEncodingDir
#define Tcl_GetDefaultEncodingDir \
	(tclStubsPtr->tcl_GetDefaultEncodingDir) /* 341 */
#endif
#ifndef Tcl_SetDefaultEncodingDir
#define Tcl_SetDefaultEncodingDir \
	(tclStubsPtr->tcl_SetDefaultEncodingDir) /* 342 */
#endif
#ifndef Tcl_AlertNotifier
#define Tcl_AlertNotifier \
	(tclStubsPtr->tcl_AlertNotifier) /* 343 */
#endif
#ifndef Tcl_ServiceModeHook
#define Tcl_ServiceModeHook \
	(tclStubsPtr->tcl_ServiceModeHook) /* 344 */
#endif
#ifndef Tcl_UniCharIsAlnum
#define Tcl_UniCharIsAlnum \
	(tclStubsPtr->tcl_UniCharIsAlnum) /* 345 */
#endif
#ifndef Tcl_UniCharIsAlpha
#define Tcl_UniCharIsAlpha \
	(tclStubsPtr->tcl_UniCharIsAlpha) /* 346 */
#endif
#ifndef Tcl_UniCharIsDigit
#define Tcl_UniCharIsDigit \
	(tclStubsPtr->tcl_UniCharIsDigit) /* 347 */
#endif
#ifndef Tcl_UniCharIsLower
#define Tcl_UniCharIsLower \
	(tclStubsPtr->tcl_UniCharIsLower) /* 348 */
#endif
#ifndef Tcl_UniCharIsSpace
#define Tcl_UniCharIsSpace \
	(tclStubsPtr->tcl_UniCharIsSpace) /* 349 */
#endif
#ifndef Tcl_UniCharIsUpper
#define Tcl_UniCharIsUpper \
	(tclStubsPtr->tcl_UniCharIsUpper) /* 350 */
#endif
#ifndef Tcl_UniCharIsWordChar
#define Tcl_UniCharIsWordChar \
	(tclStubsPtr->tcl_UniCharIsWordChar) /* 351 */
#endif
#ifndef Tcl_UniCharLen
#define Tcl_UniCharLen \
	(tclStubsPtr->tcl_UniCharLen) /* 352 */
#endif
#ifndef Tcl_UniCharNcmp
#define Tcl_UniCharNcmp \
	(tclStubsPtr->tcl_UniCharNcmp) /* 353 */
#endif
#ifndef Tcl_UniCharToUtfDString
#define Tcl_UniCharToUtfDString \
	(tclStubsPtr->tcl_UniCharToUtfDString) /* 354 */
#endif
#ifndef Tcl_UtfToUniCharDString
#define Tcl_UtfToUniCharDString \
	(tclStubsPtr->tcl_UtfToUniCharDString) /* 355 */
#endif
#ifndef Tcl_GetRegExpFromObj
#define Tcl_GetRegExpFromObj \
	(tclStubsPtr->tcl_GetRegExpFromObj) /* 356 */
#endif
#ifndef Tcl_EvalTokens
#define Tcl_EvalTokens \
	(tclStubsPtr->tcl_EvalTokens) /* 357 */
#endif
#ifndef Tcl_FreeParse
#define Tcl_FreeParse \
	(tclStubsPtr->tcl_FreeParse) /* 358 */
#endif
#ifndef Tcl_LogCommandInfo
#define Tcl_LogCommandInfo \
	(tclStubsPtr->tcl_LogCommandInfo) /* 359 */
#endif
#ifndef Tcl_ParseBraces
#define Tcl_ParseBraces \
	(tclStubsPtr->tcl_ParseBraces) /* 360 */
#endif
#ifndef Tcl_ParseCommand
#define Tcl_ParseCommand \
	(tclStubsPtr->tcl_ParseCommand) /* 361 */
#endif
#ifndef Tcl_ParseExpr
#define Tcl_ParseExpr \
	(tclStubsPtr->tcl_ParseExpr) /* 362 */
#endif
#ifndef Tcl_ParseQuotedString
#define Tcl_ParseQuotedString \
	(tclStubsPtr->tcl_ParseQuotedString) /* 363 */
#endif
#ifndef Tcl_ParseVarName
#define Tcl_ParseVarName \
	(tclStubsPtr->tcl_ParseVarName) /* 364 */
#endif
#ifndef Tcl_GetCwd
#define Tcl_GetCwd \
	(tclStubsPtr->tcl_GetCwd) /* 365 */
#endif
#ifndef Tcl_Chdir
#define Tcl_Chdir \
	(tclStubsPtr->tcl_Chdir) /* 366 */
#endif
#ifndef Tcl_Access
#define Tcl_Access \
	(tclStubsPtr->tcl_Access) /* 367 */
#endif
#ifndef Tcl_Stat
#define Tcl_Stat \
	(tclStubsPtr->tcl_Stat) /* 368 */
#endif
#ifndef Tcl_UtfNcmp
#define Tcl_UtfNcmp \
	(tclStubsPtr->tcl_UtfNcmp) /* 369 */
#endif
#ifndef Tcl_UtfNcasecmp
#define Tcl_UtfNcasecmp \
	(tclStubsPtr->tcl_UtfNcasecmp) /* 370 */
#endif
#ifndef Tcl_StringCaseMatch
#define Tcl_StringCaseMatch \
	(tclStubsPtr->tcl_StringCaseMatch) /* 371 */
#endif
#ifndef Tcl_UniCharIsControl
#define Tcl_UniCharIsControl \
	(tclStubsPtr->tcl_UniCharIsControl) /* 372 */
#endif
#ifndef Tcl_UniCharIsGraph
#define Tcl_UniCharIsGraph \
	(tclStubsPtr->tcl_UniCharIsGraph) /* 373 */
#endif
#ifndef Tcl_UniCharIsPrint
#define Tcl_UniCharIsPrint \
	(tclStubsPtr->tcl_UniCharIsPrint) /* 374 */
#endif
#ifndef Tcl_UniCharIsPunct
#define Tcl_UniCharIsPunct \
	(tclStubsPtr->tcl_UniCharIsPunct) /* 375 */
#endif
#ifndef Tcl_RegExpExecObj
#define Tcl_RegExpExecObj \
	(tclStubsPtr->tcl_RegExpExecObj) /* 376 */
#endif
#ifndef Tcl_RegExpGetInfo
#define Tcl_RegExpGetInfo \
	(tclStubsPtr->tcl_RegExpGetInfo) /* 377 */
#endif
#ifndef Tcl_NewUnicodeObj
#define Tcl_NewUnicodeObj \
	(tclStubsPtr->tcl_NewUnicodeObj) /* 378 */
#endif
#ifndef Tcl_SetUnicodeObj
#define Tcl_SetUnicodeObj \
	(tclStubsPtr->tcl_SetUnicodeObj) /* 379 */
#endif
#ifndef Tcl_GetCharLength
#define Tcl_GetCharLength \
	(tclStubsPtr->tcl_GetCharLength) /* 380 */
#endif
#ifndef Tcl_GetUniChar
#define Tcl_GetUniChar \
	(tclStubsPtr->tcl_GetUniChar) /* 381 */
#endif
#ifndef Tcl_GetUnicode
#define Tcl_GetUnicode \
	(tclStubsPtr->tcl_GetUnicode) /* 382 */
#endif
#ifndef Tcl_GetRange
#define Tcl_GetRange \
	(tclStubsPtr->tcl_GetRange) /* 383 */
#endif
#ifndef Tcl_AppendUnicodeToObj
#define Tcl_AppendUnicodeToObj \
	(tclStubsPtr->tcl_AppendUnicodeToObj) /* 384 */
#endif
#ifndef Tcl_RegExpMatchObj
#define Tcl_RegExpMatchObj \
	(tclStubsPtr->tcl_RegExpMatchObj) /* 385 */
#endif
#ifndef Tcl_SetNotifier
#define Tcl_SetNotifier \
	(tclStubsPtr->tcl_SetNotifier) /* 386 */
#endif
#ifndef Tcl_GetAllocMutex
#define Tcl_GetAllocMutex \
	(tclStubsPtr->tcl_GetAllocMutex) /* 387 */
#endif
#ifndef Tcl_GetChannelNames
#define Tcl_GetChannelNames \
	(tclStubsPtr->tcl_GetChannelNames) /* 388 */
#endif
#ifndef Tcl_GetChannelNamesEx
#define Tcl_GetChannelNamesEx \
	(tclStubsPtr->tcl_GetChannelNamesEx) /* 389 */
#endif
#ifndef Tcl_ProcObjCmd
#define Tcl_ProcObjCmd \
	(tclStubsPtr->tcl_ProcObjCmd) /* 390 */
#endif
#ifndef Tcl_ConditionFinalize
#define Tcl_ConditionFinalize \
	(tclStubsPtr->tcl_ConditionFinalize) /* 391 */
#endif
#ifndef Tcl_MutexFinalize
#define Tcl_MutexFinalize \
	(tclStubsPtr->tcl_MutexFinalize) /* 392 */
#endif
#ifndef Tcl_CreateThread
#define Tcl_CreateThread \
	(tclStubsPtr->tcl_CreateThread) /* 393 */
#endif
#ifndef Tcl_ReadRaw
#define Tcl_ReadRaw \
	(tclStubsPtr->tcl_ReadRaw) /* 394 */
#endif
#ifndef Tcl_WriteRaw
#define Tcl_WriteRaw \
	(tclStubsPtr->tcl_WriteRaw) /* 395 */
#endif
#ifndef Tcl_GetTopChannel
#define Tcl_GetTopChannel \
	(tclStubsPtr->tcl_GetTopChannel) /* 396 */
#endif
#ifndef Tcl_ChannelBuffered
#define Tcl_ChannelBuffered \
	(tclStubsPtr->tcl_ChannelBuffered) /* 397 */
#endif
#ifndef Tcl_ChannelName
#define Tcl_ChannelName \
	(tclStubsPtr->tcl_ChannelName) /* 398 */
#endif
#ifndef Tcl_ChannelVersion
#define Tcl_ChannelVersion \
	(tclStubsPtr->tcl_ChannelVersion) /* 399 */
#endif
#ifndef Tcl_ChannelBlockModeProc
#define Tcl_ChannelBlockModeProc \
	(tclStubsPtr->tcl_ChannelBlockModeProc) /* 400 */
#endif
#ifndef Tcl_ChannelCloseProc
#define Tcl_ChannelCloseProc \
	(tclStubsPtr->tcl_ChannelCloseProc) /* 401 */
#endif
#ifndef Tcl_ChannelClose2Proc
#define Tcl_ChannelClose2Proc \
	(tclStubsPtr->tcl_ChannelClose2Proc) /* 402 */
#endif
#ifndef Tcl_ChannelInputProc
#define Tcl_ChannelInputProc \
	(tclStubsPtr->tcl_ChannelInputProc) /* 403 */
#endif
#ifndef Tcl_ChannelOutputProc
#define Tcl_ChannelOutputProc \
	(tclStubsPtr->tcl_ChannelOutputProc) /* 404 */
#endif
#ifndef Tcl_ChannelSeekProc
#define Tcl_ChannelSeekProc \
	(tclStubsPtr->tcl_ChannelSeekProc) /* 405 */
#endif
#ifndef Tcl_ChannelSetOptionProc
#define Tcl_ChannelSetOptionProc \
	(tclStubsPtr->tcl_ChannelSetOptionProc) /* 406 */
#endif
#ifndef Tcl_ChannelGetOptionProc
#define Tcl_ChannelGetOptionProc \
	(tclStubsPtr->tcl_ChannelGetOptionProc) /* 407 */
#endif
#ifndef Tcl_ChannelWatchProc
#define Tcl_ChannelWatchProc \
	(tclStubsPtr->tcl_ChannelWatchProc) /* 408 */
#endif
#ifndef Tcl_ChannelGetHandleProc
#define Tcl_ChannelGetHandleProc \
	(tclStubsPtr->tcl_ChannelGetHandleProc) /* 409 */
#endif
#ifndef Tcl_ChannelFlushProc
#define Tcl_ChannelFlushProc \
	(tclStubsPtr->tcl_ChannelFlushProc) /* 410 */
#endif
#ifndef Tcl_ChannelHandlerProc
#define Tcl_ChannelHandlerProc \
	(tclStubsPtr->tcl_ChannelHandlerProc) /* 411 */
#endif
#ifndef Tcl_JoinThread
#define Tcl_JoinThread \
	(tclStubsPtr->tcl_JoinThread) /* 412 */
#endif
#ifndef Tcl_IsChannelShared
#define Tcl_IsChannelShared \
	(tclStubsPtr->tcl_IsChannelShared) /* 413 */
#endif
#ifndef Tcl_IsChannelRegistered
#define Tcl_IsChannelRegistered \
	(tclStubsPtr->tcl_IsChannelRegistered) /* 414 */
#endif
#ifndef Tcl_CutChannel
#define Tcl_CutChannel \
	(tclStubsPtr->tcl_CutChannel) /* 415 */
#endif
#ifndef Tcl_SpliceChannel
#define Tcl_SpliceChannel \
	(tclStubsPtr->tcl_SpliceChannel) /* 416 */
#endif
#ifndef Tcl_ClearChannelHandlers
#define Tcl_ClearChannelHandlers \
	(tclStubsPtr->tcl_ClearChannelHandlers) /* 417 */
#endif
#ifndef Tcl_IsChannelExisting
#define Tcl_IsChannelExisting \
	(tclStubsPtr->tcl_IsChannelExisting) /* 418 */
#endif
#ifndef Tcl_UniCharNcasecmp
#define Tcl_UniCharNcasecmp \
	(tclStubsPtr->tcl_UniCharNcasecmp) /* 419 */
#endif
#ifndef Tcl_UniCharCaseMatch
#define Tcl_UniCharCaseMatch \
	(tclStubsPtr->tcl_UniCharCaseMatch) /* 420 */
#endif
#ifndef Tcl_FindHashEntry
#define Tcl_FindHashEntry \
	(tclStubsPtr->tcl_FindHashEntry) /* 421 */
#endif
#ifndef Tcl_CreateHashEntry
#define Tcl_CreateHashEntry \
	(tclStubsPtr->tcl_CreateHashEntry) /* 422 */
#endif
#ifndef Tcl_InitCustomHashTable
#define Tcl_InitCustomHashTable \
	(tclStubsPtr->tcl_InitCustomHashTable) /* 423 */
#endif
#ifndef Tcl_InitObjHashTable
#define Tcl_InitObjHashTable \
	(tclStubsPtr->tcl_InitObjHashTable) /* 424 */
#endif
#ifndef Tcl_CommandTraceInfo
#define Tcl_CommandTraceInfo \
	(tclStubsPtr->tcl_CommandTraceInfo) /* 425 */
#endif
#ifndef Tcl_TraceCommand
#define Tcl_TraceCommand \
	(tclStubsPtr->tcl_TraceCommand) /* 426 */
#endif
#ifndef Tcl_UntraceCommand
#define Tcl_UntraceCommand \
	(tclStubsPtr->tcl_UntraceCommand) /* 427 */
#endif
#ifndef Tcl_AttemptAlloc
#define Tcl_AttemptAlloc \
	(tclStubsPtr->tcl_AttemptAlloc) /* 428 */
#endif
#ifndef Tcl_AttemptDbCkalloc
#define Tcl_AttemptDbCkalloc \
	(tclStubsPtr->tcl_AttemptDbCkalloc) /* 429 */
#endif
#ifndef Tcl_AttemptRealloc
#define Tcl_AttemptRealloc \
	(tclStubsPtr->tcl_AttemptRealloc) /* 430 */
#endif
#ifndef Tcl_AttemptDbCkrealloc
#define Tcl_AttemptDbCkrealloc \
	(tclStubsPtr->tcl_AttemptDbCkrealloc) /* 431 */
#endif
#ifndef Tcl_AttemptSetObjLength
#define Tcl_AttemptSetObjLength \
	(tclStubsPtr->tcl_AttemptSetObjLength) /* 432 */
#endif
#ifndef Tcl_GetChannelThread
#define Tcl_GetChannelThread \
	(tclStubsPtr->tcl_GetChannelThread) /* 433 */
#endif
#ifndef Tcl_GetUnicodeFromObj
#define Tcl_GetUnicodeFromObj \
	(tclStubsPtr->tcl_GetUnicodeFromObj) /* 434 */
#endif
#ifndef Tcl_GetMathFuncInfo
#define Tcl_GetMathFuncInfo \
	(tclStubsPtr->tcl_GetMathFuncInfo) /* 435 */
#endif
#ifndef Tcl_ListMathFuncs
#define Tcl_ListMathFuncs \
	(tclStubsPtr->tcl_ListMathFuncs) /* 436 */
#endif
#ifndef Tcl_SubstObj
#define Tcl_SubstObj \
	(tclStubsPtr->tcl_SubstObj) /* 437 */
#endif
#ifndef Tcl_DetachChannel
#define Tcl_DetachChannel \
	(tclStubsPtr->tcl_DetachChannel) /* 438 */
#endif
#ifndef Tcl_IsStandardChannel
#define Tcl_IsStandardChannel \
	(tclStubsPtr->tcl_IsStandardChannel) /* 439 */
#endif
#ifndef Tcl_FSCopyFile
#define Tcl_FSCopyFile \
	(tclStubsPtr->tcl_FSCopyFile) /* 440 */
#endif
#ifndef Tcl_FSCopyDirectory
#define Tcl_FSCopyDirectory \
	(tclStubsPtr->tcl_FSCopyDirectory) /* 441 */
#endif
#ifndef Tcl_FSCreateDirectory
#define Tcl_FSCreateDirectory \
	(tclStubsPtr->tcl_FSCreateDirectory) /* 442 */
#endif
#ifndef Tcl_FSDeleteFile
#define Tcl_FSDeleteFile \
	(tclStubsPtr->tcl_FSDeleteFile) /* 443 */
#endif
#ifndef Tcl_FSLoadFile
#define Tcl_FSLoadFile \
	(tclStubsPtr->tcl_FSLoadFile) /* 444 */
#endif
#ifndef Tcl_FSMatchInDirectory
#define Tcl_FSMatchInDirectory \
	(tclStubsPtr->tcl_FSMatchInDirectory) /* 445 */
#endif
#ifndef Tcl_FSLink
#define Tcl_FSLink \
	(tclStubsPtr->tcl_FSLink) /* 446 */
#endif
#ifndef Tcl_FSRemoveDirectory
#define Tcl_FSRemoveDirectory \
	(tclStubsPtr->tcl_FSRemoveDirectory) /* 447 */
#endif
#ifndef Tcl_FSRenameFile
#define Tcl_FSRenameFile \
	(tclStubsPtr->tcl_FSRenameFile) /* 448 */
#endif
#ifndef Tcl_FSLstat
#define Tcl_FSLstat \
	(tclStubsPtr->tcl_FSLstat) /* 449 */
#endif
#ifndef Tcl_FSUtime
#define Tcl_FSUtime \
	(tclStubsPtr->tcl_FSUtime) /* 450 */
#endif
#ifndef Tcl_FSFileAttrsGet
#define Tcl_FSFileAttrsGet \
	(tclStubsPtr->tcl_FSFileAttrsGet) /* 451 */
#endif
#ifndef Tcl_FSFileAttrsSet
#define Tcl_FSFileAttrsSet \
	(tclStubsPtr->tcl_FSFileAttrsSet) /* 452 */
#endif
#ifndef Tcl_FSFileAttrStrings
#define Tcl_FSFileAttrStrings \
	(tclStubsPtr->tcl_FSFileAttrStrings) /* 453 */
#endif
#ifndef Tcl_FSStat
#define Tcl_FSStat \
	(tclStubsPtr->tcl_FSStat) /* 454 */
#endif
#ifndef Tcl_FSAccess
#define Tcl_FSAccess \
	(tclStubsPtr->tcl_FSAccess) /* 455 */
#endif
#ifndef Tcl_FSOpenFileChannel
#define Tcl_FSOpenFileChannel \
	(tclStubsPtr->tcl_FSOpenFileChannel) /* 456 */
#endif
#ifndef Tcl_FSGetCwd
#define Tcl_FSGetCwd \
	(tclStubsPtr->tcl_FSGetCwd) /* 457 */
#endif
#ifndef Tcl_FSChdir
#define Tcl_FSChdir \
	(tclStubsPtr->tcl_FSChdir) /* 458 */
#endif
#ifndef Tcl_FSConvertToPathType
#define Tcl_FSConvertToPathType \
	(tclStubsPtr->tcl_FSConvertToPathType) /* 459 */
#endif
#ifndef Tcl_FSJoinPath
#define Tcl_FSJoinPath \
	(tclStubsPtr->tcl_FSJoinPath) /* 460 */
#endif
#ifndef Tcl_FSSplitPath
#define Tcl_FSSplitPath \
	(tclStubsPtr->tcl_FSSplitPath) /* 461 */
#endif
#ifndef Tcl_FSEqualPaths
#define Tcl_FSEqualPaths \
	(tclStubsPtr->tcl_FSEqualPaths) /* 462 */
#endif
#ifndef Tcl_FSGetNormalizedPath
#define Tcl_FSGetNormalizedPath \
	(tclStubsPtr->tcl_FSGetNormalizedPath) /* 463 */
#endif
#ifndef Tcl_FSJoinToPath
#define Tcl_FSJoinToPath \
	(tclStubsPtr->tcl_FSJoinToPath) /* 464 */
#endif
#ifndef Tcl_FSGetInternalRep
#define Tcl_FSGetInternalRep \
	(tclStubsPtr->tcl_FSGetInternalRep) /* 465 */
#endif
#ifndef Tcl_FSGetTranslatedPath
#define Tcl_FSGetTranslatedPath \
	(tclStubsPtr->tcl_FSGetTranslatedPath) /* 466 */
#endif
#ifndef Tcl_FSEvalFile
#define Tcl_FSEvalFile \
	(tclStubsPtr->tcl_FSEvalFile) /* 467 */
#endif
#ifndef Tcl_FSNewNativePath
#define Tcl_FSNewNativePath \
	(tclStubsPtr->tcl_FSNewNativePath) /* 468 */
#endif
#ifndef Tcl_FSGetNativePath
#define Tcl_FSGetNativePath \
	(tclStubsPtr->tcl_FSGetNativePath) /* 469 */
#endif
#ifndef Tcl_FSFileSystemInfo
#define Tcl_FSFileSystemInfo \
	(tclStubsPtr->tcl_FSFileSystemInfo) /* 470 */
#endif
#ifndef Tcl_FSPathSeparator
#define Tcl_FSPathSeparator \
	(tclStubsPtr->tcl_FSPathSeparator) /* 471 */
#endif
#ifndef Tcl_FSListVolumes
#define Tcl_FSListVolumes \
	(tclStubsPtr->tcl_FSListVolumes) /* 472 */
#endif
#ifndef Tcl_FSRegister
#define Tcl_FSRegister \
	(tclStubsPtr->tcl_FSRegister) /* 473 */
#endif
#ifndef Tcl_FSUnregister
#define Tcl_FSUnregister \
	(tclStubsPtr->tcl_FSUnregister) /* 474 */
#endif
#ifndef Tcl_FSData
#define Tcl_FSData \
	(tclStubsPtr->tcl_FSData) /* 475 */
#endif
#ifndef Tcl_FSGetTranslatedStringPath
#define Tcl_FSGetTranslatedStringPath \
	(tclStubsPtr->tcl_FSGetTranslatedStringPath) /* 476 */
#endif
#ifndef Tcl_FSGetFileSystemForPath
#define Tcl_FSGetFileSystemForPath \
	(tclStubsPtr->tcl_FSGetFileSystemForPath) /* 477 */
#endif
#ifndef Tcl_FSGetPathType
#define Tcl_FSGetPathType \
	(tclStubsPtr->tcl_FSGetPathType) /* 478 */
#endif
#ifndef Tcl_OutputBuffered
#define Tcl_OutputBuffered \
	(tclStubsPtr->tcl_OutputBuffered) /* 479 */
#endif
#ifndef Tcl_FSMountsChanged
#define Tcl_FSMountsChanged \
	(tclStubsPtr->tcl_FSMountsChanged) /* 480 */
#endif
#ifndef Tcl_EvalTokensStandard
#define Tcl_EvalTokensStandard \
	(tclStubsPtr->tcl_EvalTokensStandard) /* 481 */
#endif
#ifndef Tcl_GetTime
#define Tcl_GetTime \
	(tclStubsPtr->tcl_GetTime) /* 482 */
#endif
#ifndef Tcl_CreateObjTrace
#define Tcl_CreateObjTrace \
	(tclStubsPtr->tcl_CreateObjTrace) /* 483 */
#endif
#ifndef Tcl_GetCommandInfoFromToken
#define Tcl_GetCommandInfoFromToken \
	(tclStubsPtr->tcl_GetCommandInfoFromToken) /* 484 */
#endif
#ifndef Tcl_SetCommandInfoFromToken
#define Tcl_SetCommandInfoFromToken \
	(tclStubsPtr->tcl_SetCommandInfoFromToken) /* 485 */
#endif
#ifndef Tcl_DbNewWideIntObj
#define Tcl_DbNewWideIntObj \
	(tclStubsPtr->tcl_DbNewWideIntObj) /* 486 */
#endif
#ifndef Tcl_GetWideIntFromObj
#define Tcl_GetWideIntFromObj \
	(tclStubsPtr->tcl_GetWideIntFromObj) /* 487 */
#endif
#ifndef Tcl_NewWideIntObj
#define Tcl_NewWideIntObj \
	(tclStubsPtr->tcl_NewWideIntObj) /* 488 */
#endif
#ifndef Tcl_SetWideIntObj
#define Tcl_SetWideIntObj \
	(tclStubsPtr->tcl_SetWideIntObj) /* 489 */
#endif
#ifndef Tcl_AllocStatBuf
#define Tcl_AllocStatBuf \
	(tclStubsPtr->tcl_AllocStatBuf) /* 490 */
#endif
#ifndef Tcl_Seek
#define Tcl_Seek \
	(tclStubsPtr->tcl_Seek) /* 491 */
#endif
#ifndef Tcl_Tell
#define Tcl_Tell \
	(tclStubsPtr->tcl_Tell) /* 492 */
#endif
#ifndef Tcl_ChannelWideSeekProc
#define Tcl_ChannelWideSeekProc \
	(tclStubsPtr->tcl_ChannelWideSeekProc) /* 493 */
#endif
#ifndef Tcl_DictObjPut
#define Tcl_DictObjPut \
	(tclStubsPtr->tcl_DictObjPut) /* 494 */
#endif
#ifndef Tcl_DictObjGet
#define Tcl_DictObjGet \
	(tclStubsPtr->tcl_DictObjGet) /* 495 */
#endif
#ifndef Tcl_DictObjRemove
#define Tcl_DictObjRemove \
	(tclStubsPtr->tcl_DictObjRemove) /* 496 */
#endif
#ifndef Tcl_DictObjSize
#define Tcl_DictObjSize \
	(tclStubsPtr->tcl_DictObjSize) /* 497 */
#endif
#ifndef Tcl_DictObjFirst
#define Tcl_DictObjFirst \
	(tclStubsPtr->tcl_DictObjFirst) /* 498 */
#endif
#ifndef Tcl_DictObjNext
#define Tcl_DictObjNext \
	(tclStubsPtr->tcl_DictObjNext) /* 499 */
#endif
#ifndef Tcl_DictObjDone
#define Tcl_DictObjDone \
	(tclStubsPtr->tcl_DictObjDone) /* 500 */
#endif
#ifndef Tcl_DictObjPutKeyList
#define Tcl_DictObjPutKeyList \
	(tclStubsPtr->tcl_DictObjPutKeyList) /* 501 */
#endif
#ifndef Tcl_DictObjRemoveKeyList
#define Tcl_DictObjRemoveKeyList \
	(tclStubsPtr->tcl_DictObjRemoveKeyList) /* 502 */
#endif
#ifndef Tcl_NewDictObj
#define Tcl_NewDictObj \
	(tclStubsPtr->tcl_NewDictObj) /* 503 */
#endif
#ifndef Tcl_DbNewDictObj
#define Tcl_DbNewDictObj \
	(tclStubsPtr->tcl_DbNewDictObj) /* 504 */
#endif
#ifndef Tcl_RegisterConfig
#define Tcl_RegisterConfig \
	(tclStubsPtr->tcl_RegisterConfig) /* 505 */
#endif
#ifndef Tcl_CreateNamespace
#define Tcl_CreateNamespace \
	(tclStubsPtr->tcl_CreateNamespace) /* 506 */
#endif
#ifndef Tcl_DeleteNamespace
#define Tcl_DeleteNamespace \
	(tclStubsPtr->tcl_DeleteNamespace) /* 507 */
#endif
#ifndef Tcl_AppendExportList
#define Tcl_AppendExportList \
	(tclStubsPtr->tcl_AppendExportList) /* 508 */
#endif
#ifndef Tcl_Export
#define Tcl_Export \
	(tclStubsPtr->tcl_Export) /* 509 */
#endif
#ifndef Tcl_Import
#define Tcl_Import \
	(tclStubsPtr->tcl_Import) /* 510 */
#endif
#ifndef Tcl_ForgetImport
#define Tcl_ForgetImport \
	(tclStubsPtr->tcl_ForgetImport) /* 511 */
#endif
#ifndef Tcl_GetCurrentNamespace
#define Tcl_GetCurrentNamespace \
	(tclStubsPtr->tcl_GetCurrentNamespace) /* 512 */
#endif
#ifndef Tcl_GetGlobalNamespace
#define Tcl_GetGlobalNamespace \
	(tclStubsPtr->tcl_GetGlobalNamespace) /* 513 */
#endif
#ifndef Tcl_FindNamespace
#define Tcl_FindNamespace \
	(tclStubsPtr->tcl_FindNamespace) /* 514 */
#endif
#ifndef Tcl_FindCommand
#define Tcl_FindCommand \
	(tclStubsPtr->tcl_FindCommand) /* 515 */
#endif
#ifndef Tcl_GetCommandFromObj
#define Tcl_GetCommandFromObj \
	(tclStubsPtr->tcl_GetCommandFromObj) /* 516 */
#endif
#ifndef Tcl_GetCommandFullName
#define Tcl_GetCommandFullName \
	(tclStubsPtr->tcl_GetCommandFullName) /* 517 */
#endif
#ifndef Tcl_FSEvalFileEx
#define Tcl_FSEvalFileEx \
	(tclStubsPtr->tcl_FSEvalFileEx) /* 518 */
#endif
#ifndef Tcl_SetExitProc
#define Tcl_SetExitProc \
	(tclStubsPtr->tcl_SetExitProc) /* 519 */
#endif
#ifndef Tcl_LimitAddHandler
#define Tcl_LimitAddHandler \
	(tclStubsPtr->tcl_LimitAddHandler) /* 520 */
#endif
#ifndef Tcl_LimitRemoveHandler
#define Tcl_LimitRemoveHandler \
	(tclStubsPtr->tcl_LimitRemoveHandler) /* 521 */
#endif
#ifndef Tcl_LimitReady
#define Tcl_LimitReady \
	(tclStubsPtr->tcl_LimitReady) /* 522 */
#endif
#ifndef Tcl_LimitCheck
#define Tcl_LimitCheck \
	(tclStubsPtr->tcl_LimitCheck) /* 523 */
#endif
#ifndef Tcl_LimitExceeded
#define Tcl_LimitExceeded \
	(tclStubsPtr->tcl_LimitExceeded) /* 524 */
#endif
#ifndef Tcl_LimitSetCommands
#define Tcl_LimitSetCommands \
	(tclStubsPtr->tcl_LimitSetCommands) /* 525 */
#endif
#ifndef Tcl_LimitSetTime
#define Tcl_LimitSetTime \
	(tclStubsPtr->tcl_LimitSetTime) /* 526 */
#endif
#ifndef Tcl_LimitSetGranularity
#define Tcl_LimitSetGranularity \
	(tclStubsPtr->tcl_LimitSetGranularity) /* 527 */
#endif
#ifndef Tcl_LimitTypeEnabled
#define Tcl_LimitTypeEnabled \
	(tclStubsPtr->tcl_LimitTypeEnabled) /* 528 */
#endif
#ifndef Tcl_LimitTypeExceeded
#define Tcl_LimitTypeExceeded \
	(tclStubsPtr->tcl_LimitTypeExceeded) /* 529 */
#endif
#ifndef Tcl_LimitTypeSet
#define Tcl_LimitTypeSet \
	(tclStubsPtr->tcl_LimitTypeSet) /* 530 */
#endif
#ifndef Tcl_LimitTypeReset
#define Tcl_LimitTypeReset \
	(tclStubsPtr->tcl_LimitTypeReset) /* 531 */
#endif
#ifndef Tcl_LimitGetCommands
#define Tcl_LimitGetCommands \
	(tclStubsPtr->tcl_LimitGetCommands) /* 532 */
#endif
#ifndef Tcl_LimitGetTime
#define Tcl_LimitGetTime \
	(tclStubsPtr->tcl_LimitGetTime) /* 533 */
#endif
#ifndef Tcl_LimitGetGranularity
#define Tcl_LimitGetGranularity \
	(tclStubsPtr->tcl_LimitGetGranularity) /* 534 */
#endif
#ifndef Tcl_SaveInterpState
#define Tcl_SaveInterpState \
	(tclStubsPtr->tcl_SaveInterpState) /* 535 */
#endif
#ifndef Tcl_RestoreInterpState
#define Tcl_RestoreInterpState \
	(tclStubsPtr->tcl_RestoreInterpState) /* 536 */
#endif
#ifndef Tcl_DiscardInterpState
#define Tcl_DiscardInterpState \
	(tclStubsPtr->tcl_DiscardInterpState) /* 537 */
#endif
#ifndef Tcl_SetReturnOptions
#define Tcl_SetReturnOptions \
	(tclStubsPtr->tcl_SetReturnOptions) /* 538 */
#endif
#ifndef Tcl_GetReturnOptions
#define Tcl_GetReturnOptions \
	(tclStubsPtr->tcl_GetReturnOptions) /* 539 */
#endif
#ifndef Tcl_IsEnsemble
#define Tcl_IsEnsemble \
	(tclStubsPtr->tcl_IsEnsemble) /* 540 */
#endif
#ifndef Tcl_CreateEnsemble
#define Tcl_CreateEnsemble \
	(tclStubsPtr->tcl_CreateEnsemble) /* 541 */
#endif
#ifndef Tcl_FindEnsemble
#define Tcl_FindEnsemble \
	(tclStubsPtr->tcl_FindEnsemble) /* 542 */
#endif
#ifndef Tcl_SetEnsembleSubcommandList
#define Tcl_SetEnsembleSubcommandList \
	(tclStubsPtr->tcl_SetEnsembleSubcommandList) /* 543 */
#endif
#ifndef Tcl_SetEnsembleMappingDict
#define Tcl_SetEnsembleMappingDict \
	(tclStubsPtr->tcl_SetEnsembleMappingDict) /* 544 */
#endif
#ifndef Tcl_SetEnsembleUnknownHandler
#define Tcl_SetEnsembleUnknownHandler \
	(tclStubsPtr->tcl_SetEnsembleUnknownHandler) /* 545 */
#endif
#ifndef Tcl_SetEnsembleFlags
#define Tcl_SetEnsembleFlags \
	(tclStubsPtr->tcl_SetEnsembleFlags) /* 546 */
#endif
#ifndef Tcl_GetEnsembleSubcommandList
#define Tcl_GetEnsembleSubcommandList \
	(tclStubsPtr->tcl_GetEnsembleSubcommandList) /* 547 */
#endif
#ifndef Tcl_GetEnsembleMappingDict
#define Tcl_GetEnsembleMappingDict \
	(tclStubsPtr->tcl_GetEnsembleMappingDict) /* 548 */
#endif
#ifndef Tcl_GetEnsembleUnknownHandler
#define Tcl_GetEnsembleUnknownHandler \
	(tclStubsPtr->tcl_GetEnsembleUnknownHandler) /* 549 */
#endif
#ifndef Tcl_GetEnsembleFlags
#define Tcl_GetEnsembleFlags \
	(tclStubsPtr->tcl_GetEnsembleFlags) /* 550 */
#endif
#ifndef Tcl_GetEnsembleNamespace
#define Tcl_GetEnsembleNamespace \
	(tclStubsPtr->tcl_GetEnsembleNamespace) /* 551 */
#endif
#ifndef Tcl_SetTimeProc
#define Tcl_SetTimeProc \
	(tclStubsPtr->tcl_SetTimeProc) /* 552 */
#endif
#ifndef Tcl_QueryTimeProc
#define Tcl_QueryTimeProc \
	(tclStubsPtr->tcl_QueryTimeProc) /* 553 */
#endif
#ifndef Tcl_ChannelThreadActionProc
#define Tcl_ChannelThreadActionProc \
	(tclStubsPtr->tcl_ChannelThreadActionProc) /* 554 */
#endif
#ifndef Tcl_NewBignumObj
#define Tcl_NewBignumObj \
	(tclStubsPtr->tcl_NewBignumObj) /* 555 */
#endif
#ifndef Tcl_DbNewBignumObj
#define Tcl_DbNewBignumObj \
	(tclStubsPtr->tcl_DbNewBignumObj) /* 556 */
#endif
#ifndef Tcl_SetBignumObj
#define Tcl_SetBignumObj \
	(tclStubsPtr->tcl_SetBignumObj) /* 557 */
#endif
#ifndef Tcl_GetBignumFromObj
#define Tcl_GetBignumFromObj \
	(tclStubsPtr->tcl_GetBignumFromObj) /* 558 */
#endif
#ifndef Tcl_TakeBignumFromObj
#define Tcl_TakeBignumFromObj \
	(tclStubsPtr->tcl_TakeBignumFromObj) /* 559 */
#endif
#ifndef Tcl_TruncateChannel
#define Tcl_TruncateChannel \
	(tclStubsPtr->tcl_TruncateChannel) /* 560 */
#endif
#ifndef Tcl_ChannelTruncateProc
#define Tcl_ChannelTruncateProc \
	(tclStubsPtr->tcl_ChannelTruncateProc) /* 561 */
#endif
#ifndef Tcl_SetChannelErrorInterp
#define Tcl_SetChannelErrorInterp \
	(tclStubsPtr->tcl_SetChannelErrorInterp) /* 562 */
#endif
#ifndef Tcl_GetChannelErrorInterp
#define Tcl_GetChannelErrorInterp \
	(tclStubsPtr->tcl_GetChannelErrorInterp) /* 563 */
#endif
#ifndef Tcl_SetChannelError
#define Tcl_SetChannelError \
	(tclStubsPtr->tcl_SetChannelError) /* 564 */
#endif
#ifndef Tcl_GetChannelError
#define Tcl_GetChannelError \
	(tclStubsPtr->tcl_GetChannelError) /* 565 */
#endif
#ifndef Tcl_InitBignumFromDouble
#define Tcl_InitBignumFromDouble \
	(tclStubsPtr->tcl_InitBignumFromDouble) /* 566 */
#endif
#ifndef Tcl_GetNamespaceUnknownHandler
#define Tcl_GetNamespaceUnknownHandler \
	(tclStubsPtr->tcl_GetNamespaceUnknownHandler) /* 567 */
#endif
#ifndef Tcl_SetNamespaceUnknownHandler
#define Tcl_SetNamespaceUnknownHandler \
	(tclStubsPtr->tcl_SetNamespaceUnknownHandler) /* 568 */
#endif
#ifndef Tcl_GetEncodingFromObj
#define Tcl_GetEncodingFromObj \
	(tclStubsPtr->tcl_GetEncodingFromObj) /* 569 */
#endif
#ifndef Tcl_GetEncodingSearchPath
#define Tcl_GetEncodingSearchPath \
	(tclStubsPtr->tcl_GetEncodingSearchPath) /* 570 */
#endif
#ifndef Tcl_SetEncodingSearchPath
#define Tcl_SetEncodingSearchPath \
	(tclStubsPtr->tcl_SetEncodingSearchPath) /* 571 */
#endif
#ifndef Tcl_GetEncodingNameFromEnvironment
#define Tcl_GetEncodingNameFromEnvironment \
	(tclStubsPtr->tcl_GetEncodingNameFromEnvironment) /* 572 */
#endif
#ifndef Tcl_PkgRequireProc
#define Tcl_PkgRequireProc \
	(tclStubsPtr->tcl_PkgRequireProc) /* 573 */
#endif
#ifndef Tcl_AppendObjToErrorInfo
#define Tcl_AppendObjToErrorInfo \
	(tclStubsPtr->tcl_AppendObjToErrorInfo) /* 574 */
#endif
#ifndef Tcl_AppendLimitedToObj
#define Tcl_AppendLimitedToObj \
	(tclStubsPtr->tcl_AppendLimitedToObj) /* 575 */
#endif
#ifndef Tcl_Format
#define Tcl_Format \
	(tclStubsPtr->tcl_Format) /* 576 */
#endif
#ifndef Tcl_AppendFormatToObj
#define Tcl_AppendFormatToObj \
	(tclStubsPtr->tcl_AppendFormatToObj) /* 577 */
#endif
#ifndef Tcl_ObjPrintf
#define Tcl_ObjPrintf \
	(tclStubsPtr->tcl_ObjPrintf) /* 578 */
#endif
#ifndef Tcl_AppendPrintfToObj
#define Tcl_AppendPrintfToObj \
	(tclStubsPtr->tcl_AppendPrintfToObj) /* 579 */
#endif
/* Slot 580 is reserved */
/* Slot 581 is reserved */
/* Slot 582 is reserved */
/* Slot 583 is reserved */
/* Slot 584 is reserved */
/* Slot 585 is reserved */
/* Slot 586 is reserved */
/* Slot 587 is reserved */
/* Slot 588 is reserved */
/* Slot 589 is reserved */
/* Slot 590 is reserved */
/* Slot 591 is reserved */
/* Slot 592 is reserved */
/* Slot 593 is reserved */
/* Slot 594 is reserved */
/* Slot 595 is reserved */
/* Slot 596 is reserved */
/* Slot 597 is reserved */
/* Slot 598 is reserved */
/* Slot 599 is reserved */
/* Slot 600 is reserved */
/* Slot 601 is reserved */
/* Slot 602 is reserved */
/* Slot 603 is reserved */
/* Slot 604 is reserved */
/* Slot 605 is reserved */
/* Slot 606 is reserved */
/* Slot 607 is reserved */
/* Slot 608 is reserved */
/* Slot 609 is reserved */
/* Slot 610 is reserved */
/* Slot 611 is reserved */
/* Slot 612 is reserved */
/* Slot 613 is reserved */
/* Slot 614 is reserved */
/* Slot 615 is reserved */
/* Slot 616 is reserved */
/* Slot 617 is reserved */
/* Slot 618 is reserved */
/* Slot 619 is reserved */
/* Slot 620 is reserved */
/* Slot 621 is reserved */
/* Slot 622 is reserved */
/* Slot 623 is reserved */
/* Slot 624 is reserved */
/* Slot 625 is reserved */
/* Slot 626 is reserved */
/* Slot 627 is reserved */
/* Slot 628 is reserved */
/* Slot 629 is reserved */
#ifndef TclUnusedStubEntry
#define TclUnusedStubEntry \
	(tclStubsPtr->tclUnusedStubEntry) /* 630 */
#endif

#endif /* defined(USE_TCL_STUBS) && !defined(USE_TCL_STUB_PROCS) */

/* !END!: Do not edit above this line. */

#undef TclUnusedStubEntry

#undef TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS DLLIMPORT

#undef Tcl_PkgPresent
#define Tcl_PkgPresent(interp, name, version, exact) \
	Tcl_PkgPresentEx(interp, name, version, exact, NULL)
#undef Tcl_PkgProvide
#define Tcl_PkgProvide(interp, name, version) \
	Tcl_PkgProvideEx(interp, name, version, NULL)
#undef Tcl_PkgRequire
#define Tcl_PkgRequire(interp, name, version, exact) \
	Tcl_PkgRequireEx(interp, name, version, exact, NULL)
#undef Tcl_GetIndexFromObj
#define Tcl_GetIndexFromObj(interp, objPtr, tablePtr, msg, flags, indexPtr) \
	Tcl_GetIndexFromObjStruct(interp, objPtr, tablePtr, \
	sizeof(char *), msg, flags, indexPtr)
#undef Tcl_NewBooleanObj
#define Tcl_NewBooleanObj(boolValue) \
	Tcl_NewIntObj((boolValue)!=0)
#undef Tcl_DbNewBooleanObj
#define Tcl_DbNewBooleanObj(boolValue, file, line) \
	Tcl_DbNewLongObj((boolValue)!=0, file, line)
#undef Tcl_SetBooleanObj
#define Tcl_SetBooleanObj(objPtr, boolValue) \
	Tcl_SetIntObj((objPtr), (boolValue)!=0)
#undef Tcl_SetVar
#define Tcl_SetVar(interp, varName, newValue, flags) \
	Tcl_SetVar2(interp, varName, NULL, newValue, flags)
#undef Tcl_UnsetVar
#define Tcl_UnsetVar(interp, varName, flags) \
	Tcl_UnsetVar2(interp, varName, NULL, flags)
#undef Tcl_GetVar
#define Tcl_GetVar(interp, varName, flags) \
	Tcl_GetVar2(interp, varName, NULL, flags)
#undef Tcl_TraceVar
#define Tcl_TraceVar(interp, varName, flags, proc, clientData) \
	Tcl_TraceVar2(interp, varName, NULL, flags, proc, clientData)
#undef Tcl_UntraceVar
#define Tcl_UntraceVar(interp, varName, flags, proc, clientData) \
	Tcl_UntraceVar2(interp, varName, NULL, flags, proc, clientData)
#undef Tcl_VarTraceInfo
#define Tcl_VarTraceInfo(interp, varName, flags, proc, prevClientData) \
	Tcl_VarTraceInfo2(interp, varName, NULL, flags, proc, prevClientData)
#undef Tcl_UpVar
#define Tcl_UpVar(interp, frameName, varName, localName, flags) \
	Tcl_UpVar2(interp, frameName, varName, NULL, localName, flags)

#if defined(USE_TCL_STUBS) && !defined(USE_TCL_STUB_PROCS)
#   if defined(__CYGWIN__) && defined(TCL_WIDE_INT_IS_LONG)
/* On Cygwin64, long is 64-bit while on Win64 long is 32-bit. Therefore
 * we have to make sure that all stub entries on Cygwin64 follow the
 * Win64 signature. Cygwin64 stubbed extensions cannot use those stub
 * entries any more, they should use the 64-bit alternatives where
 * possible. Tcl 9 must find a better solution, but that cannot be done
 * without introducing a binary incompatibility.
 */
#	undef Tcl_DbNewLongObj
#	undef Tcl_GetLongFromObj
#	undef Tcl_NewLongObj
#	undef Tcl_SetLongObj
#	undef Tcl_ExprLong
#	undef Tcl_ExprLongObj
#	undef Tcl_UniCharNcmp
#	undef Tcl_UtfNcmp
#	undef Tcl_UtfNcasecmp
#	undef Tcl_UniCharNcasecmp
#	define Tcl_DbNewLongObj ((Tcl_Obj*(*)(long,const char*,int))Tcl_DbNewWideIntObj)
#	define Tcl_GetLongFromObj ((int(*)(Tcl_Interp*,Tcl_Obj*,long*))Tcl_GetWideIntFromObj)
#	define Tcl_NewLongObj ((Tcl_Obj*(*)(long))Tcl_NewWideIntObj)
#	define Tcl_SetLongObj ((void(*)(Tcl_Obj*,long))Tcl_SetWideIntObj)
#	define Tcl_ExprLong TclExprLong
	static inline int TclExprLong(Tcl_Interp *interp, const char *string, long *ptr){
	    int intValue;
	    int result = tclStubsPtr->tcl_ExprLong(interp, string, (long *)&intValue);
	    if (result == TCL_OK) *ptr = (long)intValue;
	    return result;
	}
#	define Tcl_ExprLongObj TclExprLongObj
	static inline int TclExprLongObj(Tcl_Interp *interp, Tcl_Obj *obj, long *ptr){
	    int intValue;
	    int result = tclStubsPtr->tcl_ExprLongObj(interp, obj, (long *)&intValue);
	    if (result == TCL_OK) *ptr = (long)intValue;
	    return result;
	}
#	define Tcl_UniCharNcmp(ucs,uct,n) \
		((int(*)(const Tcl_UniChar*,const Tcl_UniChar*,unsigned int))tclStubsPtr->tcl_UniCharNcmp)(ucs,uct,(unsigned int)(n))
#	define Tcl_UtfNcmp(s1,s2,n) \
		((int(*)(const char*,const char*,unsigned int))tclStubsPtr->tcl_UtfNcmp)(s1,s2,(unsigned int)(n))
#	define Tcl_UtfNcasecmp(s1,s2,n) \
		((int(*)(const char*,const char*,unsigned int))tclStubsPtr->tcl_UtfNcasecmp)(s1,s2,(unsigned int)(n))
#	define Tcl_UniCharNcasecmp(ucs,uct,n) \
		((int(*)(const Tcl_UniChar*,const Tcl_UniChar*,unsigned int))tclStubsPtr->tcl_UniCharNcasecmp)(ucs,uct,(unsigned int)(n))
#   endif
#endif

/*
 * Deprecated Tcl procedures:
 */

#undef Tcl_EvalObj
#define Tcl_EvalObj(interp,objPtr) \
    Tcl_EvalObjEx((interp),(objPtr),0)
#undef Tcl_GlobalEvalObj
#define Tcl_GlobalEvalObj(interp,objPtr) \
    Tcl_EvalObjEx((interp),(objPtr),TCL_EVAL_GLOBAL)

#endif /* _TCLDECLS */
