% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_style.R
\name{label_style}
\alias{label_style}
\alias{label_style_number}
\alias{label_style_sigfig}
\alias{label_style_pvalue}
\alias{label_style_ratio}
\alias{label_style_percent}
\title{Style Functions}
\usage{
label_style_number(
  digits = 0,
  big.mark = ifelse(decimal.mark == ",", " ", ","),
  decimal.mark = getOption("OutDec"),
  scale = 1,
  ...
)

label_style_sigfig(
  digits = 2,
  scale = 1,
  big.mark = ifelse(decimal.mark == ",", " ", ","),
  decimal.mark = getOption("OutDec"),
  ...
)

label_style_pvalue(
  digits = 1,
  prepend_p = FALSE,
  big.mark = ifelse(decimal.mark == ",", " ", ","),
  decimal.mark = getOption("OutDec"),
  ...
)

label_style_ratio(
  digits = 2,
  big.mark = ifelse(decimal.mark == ",", " ", ","),
  decimal.mark = getOption("OutDec"),
  ...
)

label_style_percent(
  symbol = FALSE,
  digits = 0,
  big.mark = ifelse(decimal.mark == ",", " ", ","),
  decimal.mark = getOption("OutDec"),
  ...
)
}
\arguments{
\item{digits, big.mark, decimal.mark, scale, prepend_p, symbol, ...}{arguments
passed to the \verb{style_*()} functions}
}
\value{
a function
}
\description{
Similar to the \verb{style_*()} family of functions, but these functions return
a \verb{style_*()} \strong{function} rather than performing the styling.
}
\examples{
my_style <- label_style_number(digits = 1)
my_style(3.14)
}
\seealso{
Other style tools: 
\code{\link{style_sigfig}()}
}
\concept{style tools}
