/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.IOException;
import org.jcodings.Encoding;
import org.jruby.ast.RegexpNode;
import org.jruby.lexer.LexingCommon;
import org.jruby.lexer.yacc.RubyLexer;
import org.jruby.lexer.yacc.StrTerm;
import org.jruby.util.ByteList;
import org.jruby.util.RegexpOptions;

public class StringTerm
extends StrTerm {
    private int flags;
    private final char begin;
    private final char end;
    private final int startLine;
    private int nest;

    public StringTerm(int flags2, int begin2, int end2, int startLine) {
        this.flags = flags2;
        this.begin = (char)begin2;
        this.end = (char)end2;
        this.nest = 0;
        this.startLine = startLine;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    private int endFound(RubyLexer lexer) throws IOException {
        if ((this.flags & 8) != 0) {
            this.flags |= 0x8000;
            lexer.pushback(0);
            return 32;
        }
        lexer.setStrTerm(null);
        if ((this.flags & 4) != 0) {
            RegexpOptions options2 = lexer.parseRegexpFlags();
            ByteList regexpBytelist = ByteList.create("");
            lexer.setState(2);
            lexer.setValue(new RegexpNode(lexer.getRubySourceline(), regexpBytelist, options2));
            return 383;
        }
        if ((this.flags & 0x40) != 0 && lexer.isLabelSuffix()) {
            lexer.nextc();
            lexer.setState(1025);
            return 388;
        }
        lexer.setState(2);
        lexer.setValue(String.valueOf(this.end));
        return 373;
    }

    @Override
    public int parseString(RubyLexer lexer) throws IOException {
        boolean spaceSeen = false;
        if ((this.flags & 0x8000) != 0) {
            if ((this.flags & 8) != 0) {
                lexer.nextc();
            }
            lexer.setState(2);
            lexer.setValue(String.valueOf(this.end));
            lexer.setStrTerm(null);
            return (this.flags & 4) != 0 ? 383 : 373;
        }
        int c = lexer.nextc();
        if ((this.flags & 8) != 0 && Character.isWhitespace(c)) {
            while (Character.isWhitespace(c = lexer.nextc())) {
            }
            spaceSeen = true;
        }
        if ((this.flags & 0x4000) != 0) {
            this.flags &= 0xFFFFBFFF;
            spaceSeen = true;
        }
        if (c == this.end && this.nest == 0) {
            return this.endFound(lexer);
        }
        if (spaceSeen) {
            lexer.pushback(c);
            return 32;
        }
        ByteList buffer = new ByteList(15);
        lexer.newtok(true);
        if ((this.flags & 2) != 0 && c == 35) {
            int token = lexer.peekVariableName(372, 371);
            if (token != 0) {
                return token;
            }
            buffer.append(35);
        }
        lexer.pushback(c);
        boolean[] encodingDetermined = new boolean[]{false};
        if (this.parseStringIntoBuffer(lexer, buffer, lexer.getEncoding(), encodingDetermined) == -1) {
            lexer.setRubySourceline(this.startLine);
            lexer.compile_error("unterminated " + ((this.flags & 4) != 0 ? "regexp" : "string") + " meets end of file");
        }
        lexer.setValue(lexer.createStr(buffer, this.flags));
        return 378;
    }

    private void mixedEscape(RubyLexer lexer, Encoding foundEncoding, Encoding parserEncoding) {
        lexer.compile_error("" + foundEncoding + " mixed within " + parserEncoding + " source");
    }

    /*
     * Enabled aggressive block sorting
     */
    public int parseStringIntoBuffer(RubyLexer lexer, ByteList buffer, Encoding encoding2, boolean[] encodingDetermined) throws IOException {
        int c;
        boolean qwords = (this.flags & 8) != 0;
        boolean expand = (this.flags & 2) != 0;
        boolean escape2 = (this.flags & 1) != 0;
        boolean regexp2 = (this.flags & 4) != 0;
        boolean indent = (this.flags & 0x20) != 0;
        boolean hasNonAscii = false;
        block5: while ((c = lexer.nextc()) != -1) {
            block34: {
                block38: {
                    block37: {
                        block36: {
                            block35: {
                                if (lexer.getHeredocIndent() > 0) {
                                    lexer.update_heredoc_indent(c);
                                }
                                if (this.begin == '\u0000' || c != this.begin) break block35;
                                ++this.nest;
                                break block34;
                            }
                            if (c != this.end) break block36;
                            if (this.nest == 0) {
                                lexer.pushback(c);
                                break;
                            }
                            --this.nest;
                            break block34;
                        }
                        if (!expand || c != 35 || lexer.peek(10)) break block37;
                        int c2 = lexer.nextc();
                        if (c2 == 36 || c2 == 64 || c2 == 123) {
                            lexer.pushback(c2);
                            lexer.pushback(c);
                            break;
                        }
                        lexer.pushback(c2);
                        break block34;
                    }
                    if (c != 92) break block38;
                    c = lexer.nextc();
                    switch (c) {
                        case 10: {
                            if (qwords) break block34;
                            if (expand) {
                                if (!indent && lexer.getHeredocIndent() < 0) continue block5;
                                if (c != this.end) continue block5;
                                c = 92;
                                if (encoding2 != null) {
                                    buffer.setEncoding(encoding2);
                                }
                                return c;
                            }
                            buffer.append(92);
                            break block34;
                        }
                        case 92: {
                            if (!escape2) break block34;
                            buffer.append(c);
                            break block34;
                        }
                        case 117: {
                            if (!expand) {
                                buffer.append(92);
                                break block34;
                            } else {
                                if (regexp2) {
                                    lexer.readUTFEscapeRegexpLiteral(buffer);
                                } else {
                                    lexer.readUTFEscape(buffer, true, encodingDetermined);
                                }
                                if (!hasNonAscii || buffer.getEncoding() == encoding2) continue block5;
                                this.mixedEscape(lexer, buffer.getEncoding(), encoding2);
                                continue block5;
                            }
                        }
                        default: {
                            if (c != -1) break;
                            return -1;
                        }
                    }
                    if (!RubyLexer.isASCII(c)) {
                        if (!expand) {
                            buffer.append(92);
                        }
                        hasNonAscii = true;
                        if (buffer.getEncoding() != encoding2) {
                            this.mixedEscape(lexer, buffer.getEncoding(), encoding2);
                            continue;
                        }
                        if (lexer.tokadd_mbchar(c, buffer)) continue;
                        lexer.compile_error("invalid multibyte char (" + encoding2 + ")");
                        continue;
                    }
                    if (regexp2) {
                        if (c == this.end && !this.simple_re_meta(c)) {
                            buffer.append(c);
                            continue;
                        }
                        lexer.pushback(c);
                        this.parseEscapeIntoBuffer(lexer, buffer);
                        if (!hasNonAscii || buffer.getEncoding() == encoding2) continue;
                        this.mixedEscape(lexer, buffer.getEncoding(), encoding2);
                        continue;
                    }
                    if (expand) {
                        lexer.pushback(c);
                        if (escape2) {
                            buffer.append(92);
                        }
                        c = lexer.readEscape();
                        break block34;
                    } else if (!(qwords && Character.isWhitespace(c) || c == this.end || this.begin != '\u0000' && c == this.begin)) {
                        buffer.append(92);
                        lexer.pushback(c);
                        continue;
                    }
                    break block34;
                }
                if (!RubyLexer.isASCII(c)) {
                    hasNonAscii = true;
                    if (!encodingDetermined[0]) {
                        encodingDetermined[0] = true;
                        buffer.setEncoding(lexer.getEncoding());
                    } else if (buffer.getEncoding() != encoding2) {
                        this.mixedEscape(lexer, buffer.getEncoding(), encoding2);
                        continue;
                    }
                    if (lexer.tokadd_mbchar(c, buffer)) continue;
                    lexer.compile_error("invalid multibyte char (" + encoding2 + ")");
                    continue;
                }
                if (qwords && Character.isWhitespace(c)) {
                    lexer.pushback(c);
                    break;
                }
            }
            if ((c & 0x80) != 0) {
                hasNonAscii = true;
                if (!encodingDetermined[0]) {
                    encodingDetermined[0] = true;
                    buffer.setEncoding(lexer.getEncoding());
                } else if (buffer.getEncoding() != encoding2) {
                    this.mixedEscape(lexer, buffer.getEncoding(), encoding2);
                    continue;
                }
            }
            buffer.append(c);
        }
        if (!encodingDetermined[0]) {
            buffer.setEncoding(lexer.getEncoding());
        }
        return c;
    }

    private boolean simple_re_meta(int c) {
        switch (c) {
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 62: 
            case 63: 
            case 93: 
            case 94: 
            case 124: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    private void escaped(RubyLexer lexer, ByteList buffer) throws IOException {
        int c = lexer.nextc();
        switch (c) {
            case 92: {
                this.parseEscapeIntoBuffer(lexer, buffer);
                break;
            }
            case -1: {
                lexer.compile_error("Invalid escape character syntax");
            }
            default: {
                buffer.append(c);
            }
        }
    }

    private void parseEscapeIntoBuffer(RubyLexer lexer, ByteList buffer) throws IOException {
        int c = lexer.nextc();
        block0 : switch (c) {
            case 10: {
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                buffer.append(92);
                buffer.append(c);
                for (int i2 = 0; i2 < 2; ++i2) {
                    c = lexer.nextc();
                    if (c == -1) {
                        lexer.compile_error("Invalid escape character syntax");
                    }
                    if (!LexingCommon.isOctChar(c)) {
                        lexer.pushback(c);
                        break block0;
                    }
                    buffer.append(c);
                }
                break;
            }
            case 120: {
                buffer.append(92);
                buffer.append(c);
                c = lexer.nextc();
                if (!LexingCommon.isHexChar(c)) {
                    lexer.compile_error("Invalid escape character syntax");
                }
                buffer.append(c);
                c = lexer.nextc();
                if (LexingCommon.isHexChar(c)) {
                    buffer.append(c);
                    break;
                }
                lexer.pushback(c);
                break;
            }
            case 77: {
                if (lexer.nextc() != 45) {
                    lexer.compile_error("Invalid escape character syntax");
                }
                buffer.append(new byte[]{92, 77, 45});
                this.escaped(lexer, buffer);
                break;
            }
            case 67: {
                if (lexer.nextc() != 45) {
                    lexer.compile_error("Invalid escape character syntax");
                }
                buffer.append(new byte[]{92, 67, 45});
                this.escaped(lexer, buffer);
                break;
            }
            case 99: {
                buffer.append(new byte[]{92, 99});
                this.escaped(lexer, buffer);
                break;
            }
            case -1: {
                lexer.compile_error("Invalid escape character syntax");
            }
            default: {
                if (c != 92 || c != this.end) {
                    buffer.append(92);
                }
                buffer.append(c);
            }
        }
    }
}

