/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.util.function.Predicate;
import org.basex.core.MainOptions;
import org.basex.data.Data;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.EnumType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.XMLToken;
import org.basex.util.hash.IntObjectMap;

public final class Str
extends AStr {
    public static final Str EMPTY = new Str(Token.EMPTY);
    public static final Str KEY = Str.get("key");
    public static final Str VALUE = Str.get("value");
    private static final IntObjectMap<Str> CACHE = new IntObjectMap();
    private static final Str[] CHAR;

    private Str(byte[] value) {
        this(value, AtomType.STRING);
    }

    private Str(byte[] value, Type type) {
        super(value, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Str get(byte[] value) {
        int vl = value.length;
        if (vl == 0) {
            return EMPTY;
        }
        if (vl == 1) {
            return CHAR[value[0]];
        }
        if (vl > 4 || vl > Token.cl(value, 0)) {
            return new Str(value);
        }
        IntObjectMap<Str> intObjectMap = CACHE;
        synchronized (intObjectMap) {
            return CACHE.computeIfAbsent(Token.cp(value, 0), () -> new Str(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Str get(int cp) {
        if (cp < 128) {
            return CHAR[cp];
        }
        IntObjectMap<Str> intObjectMap = CACHE;
        synchronized (intObjectMap) {
            return CACHE.computeIfAbsent(cp, () -> new Str(Token.cpToken(cp)));
        }
    }

    public static Str get(byte[] value, Type type) {
        return type == AtomType.STRING ? Str.get(value) : new Str(value, type);
    }

    public static Str get(String value) {
        return Str.get(Token.token(value));
    }

    public static Str get(Object value, QueryContext qc, InputInfo info) throws QueryException {
        byte[] token = XMLToken.token(value, qc.context.options.get(MainOptions.CHECKSTRINGS));
        if (token == null) {
            throw QueryError.INVCODE_X.get(info, value);
        }
        return Str.get(token);
    }

    @Override
    public byte[] string(InputInfo ii) {
        return this.value;
    }

    public byte[] string() {
        return this.value;
    }

    public int hashCode() {
        return Token.hashCode(this.value);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Item expr = this;
        if (mode.oneOf(CompileContext.Simplify.EBV, CompileContext.Simplify.PREDICATE)) {
            expr = Bln.get(this != EMPTY);
        }
        return cc.simplify(this, expr, mode);
    }

    @Override
    public Item materialize(Predicate<Data> test, InputInfo ii, QueryContext qc) {
        return this.type instanceof EnumType ? Str.get(this.string()) : this;
    }

    @Override
    public boolean materialized(Predicate<Data> test, InputInfo ii) {
        return !(this.type instanceof EnumType);
    }

    @Override
    public String toJava() {
        return Token.string(this.value);
    }

    static {
        int nl = 128;
        CHAR = new Str[128];
        for (int n = 0; n < 128; ++n) {
            Str.CHAR[n] = new Str(Token.cpToken(n));
        }
    }
}

