/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.inspect;

import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.NSGlobal;
import org.basex.query.value.Value;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.Atts;
import org.basex.util.list.TokenList;

public final class InspectStaticContext
extends StandardFunc {
    @Override
    public Value value(QueryContext qc) throws QueryException {
        StaticContext sctx;
        Item func = this.arg(0).item(qc, this.info);
        String name = this.toString(this.arg(1), qc);
        if (func.isEmpty()) {
            sctx = this.sc();
        } else if (func instanceof FuncItem) {
            FuncItem fi = (FuncItem)func;
            sctx = fi.info().sc();
        } else {
            throw QueryError.INVFUNCITEM_X_X.get(this.info, func.type, func);
        }
        return switch (name) {
            case "base-uri" -> sctx.baseURI();
            case "namespaces" -> {
                int n;
                MapBuilder mb = new MapBuilder();
                Atts nsp = sctx.ns.list;
                int ns = nsp.size();
                for (n = 0; n < ns; ++n) {
                    mb.put((Item)Str.get(nsp.name(n)), (Value)Str.get(nsp.value(n)));
                }
                nsp = NSGlobal.NS;
                ns = nsp.size();
                for (n = 0; n < ns; ++n) {
                    Str key = Str.get(nsp.name(n));
                    if (mb.contains(key)) continue;
                    mb.put((Item)key, (Value)Str.get(nsp.value(n)));
                }
                yield mb.map();
            }
            case "element-namespace" -> {
                if (sctx.elemNS == null) {
                    yield Empty.VALUE;
                }
                yield Uri.get(sctx.elemNS);
            }
            case "function-namespace" -> {
                if (sctx.funcNS == null) {
                    yield Str.get(QueryText.FN_URI);
                }
                yield Uri.get(sctx.funcNS);
            }
            case "collation" -> Uri.get(sctx.collation == null ? QueryText.COLLATION_URI : sctx.collation.uri());
            case "ordering" -> Str.get(sctx.ordered ? "ordered" : "unordered");
            case "construction" -> Str.get(sctx.strip ? "strip" : "preserve");
            case "default-order-empty" -> Str.get(sctx.orderGreatest ? "greatest" : "least");
            case "boundary-space" -> Str.get(sctx.spaces ? "preserve" : "strip");
            case "copy-namespaces" -> {
                TokenList tl = new TokenList(2L);
                tl.add(sctx.preserveNS ? "preserve" : "no-preserve");
                tl.add(sctx.inheritNS ? "inherit" : "no-inherit");
                yield StrSeq.get(tl);
            }
            case "decimal-formats" -> {
                sctx.decFormat(QNm.EMPTY, this.info);
                MapBuilder mb = new MapBuilder();
                for (byte[] format : sctx.decFormats) {
                    mb.put((Item)Str.get(format), (Value)sctx.decFormats.get(format).toMap());
                }
                yield mb.map();
            }
            default -> throw QueryError.INSPECT_UNKNOWN_X.get(this.info, name);
        };
    }
}

