/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.random;

import java.util.Random;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;

public final class RandomSeededInteger
extends StandardFunc {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        final long seed = this.toLong(this.arg(0), qc);
        final long num = this.toLong(this.arg(1), qc);
        final Long max = this.toLongOrNull(this.arg(2), qc);
        if (num < 0L) {
            throw QueryError.RANGE_NEGATIVE_X.get(this.info, num);
        }
        if (max != null && (max < 1L || max > Integer.MAX_VALUE)) {
            throw QueryError.RANDOM_BOUNDS_X.get(this.info, max);
        }
        return new Iter(){
            final Random r;
            final int mx;
            long c;
            {
                this.r = new Random(seed);
                this.mx = (int)(max != null ? max : 0L);
                this.c = num;
            }

            @Override
            public Item next() {
                return --this.c >= 0L ? Itr.get(this.mx == 0 ? (long)this.r.nextInt() : (long)this.r.nextInt(this.mx)) : null;
            }
        };
    }
}

