/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.pkg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.in.NewlineInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.util.pkg.ClassLoaderCache;
import org.basex.query.util.pkg.EXPathRepo;
import org.basex.query.util.pkg.ModuleLoader;
import org.basex.query.util.pkg.Pkg;
import org.basex.query.util.pkg.PkgDep;
import org.basex.query.util.pkg.PkgParser;
import org.basex.query.util.pkg.PkgType;
import org.basex.query.util.pkg.PkgValidator;
import org.basex.query.util.pkg.RepoArchive;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Table;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public final class RepoManager {
    private static final Pattern MAIN_CLASS = Pattern.compile("^Main-Class: *(.+?) *$");
    private final Context context;
    private final InputInfo info;

    public RepoManager(Context context) {
        this(context, null);
    }

    public RepoManager(Context context, InputInfo info) {
        this.context = context;
        this.info = info;
    }

    public boolean install(String source) throws QueryException {
        byte[] content;
        IO io = IO.get(source);
        try {
            content = io.read();
        }
        catch (IOException ex) {
            Util.debug(ex);
            throw QueryError.REPO_NOTFOUND_X.get(this.info, source);
        }
        try {
            if (io.hasSuffix(IO.XQSUFFIXES)) {
                return this.installXQ(content, source);
            }
            if (io.hasSuffix(".jar")) {
                return this.installJAR(content, source);
            }
            return this.installXAR(content);
        }
        catch (IOException ex) {
            throw QueryError.REPO_PARSE_X_X.get(this.info, io.name(), ex);
        }
    }

    public Table table() {
        Table table = new Table();
        table.description = Text.PACKAGES_X;
        table.header.add(Text.NAME);
        table.header.add(Text.VERSINFO);
        table.header.add(Text.TYPE);
        table.header.add(Text.PATH);
        for (Pkg pkg : this.packages()) {
            TokenList tl = new TokenList();
            tl.add(pkg.name());
            tl.add(pkg.version());
            tl.add(pkg.type().toString());
            tl.add(pkg.path());
            table.contents.add(tl);
        }
        return table;
    }

    public StringList ids() {
        StringList sl = new StringList();
        for (Pkg pkg : this.packages()) {
            sl.add(pkg.id());
        }
        return sl;
    }

    public void delete(String name) throws QueryException {
        boolean deleted = false;
        EXPathRepo repo = this.context.repo;
        for (Pkg pkg : this.packages()) {
            IOFile jarFile;
            String pkgPath = pkg.path();
            if (!pkg.name().equals(name) && !pkg.id().equals(name) && !pkgPath.equals(name)) continue;
            boolean isExpath = pkg.type() == PkgType.EXPATH;
            ClassLoaderCache.invalidate(isExpath ? ModuleLoader.pkgUrls(repo.path(pkgPath), pkg.modDir(repo.path(pkgPath)), this.info) : ModuleLoader.jarUrls(this.context, Strings.uriToClasspath(name)));
            if (isExpath) {
                String dep = this.dependency(pkg);
                if (dep != null) {
                    throw QueryError.REPO_DELETE_X_X.get(this.info, dep, name);
                }
                repo.delete(pkg);
            }
            IOFile pkgFile = repo.path(pkgPath);
            String className = Strings.uriToClasspath(pkg.name().replaceAll("^.*\\.", ""));
            IOFile extDir = pkgFile.parent().resolve("." + className);
            if (!extDir.delete()) {
                throw QueryError.REPO_DELETE_X.get(this.info, extDir);
            }
            if (pkg.type() == PkgType.COMBINED && !(jarFile = pkgFile.parent().resolve(className + ".jar")).delete()) {
                throw QueryError.REPO_DELETE_X.get(this.info, pkgPath);
            }
            if (!pkgFile.delete()) {
                throw QueryError.REPO_DELETE_X.get(this.info, pkgPath);
            }
            deleted = true;
        }
        if (!deleted) {
            throw QueryError.REPO_NOTFOUND_X.get(this.info, name);
        }
    }

    public ArrayList<Pkg> packages() {
        TreeMap<String, Pkg> map = new TreeMap<String, Pkg>();
        EXPathRepo repo = this.context.repo.reset();
        HashSet<String> paths = new HashSet<String>();
        for (Pkg pkg : repo.pkgDict().values()) {
            RepoManager.add(pkg, map);
            paths.add(pkg.path());
        }
        for (IOFile child : repo.path().children(IOFile.NO_HIDDEN)) {
            String name = child.name();
            if (!child.isDir()) {
                RepoManager.add(name.replaceAll("\\..*", "").replace('/', '.'), name, map);
                continue;
            }
            if (paths.contains(name)) continue;
            for (String path : child.descendants(IOFile.NO_HIDDEN)) {
                RepoManager.add(name + "." + path.replaceAll("\\..*", "").replace('/', '.'), name + "/" + path, map);
            }
        }
        for (Pkg xqm : new ArrayList<Pkg>(map.values())) {
            String jarName;
            Pkg jar;
            if (xqm.type != PkgType.XQUERY || (jar = map.get(jarName = Strings.uriToClasspath(xqm.name))) == null || xqm.merge((Pkg)jar).type != PkgType.COMBINED) continue;
            map.remove(jarName);
        }
        return new ArrayList<Pkg>(map.values());
    }

    private static void add(String name, String path, TreeMap<String, Pkg> map) {
        RepoManager.add(new Pkg(name).path(path), map);
    }

    private static void add(Pkg pkg, TreeMap<String, Pkg> map) {
        map.compute(pkg.id(), (k, v) -> v == null ? pkg : v.merge(pkg));
    }

    private boolean installXQ(byte[] content, String path) throws QueryException, IOException {
        try (QueryContext qc = new QueryContext(this.context);){
            byte[] uri = qc.parseLibrary((String)Token.string((byte[])content), (String)path).sc.module.uri();
            boolean bl = this.write(Strings.uri2path(Token.string(uri)), ".xqm", content);
            return bl;
        }
    }

    private boolean installJAR(byte[] content, String path) throws QueryException, IOException {
        byte[] manifest = new RepoArchive(content).read("META-INF/MANIFEST.MF");
        try (NewlineInput nli = new NewlineInput(new IOContent(manifest));){
            String s;
            while ((s = nli.readLine()) != null) {
                Matcher main = MAIN_CLASS.matcher(s);
                if (!main.find()) continue;
                boolean bl = this.write(main.group(1), ".jar", content);
                return bl;
            }
        }
        throw QueryError.REPO_PARSE_X_X.get(this.info, path, "No 'Main-Class' attribute found: %/META-INF/MANIFEST.MF.");
    }

    private boolean write(String pkg, String suffix, byte[] content) throws IOException {
        IOFile repo = new IOFile(this.context.soptions.get(StaticOptions.REPOPATH));
        boolean isJar = suffix.equals(".jar");
        String pth = isJar ? Strings.uriToClasspath(pkg) : pkg;
        IOFile target = new IOFile(repo, Strings.uri2path(pth) + suffix);
        boolean exists = target.exists();
        if (!target.parent().md()) {
            throw new BaseXException("Could not create %.", target);
        }
        target.write(content);
        if (isJar) {
            String pkgPath = Strings.uri2path(pkg);
            String pkgName = target.name().replaceAll(".jar$", "");
            try (JarFile jarFile = new JarFile(target.file());){
                for (JarEntry entry : Collections.list(jarFile.entries())) {
                    String name = entry.getName();
                    IOFile trg = null;
                    if (name.matches("^lib/[^/]+\\.jar")) {
                        trg = new IOFile(target.parent().resolve("." + pkgName), name.replaceAll("^.*?/", ""));
                    } else if (name.equals(pkgPath + ".xqm")) {
                        trg = new IOFile(repo, name);
                    }
                    if (trg == null) continue;
                    if (!trg.parent().md()) {
                        throw new BaseXException("Could not create %.", trg);
                    }
                    trg.write(jarFile.getInputStream(entry));
                }
            }
        }
        return exists;
    }

    private boolean installXAR(byte[] content) throws QueryException, IOException {
        boolean exists;
        RepoArchive repoArchive = new RepoArchive(content);
        IOContent dsc = new IOContent(repoArchive.read("expath-pkg.xml"));
        Pkg pkg = new PkgParser(this.info).parse(dsc);
        String id = pkg.id();
        EXPathRepo repo = this.context.repo;
        boolean bl = exists = repo.pkgDict().get(id) != null;
        if (exists) {
            this.delete(id);
        }
        new PkgValidator(repo, this.info).check(pkg);
        IOFile file = this.uniqueDir(id.replaceAll("[^\\w.-]+", "-"));
        repoArchive.unzip(file);
        repo.add(pkg.path(file.name()));
        return exists;
    }

    private IOFile uniqueDir(String name) {
        Object nm = name;
        int c = 0;
        IOFile io;
        while ((io = this.context.repo.path((String)nm)).exists()) {
            nm = name + "-" + ++c;
        }
        return io;
    }

    private String dependency(Pkg pkg) throws QueryException {
        String id = pkg.id();
        EXPathRepo repo = this.context.repo;
        HashMap<String, Pkg> dict = repo.pkgDict();
        for (Pkg pkgDep : dict.values()) {
            if (pkgDep.id().equals(id)) continue;
            IOFile desc = new IOFile(repo.path(pkgDep.path()), "expath-pkg.xml");
            String name = pkg.name();
            for (PkgDep dep : new PkgParser((InputInfo)this.info).parse((IO)desc).dep) {
                if (!name.equals(dep.name)) continue;
                return pkgDep.name();
            }
        }
        return null;
    }
}

