---
name: Bug report
about: Found a bug?  Make sure it hasn't already been filed/solved - if so, please report it!
title: ""
labels: "bug"
assignees: ""
---

## Describe the bug

_A clear and concise description of what the bug is and what the expected behaviour was. If applicable, add screenshots to help explain your problem:_

## How to reproduce

_Steps on how to reproduce the behaviour.  Please try to include this section so I can reproduce your problem in order to fix it.  If you are using any runtime flags (i.e. `btm --group`) please mention them as part of this.:_

## bottom version

_Use `btm -V` and report the version of bottom you have installed. Also, if you're not on the latest version, please [try that](https://github.com/ClementTsang/bottom/releases/latest) and see if the problem is already resolved._

## bottom config file (if used)

_If you're using a config file, please include it in the report._

## Installation method

_How did you install bottom? Note if it's not a supported method, I may not be able to help you._

## Platform and environment information

### Operating system, OS version, and architecture

_Please specify your operating system, the version, and architecture, so I can try to replicate your environment as best as possible. Note that the officially supported platforms are:_

- _macOS (`x86_64`)_
- _Linux (`x86_64`, `i686`, `aarch64`)_
- _Windows (`x86_64`, `i686`)_

_If your platform is not listed, please be aware I do not officially support it and may be unable to fix this issue._

### Terminal (i.e. urxvt, kitty, etc.)

_Sometimes this matters, so please mention your terminal/terminal emulator._

### Shell (i.e. zsh, bash, etc.)

_Again, sometimes this matters, so please mention your shell type if possible._

### Miscellaneous system info

_Not totally necessary, but if possible, include details like:_

_RAM size:_

_SWAP size:_

_CPU and number of cores:_

### Rust version

_Check this with `rustc --version`. This is only relevant if your version of bottom isn't from a pre-built binary (i.e. Cargo). Otherwise, feel free to skip._

## Additional context

_If anything hasn't been covered by the above categories, feel free to include it here:_
