'use strict'

var parse = require('ret')
var types = parse.types

module.exports = function (re, opts) {
  if (!opts) opts = {}
  var replimit = opts.limit === undefined ? 25 : opts.limit

  if (isRegExp(re)) re = re.source
  else if (typeof re !== 'string') re = String(re)

  try { re = parse(re) } catch (err) { return false }

  var reps = 0
  return (function walk (node, starHeight) {
    var i
    var ok
    var len

    if (node.type === types.REPETITION) {
      starHeight++
      reps++
      if (starHeight > 1) return false
      if (reps > replimit) return false
    }

    if (node.options) {
      for (i = 0, len = node.options.length; i < len; i++) {
        ok = walk({ stack: node.options[i] }, starHeight)
        if (!ok) return false
      }
    }
    var stack = node.stack || (node.value && node.value.stack)
    if (!stack) return true

    for (i = 0; i < stack.length; i++) {
      ok = walk(stack[i], starHeight)
      if (!ok) return false
    }

    return true
  })(re, 0)
}

function isRegExp (x) {
  return {}.toString.call(x) === '[object RegExp]'
}
