/*
 * A little client for Mercurial command server using socket
 *
 * Copyright (c) 2011 Yuya Nishihara <yuya@tcha.org>
 *
 * This software may be used and distributed according to the terms of the
 * GNU General Public License version 2 or any later version.
 *
 * About Mercurial Command Server:
 * http://mercurial.selenic.com/wiki/CommandServer
 */

#ifndef HGCLIENT_H_
#define HGCLIENT_H_

struct hgclient_tag_;
typedef struct hgclient_tag_ hgclient_t;

hgclient_t* hgc_open(const char * const envp[]);
void hgc_close(hgclient_t *hgc);
void hgc_kill(hgclient_t *hgc, int sig);
void hgc_killmaster(hgclient_t *hgc, int sig);

int hgc_runcommand(hgclient_t *hgc, const char * const args[], size_t argsize);
const char* hgc_getpager(hgclient_t *hgc, const char * const args[],
        size_t argsize);

#endif // HGCLIENT_H_
