/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.sample.extensions.processors;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.api.FileProcessListener;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.sample.extensions.processors.QualifiedNameProcessorKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lio/gitlab/arturbosch/detekt/sample/extensions/processors/QualifiedNameProcessor;", "Lio/gitlab/arturbosch/detekt/api/FileProcessListener;", "()V", "onFinish", "", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "result", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "onProcess", "file", "ClassNameVisitor", "detekt-sample-extensions"})
public final class QualifiedNameProcessor
implements FileProcessListener {
    /*
     * WARNING - void declaration
     */
    public void onProcess(@NotNull KtFile file) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String packageName = file.getPackageFqName().asString();
        ClassNameVisitor nameVisitor = new ClassNameVisitor();
        file.accept((PsiElementVisitor)nameVisitor);
        Iterable iterable = nameVisitor.getNames();
        Collection destination$iv = new HashSet();
        for (Object item$iv : $receiver$iv) {
            void it;
            String string = (String)item$iv;
            Collection collection = destination$iv;
            String string2 = packageName + '.' + (String)it;
            collection.add(string2);
        }
        HashSet fqNames = (HashSet)destination$iv;
        file.putUserData(QualifiedNameProcessorKt.getFqNamesKey(), (Object)fqNames);
    }

    /*
     * WARNING - void declaration
     */
    public void onFinish(@NotNull List<? extends KtFile> files, @NotNull Detektion result) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Iterable iterable = $receiver$iv = (Iterable)files;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            Set set;
            Object element$iv$iv = element$iv$iv$iv;
            KtFile it = (KtFile)element$iv$iv;
            if ((Set)it.getUserData(QualifiedNameProcessorKt.getFqNamesKey()) == null) continue;
            Set it$iv$iv = set;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        Collection destination$iv = new HashSet();
        for (Object element$iv : $receiver$iv) {
            Set it;
            Set set = it = (Set)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"it");
            Iterable list$iv = set;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        HashSet fqNames = (HashSet)destination$iv;
        result.addData(QualifiedNameProcessorKt.getFqNamesKey(), (Object)fqNames);
    }

    @NotNull
    public String getId() {
        return FileProcessListener.DefaultImpls.getId((FileProcessListener)this);
    }

    public int getPriority() {
        return FileProcessListener.DefaultImpls.getPriority((FileProcessListener)this);
    }

    public void init(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        FileProcessListener.DefaultImpls.init((FileProcessListener)this, (Config)config);
    }

    public void onProcessComplete(@NotNull KtFile file, @NotNull Map<String, ? extends List<? extends Finding>> findings) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull(findings, (String)"findings");
        FileProcessListener.DefaultImpls.onProcessComplete((FileProcessListener)this, (KtFile)file, findings);
    }

    public void onStart(@NotNull List<? extends KtFile> files) {
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        FileProcessListener.DefaultImpls.onStart((FileProcessListener)this, files);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lio/gitlab/arturbosch/detekt/sample/extensions/processors/QualifiedNameProcessor$ClassNameVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "()V", "names", "", "", "getNames", "()Ljava/util/Set;", "visitClassOrObject", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "detekt-sample-extensions"})
    public static final class ClassNameVisitor
    extends DetektVisitor {
        @NotNull
        private final Set<String> names;

        @NotNull
        public final Set<String> getNames() {
            return this.names;
        }

        public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
            Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
            String string = classOrObject.getNameAsSafeName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"classOrObject.nameAsSafeName.asString()");
            this.names.add(string);
        }

        public ClassNameVisitor() {
            Set set;
            ClassNameVisitor classNameVisitor = this;
            classNameVisitor.names = set = (Set)new LinkedHashSet();
        }
    }
}

