/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.cli;

import ch.cyberduck.cli.Console;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.transfer.TransferProgress;
import ch.cyberduck.core.transfer.TransferSpeedometer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import org.fusesource.jansi.Ansi;

public class TerminalStreamListener
implements StreamListener {
    private final TransferSpeedometer meter;
    private final Console console = new Console();
    private final AtomicLong timestamp = new AtomicLong();
    private static final int DEFAULT_WIDTH = 30;
    private final int width;
    private final Semaphore lock = new Semaphore(1);

    public TerminalStreamListener(TransferSpeedometer meter) {
        this(meter, 30);
    }

    public TerminalStreamListener(TransferSpeedometer meter, int width) {
        this.meter = meter;
        this.width = width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increment() {
        TransferProgress progress = this.meter.getStatus();
        if (System.currentTimeMillis() - this.timestamp.get() < 100L && !progress.isComplete()) {
            return;
        }
        try {
            int i;
            this.lock.acquire();
            BigDecimal fraction = progress.getTransferred() == 0L ? BigDecimal.ZERO : new BigDecimal(progress.getTransferred()).divide(new BigDecimal(progress.getSize()), 1, RoundingMode.DOWN);
            this.console.printf("\r%s[", Ansi.ansi().saveCursorPosition().eraseLine(Ansi.Erase.ALL).restoreCursorPosition());
            for (i = 0; i <= (int)(fraction.doubleValue() * (double)this.width); ++i) {
                this.console.printf("\u25ae", new Object[0]);
            }
            while (i < this.width) {
                this.console.printf(" ", new Object[0]);
                ++i;
            }
            this.console.printf("] %s%s", progress.getProgress(), Ansi.ansi().reset());
            this.timestamp.set(System.currentTimeMillis());
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void recv(long bytes) {
        this.increment();
    }

    @Override
    public void sent(long bytes) {
        this.increment();
    }
}

