/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.sds.SDSCopyFeature;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.shared.DefaultCopyFeature;
import ch.cyberduck.core.transfer.TransferStatus;

public class SDSDelegatingCopyFeature
implements Copy {
    private final SDSNodeIdProvider nodeid;
    private final SDSCopyFeature proxy;
    private final DefaultCopyFeature copy;

    public SDSDelegatingCopyFeature(SDSSession session, SDSNodeIdProvider nodeid, SDSCopyFeature proxy) {
        this.nodeid = nodeid;
        this.proxy = proxy;
        this.copy = new DefaultCopyFeature((Session)session);
    }

    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        if (this.proxy.isSupported(source, target)) {
            return this.proxy.copy(source, target, status, callback);
        }
        if (this.nodeid.isEncrypted(target)) {
            this.nodeid.setFileKey(status);
        }
        return this.copy.copy(source, target, status, callback);
    }

    public boolean isRecursive(Path source, Path target) {
        if (this.proxy.isSupported(source, target)) {
            return this.proxy.isRecursive(source, target);
        }
        return this.copy.isRecursive(source, target);
    }

    public boolean isSupported(Path source, Path target) {
        if (this.proxy.isSupported(source, target)) {
            return true;
        }
        return this.copy.isSupported(source, target);
    }

    public Copy withTarget(Session<?> session) {
        this.proxy.withTarget(session);
        return this;
    }
}

