/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OpenIdIdpConfig {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="issuer")
    private String issuer = null;
    @JsonProperty(value="authorizationEndPointUrl")
    private String authorizationEndPointUrl = null;
    @JsonProperty(value="tokenEndPointUrl")
    private String tokenEndPointUrl = null;
    @JsonProperty(value="userInfoEndPointUrl")
    private String userInfoEndPointUrl = null;
    @JsonProperty(value="jwksEndPointUrl")
    private String jwksEndPointUrl = null;
    @JsonProperty(value="clientId")
    private String clientId = null;
    @JsonProperty(value="clientSecret")
    private String clientSecret = null;
    @JsonProperty(value="scopes")
    private List<String> scopes = null;
    @JsonProperty(value="redirectUris")
    private List<String> redirectUris = null;
    @JsonProperty(value="pkceEnabled")
    private Boolean pkceEnabled = null;
    @JsonProperty(value="pkceChallengeMethod")
    private String pkceChallengeMethod = null;
    @JsonProperty(value="mappingClaim")
    private String mappingClaim = null;
    @JsonProperty(value="fallbackMappingClaim")
    private String fallbackMappingClaim = null;
    @JsonProperty(value="userUpdateEnabled")
    private Boolean userUpdateEnabled = null;

    public OpenIdIdpConfig id(Integer id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public OpenIdIdpConfig name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of the IDP")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OpenIdIdpConfig issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @ApiModelProperty(example="https://www.random-url.com", value="Issuer identifier of the IDP The value is a case sensitive URL.")
    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public OpenIdIdpConfig authorizationEndPointUrl(String authorizationEndPointUrl) {
        this.authorizationEndPointUrl = authorizationEndPointUrl;
        return this;
    }

    @ApiModelProperty(example="https://www.random-url.com", value="URL of the authorization endpoint")
    public String getAuthorizationEndPointUrl() {
        return this.authorizationEndPointUrl;
    }

    public void setAuthorizationEndPointUrl(String authorizationEndPointUrl) {
        this.authorizationEndPointUrl = authorizationEndPointUrl;
    }

    public OpenIdIdpConfig tokenEndPointUrl(String tokenEndPointUrl) {
        this.tokenEndPointUrl = tokenEndPointUrl;
        return this;
    }

    @ApiModelProperty(example="https://www.random-url.com", value="URL of the token endpoint")
    public String getTokenEndPointUrl() {
        return this.tokenEndPointUrl;
    }

    public void setTokenEndPointUrl(String tokenEndPointUrl) {
        this.tokenEndPointUrl = tokenEndPointUrl;
    }

    public OpenIdIdpConfig userInfoEndPointUrl(String userInfoEndPointUrl) {
        this.userInfoEndPointUrl = userInfoEndPointUrl;
        return this;
    }

    @ApiModelProperty(example="https://www.random-url.com", value="URL of the user info endpoint")
    public String getUserInfoEndPointUrl() {
        return this.userInfoEndPointUrl;
    }

    public void setUserInfoEndPointUrl(String userInfoEndPointUrl) {
        this.userInfoEndPointUrl = userInfoEndPointUrl;
    }

    public OpenIdIdpConfig jwksEndPointUrl(String jwksEndPointUrl) {
        this.jwksEndPointUrl = jwksEndPointUrl;
        return this;
    }

    @ApiModelProperty(example="https://www.random-url.com", value="URL of the JWKS endpoint")
    public String getJwksEndPointUrl() {
        return this.jwksEndPointUrl;
    }

    public void setJwksEndPointUrl(String jwksEndPointUrl) {
        this.jwksEndPointUrl = jwksEndPointUrl;
    }

    public OpenIdIdpConfig clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @ApiModelProperty(value="ID of the OAuth client")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public OpenIdIdpConfig clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @ApiModelProperty(value="Secret, which client uses at authentication.")
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public OpenIdIdpConfig scopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public OpenIdIdpConfig addScopesItem(String scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @ApiModelProperty(value="List of requested scopes Usually `openid` and the names of the requested claims.")
    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public OpenIdIdpConfig redirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
        return this;
    }

    public OpenIdIdpConfig addRedirectUrisItem(String redirectUrisItem) {
        if (this.redirectUris == null) {
            this.redirectUris = new ArrayList<String>();
        }
        this.redirectUris.add(redirectUrisItem);
        return this;
    }

    @ApiModelProperty(value="URIs, to which a user is redirected after authorization.")
    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public OpenIdIdpConfig pkceEnabled(Boolean pkceEnabled) {
        this.pkceEnabled = pkceEnabled;
        return this;
    }

    @ApiModelProperty(example="false", value="Determines whether PKCE is enabled. cf. [RFC 7636](https://tools.ietf.org/html/rfc7636) (default: false)")
    public Boolean getPkceEnabled() {
        return this.pkceEnabled;
    }

    public void setPkceEnabled(Boolean pkceEnabled) {
        this.pkceEnabled = pkceEnabled;
    }

    public OpenIdIdpConfig pkceChallengeMethod(String pkceChallengeMethod) {
        this.pkceChallengeMethod = pkceChallengeMethod;
        return this;
    }

    @ApiModelProperty(value="PKCE code challenge method. cf. [RFC 7636](https://tools.ietf.org/html/rfc7636)")
    public String getPkceChallengeMethod() {
        return this.pkceChallengeMethod;
    }

    public void setPkceChallengeMethod(String pkceChallengeMethod) {
        this.pkceChallengeMethod = pkceChallengeMethod;
    }

    public OpenIdIdpConfig mappingClaim(String mappingClaim) {
        this.mappingClaim = mappingClaim;
        return this;
    }

    @ApiModelProperty(example="email", value="Name of the claim which is used for the user mapping.")
    public String getMappingClaim() {
        return this.mappingClaim;
    }

    public void setMappingClaim(String mappingClaim) {
        this.mappingClaim = mappingClaim;
    }

    public OpenIdIdpConfig fallbackMappingClaim(String fallbackMappingClaim) {
        this.fallbackMappingClaim = fallbackMappingClaim;
        return this;
    }

    @ApiModelProperty(example="sub", value="Name of the claim which is used for the user mapping fallback.")
    public String getFallbackMappingClaim() {
        return this.fallbackMappingClaim;
    }

    public void setFallbackMappingClaim(String fallbackMappingClaim) {
        this.fallbackMappingClaim = fallbackMappingClaim;
    }

    public OpenIdIdpConfig userUpdateEnabled(Boolean userUpdateEnabled) {
        this.userUpdateEnabled = userUpdateEnabled;
        return this;
    }

    @ApiModelProperty(example="false", value="Determines if the user metadata is updated with data from the IDP. The scope `profile` is needed for the update. If this scope is not granted, only the email address is updated. (default: false)")
    public Boolean getUserUpdateEnabled() {
        return this.userUpdateEnabled;
    }

    public void setUserUpdateEnabled(Boolean userUpdateEnabled) {
        this.userUpdateEnabled = userUpdateEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenIdIdpConfig openIdIdpConfig = (OpenIdIdpConfig)o;
        return Objects.equals(this.id, openIdIdpConfig.id) && Objects.equals(this.name, openIdIdpConfig.name) && Objects.equals(this.issuer, openIdIdpConfig.issuer) && Objects.equals(this.authorizationEndPointUrl, openIdIdpConfig.authorizationEndPointUrl) && Objects.equals(this.tokenEndPointUrl, openIdIdpConfig.tokenEndPointUrl) && Objects.equals(this.userInfoEndPointUrl, openIdIdpConfig.userInfoEndPointUrl) && Objects.equals(this.jwksEndPointUrl, openIdIdpConfig.jwksEndPointUrl) && Objects.equals(this.clientId, openIdIdpConfig.clientId) && Objects.equals(this.clientSecret, openIdIdpConfig.clientSecret) && Objects.equals(this.scopes, openIdIdpConfig.scopes) && Objects.equals(this.redirectUris, openIdIdpConfig.redirectUris) && Objects.equals(this.pkceEnabled, openIdIdpConfig.pkceEnabled) && Objects.equals(this.pkceChallengeMethod, openIdIdpConfig.pkceChallengeMethod) && Objects.equals(this.mappingClaim, openIdIdpConfig.mappingClaim) && Objects.equals(this.fallbackMappingClaim, openIdIdpConfig.fallbackMappingClaim) && Objects.equals(this.userUpdateEnabled, openIdIdpConfig.userUpdateEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.issuer, this.authorizationEndPointUrl, this.tokenEndPointUrl, this.userInfoEndPointUrl, this.jwksEndPointUrl, this.clientId, this.clientSecret, this.scopes, this.redirectUris, this.pkceEnabled, this.pkceChallengeMethod, this.mappingClaim, this.fallbackMappingClaim, this.userUpdateEnabled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenIdIdpConfig {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    authorizationEndPointUrl: ").append(this.toIndentedString(this.authorizationEndPointUrl)).append("\n");
        sb.append("    tokenEndPointUrl: ").append(this.toIndentedString(this.tokenEndPointUrl)).append("\n");
        sb.append("    userInfoEndPointUrl: ").append(this.toIndentedString(this.userInfoEndPointUrl)).append("\n");
        sb.append("    jwksEndPointUrl: ").append(this.toIndentedString(this.jwksEndPointUrl)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    redirectUris: ").append(this.toIndentedString(this.redirectUris)).append("\n");
        sb.append("    pkceEnabled: ").append(this.toIndentedString(this.pkceEnabled)).append("\n");
        sb.append("    pkceChallengeMethod: ").append(this.toIndentedString(this.pkceChallengeMethod)).append("\n");
        sb.append("    mappingClaim: ").append(this.toIndentedString(this.mappingClaim)).append("\n");
        sb.append("    fallbackMappingClaim: ").append(this.toIndentedString(this.fallbackMappingClaim)).append("\n");
        sb.append("    userUpdateEnabled: ").append(this.toIndentedString(this.userUpdateEnabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

