/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.NodePermissions;
import ch.cyberduck.core.sds.io.swagger.client.model.PublicKeyContainer;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class RoomUser {
    @JsonProperty(value="id")
    private Long id = null;
    @JsonProperty(value="isGranted")
    private Boolean isGranted = null;
    @JsonProperty(value="login")
    private String login = null;
    @JsonProperty(value="displayName")
    private String displayName = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="permissions")
    private NodePermissions permissions = null;
    @JsonProperty(value="publicKeyContainer")
    private PublicKeyContainer publicKeyContainer = null;

    public RoomUser id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier for the user")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public RoomUser isGranted(Boolean isGranted) {
        this.isGranted = isGranted;
        return this;
    }

    @ApiModelProperty(example="false", required=true, value="Is user granted room permissions")
    public Boolean getIsGranted() {
        return this.isGranted;
    }

    public void setIsGranted(Boolean isGranted) {
        this.isGranted = isGranted;
    }

    public RoomUser login(String login) {
        this.login = login;
        return this;
    }

    @ApiModelProperty(required=true, value="User login name")
    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public RoomUser displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(required=true, value="Display name")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public RoomUser email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(example="john.doe@email.com", required=true, value="Email (not used)")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public RoomUser permissions(NodePermissions permissions) {
        this.permissions = permissions;
        return this;
    }

    @ApiModelProperty(value="Available permissions for this node")
    public NodePermissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(NodePermissions permissions) {
        this.permissions = permissions;
    }

    public RoomUser publicKeyContainer(PublicKeyContainer publicKeyContainer) {
        this.publicKeyContainer = publicKeyContainer;
        return this;
    }

    @ApiModelProperty(value="Public key container (private key and version)")
    public PublicKeyContainer getPublicKeyContainer() {
        return this.publicKeyContainer;
    }

    public void setPublicKeyContainer(PublicKeyContainer publicKeyContainer) {
        this.publicKeyContainer = publicKeyContainer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoomUser roomUser = (RoomUser)o;
        return Objects.equals(this.id, roomUser.id) && Objects.equals(this.isGranted, roomUser.isGranted) && Objects.equals(this.login, roomUser.login) && Objects.equals(this.displayName, roomUser.displayName) && Objects.equals(this.email, roomUser.email) && Objects.equals(this.permissions, roomUser.permissions) && Objects.equals(this.publicKeyContainer, roomUser.publicKeyContainer);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.isGranted, this.login, this.displayName, this.email, this.permissions, this.publicKeyContainer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoomUser {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isGranted: ").append(this.toIndentedString(this.isGranted)).append("\n");
        sb.append("    login: ").append(this.toIndentedString(this.login)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    publicKeyContainer: ").append(this.toIndentedString(this.publicKeyContainer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

