/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.RoleList;
import ch.cyberduck.core.sds.io.swagger.client.model.UserAttributes;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.joda.time.DateTime;

public class UserItem {
    @JsonProperty(value="id")
    private Long id = null;
    @JsonProperty(value="login")
    private String login = null;
    @JsonProperty(value="firstName")
    private String firstName = null;
    @JsonProperty(value="lastName")
    private String lastName = null;
    @JsonProperty(value="lockStatus")
    private Integer lockStatus = null;
    @JsonProperty(value="isLocked")
    private Boolean isLocked = null;
    @JsonProperty(value="hasManageableRooms")
    private Boolean hasManageableRooms = null;
    @JsonProperty(value="userRoles")
    private RoleList userRoles = null;
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="gender")
    private GenderEnum gender = null;
    @JsonProperty(value="createdAt")
    private DateTime createdAt = null;
    @JsonProperty(value="lastLoginSuccessAt")
    private DateTime lastLoginSuccessAt = null;
    @JsonProperty(value="expireAt")
    private DateTime expireAt = null;
    @JsonProperty(value="isEncryptionEnabled")
    private Boolean isEncryptionEnabled = null;
    @JsonProperty(value="userAttributes")
    private UserAttributes userAttributes = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="phone")
    private String phone = null;

    public UserItem id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier for the user")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public UserItem login(String login) {
        this.login = login;
        return this;
    }

    @ApiModelProperty(required=true, value="User login name")
    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public UserItem firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(required=true, value="User first name")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public UserItem lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(required=true, value="User last name")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public UserItem lockStatus(Integer lockStatus) {
        this.lockStatus = lockStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="DEPRECATED. User lock status: * `0` - locked * `1` - Web access allowed * `2` - Web and mobile access allowed")
    public Integer getLockStatus() {
        return this.lockStatus;
    }

    public void setLockStatus(Integer lockStatus) {
        this.lockStatus = lockStatus;
    }

    public UserItem isLocked(Boolean isLocked) {
        this.isLocked = isLocked;
        return this;
    }

    @ApiModelProperty(example="false", required=true, value="User is locked: * `false` - unlocked * `true` - locked  Iser is locked and can not login anymore. (default: false)")
    public Boolean getIsLocked() {
        return this.isLocked;
    }

    public void setIsLocked(Boolean isLocked) {
        this.isLocked = isLocked;
    }

    public UserItem hasManageableRooms(Boolean hasManageableRooms) {
        this.hasManageableRooms = hasManageableRooms;
        return this;
    }

    @ApiModelProperty(example="false", required=true, value="User has manageable rooms")
    public Boolean getHasManageableRooms() {
        return this.hasManageableRooms;
    }

    public void setHasManageableRooms(Boolean hasManageableRooms) {
        this.hasManageableRooms = hasManageableRooms;
    }

    public UserItem userRoles(RoleList userRoles) {
        this.userRoles = userRoles;
        return this;
    }

    @ApiModelProperty(required=true, value="List of user roles")
    public RoleList getUserRoles() {
        return this.userRoles;
    }

    public void setUserRoles(RoleList userRoles) {
        this.userRoles = userRoles;
    }

    public UserItem title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="Job title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public UserItem gender(GenderEnum gender) {
        this.gender = gender;
        return this;
    }

    @ApiModelProperty(example="n", value="Gender")
    public GenderEnum getGender() {
        return this.gender;
    }

    public void setGender(GenderEnum gender) {
        this.gender = gender;
    }

    public UserItem createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(example="2018-01-01T00:00:00", value="Creation date")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public UserItem lastLoginSuccessAt(DateTime lastLoginSuccessAt) {
        this.lastLoginSuccessAt = lastLoginSuccessAt;
        return this;
    }

    @ApiModelProperty(example="2018-01-01T00:00:00", value="Last successful logon date")
    public DateTime getLastLoginSuccessAt() {
        return this.lastLoginSuccessAt;
    }

    public void setLastLoginSuccessAt(DateTime lastLoginSuccessAt) {
        this.lastLoginSuccessAt = lastLoginSuccessAt;
    }

    public UserItem expireAt(DateTime expireAt) {
        this.expireAt = expireAt;
        return this;
    }

    @ApiModelProperty(example="2018-01-01T00:00:00", value="Expiration date")
    public DateTime getExpireAt() {
        return this.expireAt;
    }

    public void setExpireAt(DateTime expireAt) {
        this.expireAt = expireAt;
    }

    public UserItem isEncryptionEnabled(Boolean isEncryptionEnabled) {
        this.isEncryptionEnabled = isEncryptionEnabled;
        return this;
    }

    @ApiModelProperty(example="false", value="User has generated private key. Possible if **TripleCrypt\u2122 technology** is active for this customer")
    public Boolean getIsEncryptionEnabled() {
        return this.isEncryptionEnabled;
    }

    public void setIsEncryptionEnabled(Boolean isEncryptionEnabled) {
        this.isEncryptionEnabled = isEncryptionEnabled;
    }

    public UserItem userAttributes(UserAttributes userAttributes) {
        this.userAttributes = userAttributes;
        return this;
    }

    @ApiModelProperty(value="User attributes")
    public UserAttributes getUserAttributes() {
        return this.userAttributes;
    }

    public void setUserAttributes(UserAttributes userAttributes) {
        this.userAttributes = userAttributes;
    }

    public UserItem email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(example="john.doe@email.com", value="Email (not used)")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public UserItem phone(String phone) {
        this.phone = phone;
        return this;
    }

    @ApiModelProperty(value="Phone Number")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserItem userItem = (UserItem)o;
        return Objects.equals(this.id, userItem.id) && Objects.equals(this.login, userItem.login) && Objects.equals(this.firstName, userItem.firstName) && Objects.equals(this.lastName, userItem.lastName) && Objects.equals(this.lockStatus, userItem.lockStatus) && Objects.equals(this.isLocked, userItem.isLocked) && Objects.equals(this.hasManageableRooms, userItem.hasManageableRooms) && Objects.equals(this.userRoles, userItem.userRoles) && Objects.equals(this.title, userItem.title) && Objects.equals((Object)this.gender, (Object)userItem.gender) && Objects.equals(this.createdAt, userItem.createdAt) && Objects.equals(this.lastLoginSuccessAt, userItem.lastLoginSuccessAt) && Objects.equals(this.expireAt, userItem.expireAt) && Objects.equals(this.isEncryptionEnabled, userItem.isEncryptionEnabled) && Objects.equals(this.userAttributes, userItem.userAttributes) && Objects.equals(this.email, userItem.email) && Objects.equals(this.phone, userItem.phone);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.login, this.firstName, this.lastName, this.lockStatus, this.isLocked, this.hasManageableRooms, this.userRoles, this.title, this.gender, this.createdAt, this.lastLoginSuccessAt, this.expireAt, this.isEncryptionEnabled, this.userAttributes, this.email, this.phone});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserItem {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    login: ").append(this.toIndentedString(this.login)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    lockStatus: ").append(this.toIndentedString(this.lockStatus)).append("\n");
        sb.append("    isLocked: ").append(this.toIndentedString(this.isLocked)).append("\n");
        sb.append("    hasManageableRooms: ").append(this.toIndentedString(this.hasManageableRooms)).append("\n");
        sb.append("    userRoles: ").append(this.toIndentedString(this.userRoles)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    gender: ").append(this.toIndentedString((Object)this.gender)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    lastLoginSuccessAt: ").append(this.toIndentedString(this.lastLoginSuccessAt)).append("\n");
        sb.append("    expireAt: ").append(this.toIndentedString(this.expireAt)).append("\n");
        sb.append("    isEncryptionEnabled: ").append(this.toIndentedString(this.isEncryptionEnabled)).append("\n");
        sb.append("    userAttributes: ").append(this.toIndentedString(this.userAttributes)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum GenderEnum {
        M("m"),
        F("f"),
        N("n");

        private String value;

        private GenderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static GenderEnum fromValue(String text) {
            for (GenderEnum b : GenderEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

