/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.crypto;

import com.dracoon.sdk.crypto.BadFileException;
import com.dracoon.sdk.crypto.CryptoSystemException;
import com.dracoon.sdk.crypto.FileCipher;
import com.dracoon.sdk.crypto.model.EncryptedDataContainer;
import com.dracoon.sdk.crypto.model.PlainDataContainer;
import com.dracoon.sdk.crypto.model.PlainFileKey;

public class FileEncryptionCipher
extends FileCipher {
    FileEncryptionCipher(PlainFileKey fileKey) throws CryptoSystemException {
        try {
            this.init(true, fileKey);
        }
        catch (IllegalArgumentException e) {
            throw new CryptoSystemException("Could not create encryption cipher.", e);
        }
    }

    public EncryptedDataContainer processBytes(PlainDataContainer plainData) throws IllegalArgumentException, IllegalStateException, CryptoSystemException {
        byte[] eData;
        if (plainData == null) {
            throw new IllegalArgumentException("Data container cannot be null.");
        }
        if (plainData.getContent() == null) {
            throw new IllegalArgumentException("Data container content cannot be null.");
        }
        try {
            eData = this.process(plainData.getContent(), false);
        }
        catch (BadFileException e) {
            throw new CryptoSystemException("Could not encrypt file. Encryption failed.", e);
        }
        return new EncryptedDataContainer(eData, null);
    }

    public EncryptedDataContainer doFinal() throws IllegalStateException, CryptoSystemException {
        byte[] eData;
        try {
            eData = this.process(new byte[0], true);
        }
        catch (BadFileException e) {
            throw new CryptoSystemException("Could not encrypt file. Encryption failed.", e);
        }
        byte[] content = new byte[eData.length - 16];
        byte[] tag = new byte[16];
        System.arraycopy(eData, 0, content, 0, content.length);
        System.arraycopy(eData, content.length, tag, 0, tag.length);
        return new EncryptedDataContainer(content, tag);
    }
}

