/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.spectra;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.IndexedListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.s3.S3ListService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.spectra.SpectraSession;
import java.util.HashMap;

public class SpectraListService
extends S3ListService {
    public SpectraListService(SpectraSession session) {
        super((S3Session)session);
    }

    public AttributedList<Path> list(Path directory, final ListProgressListener listener) throws BackgroundException {
        return super.list(directory, (ListProgressListener)new IndexedListProgressListener(){

            public void message(String message) {
                listener.message(message);
            }

            public void chunk(Path folder, AttributedList<Path> list) throws ConnectionCanceledException {
                super.chunk(folder, list);
                listener.chunk(folder, list);
            }

            public void visit(AttributedList<Path> list, int index, Path p) {
                if (p.isFile() && p.attributes().isDuplicate() && p.attributes().getRevision() == 1L) {
                    HashMap<String, String> custom = new HashMap<String, String>(p.attributes().getCustom());
                    custom.put("revertable", Boolean.TRUE.toString());
                    p.attributes().setCustom(custom);
                }
            }
        });
    }
}

