/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.spectra;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.spectra.LazyInputStream;
import ch.cyberduck.core.spectra.SpectraBulkService;
import ch.cyberduck.core.spectra.SpectraSession;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.jets3t.service.ServiceException;

public class SpectraReadFeature
implements Read {
    private final PathContainerService containerService = new S3PathContainerService();
    private final SpectraSession session;
    private final SpectraBulkService bulk;

    public SpectraReadFeature(SpectraSession session) {
        this(session, new SpectraBulkService(session));
    }

    public SpectraReadFeature(SpectraSession session, SpectraBulkService bulk) {
        this.session = session;
        this.bulk = bulk;
    }

    public InputStream read(final Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        List<TransferStatus> chunks = this.bulk.query(Transfer.Type.download, file, status);
        chunks.sort(Comparator.comparingLong(TransferStatus::getOffset));
        ArrayList<LazyInputStream> streams = new ArrayList<LazyInputStream>();
        for (final TransferStatus chunk : chunks) {
            LazyInputStream in = new LazyInputStream(new LazyInputStream.OpenCallback(){

                @Override
                public InputStream open() throws IOException {
                    try {
                        return ((RequestEntityRestStorageService)SpectraReadFeature.this.session.getClient()).getObjectImpl(false, SpectraReadFeature.this.containerService.getContainer(file).getName(), SpectraReadFeature.this.containerService.getKey(file), null, null, null, null, null, null, file.attributes().getVersionId(), new HashMap(), chunk.getParameters()).getDataInputStream();
                    }
                    catch (ServiceException e) {
                        throw new IOException(e.getMessage(), e);
                    }
                }
            });
            streams.add(in);
        }
        return new SequenceInputStream(Collections.enumeration(streams));
    }

    public boolean offset(Path file) {
        return false;
    }
}

