/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.openstack.swift;

import ch.iterate.openstack.swift.io.ContentLengthInputStream;
import ch.iterate.openstack.swift.io.HttpMethodReleaseInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.util.EntityUtils;

public class Response {
    private HttpResponse response;

    public Response(HttpResponse r) {
        this.response = r;
    }

    public Header[] getResponseHeaders() {
        return this.response.getAllHeaders();
    }

    public StatusLine getStatusLine() {
        return this.response.getStatusLine();
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public String getStatusMessage() {
        return this.response.getStatusLine().getReasonPhrase();
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public String getResponseBodyAsString() throws IOException {
        return EntityUtils.toString((HttpEntity)this.response.getEntity());
    }

    public ContentLengthInputStream getResponseBodyAsStream() throws IOException {
        return new ContentLengthInputStream((InputStream)((Object)new HttpMethodReleaseInputStream(this.response)), this.response.getEntity().getContentLength());
    }

    public byte[] getResponseBody() throws IOException {
        return EntityUtils.toByteArray((HttpEntity)this.response.getEntity());
    }

    public Header getResponseHeader(String headerName) {
        return this.response.getFirstHeader(headerName);
    }

    public Header[] getResponseHeaders(String headerName) {
        return this.response.getHeaders(headerName);
    }

    public String getContentEncoding() {
        return this.response.getEntity().getContentEncoding().getValue();
    }
}

