/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.openstack.swift.handler;

import ch.iterate.openstack.swift.Response;
import ch.iterate.openstack.swift.exception.AuthorizationException;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.model.AccountInfo;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;

public class AccountInfoHandler
implements ResponseHandler<AccountInfo> {
    public AccountInfo handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        if (response.getStatusLine().getStatusCode() == 204 || response.getStatusLine().getStatusCode() == 200) {
            return new AccountInfo(this.getAccountBytesUsed(response), this.getAccountContainerCount(response), this.getAccountTempUrlKey(response));
        }
        if (response.getStatusLine().getStatusCode() == 401) {
            throw new AuthorizationException(new Response(response));
        }
        throw new GenericException(new Response(response));
    }

    private Integer getAccountContainerCount(HttpResponse response) {
        Header contCountHeader = response.getFirstHeader("X-Account-Container-Count");
        if (contCountHeader != null) {
            return Integer.parseInt(contCountHeader.getValue());
        }
        return null;
    }

    private Long getAccountBytesUsed(HttpResponse response) {
        Header accountBytesUsedHeader = response.getFirstHeader("X-Account-Bytes-Used");
        if (accountBytesUsedHeader != null) {
            return Long.parseLong(accountBytesUsedHeader.getValue());
        }
        return null;
    }

    private String getAccountTempUrlKey(HttpResponse response) {
        Header tempUrlKeyHeader = response.getFirstHeader("X-Account-Meta-Temp-URL-Key");
        if (tempUrlKeyHeader != null) {
            return tempUrlKeyHeader.getValue();
        }
        return null;
    }
}

