/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.events;

import com.google.common.base.Preconditions;
import com.spectralogic.ds3client.utils.Guard;

public class FailureEvent {
    private final FailureActivity doingWhat;
    private final String objectName;
    private final String endpoint;
    private final Throwable causalException;

    private FailureEvent(FailureActivity what, String objectName, String endpoint, Throwable causalException) {
        this.doingWhat = what;
        this.objectName = objectName;
        this.endpoint = endpoint;
        this.causalException = causalException;
    }

    public FailureActivity doingWhat() {
        return this.doingWhat;
    }

    public String withObjectNamed() {
        return this.objectName;
    }

    public String usingSystemWithEndpoint() {
        return this.endpoint;
    }

    public Throwable getCausalException() {
        return this.causalException;
    }

    public String toString() {
        return "Failure " + this.doingWhat().getActivityText() + " with object named \"" + this.withObjectNamed() + "\" using system with endpoint " + this.usingSystemWithEndpoint();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private FailureActivity doingWhat;
        private String withObjectNamed;
        private String usingSystemWithEndpoint;
        private Throwable causalException;

        public Builder doingWhat(FailureActivity what) {
            this.doingWhat = what;
            return this;
        }

        public Builder withObjectNamed(String objectName) {
            this.withObjectNamed = objectName;
            return this;
        }

        public Builder usingSystemWithEndpoint(String endpoint) {
            this.usingSystemWithEndpoint = endpoint;
            return this;
        }

        public Builder withCausalException(Throwable causalException) {
            this.causalException = causalException;
            return this;
        }

        public FailureEvent build() {
            Preconditions.checkNotNull((Object)((Object)this.doingWhat), (Object)"The failed activity may not be null or empty.");
            Guard.throwOnNullOrEmptyString(this.withObjectNamed, "The name of the object involved in the activity may not be null or empty.");
            Guard.throwOnNullOrEmptyString(this.usingSystemWithEndpoint, "The endpoint referenced in the activity may not be null or empty.");
            Preconditions.checkNotNull((Object)this.causalException, (Object)"The exception causing a failure may not be null.");
            return new FailureEvent(this.doingWhat, this.withObjectNamed, this.usingSystemWithEndpoint, this.causalException);
        }
    }

    public static enum FailureActivity {
        PuttingObject("putting object"),
        GettingObject("getting object"),
        ComputingChecksum("computing checksum"),
        RecordingMetadata("recording metadata"),
        RestoringMetadata("restoring metadata");

        private final String activityText;

        private FailureActivity(String activityText) {
            this.activityText = activityText;
        }

        public String getActivityText() {
            return this.activityText;
        }
    }
}

