/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.utils;

import com.google.common.escape.Escaper;
import com.google.common.net.PercentEscaper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;

public final class MetadataStringManipulation {
    private static final String HTTP_HEADER_SAFE_CHARS = "!#$&'*-.~^_`|,=";
    private static final Escaper HTTP_HEADER_ESCAPER = new PercentEscaper("!#$&'*-.~^_`|,=", false);

    private MetadataStringManipulation() {
    }

    public static String toEncodedString(String str) {
        if (str == null) {
            return null;
        }
        String strUtf8 = new String(str.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
        return MetadataStringManipulation.getMetadataEscaper().escape(strUtf8);
    }

    public static String toDecodedString(String str) {
        if (str == null) {
            return null;
        }
        try {
            return URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not decode string: " + str, e);
        }
    }

    private static Escaper getMetadataEscaper() {
        return HTTP_HEADER_ESCAPER;
    }
}

