/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.nuxeo.onedrive.client.AbstractResponse;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.RequestExecutor;
import org.nuxeo.onedrive.client.RequestHeader;

public abstract class AbstractRequest<R extends AbstractResponse> {
    private final Set<RequestHeader> headers = new HashSet<RequestHeader>();
    private final String method;
    private final URL url;

    public AbstractRequest(URL url, String method) {
        this.url = Objects.requireNonNull(url);
        this.method = Objects.requireNonNull(method);
    }

    public void addHeader(String key, String value) {
        this.headers.add(new RequestHeader(key, value));
    }

    public R sendRequest(RequestExecutor sender) throws IOException {
        return this.sendRequest(sender, null);
    }

    public R sendRequest(RequestExecutor sender, InputStream body) throws IOException {
        this.addAuthorizationHeader(sender, this.headers);
        switch (this.method) {
            case "GET": {
                RequestExecutor.Response response = sender.doGet(this.url, this.headers);
                return this.createResponse(response);
            }
            case "DELETE": {
                RequestExecutor.Response response = sender.doDelete(this.url, this.headers);
                return this.createResponse(response);
            }
            case "POST": {
                RequestExecutor.Upload response = sender.doPost(this.url, this.headers);
                OutputStream out = response.getOutputStream();
                IOUtils.copy((InputStream)body, (OutputStream)out);
                out.close();
                return this.createResponse(response.getResponse());
            }
            case "PATCH": {
                RequestExecutor.Upload response = sender.doPatch(this.url, this.headers);
                OutputStream out = response.getOutputStream();
                IOUtils.copy((InputStream)body, (OutputStream)out);
                out.close();
                return this.createResponse(response.getResponse());
            }
            case "PUT": {
                RequestExecutor.Upload response = sender.doPut(this.url, this.headers);
                OutputStream out = response.getOutputStream();
                IOUtils.copy((InputStream)body, (OutputStream)out);
                out.close();
                return this.createResponse(response.getResponse());
            }
        }
        throw new OneDriveAPIException(String.format("Unsupported HTTP method %s", this.method));
    }

    protected void addAuthorizationHeader(RequestExecutor executor, Set<RequestHeader> headers) {
        executor.addAuthorizationHeader(headers);
    }

    protected abstract R createResponse(RequestExecutor.Response var1) throws IOException;
}

