/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.UseragentProvider;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.Lifecycle;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.features.Logging;
import ch.cyberduck.core.features.Metadata;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.googlestorage.GoogleStorageAttributesFinderFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageCopyFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageDeleteFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageDirectoryFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageFindFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageHomeFinderService;
import ch.cyberduck.core.googlestorage.GoogleStorageLifecycleFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageListService;
import ch.cyberduck.core.googlestorage.GoogleStorageLocationFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageLoggingFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageMetadataFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageMoveFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageReadFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageSearchFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageTouchFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageUrlProvider;
import ch.cyberduck.core.googlestorage.GoogleStorageWebsiteDistributionConfiguration;
import ch.cyberduck.core.googlestorage.GoogleStorageWriteFeature;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.identity.DefaultCredentialsIdentityConfiguration;
import ch.cyberduck.core.identity.IdentityConfiguration;
import ch.cyberduck.core.oauth.OAuth2ErrorResponseInterceptor;
import ch.cyberduck.core.oauth.OAuth2RequestInterceptor;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.ssl.DefaultX509KeyManager;
import ch.cyberduck.core.ssl.DisabledX509TrustManager;
import ch.cyberduck.core.ssl.ThreadLocalHostnameDelegatingTrustManager;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.v2.ApacheHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.storage.Storage;
import java.io.IOException;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.HttpClientBuilder;

public class GoogleStorageSession
extends HttpSession<Storage> {
    private ApacheHttpTransport transport;
    private final UseragentProvider useragent = new PreferencesUseragentProvider();
    private OAuth2RequestInterceptor authorizationService;

    public GoogleStorageSession(Host host) {
        super(host, new ThreadLocalHostnameDelegatingTrustManager((X509TrustManager)new DisabledX509TrustManager(), host.getHostname()), (X509KeyManager)new DefaultX509KeyManager());
    }

    public GoogleStorageSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, new ThreadLocalHostnameDelegatingTrustManager(trust, host.getHostname()), key);
    }

    public Storage connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt) {
        HttpClientBuilder configuration = this.builder.build(proxy, (TranscriptListener)this, prompt);
        this.authorizationService = new OAuth2RequestInterceptor((HttpClient)configuration.build(), this.host.getProtocol()).withRedirectUri(this.host.getProtocol().getOAuthRedirectUrl());
        configuration.addInterceptorLast((HttpRequestInterceptor)this.authorizationService);
        configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new OAuth2ErrorResponseInterceptor(this.host, this.authorizationService, prompt));
        this.transport = new ApacheHttpTransport((HttpClient)configuration.build());
        return new Storage.Builder((HttpTransport)this.transport, (JsonFactory)new JacksonFactory(), new HttpRequestInitializer(){

            public void initialize(HttpRequest request) {
                request.setSuppressUserAgentSuffix(true);
            }
        }).setApplicationName(this.useragent.get()).build();
    }

    public void login(Proxy proxy, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        this.authorizationService.setTokens(this.authorizationService.authorize(this.host, prompt, cancel));
    }

    protected void logout() throws BackgroundException {
        try {
            this.transport.shutdown();
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public HttpClient getHttpClient() {
        return this.transport.getHttpClient();
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == ListService.class) {
            return (T)new GoogleStorageListService(this);
        }
        if (type == Touch.class) {
            return (T)new GoogleStorageTouchFeature(this);
        }
        if (type == Read.class) {
            return (T)new GoogleStorageReadFeature(this);
        }
        if (type == Write.class) {
            return (T)((Object)new GoogleStorageWriteFeature(this));
        }
        if (type == Find.class) {
            return (T)new GoogleStorageFindFeature(this);
        }
        if (type == AttributesFinder.class) {
            return (T)new GoogleStorageAttributesFinderFeature(this);
        }
        if (type == Delete.class) {
            return (T)new GoogleStorageDeleteFeature(this);
        }
        if (type == Directory.class) {
            return (T)new GoogleStorageDirectoryFeature(this);
        }
        if (type == Move.class) {
            return (T)new GoogleStorageMoveFeature(this);
        }
        if (type == Headers.class) {
            return (T)new GoogleStorageMetadataFeature(this);
        }
        if (type == Metadata.class) {
            return (T)new GoogleStorageMetadataFeature(this);
        }
        if (type == Copy.class) {
            return (T)new GoogleStorageCopyFeature(this);
        }
        if (type == DistributionConfiguration.class) {
            return (T)new GoogleStorageWebsiteDistributionConfiguration(this);
        }
        if (type == IdentityConfiguration.class) {
            return (T)new DefaultCredentialsIdentityConfiguration(this.host);
        }
        if (type == Logging.class) {
            return (T)new GoogleStorageLoggingFeature(this);
        }
        if (type == UrlProvider.class) {
            return (T)new GoogleStorageUrlProvider(this);
        }
        if (type == Search.class) {
            return (T)new GoogleStorageSearchFeature(this);
        }
        if (type == Versioning.class) {
            return null;
        }
        if (type == Location.class) {
            return (T)new GoogleStorageLocationFeature(this);
        }
        if (type == Home.class) {
            return (T)((Object)new GoogleStorageHomeFinderService((Session)this));
        }
        if (type == Lifecycle.class) {
            return (T)new GoogleStorageLifecycleFeature(this);
        }
        return (T)super._getFeature(type);
    }
}

