/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.googlestorage.GoogleStorageWriteFeature;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.DefaultStreamCloser;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.input.NullInputStream;

public class GoogleStorageTouchFeature
implements Touch<VersionId> {
    private Write<VersionId> writer;

    public GoogleStorageTouchFeature(GoogleStorageSession session) {
        this.writer = new GoogleStorageWriteFeature(session);
    }

    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        if (Checksum.NONE == status.getChecksum()) {
            status.setChecksum(this.writer.checksum(file).compute((InputStream)new NullInputStream(0L), status));
        }
        status.setLength(0L);
        StatusOutputStream out = this.writer.write(file, status, (ConnectionCallback)new DisabledConnectionCallback());
        new DefaultStreamCloser().close((OutputStream)out);
        return new Path(file.getParent(), file.getName(), file.getType(), new PathAttributes(file.attributes()).withVersionId(((VersionId)out.getStatus()).id));
    }

    public boolean isSupported(Path workdir, String filename) {
        return !workdir.isRoot();
    }

    public Touch<VersionId> withWriter(Write<VersionId> writer) {
        this.writer = writer;
        return this;
    }
}

