/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.oauth;

import ch.cyberduck.core.oauth.OAuth2TokenListener;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class OAuth2TokenListenerRegistry {
    private static final Logger log = Logger.getLogger(OAuth2TokenListenerRegistry.class);
    private static final OAuth2TokenListenerRegistry global = new OAuth2TokenListenerRegistry();
    private final Map<String, OAuth2TokenListener> listeners = new HashMap<String, OAuth2TokenListener>();

    public static OAuth2TokenListenerRegistry get() {
        return global;
    }

    public void register(String state, OAuth2TokenListener listener) {
        this.listeners.put(state, listener);
    }

    public void notify(String state, String token) {
        OAuth2TokenListener listener = this.listeners.get(state);
        if (null == listener) {
            log.error((Object)String.format("Missing listener for state %s", state));
            return;
        }
        this.listeners.remove(state);
        listener.callback(token);
    }
}

