/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateIdProvider;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.io.swagger.client.ApiClient;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.api.FilesApi;
import ch.cyberduck.core.storegate.io.swagger.client.model.MoveFileRequest;
import ch.cyberduck.core.transfer.TransferStatus;

public class StoregateMoveFeature
implements Move {
    private final StoregateSession session;
    private final StoregateIdProvider fileid;

    public StoregateMoveFeature(StoregateSession session, StoregateIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public Path move(Path file, Path renamed, TransferStatus status, Delete.Callback delete, ConnectionCallback callback) throws BackgroundException {
        try {
            MoveFileRequest move = new MoveFileRequest().name(renamed.getName()).parentID(this.fileid.getFileid(renamed.getParent(), (ListProgressListener)new DisabledListProgressListener())).mode(MoveFileRequest.ModeEnum.NUMBER_1);
            new FilesApi((ApiClient)this.session.getClient()).filesMove(this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener()), move);
        }
        catch (ApiException e) {
            throw new StoregateExceptionMappingService().map("Cannot rename {0}", e, file);
        }
        return new Path(renamed.getParent(), renamed.getName(), renamed.getType(), new PathAttributes(renamed.attributes()).withVersionId(file.attributes().getVersionId()));
    }

    public boolean isRecursive(Path source, Path target) {
        return false;
    }

    public Move withDelete(Delete delete) {
        return this;
    }
}

