/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.http.HttpMethodReleaseInputStream;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.storegate.StoregateApiClient;
import ch.cyberduck.core.storegate.StoregateIdProvider;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.apache.log4j.Logger;

public class StoregateReadFeature
implements Read {
    private static final Logger log = Logger.getLogger(StoregateReadFeature.class);
    private final StoregateSession session;
    private final StoregateIdProvider fileid;

    public StoregateReadFeature(StoregateSession session, StoregateIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            StoregateApiClient client = (StoregateApiClient)this.session.getClient();
            HttpGet request = new HttpGet(String.format("%s/v4/download/files/%s?stream=true", client.getBasePath(), this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener())));
            if (status.isAppend()) {
                HttpRange range = HttpRange.withStatus((TransferStatus)status);
                String header = -1L == range.getEnd() ? String.format("bytes=%d-", range.getStart()) : String.format("bytes=%d-%d", range.getStart(), range.getEnd());
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Add range header %s for file %s", header, file));
                }
                request.addHeader((Header)new BasicHeader("Range", header));
                request.addHeader((Header)new BasicHeader("Accept-Encoding", "identity"));
            }
            CloseableHttpResponse response = client.getClient().execute((HttpUriRequest)request);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: 
                case 206: {
                    return new HttpMethodReleaseInputStream((HttpResponse)response);
                }
            }
            throw new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Download {0} failed", (Throwable)e, file);
        }
    }

    public boolean offset(Path file) {
        return true;
    }
}

