/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate.io.swagger.client.api;

import ch.cyberduck.core.storegate.io.swagger.client.ApiClient;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.ApiResponse;
import ch.cyberduck.core.storegate.io.swagger.client.Configuration;
import ch.cyberduck.core.storegate.io.swagger.client.Pair;
import ch.cyberduck.core.storegate.io.swagger.client.model.EventContents;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;
import org.joda.time.DateTime;

public class EventsApi {
    private ApiClient apiClient;

    public EventsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EventsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public EventContents eventsGet(Integer pageIndex, Integer pageSize, DateTime fromDate, DateTime toDate, String user, String fileId, String filename) throws ApiException {
        return this.eventsGetWithHttpInfo(pageIndex, pageSize, fromDate, toDate, user, fileId, filename).getData();
    }

    public ApiResponse<EventContents> eventsGetWithHttpInfo(Integer pageIndex, Integer pageSize, DateTime fromDate, DateTime toDate, String user, String fileId, String filename) throws ApiException {
        Object localVarPostBody = null;
        if (pageIndex == null) {
            throw new ApiException(400, "Missing the required parameter 'pageIndex' when calling eventsGet");
        }
        if (pageSize == null) {
            throw new ApiException(400, "Missing the required parameter 'pageSize' when calling eventsGet");
        }
        if (fromDate == null) {
            throw new ApiException(400, "Missing the required parameter 'fromDate' when calling eventsGet");
        }
        if (toDate == null) {
            throw new ApiException(400, "Missing the required parameter 'toDate' when calling eventsGet");
        }
        if (user == null) {
            throw new ApiException(400, "Missing the required parameter 'user' when calling eventsGet");
        }
        if (fileId == null) {
            throw new ApiException(400, "Missing the required parameter 'fileId' when calling eventsGet");
        }
        if (filename == null) {
            throw new ApiException(400, "Missing the required parameter 'filename' when calling eventsGet");
        }
        String localVarPath = "/v4/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageIndex", pageIndex));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fromDate", fromDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "toDate", toDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "user", user));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fileId", fileId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filename", filename));
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<EventContents> localVarReturnType = new GenericType<EventContents>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String eventsGet_0(DateTime fromDate, DateTime toDate, String user, String fileId, String filename) throws ApiException {
        return this.eventsGet_0WithHttpInfo(fromDate, toDate, user, fileId, filename).getData();
    }

    public ApiResponse<String> eventsGet_0WithHttpInfo(DateTime fromDate, DateTime toDate, String user, String fileId, String filename) throws ApiException {
        Object localVarPostBody = null;
        if (fromDate == null) {
            throw new ApiException(400, "Missing the required parameter 'fromDate' when calling eventsGet_0");
        }
        if (toDate == null) {
            throw new ApiException(400, "Missing the required parameter 'toDate' when calling eventsGet_0");
        }
        if (user == null) {
            throw new ApiException(400, "Missing the required parameter 'user' when calling eventsGet_0");
        }
        if (fileId == null) {
            throw new ApiException(400, "Missing the required parameter 'fileId' when calling eventsGet_0");
        }
        if (filename == null) {
            throw new ApiException(400, "Missing the required parameter 'filename' when calling eventsGet_0");
        }
        String localVarPath = "/v4/events/export";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fromDate", fromDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "toDate", toDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "user", user));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fileId", fileId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filename", filename));
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String eventsGet_1(String downloadid) throws ApiException {
        return this.eventsGet_1WithHttpInfo(downloadid).getData();
    }

    public ApiResponse<String> eventsGet_1WithHttpInfo(String downloadid) throws ApiException {
        Object localVarPostBody = null;
        if (downloadid == null) {
            throw new ApiException(400, "Missing the required parameter 'downloadid' when calling eventsGet_1");
        }
        String localVarPath = "/v4/events/export/{downloadid}".replaceAll("\\{downloadid\\}", this.apiClient.escapeString(downloadid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String eventsPost(DateTime fromDate, DateTime toDate, String user, String fileId, String filename) throws ApiException {
        return this.eventsPostWithHttpInfo(fromDate, toDate, user, fileId, filename).getData();
    }

    public ApiResponse<String> eventsPostWithHttpInfo(DateTime fromDate, DateTime toDate, String user, String fileId, String filename) throws ApiException {
        Object localVarPostBody = null;
        if (fromDate == null) {
            throw new ApiException(400, "Missing the required parameter 'fromDate' when calling eventsPost");
        }
        if (toDate == null) {
            throw new ApiException(400, "Missing the required parameter 'toDate' when calling eventsPost");
        }
        if (user == null) {
            throw new ApiException(400, "Missing the required parameter 'user' when calling eventsPost");
        }
        if (fileId == null) {
            throw new ApiException(400, "Missing the required parameter 'fileId' when calling eventsPost");
        }
        if (filename == null) {
            throw new ApiException(400, "Missing the required parameter 'filename' when calling eventsPost");
        }
        String localVarPath = "/v4/events/export";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fromDate", fromDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "toDate", toDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "user", user));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fileId", fileId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filename", filename));
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

