/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.gui;

import java.awt.Frame;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.utils.RestUtils;

public class GuiUtils {
    private static final Log log = LogFactory.getLog(GuiUtils.class);
    private Map cachedImageIcons = new HashMap();

    public boolean applyIcon(Object component, String iconResourcePath) {
        ImageIcon icon = (ImageIcon)this.cachedImageIcons.get(iconResourcePath);
        if (icon == null) {
            URL iconUrl = this.getClass().getResource(iconResourcePath);
            if (iconUrl == null) {
                try {
                    int firstSlashIndex = iconResourcePath.indexOf(47, 1);
                    String firstPathComponent = iconResourcePath.substring(0, firstSlashIndex);
                    String pathRemainder = iconResourcePath.substring(firstSlashIndex);
                    URL baseUrl = this.getClass().getResource(firstPathComponent);
                    iconUrl = new URL(baseUrl.toString() + RestUtils.encodeUrlPath(pathRemainder, "/"));
                    iconUrl.getContent();
                }
                catch (Exception e) {
                    log.warn((Object)("Unable to load icon with resource path: " + iconResourcePath));
                    return false;
                }
            }
            if (iconUrl != null) {
                icon = new ImageIcon(iconUrl);
                this.cachedImageIcons.put(iconResourcePath, icon);
            }
        }
        if (icon != null) {
            if (component instanceof JMenuItem) {
                ((JMenuItem)component).setIcon(icon);
            } else if (component instanceof JButton) {
                ((JButton)component).setIcon(icon);
            } else if (component instanceof JLabel) {
                ((JLabel)component).setIcon(icon);
            } else if (component instanceof Frame) {
                ((Frame)component).setIconImage(icon.getImage());
            } else {
                log.warn((Object)("Cannot set icon for unexpected JComponent object: " + component.getClass().getName()));
                return false;
            }
            return true;
        }
        log.warn((Object)("Unable to load icon with resource path: " + iconResourcePath));
        return false;
    }
}

