/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.samples;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.jets3t.samples.SamplesUtils;
import org.jets3t.service.Constants;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.ProviderCredentials;
import org.jets3t.service.utils.ServiceUtils;

public class StorePassphraseBasedLogin {
    private static final String passphrase = "Example passphrase";
    private static final String password = "password";

    public static void main(String[] args) throws Exception {
        AWSCredentials awsCredentials = SamplesUtils.loadAWSCredentials();
        String combinedPassphraseAndPassword = "Example passphrasepassword";
        String bucketName = "jets3t-" + ServiceUtils.toHex(ServiceUtils.computeMD5Hash(passphrase.getBytes(Constants.DEFAULT_ENCODING)));
        String credentialObjectName = ServiceUtils.toHex(ServiceUtils.computeMD5Hash(combinedPassphraseAndPassword.getBytes(Constants.DEFAULT_ENCODING))) + "/jets3t.credentials";
        S3Bucket bucket = new S3Bucket(bucketName);
        System.out.println("bucketName=" + bucketName);
        System.out.println("credentialObjectName=" + credentialObjectName);
        RestS3Service s3Service = new RestS3Service(awsCredentials);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        awsCredentials.save(password, baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        bucket = s3Service.createBucket(bucketName);
        S3Object credsObject = new S3Object(credentialObjectName);
        credsObject.setDataInputStream(bais);
        credsObject.setAcl(AccessControlList.REST_CANNED_PUBLIC_READ);
        s3Service.putObject(bucket, credsObject);
        s3Service = new RestS3Service(null);
        System.out.println("Is bucket accessible? " + s3Service.isBucketAccessible(bucketName));
        S3Object retrievedCredsObject = s3Service.getObject(bucket, credentialObjectName);
        ProviderCredentials retrievedCreds = AWSCredentials.load(password, new BufferedInputStream(retrievedCredsObject.getDataInputStream()));
        System.out.println("Retrieved credentials from S3: " + retrievedCreds.getAccessKey() + " : " + retrievedCreds.getSecretKey());
    }
}

