/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.security;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.jets3t.service.security.AWSSessionCredentials;
import org.jets3t.service.utils.RestUtils;
import org.jets3t.service.utils.ServiceUtils;

public class AWSEC2IAMSessionCredentials
extends AWSSessionCredentials {
    private static final Log log = LogFactory.getLog(AWSEC2IAMSessionCredentials.class);
    protected static String baseCredentialsUrl = "http://169.254.169.254/latest/meta-data/iam/security-credentials";
    protected String roleName = null;
    protected Date expiration = null;
    protected boolean automaticRefreshEnabled = true;
    protected long automaticRefreshRetryDelaySeconds = 10L;
    private volatile long automaticRefreshLastRetryMS = 0L;

    public AWSEC2IAMSessionCredentials(String awsAccessKey, String awsSecretAccessKey, String sessionToken, String roleName, Date expiration, boolean automaticRefreshEnabled) {
        super(awsAccessKey, awsSecretAccessKey, sessionToken, null);
        this.roleName = roleName;
        this.expiration = expiration;
        this.automaticRefreshEnabled = automaticRefreshEnabled;
    }

    @Override
    protected String getTypeName() {
        return "ec2-iam-session";
    }

    public boolean isAutomaticRefreshEnabled() {
        return this.automaticRefreshEnabled;
    }

    @Override
    public String getSessionToken() {
        this.refreshFromEC2InstanceDataIfNearExpiration();
        return this.sessionToken;
    }

    @Override
    public String getAccessKey() {
        this.refreshFromEC2InstanceDataIfNearExpiration();
        return this.accessKey;
    }

    @Override
    public String getSecretKey() {
        this.refreshFromEC2InstanceDataIfNearExpiration();
        return this.secretKey;
    }

    public String getRoleName() {
        this.refreshFromEC2InstanceDataIfNearExpiration();
        return this.roleName;
    }

    public Date getExpiration() {
        this.refreshFromEC2InstanceDataIfNearExpiration();
        return this.expiration;
    }

    public boolean isNearExpiration() {
        long diffOf15MinsInMS;
        Date now = new Date();
        long difference = this.expiration.getTime() - now.getTime();
        return difference <= (diffOf15MinsInMS = 900000L);
    }

    public void refreshFromEC2InstanceData() {
        AWSEC2IAMSessionCredentials loadedCredentials = AWSEC2IAMSessionCredentials.loadFromEC2InstanceData(this.roleName, this.automaticRefreshEnabled);
        this.accessKey = loadedCredentials.getAccessKey();
        this.secretKey = loadedCredentials.getSecretKey();
        this.sessionToken = loadedCredentials.getSessionToken();
        this.expiration = loadedCredentials.getExpiration();
    }

    public synchronized void refreshFromEC2InstanceDataIfNearExpiration() {
        if (this.automaticRefreshEnabled && this.isNearExpiration()) {
            long msSinceLastRetry = System.currentTimeMillis() - this.automaticRefreshLastRetryMS;
            if (msSinceLastRetry / 1000L < this.automaticRefreshRetryDelaySeconds) {
                return;
            }
            try {
                this.automaticRefreshLastRetryMS = System.currentTimeMillis();
                this.refreshFromEC2InstanceData();
            }
            catch (Exception ex) {
                log.warn((Object)"Failed to automatically refresh IAM role credentials from EC2 instance data", (Throwable)ex);
            }
        }
    }

    public static AWSEC2IAMSessionCredentials loadFromEC2InstanceData(String urlPrefix, String roleName, boolean automaticRefreshEnabled) {
        try {
            String url = urlPrefix;
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            url = url + roleName;
            String iamRoleData = RestUtils.httpGetUrlAsString(url);
            return AWSEC2IAMSessionCredentials.parseEC2InstanceData(iamRoleData, roleName, automaticRefreshEnabled);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static AWSEC2IAMSessionCredentials loadFromEC2InstanceData(String roleName, boolean automaticRefreshEnabled) {
        return AWSEC2IAMSessionCredentials.loadFromEC2InstanceData(baseCredentialsUrl, roleName, automaticRefreshEnabled);
    }

    public static AWSEC2IAMSessionCredentials loadFromEC2InstanceData(boolean automaticRefreshEnabled) {
        String roleName;
        try {
            roleName = RestUtils.httpGetUrlAsString(baseCredentialsUrl + "/").trim();
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not fetch IAM role name from EC2 meta data!", ex);
        }
        if (roleName == null || roleName.length() == 0) {
            throw new RuntimeException("Empty IAM role name in EC2 meta data!");
        }
        return AWSEC2IAMSessionCredentials.loadFromEC2InstanceData(baseCredentialsUrl, roleName, automaticRefreshEnabled);
    }

    public static AWSEC2IAMSessionCredentials parseEC2InstanceData(String iamRoleData, String roleName, boolean automaticRefreshEnabled) throws JsonProcessingException, IOException, ParseException {
        ObjectMapper jsonMapper = new ObjectMapper();
        JsonNode node = jsonMapper.readTree(iamRoleData);
        String resultCode = (String)node.findValuesAsText("Code").get(0);
        if (!resultCode.equals("Success")) {
            throw new RuntimeException("Status 'Code' != 'Success'");
        }
        String accessKey = (String)node.findValuesAsText("AccessKeyId").get(0);
        String secretKey = (String)node.findValuesAsText("SecretAccessKey").get(0);
        String sessionToken = (String)node.findValuesAsText("Token").get(0);
        Date expiration = ServiceUtils.parseIso8601Date((String)node.findValuesAsText("Expiration").get(0));
        return new AWSEC2IAMSessionCredentials(accessKey, secretKey, sessionToken, roleName, expiration, automaticRefreshEnabled);
    }
}

