/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.servlets.gatekeeper.impl;

import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.utils.gatekeeper.SignatureRequest;
import org.jets3t.servlets.gatekeeper.impl.DefaultUrlSigner;

public class RenameToUuidUrlSigner
extends DefaultUrlSigner {
    private static final Log log = LogFactory.getLog(RenameToUuidUrlSigner.class);
    private String lastTransactionId = "";
    private int countOfRenamedObjects = 0;

    public RenameToUuidUrlSigner(ServletConfig servletConfig) throws ServletException {
        super(servletConfig);
    }

    @Override
    protected void updateObject(SignatureRequest signatureRequest, Properties messageProperties) throws S3ServiceException {
        super.updateObject(signatureRequest, messageProperties);
        String transactionId = messageProperties.getProperty("transactionId");
        Map objectMetadata = signatureRequest.getObjectMetadata();
        if (transactionId != null) {
            if (!this.lastTransactionId.equals(transactionId)) {
                this.countOfRenamedObjects = 0;
                this.lastTransactionId = transactionId;
            }
            String originalKey = signatureRequest.getObjectKey();
            if (objectMetadata.containsKey("jets3t-uploader-summary-doc")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Object with key '" + originalKey + "' is flagged as a Summary Document, and will not be renamed"));
                }
            } else {
                String extension = null;
                int lastDotIndex = originalKey.lastIndexOf(".");
                if (lastDotIndex >= 0) {
                    extension = originalKey.substring(lastDotIndex + 1);
                }
                String newKey = transactionId + "." + ++this.countOfRenamedObjects + (extension != null ? "." + extension : "");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Renamed object key '" + originalKey + "' to '" + newKey + "'"));
                }
                signatureRequest.setObjectKey(newKey);
            }
        }
    }
}

