/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.fileproperties.TemplateFilterBase;
import com.dropbox.core.v2.files.SharedLink;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

class ListFolderArg {
    protected final String path;
    protected final boolean recursive;
    protected final boolean includeMediaInfo;
    protected final boolean includeDeleted;
    protected final boolean includeHasExplicitSharedMembers;
    protected final boolean includeMountedFolders;
    protected final Long limit;
    protected final SharedLink sharedLink;
    protected final TemplateFilterBase includePropertyGroups;

    public ListFolderArg(String path, boolean recursive, boolean includeMediaInfo, boolean includeDeleted, boolean includeHasExplicitSharedMembers, boolean includeMountedFolders, Long limit, SharedLink sharedLink, TemplateFilterBase includePropertyGroups) {
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        if (!Pattern.matches("(/(.|[\\r\\n])*)?|id:.*|(ns:[0-9]+(/.*)?)", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        this.recursive = recursive;
        this.includeMediaInfo = includeMediaInfo;
        this.includeDeleted = includeDeleted;
        this.includeHasExplicitSharedMembers = includeHasExplicitSharedMembers;
        this.includeMountedFolders = includeMountedFolders;
        if (limit != null) {
            if (limit < 1L) {
                throw new IllegalArgumentException("Number 'limit' is smaller than 1L");
            }
            if (limit > 2000L) {
                throw new IllegalArgumentException("Number 'limit' is larger than 2000L");
            }
        }
        this.limit = limit;
        this.sharedLink = sharedLink;
        this.includePropertyGroups = includePropertyGroups;
    }

    public ListFolderArg(String path) {
        this(path, false, false, false, false, true, null, null, null);
    }

    public String getPath() {
        return this.path;
    }

    public boolean getRecursive() {
        return this.recursive;
    }

    public boolean getIncludeMediaInfo() {
        return this.includeMediaInfo;
    }

    public boolean getIncludeDeleted() {
        return this.includeDeleted;
    }

    public boolean getIncludeHasExplicitSharedMembers() {
        return this.includeHasExplicitSharedMembers;
    }

    public boolean getIncludeMountedFolders() {
        return this.includeMountedFolders;
    }

    public Long getLimit() {
        return this.limit;
    }

    public SharedLink getSharedLink() {
        return this.sharedLink;
    }

    public TemplateFilterBase getIncludePropertyGroups() {
        return this.includePropertyGroups;
    }

    public static Builder newBuilder(String path) {
        return new Builder(path);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.recursive, this.includeMediaInfo, this.includeDeleted, this.includeHasExplicitSharedMembers, this.includeMountedFolders, this.limit, this.sharedLink, this.includePropertyGroups});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListFolderArg other = (ListFolderArg)obj;
            return (this.path == other.path || this.path.equals(other.path)) && this.recursive == other.recursive && this.includeMediaInfo == other.includeMediaInfo && this.includeDeleted == other.includeDeleted && this.includeHasExplicitSharedMembers == other.includeHasExplicitSharedMembers && this.includeMountedFolders == other.includeMountedFolders && (this.limit == other.limit || this.limit != null && this.limit.equals(other.limit)) && (this.sharedLink == other.sharedLink || this.sharedLink != null && this.sharedLink.equals(other.sharedLink)) && (this.includePropertyGroups == other.includePropertyGroups || this.includePropertyGroups != null && this.includePropertyGroups.equals(other.includePropertyGroups));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<ListFolderArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ListFolderArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("path");
            StoneSerializers.string().serialize(value.path, g);
            g.writeFieldName("recursive");
            StoneSerializers.boolean_().serialize((Boolean)value.recursive, g);
            g.writeFieldName("include_media_info");
            StoneSerializers.boolean_().serialize((Boolean)value.includeMediaInfo, g);
            g.writeFieldName("include_deleted");
            StoneSerializers.boolean_().serialize((Boolean)value.includeDeleted, g);
            g.writeFieldName("include_has_explicit_shared_members");
            StoneSerializers.boolean_().serialize((Boolean)value.includeHasExplicitSharedMembers, g);
            g.writeFieldName("include_mounted_folders");
            StoneSerializers.boolean_().serialize((Boolean)value.includeMountedFolders, g);
            if (value.limit != null) {
                g.writeFieldName("limit");
                StoneSerializers.nullable(StoneSerializers.uInt32()).serialize(value.limit, g);
            }
            if (value.sharedLink != null) {
                g.writeFieldName("shared_link");
                StoneSerializers.nullableStruct(SharedLink.Serializer.INSTANCE).serialize(value.sharedLink, g);
            }
            if (value.includePropertyGroups != null) {
                g.writeFieldName("include_property_groups");
                StoneSerializers.nullable(TemplateFilterBase.Serializer.INSTANCE).serialize(value.includePropertyGroups, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public ListFolderArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            TemplateFilterBase f_includePropertyGroups;
            SharedLink f_sharedLink;
            Long f_limit;
            Boolean f_includeMountedFolders;
            Boolean f_includeHasExplicitSharedMembers;
            Boolean f_includeDeleted;
            Boolean f_includeMediaInfo;
            Boolean f_recursive;
            String f_path;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_path = null;
                f_recursive = false;
                f_includeMediaInfo = false;
                f_includeDeleted = false;
                f_includeHasExplicitSharedMembers = false;
                f_includeMountedFolders = true;
                f_limit = null;
                f_sharedLink = null;
                f_includePropertyGroups = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("path".equals(field)) {
                        f_path = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("recursive".equals(field)) {
                        f_recursive = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("include_media_info".equals(field)) {
                        f_includeMediaInfo = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("include_deleted".equals(field)) {
                        f_includeDeleted = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("include_has_explicit_shared_members".equals(field)) {
                        f_includeHasExplicitSharedMembers = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("include_mounted_folders".equals(field)) {
                        f_includeMountedFolders = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("limit".equals(field)) {
                        f_limit = StoneSerializers.nullable(StoneSerializers.uInt32()).deserialize(p);
                        continue;
                    }
                    if ("shared_link".equals(field)) {
                        f_sharedLink = StoneSerializers.nullableStruct(SharedLink.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("include_property_groups".equals(field)) {
                        f_includePropertyGroups = StoneSerializers.nullable(TemplateFilterBase.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_path == null) {
                    throw new JsonParseException(p, "Required field \"path\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            ListFolderArg value = new ListFolderArg(f_path, f_recursive, f_includeMediaInfo, f_includeDeleted, f_includeHasExplicitSharedMembers, f_includeMountedFolders, f_limit, f_sharedLink, f_includePropertyGroups);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String path;
        protected boolean recursive;
        protected boolean includeMediaInfo;
        protected boolean includeDeleted;
        protected boolean includeHasExplicitSharedMembers;
        protected boolean includeMountedFolders;
        protected Long limit;
        protected SharedLink sharedLink;
        protected TemplateFilterBase includePropertyGroups;

        protected Builder(String path) {
            if (path == null) {
                throw new IllegalArgumentException("Required value for 'path' is null");
            }
            if (!Pattern.matches("(/(.|[\\r\\n])*)?|id:.*|(ns:[0-9]+(/.*)?)", path)) {
                throw new IllegalArgumentException("String 'path' does not match pattern");
            }
            this.path = path;
            this.recursive = false;
            this.includeMediaInfo = false;
            this.includeDeleted = false;
            this.includeHasExplicitSharedMembers = false;
            this.includeMountedFolders = true;
            this.limit = null;
            this.sharedLink = null;
            this.includePropertyGroups = null;
        }

        public Builder withRecursive(Boolean recursive) {
            this.recursive = recursive != null ? recursive : false;
            return this;
        }

        public Builder withIncludeMediaInfo(Boolean includeMediaInfo) {
            this.includeMediaInfo = includeMediaInfo != null ? includeMediaInfo : false;
            return this;
        }

        public Builder withIncludeDeleted(Boolean includeDeleted) {
            this.includeDeleted = includeDeleted != null ? includeDeleted : false;
            return this;
        }

        public Builder withIncludeHasExplicitSharedMembers(Boolean includeHasExplicitSharedMembers) {
            this.includeHasExplicitSharedMembers = includeHasExplicitSharedMembers != null ? includeHasExplicitSharedMembers : false;
            return this;
        }

        public Builder withIncludeMountedFolders(Boolean includeMountedFolders) {
            this.includeMountedFolders = includeMountedFolders != null ? includeMountedFolders : true;
            return this;
        }

        public Builder withLimit(Long limit) {
            if (limit != null) {
                if (limit < 1L) {
                    throw new IllegalArgumentException("Number 'limit' is smaller than 1L");
                }
                if (limit > 2000L) {
                    throw new IllegalArgumentException("Number 'limit' is larger than 2000L");
                }
            }
            this.limit = limit;
            return this;
        }

        public Builder withSharedLink(SharedLink sharedLink) {
            this.sharedLink = sharedLink;
            return this;
        }

        public Builder withIncludePropertyGroups(TemplateFilterBase includePropertyGroups) {
            this.includePropertyGroups = includePropertyGroups;
            return this;
        }

        public ListFolderArg build() {
            return new ListFolderArg(this.path, this.recursive, this.includeMediaInfo, this.includeDeleted, this.includeHasExplicitSharedMembers, this.includeMountedFolders, this.limit, this.sharedLink, this.includePropertyGroups);
        }
    }
}

