/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum TimeUnit {
    MILLISECONDS,
    SECONDS,
    MINUTES,
    HOURS,
    DAYS,
    WEEKS,
    MONTHS,
    YEARS,
    OTHER;


    static class Serializer
    extends UnionSerializer<TimeUnit> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TimeUnit value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case MILLISECONDS: {
                    g.writeString("milliseconds");
                    break;
                }
                case SECONDS: {
                    g.writeString("seconds");
                    break;
                }
                case MINUTES: {
                    g.writeString("minutes");
                    break;
                }
                case HOURS: {
                    g.writeString("hours");
                    break;
                }
                case DAYS: {
                    g.writeString("days");
                    break;
                }
                case WEEKS: {
                    g.writeString("weeks");
                    break;
                }
                case MONTHS: {
                    g.writeString("months");
                    break;
                }
                case YEARS: {
                    g.writeString("years");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public TimeUnit deserialize(JsonParser p) throws IOException, JsonParseException {
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            TimeUnit value = "milliseconds".equals(tag) ? MILLISECONDS : ("seconds".equals(tag) ? SECONDS : ("minutes".equals(tag) ? MINUTES : ("hours".equals(tag) ? HOURS : ("days".equals(tag) ? DAYS : ("weeks".equals(tag) ? WEEKS : ("months".equals(tag) ? MONTHS : ("years".equals(tag) ? YEARS : OTHER)))))));
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

