/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp.auth;

import ch.cyberduck.core.AuthenticationProvider;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.sftp.SFTPExceptionMappingService;
import ch.cyberduck.core.sftp.SFTPSession;
import ch.cyberduck.core.sftp.auth.SFTPPublicKeyAuthentication;
import ch.cyberduck.core.threading.CancelCallback;
import java.io.IOException;
import java.text.MessageFormat;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.userauth.method.AuthMethod;
import net.schmizz.sshj.userauth.method.AuthPassword;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.PasswordUpdateProvider;
import net.schmizz.sshj.userauth.password.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SFTPPasswordAuthentication
implements AuthenticationProvider<Boolean> {
    private static final Logger log = Logger.getLogger(SFTPPasswordAuthentication.class);
    private final SFTPSession session;

    public SFTPPasswordAuthentication(SFTPSession session) {
        this.session = session;
    }

    public Boolean authenticate(Host bookmark, LoginCallback callback, CancelCallback cancel) throws BackgroundException {
        Credentials credentials = bookmark.getCredentials();
        if (StringUtils.isBlank((CharSequence)credentials.getPassword())) {
            Credentials input = callback.prompt(bookmark, credentials.getUsername(), String.format("%s %s", LocaleFactory.localizedString((String)"Login", (String)"Login"), bookmark.getHostname()), MessageFormat.format(LocaleFactory.localizedString((String)"Login {0} with username and password", (String)"Credentials"), BookmarkNameProvider.toString((Host)bookmark)), new LoginOptions(bookmark.getProtocol()).user(false));
            if (input.isPublicKeyAuthentication()) {
                credentials.setIdentity(input.getIdentity());
                return new SFTPPublicKeyAuthentication(this.session).authenticate(bookmark, callback, cancel);
            }
            credentials.setSaved(input.isSaved());
            credentials.setPassword(input.getPassword());
        }
        return this.authenticate(bookmark, credentials, callback, cancel);
    }

    public String getMethod() {
        return "password";
    }

    public boolean authenticate(final Host host, final Credentials credentials, final LoginCallback callback, CancelCallback cancel) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Login using password authentication with credentials %s", credentials));
        }
        try {
            ((SSHClient)this.session.getClient()).auth(credentials.getUsername(), new AuthMethod[]{new AuthPassword(new PasswordFinder(){

                public char[] reqPassword(Resource<?> resource) {
                    return credentials.getPassword().toCharArray();
                }

                public boolean shouldRetry(Resource<?> resource) {
                    return false;
                }
            }, new PasswordUpdateProvider(){

                public char[] provideNewPassword(Resource<?> resource, String prompt) {
                    try {
                        StringAppender message = new StringAppender().append(prompt);
                        Credentials changed = callback.prompt(host, credentials.getUsername(), LocaleFactory.localizedString((String)"Change Password", (String)"Credentials"), message.toString(), new LoginOptions(host.getProtocol()).anonymous(false).user(false).publickey(false));
                        return changed.getPassword().toCharArray();
                    }
                    catch (LoginCanceledException e) {
                        return "".toCharArray();
                    }
                }

                public boolean shouldRetry(Resource<?> resource) {
                    return false;
                }
            })});
            return ((SSHClient)this.session.getClient()).isAuthenticated();
        }
        catch (IOException e) {
            throw new SFTPExceptionMappingService().map(e);
        }
    }
}

