/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp.openssh;

import ch.cyberduck.core.sftp.auth.AgentAuthenticator;
import com.jcraft.jsch.agentproxy.AgentProxy;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.Identity;
import com.jcraft.jsch.agentproxy.USocketFactory;
import com.jcraft.jsch.agentproxy.connector.SSHAgentConnector;
import com.jcraft.jsch.agentproxy.usocket.JNAUSocketFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class OpenSSHAgentAuthenticator
extends AgentAuthenticator {
    private static final Logger log = Logger.getLogger(OpenSSHAgentAuthenticator.class);
    private AgentProxy proxy;

    public OpenSSHAgentAuthenticator() {
        try {
            this.proxy = new AgentProxy((Connector)new SSHAgentConnector((USocketFactory)new JNAUSocketFactory()));
        }
        catch (AgentProxyException e) {
            log.warn((Object)String.format("Agent proxy %s failed with %s", new Object[]{this, e}));
        }
    }

    @Override
    public AgentProxy getProxy() {
        return this.proxy;
    }

    @Override
    public Collection<Identity> getIdentities() {
        if (!SSHAgentConnector.isConnectorAvailable()) {
            log.warn((Object)String.format("SSH agent %s is not running", this));
            return Collections.emptyList();
        }
        if (null == this.proxy) {
            return Collections.emptyList();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Retrieve identities from proxy %s", this.proxy));
        }
        List<Identity> identities = Arrays.asList(this.proxy.getIdentities());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Found %d identities", identities.size()));
        }
        return identities;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OpenSSHAgentAuthenticator{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

