/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client;

import com.spectralogic.ds3client.models.JobNode;
import com.spectralogic.ds3client.models.common.Credentials;
import com.spectralogic.ds3client.networking.ConnectionDetails;
import com.spectralogic.ds3client.utils.Guard;
import com.spectralogic.ds3client.utils.PropertyUtils;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConnectionDetailsImpl
implements ConnectionDetails {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionDetailsImpl.class);
    private static final String DEFAULT_USER_AGENT_HEADER_VALUE = "ds3_java_sdk";
    private final String endpoint;
    private final Credentials credentials;
    private final boolean https;
    private final URI proxy;
    private final int retries;
    private final int bufferSizeInBytes;
    private final int connectionTimeoutInMillis;
    private final int socketTimeoutInMillis;
    private final boolean certificateVerification;
    private final String userAgent;

    public static ConnectionDetails newForNode(JobNode node, ConnectionDetails connectionDetails) {
        Builder connectionBuilder;
        if (node.getEndPoint() == null || node.getEndPoint().equals("FAILED_TO_DETERMINE_DATAPATH_IP_ADDRESS")) {
            LOG.trace("Running against an old version of the DS3 API, reusing existing endpoint configuration");
            connectionBuilder = ConnectionDetailsImpl.builder(connectionDetails.getEndpoint(), connectionDetails.getCredentials());
        } else {
            LOG.trace("Creating new Connection Details for endpoint: {}", (Object)node.getEndPoint());
            connectionBuilder = ConnectionDetailsImpl.builder(ConnectionDetailsImpl.buildAuthority(node, connectionDetails), connectionDetails.getCredentials());
        }
        connectionBuilder.withRedirectRetries(connectionDetails.getRetries()).withHttps(connectionDetails.isHttps()).withCertificateVerification(connectionDetails.isCertificateVerification()).withBufferSize(connectionDetails.getBufferSize()).withConnectionTimeout(connectionDetails.getConnectionTimeout()).withSocketTimeout(connectionDetails.getSocketTimeout()).withProxy(connectionDetails.getProxy()).withUserAgent(connectionDetails.getUserAgent());
        return connectionBuilder.build();
    }

    private static String buildAuthority(JobNode node, ConnectionDetails connectionDetails) {
        return node.getEndPoint() + ":" + Integer.toString(connectionDetails.isHttps() ? node.getHttpsPort() : node.getHttpPort());
    }

    static Builder builder(String uriEndpoint, Credentials credentials) {
        return new Builder(uriEndpoint, credentials);
    }

    private ConnectionDetailsImpl(Builder builder) {
        this.endpoint = builder.endpoint;
        this.credentials = builder.credentials;
        this.https = builder.https;
        this.proxy = builder.proxy;
        this.retries = builder.retries;
        this.bufferSizeInBytes = builder.bufferSizeInBytes;
        this.connectionTimeoutInMillis = builder.connectionTimeoutInMillis;
        this.certificateVerification = builder.certificateVerification;
        this.socketTimeoutInMillis = builder.socketTimeoutInMillis;
        this.userAgent = builder.userAgent;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public boolean isHttps() {
        return this.https;
    }

    @Override
    public URI getProxy() {
        return this.proxy;
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSizeInBytes;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeoutInMillis;
    }

    @Override
    public int getSocketTimeout() {
        return this.socketTimeoutInMillis;
    }

    @Override
    public boolean isCertificateVerification() {
        return this.certificateVerification;
    }

    @Override
    public String getUserAgent() {
        return Guard.isStringNullOrEmpty((String)this.userAgent) ? this.getDefaultSdkVersion() : this.userAgent;
    }

    private String getDefaultSdkVersion() {
        String sdkVersion = PropertyUtils.getSdkVersion();
        if (Guard.isStringNullOrEmpty((String)sdkVersion)) {
            return DEFAULT_USER_AGENT_HEADER_VALUE;
        }
        return "ds3_java_sdk-" + sdkVersion;
    }

    public String toString() {
        return "Endpoint: " + this.endpoint + " | Https?: " + this.https;
    }

    static class Builder
    implements com.spectralogic.ds3client.utils.Builder<ConnectionDetailsImpl> {
        private final String endpoint;
        private final Credentials credentials;
        private boolean https = false;
        private URI proxy = null;
        private int retries = 5;
        private int bufferSizeInBytes = 0x100000;
        private int connectionTimeoutInMillis = 5000;
        private int socketTimeoutInMillis = 3600000;
        private boolean certificateVerification;
        private String userAgent;

        private Builder(String endpoint, Credentials credentials) {
            this.endpoint = endpoint;
            this.credentials = credentials;
        }

        public Builder withHttps(boolean secure) {
            this.https = secure;
            return this;
        }

        public Builder withProxy(URI proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder withRedirectRetries(int retries) {
            this.retries = retries;
            return this;
        }

        public Builder withBufferSize(int bufferSizeInBytes) {
            this.bufferSizeInBytes = bufferSizeInBytes;
            return this;
        }

        public Builder withConnectionTimeout(int connectionTimeoutInMillis) {
            this.connectionTimeoutInMillis = connectionTimeoutInMillis;
            return this;
        }

        public Builder withCertificateVerification(boolean certificateVerification) {
            this.certificateVerification = certificateVerification;
            return this;
        }

        public Builder withSocketTimeout(int socketTimeoutInMillis) {
            this.socketTimeoutInMillis = socketTimeoutInMillis;
            return this;
        }

        public Builder withUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        @Override
        public ConnectionDetailsImpl build() {
            return new ConnectionDetailsImpl(this);
        }
    }
}

