/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client;

import com.spectralogic.ds3client.exceptions.ContentLengthNotMatchException;
import com.spectralogic.ds3client.utils.IOUtils;
import com.spectralogic.ds3client.utils.PerformanceUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;

public class Ds3InputStreamEntity
extends InputStreamEntity {
    private int bufferSize = 0x100000;
    private final String path;

    public Ds3InputStreamEntity(InputStream inStream, long length, ContentType contentType, String path) {
        super(inStream, length, contentType);
        this.path = path;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public long getBufferSize() {
        return this.bufferSize;
    }

    public void writeTo(OutputStream outStream) throws IOException {
        long startTime = PerformanceUtils.getCurrentTime();
        long totalBytes = IOUtils.copy(this.getContent(), outStream, this.bufferSize, this.path, true);
        long endTime = PerformanceUtils.getCurrentTime();
        if (this.getContentLength() != -1L && totalBytes != this.getContentLength()) {
            throw new ContentLengthNotMatchException(this.path, this.getContentLength(), totalBytes);
        }
        PerformanceUtils.logMbps(startTime, endTime, totalBytes, this.path, true);
    }
}

