/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.interfaces;

import com.spectralogic.ds3client.commands.interfaces.Ds3Request;
import com.spectralogic.ds3client.commands.interfaces.RequestHeaders;
import com.spectralogic.ds3client.commands.interfaces.RequestHeadersImpl;
import com.spectralogic.ds3client.models.ChecksumType;
import com.spectralogic.ds3client.utils.SafeStringManipulation;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public abstract class AbstractRequest
implements Ds3Request {
    private final RequestHeaders headers = AbstractRequest.buildDefaultHeaders();
    private final Map<String, String> queryParams = new HashMap<String, String>();

    private static RequestHeaders buildDefaultHeaders() {
        RequestHeadersImpl requestHeaders = new RequestHeadersImpl();
        requestHeaders.put("Naming-Convention", "s3");
        return requestHeaders;
    }

    @Override
    public String getContentType() {
        return ContentType.APPLICATION_XML.getMimeType();
    }

    @Override
    public InputStream getStream() {
        return null;
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public ChecksumType getChecksum() {
        return ChecksumType.none();
    }

    @Override
    public ChecksumType.Type getChecksumType() {
        return ChecksumType.Type.NONE;
    }

    @Override
    public final Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    @Override
    public final RequestHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public void removeQueryParam(String name) {
        this.queryParams.remove(name);
    }

    protected final <T> void updateQueryParam(String name, T param) {
        if (param == null) {
            this.queryParams.remove(name);
        } else {
            this.queryParams.put(name, SafeStringManipulation.safeQueryParamEscape(param));
        }
    }
}

