/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.CancelImportOnAllTapesSpectraS3Response;
import com.spectralogic.ds3client.models.TapeFailureList;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class CancelImportOnAllTapesSpectraS3ResponseParser
extends AbstractResponseParser<CancelImportOnAllTapesSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{204, 207};

    @Override
    public CancelImportOnAllTapesSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 204: {
                    return new CancelImportOnAllTapesSpectraS3Response(null, this.getChecksum(), this.getChecksumType());
                }
                case 207: {
                    try (InputStream inputStream = response.getResponseStream();){
                        TapeFailureList result = XmlOutput.fromXml(inputStream, TapeFailureList.class);
                        CancelImportOnAllTapesSpectraS3Response cancelImportOnAllTapesSpectraS3Response = new CancelImportOnAllTapesSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return cancelImportOnAllTapesSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

